<?php

require_once __DIR__ . '/../../Util.php';

class PacienteController extends Zend_Controller_Action {

	public function init() {
		$this->_helper->acl->allow(NULL, array("buscar-domicilio", "buscar-usuarios", "buscar-rua", "buscar-cep", "buscar", "buscar-usuario-relatorio", "buscar-ocupacao", "busca-estado-por-pais", "busca-cidade-por-estado", "esus-form-paciente-cns","anexar", "salvar-anexo"));
		$this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/jquery.maskedinput-1.3.min.js');
		$this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/default/paciente/form-paciente.js');
	}

	public function buscarDomicilioAction() {
		$term = $this->_getParam("term", FALSE);
		$tbDom = new Application_Model_Domicilio();
		$this->view->dados = $tbDom->buscaDomicilio($term);
		return $this->render("dados", NULL, TRUE);
	}

	public function buscarUsuariosAction() {
		$tbUsu = new Application_Model_Usuario();
		$term = $this->_getParam("term", FALSE);
		$this->view->dados = $tbUsu->buscar($term);
		return $this->render("dados", NULL, TRUE);
	}

	public function buscarNumerosDeDomicilioPorEnderecoAction() {
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
		$rua_codigo = $this->_getParam("rua_codigo", FALSE);
		$rua_cep = $this->_getParam("rua_cep", FALSE);
		$rua_bairro = $this->_getParam("rua_bairro", FALSE);
		$dom_numero = $this->_getParam("dom_numero", FALSE);
		$cid_codigo = $this->_getParam("cid_codigo", FALSE);
		$rua_nome = $this->_getParam("rua_nome", FALSE);
		$dom_complemento = $this->_getParam("dom_complemento", FALSE);
		$usu_codigo_responsavel = $this->_getParam("usu_codigo_responsavel", FALSE);
		$rua_cep = str_replace("-", "", str_replace(".", "", $rua_cep));
		$co_tipo_logradouro = $this->_getParam("co_tipo_logradouro", FALSE);
		$tbDom = new Application_Model_Domicilio();
		$this->view->dados = $tbDom->buscarNumerosDeDomicilioPorEndereco($rua_codigo, $rua_cep, $rua_bairro, $dom_numero, $co_tipo_logradouro, $cid_codigo, $rua_nome, $usu_codigo_responsavel, $dom_complemento)->toArray();
		return $this->render("dados", NULL, TRUE);
	}

	public function buscarRuaAction() {
		$tbConf = new Application_Model_Configuracao();
		$tbRua = new Application_Model_Rua();
		$term = $this->_getParam("term", FALSE);
		$this->view->dados = $tbRua->buscarRua($term);
		return $this->render("dados", NULL, TRUE);
	}

	public function buscarCepAction() {
		$tbConf = new Application_Model_Configuracao();
		$tbRua = new Application_Model_Rua();
		$term = $this->_getParam("term", FALSE);
		$this->view->dados = $tbRua->buscarCep($term);
		return $this->render("dados", NULL, TRUE);
	}

	public function getProntuarioDuplicadoAction() {
		$prontuario = $this->_getParam("prontuario", FALSE);
		$tbPep = new Application_Model_Usuario();
		$num = $tbPep->getProntuarioDuplicado($prontuario);
		$this->view->dados = $num->num;
		return $this->render("dados", NULL, TRUE);
	}

	public function buscaEstadoPorPaisAction() {
		$pais_codigo = $this->_request->getPost("pais_codigo");
		//$pais_codigo = $this->_getParam("pais_codigo",FALSE);
		$tbEst = new Application_Model_Estado();
		$this->view->dados = $tbEst->listaEstadoPorPais($pais_codigo)->toArray();


		return $this->render("dados", NULL, TRUE);
	}

	public function buscaCidadePorEstadoAction() {
		$ufCodigo = $this->_getParam("uf_codigo", FALSE);
		$tbCid = new Application_Model_Cidade();
		//$this->view->dados = $tbCid->fetchAll("uf_codigo = '$uf_codigo'","cid_nome")->toArray();
		$this->view->dados = $tbCid->listaCidadePorEstadoCodigo($ufCodigo)->toArray();
		return $this->render("dados", NULL, TRUE);
	}

	public function buscaDadosEspeciaisAction() {
		$tbUsu = new Application_Model_Usuario();
		$codPaciente = $this->_request->getPost("codPaciente");
		if ($codPaciente) {
			$this->view->dados = $tbUsu->buscaDadosEspeciais($codPaciente);
			return $this->render("dados", NULL, TRUE);
		}
	}

	public function buscaDadosEstratificacaoAction() {
		$tbUsu = new Application_Model_Usuario();
		$codPaciente = $this->_request->getPost("codPaciente");
		if ($codPaciente) {
			$this->view->dados = $tbUsu->buscaDadosEstratificacao($codPaciente);
			return $this->render("dados", NULL, TRUE);
		}
	}

	public function validaCnsDuplicadoAction() {
		$tbUsu = new Application_Model_Usuario();
		$cns = $this->_request->getPost("cns");
		$usuCodigo = $this->_request->getPost("usuCodigo");
		$this->view->dados = $tbUsu->validaCnsDuplicado($cns, $usuCodigo)->qtd_sus;
		return $this->render("dados", NULL, TRUE);
	}

	public function formPacienteAction() {
		$tbUsr = new Application_Model_Usuarios();
		$this->view->usr_tipo_medico = $tbUsr->getUsrAtual()->usr_tipo_medico;
		$this->view->usr_digitador = $tbUsr->getUsrAtual()->usr_digitador;

		$this->view->title = "Cadastro de Pessoa";
		$this->_helper->layout->setLayout("simples");

		$valida = $this->_request->getParam("valida");
		$this->view->valida = $valida;

		$tbEsC = new Application_Model_EstadoCivil();
		$tbPais = new Application_Model_Pais();
		$tbEst = new Application_Model_Estado();
		$tbCid = new Application_Model_Cidade();
		$tbRac = new Application_Model_Raca();
		$tbEtn = new Application_Model_Etnia();
		$tbEpa = new Application_Model_EsusPais();
		$tbOcu = new Application_Model_Ocupacao();
		$tbConf = new Application_Model_Configuracao();
		$tbRua = new Application_Model_Rua();
		$tbUsu = new Application_Model_Usuario();
		$tbUsr = new Application_Model_Usuarios();
		$tbPergDet = new Application_Model_TbPerguntaDetalhe();
		$tbUni = new Application_Model_Unidade();
		$tbUsuDef = new Application_Model_UsuarioDeficiencias();
		$tbUsuCrianca = new Application_Model_UsuarioCriancas();
		$tbUsuCardio = new Application_Model_UsuarioDoencaCardiaca();
		$tbUsuRenal = new Application_Model_UsuarioDoencaRins();
		$tbUsuPulmao = new Application_Model_UsuarioDoencaPulmonar();
		$tbUsuAlimen = new Application_Model_UsuarioOrigemAlimentacao();
		$tbUsuHigiene = new Application_Model_UsuarioHigiene();
		$tbUsuInfo = new Application_Model_UsuarioInfoSociodemo();

		$codIbge = $tbConf->getConfig("CID_CODIGO_IBGE");

		$prontuario_same = $tbConf->getConfig("USA_PRONTUARIO_SAME");
		$this->view->prontuario_same = $prontuario_same;

		$vinculo_municipal = $tbConf->getConfig("USA_VINCULO_MUNICIPAL");
		$this->view->vinculo_municipal = $vinculo_municipal;

		$tbTpLogr = new Application_Model_TbMsTipoLogradouro();

		$pessoa = $this->_getParam("pessoa", FALSE);

		if ($pessoa) {
			$this->view->dados = $tbUsu->listaDadosUsuario($pessoa);
			$rowInfo = count($tbUsuInfo->getDadosPorUsuario($pessoa));
			if ($rowInfo > 0) {
				$this->view->infoSociodemo = $tbUsuInfo->getDadosPorUsuario($pessoa);
			}
			$rowDef = count($tbUsuDef->getDadosPorUsuario($pessoa));
			if ($rowDef > 0) {
				$this->view->deficienciasEdit = $tbUsuDef->getDadosPorUsuario($pessoa)->toArray();
			}
			$rowCrianca = count($tbUsuCrianca->getDadosPorUsuario($pessoa));
			if ($rowCrianca > 0) {
				$this->view->criancasEdit = $tbUsuCrianca->getDadosPorUsuario($pessoa)->toArray();
			}
			$rowCardio = count($tbUsuCardio->getDadosPorUsuario($pessoa));
			if ($rowCardio > 0) {
				$this->view->cardiacaEdit = $tbUsuCardio->getDadosPorUsuario($pessoa)->toArray();
			}
			$rowRenal = count($tbUsuRenal->getDadosPorUsuario($pessoa));
			if ($rowRenal > 0) {
				$this->view->renalEdit = $tbUsuRenal->getDadosPorUsuario($pessoa)->toArray();
			}
			$rowPulmao = count($tbUsuPulmao->getDadosPorUsuario($pessoa));
			if ($rowPulmao > 0) {
				$this->view->respiratoriaEdit = $tbUsuPulmao->getDadosPorUsuario($pessoa)->toArray();
			}
			$rowAlimen = count($tbUsuAlimen->getDadosPorUsuario($pessoa));
			if ($rowAlimen > 0) {
				$this->view->alimentacaoEdit = $tbUsuAlimen->getDadosPorUsuario($pessoa)->toArray();
			}
			$rowHig = count($tbUsuHigiene->getDadosPorUsuario($pessoa));
			if ($rowHig > 0) {
				$this->view->higieneEdit = $tbUsuHigiene->getDadosPorUsuario($pessoa)->toArray();
			}
			$usr_cadastro_codigo = $this->view->dados[0]->usr_cadastro_codigo;
			$uni_codigo = $this->view->dados[0]->uni_cadastro_codigo;
			$unidade = $tbUni->getUnidade($uni_codigo)->toArray();

			if ($usr_cadastro_codigo == null) {
				$this->view->usr_cadastro_codigo = $this->view->dados[0]->usr_codigo;
				$this->view->usr_cadastro_nome = $this->view->dados[0]->usr_nome;
			}

			$this->view->uni_logado_cogigo = $unidade[0]["uni_codigo"];
			$this->view->uni_logado_desc = $unidade[0]["uni_desc"];
		}
		else {
			$this->view->usr_cadastro_codigo = $tbUsr->getUsrAtual()->usr_codigo;
			$this->view->usr_cadastro_nome = $tbUsr->getUsrAtual()->usr_nome;
			$this->view->uni_logado_cogigo = $tbUsr->getUsrAtual()->uni_codigo;
			$this->view->uni_logado_desc = $tbUsr->getUsrAtual()->uni_desc;
		}

		$dadosEstCid = array(
			"codCid" => $tbRua->getDadosCidadeEstado($codIbge)->cid_codigo,
			"ufSigla" => $tbRua->getDadosCidadeEstado($codIbge)->uf_sigla
		);
		$this->view->dadosEstCid = $dadosEstCid;
		$this->view->poupup = $this->_getParam("poupup", FALSE);

		$this->view->tp_lograd = $tbTpLogr->getTiposLogradouro();
		$this->view->usuarios = $tbUsr->getUsuariosModulo();

		$this->view->estadoCivil = $tbEsC->fetchAll();
		$this->view->pais = $tbPais->fetchAll();
		$this->view->estado = $tbEst->fetchAll();
		$this->view->cidade = $tbCid->listaCidadePorEstado($dadosEstCid["ufSigla"]);
		$this->view->raca = $tbRac->fetchAll("rac_ativacao = 'A'");
		$this->view->etnia = $tbEtn->fetchAll();
		$this->view->esus_pais = $tbEpa->fetchAll();
		$this->view->deficiencias = $tbPergDet->getPerguntaDetalhe("10");
		$this->view->criancas = $tbPergDet->getPerguntaDetalhe("1");
		$this->view->cardiaca = $tbPergDet->getPerguntaDetalhe("30");
		$this->view->renal = $tbPergDet->getPerguntaDetalhe("32");
		$this->view->respiratoria = $tbPergDet->getPerguntaDetalhe("34");
		$this->view->alimentacao = $tbPergDet->getPerguntaDetalhe("49");
		$this->view->higiene = $tbPergDet->getPerguntaDetalhe("51");
		$this->view->parentescoResp = $tbPergDet->getPerguntaDetalhe("1001");
		$this->view->escolaridade = $tbPergDet->getPerguntaDetalhe("55");
		$this->view->mercado = $tbPergDet->getPerguntaDetalhe("56");
		$this->view->orientacao_sexual = $tbPergDet->getPerguntaDetalhe("73");
		$this->view->identidade_genero = $tbPergDet->getPerguntaDetalhe("74");
		$this->view->peso = $tbPergDet->getPerguntaDetalhe("21");
		$this->view->situacao_rua = $tbPergDet->getPerguntaDetalhe("12");
		$this->view->alimentacao_dia = $tbPergDet->getPerguntaDetalhe("48");
		$this->view->ocupacao = $tbOcu->fetchAll();
	}

	public function salvarUsuarioAction() {
		$this->_helper->layout->disableLayout();
		$this->view->title = "Cadastro de Pessoa";
		$valida = $this->_request->getParam("valida");
		$tbUsr = new Application_Model_Usuarios();
		$usr_digitador = $tbUsr->getUsrAtual()->usr_digitador;

		if ($this->_request->isPost()) {
			// Array de Dados Usuario

			$pessoa = array(
				"usu_nome" => ($this->_request->getPost("nome", "") ? trim(mb_convert_case($this->_request->getPost("nome", ""), MB_CASE_UPPER, "UTF-8")) : NULL),
				"usu_nome_social" => ($this->_request->getPost("usu_nome_social", "") ? trim(mb_convert_case($this->_request->getPost("usu_nome_social", ""), MB_CASE_UPPER, "UTF-8")) : NULL),
				"usu_datanasc" => ($this->_request->getPost("datanascimento", "") ? strtoupper($this->_request->getPost("datanascimento", "")) : NULL),
				"usu_data_cad" => ($this->_request->getPost("usu_data_cad", "") ? strtoupper($this->_request->getPost("usu_data_cad", "")) : date("Y-m-d")),
				"usu_rg" => ($this->_request->getPost("rg", "") ? $this->_request->getPost("rg", "") : NULL),
				"usu_rg_emissor" => ($this->_request->getPost("orgaoemissor", "") ? $this->_request->getPost("orgaoemissor", "") : NULL),
				"usu_rg_dt_emissao" => ($this->_request->getPost("dataemissao", "") ? $this->_request->getPost("dataemissao", "") : NULL),
				"usu_pis_pasep" => ($this->_request->getPost("pispasep", "") ? $this->_request->getPost("pispasep", "") : NULL),
				"usu_cpf" => preg_replace('#[^0-9]#', '', $this->_request->getPost("cnpj_cpf")),
				"cid_codigo_nasc" => ($this->_request->getPost("cid_codigo_nasc", "") ? $this->_request->getPost("cid_codigo_nasc", "") : NULL),
				"usu_bloqueado" => ($this->_request->getPost("pep_bloqueado", "") ? $this->_request->getPost("pep_bloqueado", "") : NULL),
				"usu_sexo" => ($this->_request->getPost("pep_sexo", "") ? $this->_request->getPost("pep_sexo", "") : NULL),
				"usu_mae" => ($this->_request->getPost("pep_mae", "") ? trim(mb_convert_case($this->_request->getPost("pep_mae", ""), MB_CASE_UPPER, "UTF-8")) : NULL),
				"usu_pai" => ($this->_request->getPost("pep_pai", "") ? trim(mb_convert_case($this->_request->getPost("pep_pai", ""), MB_CASE_UPPER, "UTF-8")) : NULL),
				"usu_email" => ($this->_request->getPost("pep_email", "") ? $this->_request->getPost("pep_email", "") : NULL),
				"usu_celular" => ($this->_request->getPost("pep_celular", "") ? $this->_request->getPost("pep_celular", "") : NULL),
				"usu_fone" => ($this->_request->getPost("pep_telefone", "") ? $this->_request->getPost("pep_telefone", "") : NULL),
				"usu_conjuge" => ($this->_request->getPost("pep_conjuge", "") ? $this->_request->getPost("pep_conjuge", "") : NULL),
				"usu_obito" => ($this->_request->getPost("pep_obito", "") ? $this->_request->getPost("pep_obito", "") : NULL),
				"usu_mudanca_territorio" => ($this->_request->getPost("usu_mudanca_territorio", "") ? $this->_request->getPost("usu_mudanca_territorio", "") : NULL),
				"usu_dt_obito" => ($this->_request->getPost("pep_data_obito", "") ? $this->_request->getPost("pep_data_obito", "") : NULL),
				"usu_numero_do" => ($this->_request->getPost("usu_numero_do", "") ? $this->_request->getPost("usu_numero_do", "") : NULL),
				"pais_codigo" => ($this->_request->getPost("pais_codigo", "") ? $this->_request->getPost("pais_codigo", "") : NULL),
				"usu_cartao_sus" => ($this->_request->getPost("pep_cartao_sus", "") ? $this->_request->getPost("pep_cartao_sus", "") : NULL),
				"usu_cert_cartorio_nasc" => ($this->_request->getPost("pep_cartorio_nasc", "") ? $this->_request->getPost("pep_cartorio_nasc", "") : NULL),
				"usu_cert_livro_nasc" => ($this->_request->getPost("pep_livro_nasc", "") ? $this->_request->getPost("pep_livro_nasc", "") : NULL),
				"usu_cert_lv_fls_nasc" => ($this->_request->getPost("pep_folha_nasc", "") ? $this->_request->getPost("pep_folha_nasc", "") : NULL),
				"usu_cert_termo_nasc" => ($this->_request->getPost("pep_termo_nasc", "") ? $this->_request->getPost("pep_termo_nasc", "") : NULL),
				"uni_codigo" => ($this->_request->getPost("uni_codigo", "") ? $this->_request->getPost("uni_codigo", "") : NULL),
				"rac_codigo" => ($this->_request->getPost("rac_codigo", "") ? $this->_request->getPost("rac_codigo", "") : NULL),
				"usu_cbo_r" => ($this->_request->getPost("co_ocupacao", "") ? $this->_request->getPost("co_ocupacao", "") : NULL),
				"usu_cnh_numero" => ($this->_request->getPost("pep_cnh", "") ? $this->_request->getPost("pep_cnh", "") : NULL),
				"usu_cnh_categoria" => ($this->_request->getPost("pep_categoria_cnh", "") ? $this->_request->getPost("pep_categoria_cnh", "") : NULL),
				"usu_ctps" => ($this->_request->getPost("pep_carteira_trabalho", "") ? $this->_request->getPost("pep_carteira_trabalho", "") : NULL),
				"usu_ctps_serie" => ($this->_request->getPost("pep_carteira_trabalho_serie", "") ? $this->_request->getPost("pep_carteira_trabalho_serie", "") : NULL),
				"usu_ctps_dt_emissao" => ($this->_request->getPost("pep_carteira_trabalho_data", "") ? $this->_request->getPost("pep_carteira_trabalho_data", "") : NULL),
				"usu_tit_eleitor" => ($this->_request->getPost("pep_titulo_eleitor", "") ? $this->_request->getPost("pep_titulo_eleitor", "") : NULL),
				"usu_tit_eleitor_zona" => ($this->_request->getPost("pep_titulo_zona", "") ? $this->_request->getPost("pep_titulo_zona", "") : NULL),
				"usu_tit_eleitor_secao" => ($this->_request->getPost("pep_titulo_secao", "") ? $this->_request->getPost("pep_titulo_secao", "") : NULL),
				"usu_transporte_publico" => ($this->_request->getPost("pep_transporte_publico", "") ? $this->_request->getPost("pep_transporte_publico", "") : NULL),
				"usu_freq_escolar" => ($this->_request->getPost("pep_frenquencia_escolar", "") ? $this->_request->getPost("pep_frenquencia_escolar", "") : NULL),
				"nr_portaria_naturalizacao" => ($this->_request->getPost("pep_portaria_naturalizacao", "") ? $this->_request->getPost("pep_portaria_naturalizacao", "") : NULL),
				"dt_naturalizacao" => ($this->_request->getPost("pep_data_naturalizacao", "") ? $this->_request->getPost("pep_data_naturalizacao", "") : NULL),
				"usu_dt_entrada_pais" => ($this->_request->getPost("pep_data_entrada_pais", "") ? $this->_request->getPost("pep_data_entrada_pais", "") : NULL),
				"usu_bolsa_alimentacao" => ($this->_request->getPost("pep_bolsa_alimentacao", "") ? $this->_request->getPost("pep_bolsa_alimentacao", "") : NULL),
				"usu_bolsa_familia" => ($this->_request->getPost("pep_bolsa_familia", "") ? $this->_request->getPost("pep_bolsa_familia", "") : NULL),
				"usu_plano_saude" => ($this->_request->getPost("pep_plano_saude", "") ? $this->_request->getPost("pep_plano_saude", "") : NULL),
				"usu_renda_media" => ($this->_request->getPost("pep_renda", "") ? $this->_request->getPost("pep_renda", "") : NULL),
				"usu_observacao" => ($this->_request->getPost("pep_observacao", "") ? $this->_request->getPost("pep_observacao", "") : NULL),
				"usu_sit_familiar" => ($this->_request->getPost("pep_situacao_familiar", "") ? $this->_request->getPost("pep_situacao_familiar", "") : NULL),
				"estc_codigo" => ($this->_request->getPost("estc_codigo", "") ? $this->_request->getPost("estc_codigo", "") : NULL),
				"uf_sigla_rg" => ($this->_request->getPost("estadoemissor", "") ? $this->_request->getPost("estadoemissor", "") : NULL),
				"usr_codigo" => ($this->_request->getPost("usr_codigo", "") ? $this->_request->getPost("usr_codigo", "") : NULL),
				"usr_cadastro_codigo" => ($this->_request->getPost("usr_cadastro_codigo", "") ? $this->_request->getPost("usr_cadastro_codigo", "") : NULL),
				"cd_nacionalidade" => ($this->_request->getPost("cd_nacionalidade", "") ? $this->_request->getPost("cd_nacionalidade", "") : NULL),
				"usu_sit_rua" => ($this->_request->getPost("usu_sit_rua", "") ? $this->_request->getPost("usu_sit_rua", "") : NULL),
				"usu_deficiencia" => ($this->_request->getPost("usu_deficiencia", "") ? $this->_request->getPost("usu_deficiencia", "") : NULL),
				"usu_tem_diabete" => ($this->_request->getPost("usu_tem_diabete", "") ? $this->_request->getPost("usu_tem_diabete", "") : NULL),
				"usu_esta_gestante" => ($this->_request->getPost("usu_esta_gestante", "") ? $this->_request->getPost("usu_esta_gestante", "") : NULL),
				"usu_tem_hipertensao" => ($this->_request->getPost("usu_tem_hipertensao", "") ? $this->_request->getPost("usu_tem_hipertensao", "") : NULL),
				"etn_codigo" => ($this->_request->getPost("etn_codigo", "") ? $this->_request->getPost("etn_codigo", "") : NULL),
				"epa_codigo" => ($this->_request->getPost("epa_codigo", "") ? $this->_request->getPost("epa_codigo", "") : NULL),
				"usu_st_responsavel_familiar" => ($this->_request->getPost("proprio_responsavel", "") ? $this->_request->getPost("proprio_responsavel", "") : NULL),
				"usu_maternidade_ref" => ($this->_request->getPost("usu_maternidade_ref", "") ? $this->_request->getPost("usu_maternidade_ref", "") : NULL),
				"usr_esp_codigo" => ($this->_request->getPost("esp_codigo", "") ? $this->_request->getPost("esp_codigo", "") : NULL),
				"usr_equipe_codigo" => ($this->_request->getPost("equipe_codigo", "") ? $this->_request->getPost("equipe_codigo", "") : NULL),
				"usu_microarea" => ($this->_request->getPost("usu_microarea", "") ? $this->_request->getPost("usu_microarea", "") : NULL),
				"usu_microarea_fa" => ($this->_request->getPost("usu_microarea_fa", "") ? $this->_request->getPost("usu_microarea_fa", "") : "f"),
				"usu_origem_prontuario" => 'false',
				"usu_recusa" => ($this->_request->getPost("usu_recusa", "") ? $this->_request->getPost("usu_recusa", "") : "f"),
				"uni_cadastro_codigo" => ($this->_request->getPost("uni_logado_cogigo", "") ? $this->_request->getPost("uni_logado_cogigo", "") : NULL),
				"risco_gestacao" => ($this->_request->getPost("risco_gestacao", "") ? $this->_request->getPost("risco_gestacao", "") : ""),
				"risco_hipertensao" => ($this->_request->getPost("risco_hipertensao", "") ? $this->_request->getPost("risco_hipertensao", "") : ""),
				"risco_diabetes" => ($this->_request->getPost("risco_diabetes", "") ? $this->_request->getPost("risco_diabetes", "") : ""),
				"risco_idoso" => ($this->_request->getPost("risco_idoso", "") ? $this->_request->getPost("risco_idoso", "") : ""),
				"risco_crianca" => ($this->_request->getPost("risco_crianca", "") ? $this->_request->getPost("risco_crianca", "") : ""),
				"risco_odonto" => ($this->_request->getPost("risco_odonto", "") ? $this->_request->getPost("risco_odonto", "") : ""),
				"risco_psico" => ($this->_request->getPost("risco_psico", "") ? $this->_request->getPost("risco_psico", "") : ""),
				"usu_sera_integrado" => 'true',
                "usu_same" => ($this->_request->getPost("pep_prontuario_same", "") ? $this->_request->getPost("pep_prontuario_same", "") : ""),
			);

			/*
			Correção dos dados enviados em caso de formulário desabilitado, pois apenas usuarios do tipo M e E
			podem alterar essas informações
			*/
			if ($usr_digitador != "S") {
				if ($_SESSION['logon']['usr']->usr_tipo_medico != "M" &&
					$_SESSION['logon']['usr']->usr_tipo_medico != "E" &&
					$_SESSION['logon']['usr']->usr_tipo_medico != "C" &&
					$_SESSION['logon']['usr']->usr_tipo_medico != "D") {
					unset($pessoa['usu_esta_gestante']);
				}
				if ($_SESSION['logon']['usr']->usr_tipo_medico != "M" &&
					$_SESSION['logon']['usr']->usr_tipo_medico != "E" &&
					$_SESSION['logon']['usr']->usr_tipo_medico != "C") {
					unset($pessoa['usu_tem_diabete']);
					unset($pessoa['usu_tem_hipertensao']);
				}
				if ($_SESSION['logon']['usr']->usr_tipo_medico != "M" &&
					$_SESSION['logon']['usr']->usr_tipo_medico != "E"){
					unset($pessoa['risco_gestacao']);
					unset($pessoa['risco_diabetes']);
					unset($pessoa['risco_hipertensao']);
					unset($pessoa['risco_idoso']);
					unset($pessoa['risco_crianca']);
					unset($pessoa['usu_maternidade_ref']);
				}
                if ($_SESSION['logon']['usr']->usr_tipo_medico != "M" &&
                    $_SESSION['logon']['usr']->usr_tipo_medico != "E" &&
                    $_SESSION['logon']['usr']->usr_tipo_medico != "P"){
                    unset($pessoa['risco_psico']);
                }
                if ($_SESSION['logon']['usr']->usr_tipo_medico != "D"){
                    unset($pessoa['risco_odonto']);
                }
			}

			if ($pessoa["usu_obito"] == "t") {
				$pessoa["usu_bloqueado"] = "t";
			}

			if ($pessoa["usu_mudanca_territorio"] == "t") {
				$pessoa["usu_bloqueado"] = "t";
			}

			if ($this->_request->getPost("pep_prontuario") != "") {
				$pessoa['usu_prontuario'] = $this->_request->getPost("pep_prontuario");
			}

			$bai_codigo = $this->_request->getPost("bai_codigo", "");

			if ($this->_request->getPost("sn", "") == 1) {
				$dom_numero = "0";
			} else {
				if ($this->_request->getPost("dom_numero") == "S/N") {
					$dom_numero = "0";
				} else {
					$dom_numero = $this->_request->getPost("dom_numero", "");
				}
			}
			$dadosDomicilio = array(
				"dom_data_cadastro" => date("Y-m-d"),
				"dom_numero" => $dom_numero,
				"dom_complemento" => ($this->_request->getPost("dom_complemento", "") ? mb_convert_case($this->_request->getPost("dom_complemento", ""), MB_CASE_UPPER, "UTF-8") : NULL),
				"dom_ponto_referencia" => ($this->_request->getPost("dom_ponto_referencia", "") ? $this->_request->getPost("dom_ponto_referencia", "") : NULL),
				"co_tipo_domicilio" => "6",
				"dom_telefone" => ($this->_request->getPost("dom_telefone", "") ? $this->_request->getPost("dom_telefone", "") : NULL)
			);
			// Valida edição
			if ($this->_request->getPost("pessoa-edita")) {
				$pessoa["usu_codigo"] = $this->_request->getPost("pessoa-edita");
				//A unidade e o usuário que cadastrou não podem ser editados
				unset($pessoa['uni_cadastro_codigo']);
				unset($pessoa['usr_cadastro_codigo']);
			}
			// Inicio da transação
			Zend_Db_Table::getDefaultAdapter()->beginTransaction();
			try {
				/* -----------------------------------------------------/
				 * INSERÇÃO DOMICILIO                                   /
				 * ---------------------------------------------------- */
				// Validação de Inserção do cadastro de domicilio
				$rua = $this->_request->getPost("rua_codigo");
				// Realiza validações se a rua foi informada
				if (!empty($rua)) {
					// Inserindo código de rua no array de domicilio
					$dadosDomicilio["rua_codigo"] = $this->_request->getPost("rua_codigo");
					// Já existe um domicilio cadastrado, não faz nada
					$tbDom = new Application_Model_Domicilio();
					if ($this->_request->getPost("dom_codigo")) {
						$dadosDomicilio["dom_codigo"] = $this->_request->getPost("dom_codigo");
						$codDom = $tbDom->salvarDomicilio($dadosDomicilio);
					} else {
						if ($tbDom->getQtdCodDomicilioDuplicado($dadosDomicilio)->dom_codigo != "") {
							$codDom = $tbDom->getQtdCodDomicilioDuplicado($dadosDomicilio)->dom_codigo;
							throw new Zend_Validate_Exception("Já existe um domicílio com as mesmas caracteristicas! Favor verificar");
						} else {
							$codDom = $tbDom->salvarDomicilio($dadosDomicilio);
						}
					}
				}

				/* -----------------------------------------------------/
				 * INSERÇÃO USUARIO PACIENTE                            /
				 * ---------------------------------------------------- */
				// Cadastro de domicilio feito, vincula paciente/donicilio
				if (!empty($rua)) {
					$pessoa["dom_codigo"] = $codDom;
				}

				// Salvando dados usuario
				$tbUsu = new Application_Model_Usuario();
				$usu_codigo = $tbUsu->salvar($pessoa);
				$pessoa["usu_codigo"] = $usu_codigo;

				if ((new Application_Model_Configuracao())->getConfig('ENVIO_MENSAGENS_AUTOMATICAS')) {
					$pessoa["access_token"] = $_SESSION['access_token'];

					$pessoa["usu_codigo_agentic"] = Util::sendRequestAgentic($pessoa, 'paciente', '/pacientes/cadastrar');
					unset($pessoa["access_token"]);
					$usu_codigo = $tbUsu->salvar($pessoa);
				}

				if ($this->_request->getPost("usr_codigo") != "") {
					// Salvando informações sociodemográficas do paciente se houver
					$this->salvarInfoSociodemo($usu_codigo);

					// Salvando responsável pelo do paciente se houver
					$criancas = $this->_request->getPost("criancas");
					$this->salvarCriancas($usu_codigo, $criancas);

					// Salvando deficiencias do paciente se houver
					$deficiencias = $this->_request->getPost("deficiencias");
					$this->salvarDeficiencias($usu_codigo, $deficiencias);

					// Salvando doença cardiaca do paciente se houver
					$cardiaca = $this->_request->getPost("cardiaca");
					$this->salvarDoencaCardiaca($usu_codigo, $cardiaca);

					// Salvando problemas nos rins do paciente se houver
					$renal = $this->_request->getPost("renal");
					$this->salvarDoencaRins($usu_codigo, $renal);

					// Salvando doença pulmonar do paciente se houver
					$respiratoria = $this->_request->getPost("respiratoria");
					$this->salvarDoencaPulmonar($usu_codigo, $respiratoria);

					// Salvando origem da alimentação do paciente se houver
					$alimentacao = $this->_request->getPost("alimentacao");
					$this->salvarOrigemAlimentar($usu_codigo, $alimentacao);

					// Salvando acesso à higiene do paciente se houver
					$higiene = $this->_request->getPost("higiene");
					$this->salvarHigiene($usu_codigo, $higiene);
				}

				if ($this->_request->getPost("proprio_responsavel") == "S" && $codDom != "") {
					$this->vinculaResponsavelProprio($usu_codigo, $codDom);
				} else {
					if ($this->_request->getPost("usu_codigo", "")) {
						$this->vinculaResponsavelIntegrante($this->_request->getPost("usu_codigo", ""), $codDom);
					}
				}
				Zend_Db_Table::getDefaultAdapter()->commit();
			} catch (Exception $exc) {
				Zend_Db_Table::getDefaultAdapter()->rollBack();
				$this->view->dados = $exc->getMessage();
				return $this->render("dados", NULL, TRUE);
			}

			$this->view->dados = array("msg" => "Dados cadastrados com sucesso", "id" => $usu_codigo);
			if (!$valida)
				return $this->render("dados", NULL, TRUE);
			else
				return $this->_redirect("/programas-federais/cadastro-individual/inconsistencias");
		} else {
			return $this->_redirect("/default/paciente/form-paciente");
		}
	}

	public function vinculaResponsavelIntegrante($usu_codigo = FALSE, $dom_codigo = FALSE) {
		$tbUsu = new Application_Model_Usuario();
		$tbDom = new Application_Model_Domicilio();
		try {
			$tbDom->removeResponsavel($usu_codigo);
		} catch (Exception $exc) {
			die($exc->getMessage());
		}
		$array_salvar = array("usu_codigo" => $usu_codigo,
			"dom_codigo" => $dom_codigo,
			"usu_origem_prontuario" => 'false');

		try {
			$tbUsu->salvar($array_salvar);
			$this->vinculaResponsavelProprio($usu_codigo, $dom_codigo);
		} catch (Exception $exc) {

			die($exc->getMessage());
		}
		return true;
	}

	public function salvarInfoSociodemo($usuCodigo = FALSE) {
		$tbUsuInfo = new Application_Model_UsuarioInfoSociodemo();
		$tbUsuInfo->excluirPorUsuario($usuCodigo);
		$dados = "";
		$dados = array(
			"usu_codigo" => $usuCodigo,
			"uis_parentesco_resp" => ($this->_request->getPost("uis_parentesco_resp", "") ? $this->_request->getPost("uis_parentesco_resp", "") : NULL),
			"uis_curso_mais_elevado" => ($this->_request->getPost("uis_curso_mais_elevado", "") ? $this->_request->getPost("uis_curso_mais_elevado", "") : NULL),
			"uis_mercado_trabalho" => ($this->_request->getPost("uis_mercado_trabalho", "") ? $this->_request->getPost("uis_mercado_trabalho", "") : NULL),
			"uis_freq_cuidador_trad" => ($this->_request->getPost("uis_freq_cuidador_trad", "") ? $this->_request->getPost("uis_freq_cuidador_trad", "") : NULL),
			"uis_grupo_comunitario" => ($this->_request->getPost("uis_grupo_comunitario", "") ? $this->_request->getPost("uis_grupo_comunitario", "") : NULL),
			"uis_povo_comunidade_trad" => ($this->_request->getPost("uis_povo_comunidade_trad", "") ? $this->_request->getPost("uis_povo_comunidade_trad", "") : NULL),
			"uis_povo_comunidade_trad_nome" => ($this->_request->getPost("uis_povo_comunidade_trad_nome", "") ? $this->_request->getPost("uis_povo_comunidade_trad_nome", "") : NULL),
			"uis_orientacao_sexual" => ($this->_request->getPost("uis_orientacao_sexual", "") ? $this->_request->getPost("uis_orientacao_sexual", "") : NULL),
			"uis_orientacao_sexual_nome" => ($this->_request->getPost("uis_orientacao_sexual_nome", "") ? $this->_request->getPost("uis_orientacao_sexual_nome", "") : NULL),
			"uis_identidade_genero" => ($this->_request->getPost("uis_identidade_genero", "") ? $this->_request->getPost("uis_identidade_genero", "") : NULL),
			"uis_identidade_genero_nome" => ($this->_request->getPost("uis_identidade_genero_nome", "") ? $this->_request->getPost("uis_identidade_genero_nome", "") : NULL),
			"uis_peso" => ($this->_request->getPost("uis_peso", "") ? $this->_request->getPost("uis_peso", "") : NULL),
			"uis_fumante" => ($this->_request->getPost("uis_fumante", "") ? $this->_request->getPost("uis_fumante", "") : NULL),
			"uis_alcool" => ($this->_request->getPost("uis_alcool", "") ? $this->_request->getPost("uis_alcool", "") : NULL),
			"uis_drogas" => ($this->_request->getPost("uis_drogas", "") ? $this->_request->getPost("uis_drogas", "") : NULL),
			"uis_avc_derrame" => ($this->_request->getPost("uis_avc_derrame", "") ? $this->_request->getPost("uis_avc_derrame", "") : NULL),
			"uis_infarto" => ($this->_request->getPost("uis_infarto", "") ? $this->_request->getPost("uis_infarto", "") : NULL),
			"uis_doenca_cardiaca" => ($this->_request->getPost("uis_doenca_cardiaca", "") ? $this->_request->getPost("uis_doenca_cardiaca", "") : NULL),
			"uis_problema_rins" => ($this->_request->getPost("uis_problema_rins", "") ? $this->_request->getPost("uis_problema_rins", "") : NULL),
			"uis_doenca_respiratoria" => ($this->_request->getPost("uis_doenca_respiratoria", "") ? $this->_request->getPost("uis_doenca_respiratoria", "") : NULL),
			"uis_hanseniase" => ($this->_request->getPost("uis_hanseniase", "") ? $this->_request->getPost("uis_hanseniase", "") : NULL),
			"uis_tuberculose" => ($this->_request->getPost("uis_tuberculose", "") ? $this->_request->getPost("uis_tuberculose", "") : NULL),
			"uis_cancer" => ($this->_request->getPost("uis_cancer", "") ? $this->_request->getPost("uis_cancer", "") : NULL),
			"uis_internacao_dose_meses" => ($this->_request->getPost("uis_internacao_dose_meses", "") ? $this->_request->getPost("uis_internacao_dose_meses", "") : NULL),
			"uis_internacao_dose_meses_causa" => ($this->_request->getPost("uis_internacao_dose_meses_causa", "") ? $this->_request->getPost("uis_internacao_dose_meses_causa", "") : NULL),
			"uis_problema_saude_mental" => ($this->_request->getPost("uis_problema_saude_mental", "") ? $this->_request->getPost("uis_problema_saude_mental", "") : NULL),
			"uis_acamado" => ($this->_request->getPost("uis_acamado", "") ? $this->_request->getPost("uis_acamado", "") : NULL),
			"uis_domiciliado" => ($this->_request->getPost("uis_domiciliado", "") ? $this->_request->getPost("uis_domiciliado", "") : NULL),
			"uis_plantas_medicinais" => ($this->_request->getPost("uis_plantas_medicinais", "") ? $this->_request->getPost("uis_plantas_medicinais", "") : NULL),
			"uis_plantas_medicinais_nome" => ($this->_request->getPost("uis_plantas_medicinais_nome", "") ? $this->_request->getPost("uis_plantas_medicinais_nome", "") : NULL),
			"uis_praticas_integrat_complem" => ($this->_request->getPost("uis_praticas_integrat_complem", "") ? $this->_request->getPost("uis_praticas_integrat_complem", "") : NULL),
			"uis_condicao_saude1" => ($this->_request->getPost("uis_condicao_saude1", "") ? $this->_request->getPost("uis_condicao_saude1", "") : NULL),
			"uis_condicao_saude2" => ($this->_request->getPost("uis_condicao_saude2", "") ? $this->_request->getPost("uis_condicao_saude2", "") : NULL),
			"uis_condicao_saude3" => ($this->_request->getPost("uis_condicao_saude3", "") ? $this->_request->getPost("uis_condicao_saude3", "") : NULL),
			"uis_situacao_rua_tempo" => ($this->_request->getPost("uis_situacao_rua_tempo", "") ? $this->_request->getPost("uis_situacao_rua_tempo", "") : NULL),
			"uis_recebe_beneficio" => ($this->_request->getPost("uis_recebe_beneficio", "") ? $this->_request->getPost("uis_recebe_beneficio", "") : NULL),
			"uis_referencia_familiar" => ($this->_request->getPost("uis_referencia_familiar", "") ? $this->_request->getPost("uis_referencia_familiar", "") : NULL),
			"uis_vezes_alimenta_dia" => ($this->_request->getPost("uis_vezes_alimenta_dia", "") ? $this->_request->getPost("uis_vezes_alimenta_dia", "") : NULL),
			"uis_acompanhado_intituicao" => ($this->_request->getPost("uis_acompanhado_intituicao", "") ? $this->_request->getPost("uis_acompanhado_intituicao", "") : NULL),
			"uis_acompanhado_intituicao_nome" => ($this->_request->getPost("uis_acompanhado_intituicao_nome", "") ? $this->_request->getPost("uis_acompanhado_intituicao_nome", "") : NULL),
			"uis_vista_familiar_frequencia" => ($this->_request->getPost("uis_vista_familiar_frequencia", "") ? $this->_request->getPost("uis_vista_familiar_frequencia", "") : NULL),
			"uis_vista_familiar_grau" => ($this->_request->getPost("uis_vista_familiar_grau", "") ? $this->_request->getPost("uis_vista_familiar_grau", "") : NULL),
			"uis_acesso_higiene_pessoal" => ($this->_request->getPost("uis_acesso_higiene_pessoal", "") ? $this->_request->getPost("uis_acesso_higiene_pessoal", "") : NULL)
		);
		try {
			$tbUsuInfo->salvar($dados);
		} catch (Exception $ex) {
			die($ex->getMessage());
			return $ex->getMessage();
		}
	}

	public function salvarDeficiencias($usuCodigo = FALSE, $deficiencias = FALSE) {
		$tbUsuDef = new Application_Model_UsuarioDeficiencias();
		$tbUsuDef->excluirPorUsuario($usuCodigo);
		foreach ($deficiencias as $value) {
			$dados = "";
			$dados = array(
				"usu_codigo" => $usuCodigo,
				"co_pergunta_detalhe" => $value
			);
			try {
				$tbUsuDef->salvar($dados);
			} catch (Exception $ex) {
				die($ex->getMessage());
				return $ex->getMessage();
			}
		}
	}

	public function salvarCriancas($usuCodigo = FALSE, $criancas = FALSE) {
		$tbUsuCriancas = new Application_Model_UsuarioCriancas();
		$tbUsuCriancas->excluirPorUsuario($usuCodigo);
		foreach ($criancas as $value) {
			$dados = "";
			$dados = array(
				"usu_codigo" => $usuCodigo,
				"co_pergunta_detalhe" => $value
			);
			try {
				$tbUsuCriancas->salvar($dados);
			} catch (Exception $ex) {
				die($ex->getMessage());
				return $ex->getMessage();
			}
		}
	}

	public function salvarDoencaCardiaca($usuCodigo = FALSE, $cardiaca = FALSE) {
		$tbUsuCardio = new Application_Model_UsuarioDoencaCardiaca();
		$tbUsuCardio->excluirPorUsuario($usuCodigo);
		foreach ($cardiaca as $value) {
			$dados = "";
			$dados = array(
				"usu_codigo" => $usuCodigo,
				"co_pergunta_detalhe" => $value
			);
			try {
				$tbUsuCardio->salvar($dados);
			} catch (Exception $ex) {
				die($ex->getMessage());
				return $ex->getMessage();
			}
		}
	}

	public function salvarDoencaRins($usuCodigo = FALSE, $renal = FALSE) {
		$tbUsuRenal = new Application_Model_UsuarioDoencaRins();
		$tbUsuRenal->excluirPorUsuario($usuCodigo);
		foreach ($renal as $value) {
			$dados = "";
			$dados = array(
				"usu_codigo" => $usuCodigo,
				"co_pergunta_detalhe" => $value
			);
			try {
				$tbUsuRenal->salvar($dados);
			} catch (Exception $ex) {
				die($ex->getMessage());
				return $ex->getMessage();
			}
		}
	}

	public function salvarDoencaPulmonar($usuCodigo = FALSE, $respiratoria = FALSE) {
		$tbUsuPulmonar = new Application_Model_UsuarioDoencaPulmonar();
		$tbUsuPulmonar->excluirPorUsuario($usuCodigo);
		foreach ($respiratoria as $value) {
			$dados = "";
			$dados = array(
				"usu_codigo" => $usuCodigo,
				"co_pergunta_detalhe" => $value
			);
			try {
				$tbUsuPulmonar->salvar($dados);
			} catch (Exception $ex) {
				die($ex->getMessage());
				return $ex->getMessage();
			}
		}
	}

	public function salvarOrigemAlimentar($usuCodigo = FALSE, $alimentacao = FALSE) {
		$tbUsuAlimentacao = new Application_Model_UsuarioOrigemAlimentacao();
		$tbUsuAlimentacao->excluirPorUsuario($usuCodigo);
		foreach ($alimentacao as $value) {
			$dados = "";
			$dados = array(
				"usu_codigo" => $usuCodigo,
				"co_pergunta_detalhe" => $value
			);
			try {
				$tbUsuAlimentacao->salvar($dados);
			} catch (Exception $ex) {
				die($ex->getMessage());
				return $ex->getMessage();
			}
		}
	}

	public function salvarHigiene($usuCodigo = FALSE, $higiene = FALSE) {
		$tbUsuHigiene = new Application_Model_UsuarioHigiene();
		$tbUsuHigiene->excluirPorUsuario($usuCodigo);
		foreach ($higiene as $value) {
			$dados = "";
			$dados = array(
				"usu_codigo" => $usuCodigo,
				"co_pergunta_detalhe" => $value
			);
			try {
				$tbUsuHigiene->salvar($dados);
			} catch (Exception $ex) {
				die($ex->getMessage());
				return $ex->getMessage();
			}
		}
	}

	public function vinculaResponsavelProprio($usu_codigo = FALSE, $dom_codigo = FALSE) {
		$tbDom = new Application_Model_Domicilio();
		//$verifica_responsavel = $tbDom->verificaSeJaEResponsavel($usu_codigo);
		$dados = array("dom_codigo" => $dom_codigo,
			"usu_codigo_responsavel" => $usu_codigo);
		try {
			$tbDom->salvar($dados);
		} catch (Exception $exc) {
			die($exc->getMessage());
		}
	}

	public function listaCadastrosDuplicadosAction() {
		$tbUsu = new Application_Model_Usuario();
		$dadosPessoa = array(
			"usu_datanasc" => ($this->_request->getPost("datanascimento", "") ? $this->_request->getPost("datanascimento", "") : NULL),
			"usu_mae" => ($this->_request->getPost("pep_mae", "") ? $this->_request->getPost("pep_mae", "") : NULL),
            "usu_cartao_sus" => ($this->_request->getPost("pep_cartao_sus", "") ? $this->_request->getPost("pep_cartao_sus", "") : NULL)
		);

		$nome = explode(" ", $this->_request->getPost("nome", ""));

		try {
			$qtdCadDup = $tbUsu->listaCadastroDuplicado($dadosPessoa, $nome);
		} catch (Exception $exc) {
			$this->view->dados = "";
			return $this->render("dados", NULL, TRUE);
		}
		$this->view->dados = $qtdCadDup;
		return $this->render("dados", NULL, TRUE);
	}

	public function dadosAction() {
		$usu_codigo = $this->_getParam("cod", FALSE);
		if (!$usu_codigo)
			return $this->_redirect("/");

		$tbUsu = new Application_Model_Usuario();
		$this->view->dados = $tbUsu->getDados($usu_codigo);
		$this->view->obs = $this->_getParam("obs", FALSE);
	}

	public function historicoDeMedicamentosAction() {
		$usu_codigo = $this->_getParam("cod", FALSE);
		if (!$usu_codigo)
			return $this->_redirect("/");

		$tbRecIt = new Application_Model_ReceitaItens();
		$this->view->itens = $tbRecIt->receitasPorUsuario($usu_codigo);
	}

	public function historicoDeMedicamentosRetiradosAction() {
		$usu_codigo = $this->_getParam("cod", FALSE);
		if (!$usu_codigo)
			return $this->_redirect("/");

		$tbMov = new Application_Model_Movimento();
		$this->view->itens = $tbMov->getMedicamentosDispensados($usu_codigo);
	}

	public function anexarAction(){

        $this->view->title = "Anexo de Arquivos";
        $usu_codigo = $this->_getParam("id", FALSE);

        if($usu_codigo){
            $tbUsu = new Application_Model_Usuario();
            $this->view->usuario = $tbUsu->getUsuarioPorId($usu_codigo);
            $this->view->itens = (new Application_Model_UsuarioAnexos())->getAnexosByUsuario($usu_codigo);
            $this->view->tipos = (new Application_Model_TipoDocumento())->listar();
        }
    }

    public function salvarAnexoAction(){

        $tipo = $_FILES['ua_anexo']['type'];
        $size = $_FILES['ua_anexo']['size'];
        $extensao = '';

        $usu_codigo = $this->_request->getPost("usu_codigo");
        $ua_descricao = $this->_request->getPost("ua_descricao");
        $td_codigo = $this->_request->getPost("td_codigo");

        if($tipo !== 'application/pdf' && $tipo !== 'image/jpg' && $tipo !== 'image/png'){
            $this->view->dados = ["success"=>false,"mensagem"=>"Arquivo deve ser do tipo PDF, PNG ou JPG!"];
        } else {
          switch ($tipo){
            case 'application/pdf':
              $extensao = '.pdf';
              break;
            case 'image/jpg':
              $extensao = '.jpg';
              break;
            case 'image/png':
              $extensao = '.png';
              break;
            default:
              $extensao = '';
              break;
          }
        }

        if($size > 10000000){
            $this->view->dados = ["success"=>false,"mensagem"=>"Tamanho máximo permitido: 10Mb!"];
        }
        $fileName = $usu_codigo."_".time().$extensao;
        $sourcePath = $_FILES['ua_anexo']['tmp_name'];
        $targetPath = ANEXOS_PATH."/".$fileName;
        if(move_uploaded_file($sourcePath,$targetPath)){
            $dados = [
                "td_codigo"=>$td_codigo,
                "usu_codigo"=> $usu_codigo,
                "ua_descricao"=>$ua_descricao,
                "ua_data"=> date('Y-m-d'),
                "ua_caminho"=> $fileName
            ];
            try{
                (new Application_Model_UsuarioAnexos())->salvar($dados);
            } catch (Exception $e){
                $this->view->dados = ["success"=>false,"mensagem"=>$e->getMessage()];
            }
            $this->view->dados = ["success"=>true,"mensagem"=>"Arquivo anexado com sucesso!"];

        } else{
            $this->view->dados = ["success"=>false,"mensagem"=>"Erro ao salvar o upload. Entre em contato com o suporte técnico!"];
        }
        return $this->render("dados", NULL, TRUE);

    }

    public function excluirAnexoAction(){
        $ua_codigo = $this->_getParam("ua_codigo", FALSE);
        $tbUa = new Application_Model_UsuarioAnexos();
        if($ua_codigo){
            $caminho = $tbUa->getCaminho($ua_codigo)->ua_caminho;
            $file = ANEXOS_PATH."/".$caminho;
            if(unlink($file)){
                try{
                    $tbUa->excluir($ua_codigo);
                    $this->view->dados = ["success"=>true,"mensagem"=>"Arquivo excluído com sucesso!"];
                } catch (Exception $e){
                    $this->view->dados = ["success"=>false,"mensagem"=>$e->getMessage()];
                }
            } else {
                $this->view->dados = ["success"=>false,"mensagem"=>"Erro ao excluir o arquivo. Entre em contato com o suporte técnico!"];
            }
            return $this->render("dados", NULL, TRUE);
        }
    }

    public function visualizarAnexoAction(){
        $ua_codigo = $this->_getParam("ua_codigo", FALSE);
        if($ua_codigo){
            $caminho = (new Application_Model_UsuarioAnexos())->getCaminho($ua_codigo)->ua_caminho;
            $file = $_SERVER['PHP_SELF']."../../../../WebSocialSaude/anexos/".$caminho;
            if($caminho){
                $this->view->dados = ["success"=>true,"arquivo"=>$file];
            } else {
                $this->view->dados = ["success"=>false,"mensagem"=>"Erro ao encontrar o arquivo. Entre em contato com o suporte técnico!"];
            }
        }
        return $this->render("dados", NULL, TRUE);
    }

	/**
	 *
	 * Retorna os ultimos exames que foram solicitados para determinado paciente
	 */
	public function historicoDeExamesAction() {
		$usu_codigo = $this->_getParam("cod", FALSE);
		if (!$usu_codigo)
			return $this->_redirect("/");

		$tbRes = new Application_Model_ResultadoExame();
		$dados = $tbRes->getSolicitados($usu_codigo);

		$tbUsr = new Application_Model_Usuarios();
		$id_login = $tbUsr->getUsrAtual();

		$tbAge = new Application_Model_Agendamento();
		$age_codigo = $tbAge->usuEmAberto()->age_codigo;

		$this->view->age_codigo = $age_codigo;
		$this->view->usr_cadastro_codigo = $id_login;
		$this->view->itens = $dados;
	}

	public function historicoEncaminhamentosAction() {
		$this->_helper->layout->setLayout("vazio");
		$usu_codigo = $_SESSION[prontuario][age]->usu_codigo ? $_SESSION[prontuario][age]->usu_codigo : $this->_getParam("usu_codigo", FALSE);
		$tipo = $this->_getParam("tipo", FALSE);

		$tbEnc = new Application_Model_Encaminhamento();
		$this->view->itens = $tbEnc->getEncaminhamentos($usu_codigo, null, null, null);
		$this->view->tipo = $tipo;
	}

	public function historicoDeExamesRealizadosAction() {
		$this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/default/paciente/historico-de-exames-realizados.js');
		$this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/jquery.elevateZoom-2.5.5.min.js');
		$usu_codigo = $this->_getParam("cod", FALSE);
		if (!$usu_codigo)
			return $this->_redirect("/");

		$tbRes = new Application_Model_ResultadoExame();
		$dados = $tbRes->getColetados($usu_codigo);
		$this->view->itens = $dados;

		$tbUpl = new Application_Model_UploadArquivo();
		$dadosImg = $tbUpl->getArquivosPorUsuario($usu_codigo);

		$this->view->itensImg = $dadosImg;
	}

	/**
	 * Retorna os USU's em JSON
	 * O retorno é usado pelo plugin de busca
	 */
	public function buscarAction() {
		$tbUsu = new Application_Model_Usuario();
		$term = $this->_getParam("term", FALSE);
		$tipo_busca = $this->_getParam("tipo_busca", FALSE);
		if ($tipo_busca == "") {
			$this->view->dados = $tbUsu->buscar($term);
		} else {
			$this->view->dados = $tbUsu->buscarFiltro($term, $tipo_busca);
		}

		return $this->render("dados", NULL, TRUE);
	}

	public function verificaVinculosDomicilioAction() {
		$usu_codigo = $this->_getParam("usu_codigo", FALSE);
		$tbUsu = new Application_Model_Usuario();
		$this->view->dados = $tbUsu->getVinculoComDomicilio($usu_codigo)->toArray();

		return $this->render("dados", NULL, TRUE);
	}

	public function buscarUsuarioRelatorioAction() {
		$tbUsu = new Application_Model_Usuario();
		$term = $this->_getParam("term", FALSE);
		$this->view->dados = $tbUsu->buscarUsuarioRelatorio($term);
		return $this->render("dados", NULL, TRUE);
	}

	public function buscarOcupacaoAction() {
		$term = $this->_getParam("term", FALSE);
		$tbOcu = new Application_Model_Ocupacao();
		// echo "<pre>".  print_r($tbEst->fetchAll("pais_codigo = '$pais_codigo'"),1);die();
		$this->view->dados = $tbOcu->buscar($term);
		//die($this->view->estados);
		return $this->render("dados", NULL, TRUE);
	}

	public function tipoLogradouroAction() {
		$tbTpLogr = new Application_Model_TbMsTipoLogradouro();
		$id = $this->_getParam("id", FALSE);
		$select = $tbTpLogr->selectTag($id);
		$this->view->dados = $select;
		return $this->render("dados", NULL, TRUE);
	}

	/* ----------------------------------------------------------------
	 * MODULO E-SUS
	 * ---------------------------------------------------------------- */

	public function getDadosImportacaoCodigoAction($eir_codigo) {
		$tbEir = new Application_Model_EsusImportacaoResultado();
		$dadosEir = $tbEir->getDadosResultadoCodigo($eir_codigo);
		return $dadosEir;
	}

	public function editaPacienteEsusAction() {
		$this->_helper->layout->disableLayout();
		$eir_codigo = trim($this->_request->getPost("eir_codigo"));
		$usu_codigo = trim($this->_request->getPost("usu_codigo"));

		$tbUsu = new Application_Model_Usuario();
		$dadosEir = $this->getDadosImportacaoCodigoAction($eir_codigo);
		$dadosPac = $tbUsu->getPacientesPelaMaeNomeNasc($dadosEir, $usu_codigo);

		if (count($dadosPac) == 0) {
			$this->view->dados = "aviso";
		} else
			if (count($dadosPac) == 1) {
				$this->view->dados = "form";
			} else {
				$this->view->dados = "lista";
			}

		return $this->render("dados", NULL, TRUE);
	}

	public function esusListaPacientesDuplicadosAction() {
		$this->_helper->layout->disableLayout();
		$this->view->title = "E-SUS - Resultados";
		$eir_codigo = trim($this->_request->getParam("eir_codigo"));
		$usu_codigo = trim($this->_request->getParam("usu_codigo"));
		$tbUsu = new Application_Model_Usuario();
		$dadosEir = $this->getDadosImportacaoCodigoAction($eir_codigo);
		$dadosPac = $tbUsu->getPacientesPelaMaeNomeNasc($dadosEir);
		$this->view->dados = $dadosPac;
		$this->view->erroImportacao = $dadosEir->eir_mensagem;
		$this->view->dadosEir = $dadosEir;
	}

	public function esusIncosistenciaInvalidaAction() {
		$this->_helper->layout->disableLayout();
	}

	public function esusFormPacienteAction() {
		$this->_helper->layout->disableLayout();
		$this->view->title = "Edita Incosistências Paciente";
		$eir_codigo = trim($this->_request->getParam("eir_codigo"));
		$usu_codigo = trim($this->_request->getParam("usu_codigo"));
		$tbRac = new Application_Model_Raca();
		$tbUsu = new Application_Model_Usuario();
		$tbConf = new Application_Model_Configuracao();
		$dadosEir = $this->getDadosImportacaoCodigoAction($eir_codigo);
		$dadosPac = $tbUsu->getPacientesPelaMaeNomeNasc($dadosEir, $usu_codigo);
		$this->view->raca = $tbRac->fetchAll("rac_ativacao = 'A'");
		$this->view->erroImportacao = $dadosEir->eir_mensagem;
        $vinculo_municipal = $tbConf->getConfig("USA_VINCULO_MUNICIPAL");
        $this->view->vinculo_municipal = $vinculo_municipal;
		//echo $this->view->erroImportacao; die("Erro");
		$this->view->dados = $dadosPac;
	}

	public function esusFormPacienteCnsAction() {
		$this->_helper->layout->disableLayout();
		$this->view->title = "Edita Incosistências Paciente";
		$usu_codigo = trim($this->_request->getParam("usu_codigo"));
		$ativCol = trim($this->_request->getParam("ativ_col"));
		$tbUsu = new Application_Model_Usuario();
        $tbConf = new Application_Model_Configuracao();
		$dadosPac = $tbUsu->getDados($usu_codigo);
		$this->view->dados = $dadosPac;
		$this->view->ativCol = $ativCol;
        $vinculo_municipal = $tbConf->getConfig("USA_VINCULO_MUNICIPAL");
        $this->view->vinculo_municipal = $vinculo_municipal;
	}

	public function esusFormPacienteCnsSalvarAction() {
		$tbUsu = new Application_Model_Usuario();
		$array_dados = array("usu_nome" => trim(mb_convert_case($_POST['usu_nome'], MB_CASE_UPPER, "UTF-8")),
			"usu_mae" => trim(mb_convert_case($_POST['usu_mae'], MB_CASE_UPPER, "UTF-8")),
			"usu_cartao_sus" => mb_convert_case($_POST['usu_cartao_sus'], MB_CASE_UPPER, "UTF-8"),
			"usu_pai" => trim(mb_convert_case($_POST['usu_pai'], MB_CASE_UPPER, "UTF-8")),
			"usu_codigo" => $_POST['usu_codigo'],
			"usu_origem_prontuario" => 'false');
        $tbConf = new Application_Model_Configuracao();
        if($tbConf->getConfig("USA_VINCULO_MUNICIPAL")){
            $array_dados['vinculo_municipal'] = $_POST['vinculo_municipal'];
        }
		$tbUsu->salvar($array_dados);
		return $this->render("dados", NULL, TRUE);
	}

	public function salvarFormPacienteEsusAction() {
		$tbCon = new Application_Model_Configuracao();
		$this->salvarPacienteEsusAction($_POST);
	}

	public function salvarPacienteEsusAction($post) {
		$this->_helper->layout->disableLayout();
		// Array de Dados Usuario
		$paciente = array(
			"usu_nome" => ($this->_request->getPost("nome", "") ? mb_strtoupper($this->_request->getPost("nome", ""), "UTF-8") : NULL),
			"usu_datanasc" => ($this->_request->getPost("datanascimento", "") ? strtoupper($this->_request->getPost("datanascimento", "")) : NULL),
			"usu_pis_pasep" => ($this->_request->getPost("pispasep", "") ? $this->_request->getPost("pispasep", "") : NULL),
			"usu_cpf" => ($this->_request->getPost("cnpj_cpf", "") ? $this->_request->getPost("cnpj_cpf", "") : NULL),
			"usu_mae" => ($this->_request->getPost("pep_mae", "") ? mb_strtoupper($this->_request->getPost("pep_mae", ""), "UTF-8") : NULL),
			"usu_celular" => ($this->_request->getPost("pep_celular", "") ? $this->_request->getPost("pep_celular", "") : NULL),
			"usu_fone" => ($this->_request->getPost("pep_telefone", "") ? $this->_request->getPost("pep_telefone", "") : NULL),
			"usu_fone_recado" => ($this->_request->getPost("pep_contato", "") ? $this->_request->getPost("pep_contato", "") : NULL),
			"usu_cartao_sus" => ($this->_request->getPost("pep_cartao_sus", "") ? $this->_request->getPost("pep_cartao_sus", "") : NULL),
			"rac_codigo" => ($this->_request->getPost("rac_codigo", "") ? $this->_request->getPost("rac_codigo", "") : NULL),
			"usu_origem_prontuario" => 'false',
		);
		// Valida edição
		if ($this->_request->getPost("usu_codigo")) {
			$paciente["usu_codigo"] = $this->_request->getPost("usu_codigo");
		}

		Zend_Db_Table::getDefaultAdapter()->beginTransaction();
		try {
			// Salvando dados usuario
			$tbUsu = new Application_Model_Usuario();
			$usu_codigo = $tbUsu->salvar($paciente);
			Zend_Db_Table::getDefaultAdapter()->commit();
		} catch (Exception $exc) {
			Zend_Db_Table::getDefaultAdapter()->roolBack();
			$this->view->dados = $exc->getMessage();
			return $this->render("dados", NULL, TRUE);
		}
		$this->view->dados = "";
		return $this->render("dados", NULL, TRUE);
	}

	public function buscaUltimoAgendadoAction() {
		$tbAgee = new Application_Model_AgendamentoExterno();
		$codUser = $this->_request->getPost("codUser");
		if ($codUser) {
			$this->view->dados = $tbAgee->getUltimoPacienteAgendado($codUser);
			return $this->render("dados", NULL, TRUE);
		}
	}

}
