<?php

class ProdutoController extends Zend_Controller_Action {

  public function init() {
    $this->_helper->acl->allow(NULL);
    $this->view->title = "Produtos";
  }

  public function indexAction() {
    $tbProd = new Application_Model_Produto();
    $this->view->itens = $tbProd->listProdutos();
  }

  /**
   * Busca os todos produtos (medicamento ou não)
   * Retorna um json, para ser usado com o plugin jquery.buscar.js
   */
  public function buscarAction() {
    $term = $this->_getParam("term", FALSE);
    $horus = $this->_getParam("horus", FALSE);

    if (!$term)
      return false;

    $tbPro = new Application_Model_Produto();
    $limite = $this->_getParam("limite", FALSE);
    if ($horus) {
      $this->view->dados = $tbPro->buscarMedicamentosHorus($term, $limite);
    } else {
      $this->view->dados = $tbPro->buscarMedicamentos($term, $limite);
    }

    return $this->render("dados", NULL, TRUE);
  }

  public function pesquisaAction(){
    $term = $this->_getParam("busca");

    $tbPro = new Application_Model_Produto();

    $this->view->itens = $tbPro->pesquisar($term);
    $this->render('index');
  }

//  public function novoAction() {
//    $popup = $this->_getParam("popup", FALSE);
//
//    return $this->_redirect("../../../WebSocialSaude/materiais.php?acao=form_add&popup=$popup");
//  }

  public function novoAction()
  {
    $tbTipoProd = new Application_Model_TipoProduto();
    $this->view->tipo_produto = $tbTipoProd->listar();

    $tbGrupoProd = new Application_Model_ProdutoGrupo();
    $this->view->grupo_produto = $tbGrupoProd->listar();

    $tbSubgrupoProd = new Application_Model_ProdutoSubgrupo();
    $this->view->subgrupo_produto = $tbSubgrupoProd->listar();

    $tbUnidmedida = new Application_Model_Unidmedida();
    $this->view->unidade_medida = $tbUnidmedida->listar();

    $tbPsico = new Application_Model_PortariaPsicotropico();
    $this->view->portaria_psico = $tbPsico->listar();

    $tbImu = new Application_Model_TbVacinaImunobiologico();
    $this->view->imunobiologicos = $tbImu->getImunobiologicos();

    $this->render('form');
  }

  public function formAction()
  {
    $tbTipoProd = new Application_Model_TipoProduto();
    $this->view->tipo_produto = $tbTipoProd->listar();

    $tbGrupoProd = new Application_Model_ProdutoGrupo();
    $this->view->grupo_produto = $tbGrupoProd->listar();

    $tbSubgrupoProd = new Application_Model_ProdutoSubgrupo();
    $this->view->subgrupo_produto = $tbSubgrupoProd->listar();

    $tbUnidmedida = new Application_Model_Unidmedida();
    $this->view->unidade_medida = $tbUnidmedida->listar();

    $tbPsico = new Application_Model_PortariaPsicotropico();
    $this->view->portaria_psico = $tbPsico->listar();

    $tbImu = new Application_Model_TbVacinaImunobiologico();
    $this->view->imunobiologicos = $tbImu->getImunobiologicos();

    $id = $this->_getParam("id", FALSE);

    if ($id) {
      $tbProd = new Application_Model_Produto();
      $this->view->dados = $tbProd->editar($id);
      $this->view->vinculos = $tbProd->getVinculosPorProduto($id);
    }

  }

  public function salvarAction(){
    $data = $this->_request->getPost();
    $tbPro = new Application_Model_Produto();

    try{
      $pro_codigo = $tbPro->salvarProduto($data);
      $this->view->dados = array("success" => true, "novo" => $pro_codigo);
    }catch (Exception $e){
      $this->view->dados = array("success" => false,"mensagem" => $e->getMessage());
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function salvarVinculoAction(){
    $produto= $this->_request->getPost('produto');
    $setor = $this->_request->getPost('setor');
    $data = array('set_codigo' => $setor, 'pro_codigo' => $produto);

    $tbProset = new Application_Model_ProdutoSetor();
    $jaExisteVinculo = $tbProset->verificaVinculoProdutoSetor($produto, $setor);

    if($jaExisteVinculo == 0){
      try{
        $proset_codigo = $tbProset->salvar($data);
        $this->view->dados = array("success" => true, "prset_codigo" => $proset_codigo);
      }catch (Exception $e){
        $this->view->dados = array("success" => false,"mensagem" => $e->getMessage());
      }
    } else {
      $this->view->dados = array("success" => false,"mensagem" => "O produto já possui vínculo com este setor!");
    }
    return $this->render("dados", NULL, TRUE);
  }

  /**
   * Busca os todos Medicamentos (controlados ou não)
   * Retorna um json, para ser usado com o plugin jquery.buscar.js
   */
  public function medicamentoAction() {
    $term = $this->_getParam("term", FALSE);
    $todos = $this->_getParam("todos", FALSE);

    if (!$term)
      return false;

    $tbPro = new Application_Model_Produto();
    $limite = $this->_getParam("limite", FALSE);

    $this->view->dados = $tbPro->buscarMedicamentos($term, $todos, $limite);

    return $this->render("dados", NULL, TRUE);
  }

  /**
   * Busca os Medicamentos do Posto (não-controlados)
   * Retorna um json, para ser usado com o plugin jquery.buscar.js
   */
  public function medicamentoPostoAction() {
    $term = $this->_getParam("term", FALSE);
    if (!$term)
      return false;

    $tbPro = new Application_Model_Produto();
    $this->view->dados = $tbPro->buscarMedicamentosPosto($term);

    return $this->render("dados", NULL, TRUE);
  }

  public function buscarProdutosAction() {
    $term = $this->_getParam("term", FALSE);
    $set_codigo = $this->_getParam("setor", FALSE);
    if (!$term)
      return false;

    $tbPro = new Application_Model_Produto();
    $limite = $this->_getParam("limite", FALSE);
    $this->view->dados = $tbPro->buscarProdutos($term, $limite, $set_codigo);

    return $this->render("dados", NULL, TRUE);
  }

  public function buscarProdutosComEstoqueAction() {
    $term = $this->_getParam("term", FALSE);

    $set_codigo = $this->_getParam("setor", FALSE);
    $tipo = $this->_getParam("tipo", FALSE);

    if (!$term)
      return false;

    $tbPro = new Application_Model_Produto();
    $limite = $this->_getParam("limite", FALSE) ? $this->_getParam("limite", FALSE) : $this->_getParam("l", FALSE);
    $this->view->dados = $tbPro->buscarProdutosComEstoque($term, $limite, $set_codigo, $tipo);

    return $this->render("dados", NULL, TRUE);
  }

  /**
   * Busca os Medicamentos Controlados
   * Retorna um json, para ser usado com o plugin jquery.buscar.js
   */
  public function medicamentoControladosAction() {
    $term = $this->_getParam("term", FALSE);
    if (!$term)
      return false;

    $tbPro = new Application_Model_Produto();
    $this->view->dados = $tbPro->buscarMedicamentosControlado($term);

    return $this->render("dados", NULL, TRUE);
  }

  public function reservarAction() {
    $tipo = $this->_request->getPost("tipo", FALSE);
    $codigo = $this->_request->getPost("codigo", FALSE);
    $saldo = $this->_request->getPost("saldo", array());
    $cont = $this->_request->getPost("cont", array());
    $produtos = $this->_request->getPost("pro", NULL);
    $tbPro = new Application_Model_Produto();
    $tbCFR = new Application_Model_ControleFracionadoReserva();
    $tbUsr = new Application_Model_Usuarios();
    $set_codigo = $tbUsr->getUsrAtual()->set_codigo;
    $data_hora = $this->_request->getPost("data_hora");
    $tbLgp = new Application_Model_LeitoGradeProdutos();
    $usr_codigo = $this->_request->getPost("usr_codigo", FALSE);
    if ($produtos) {
      $tbMov = new Application_Model_Movimento();
      $tbMItens = new Application_Model_ItensMovimento();
      $dados = array(
        "mov_data" => $data_hora,
        "usr_codigo" => $usr_codigo,
        "mov_tipo" => "S",
        "mov_saida" => "D",
      );
      $mov_codigo = $tbMov->salvar($dados);


      foreach ($produtos as $produto) {
        $mov = array(
          "mov_codigo" => $mov_codigo,
          "pro_codigo" => $produto['pro_codigo'],
          "ite_lote" => $produto['pro_lote'],
          "ite_quantidade" => $produto['pro_qtde'],
          "ite_validade" => $produto['pro_validade'],
        );
        $item = $tbMItens->salvar($mov);
        $produto['lgp_status'] = 'R';
        $produto['ite_codigo'] = $item;
        unset($produto['pro_qtde_max']);
        $tbLgp->salvar($produto);

      }

    }


    try {
      $novos = $tbPro->fracionarVarios($saldo);

      // PHP Bug: array_merge não preserva a chave se ela for int
      // http://br2.php.net/manual/pt_BR/function.array-merge.php#107590
      if ($novos) {
        foreach ($novos as $k => $v)
          $cont[$k] = $v;
      }

      $return = $tbCFR->addParaReserva($tipo, $codigo, $cont);
      $this->view->dados = array("success" => true, "mensagem" => $return);
    } catch (Exception $exc) {
      $this->view->dados = array("error" => true, "mensagem" => $exc->getMessage());
    }

    return $this->render("dados", NULL, TRUE);
  }

  /**
   * Usado para cancelar a reserva
   */
  public function retirarReservaAction() {
    $this->_helper->layout->disableLayout();
    $this->_helper->viewRenderer->setNoRender(true);

    $tipo = $this->_request->getPost("tipo", FALSE);
    $codigo = $this->_request->getPost("codigo", FALSE);

    if (!$tipo || !$codigo)
      return FALSE;
    $tbLgp = new Application_Model_LeitoGradeProdutos();

    $produtos = $tbLgp->buscarRerservas($codigo);


    if ($produtos) {

      $tbMov = new Application_Model_ItensMovimento();
      $tbLgp->cancelar($codigo);
      foreach ($produtos as $pro) {

        $tbMov->deletar($pro->ite_codigo);
      }
    }
    $tbCFR = new Application_Model_ControleFracionadoReserva();
    $tbCFR->devolver($tipo, $codigo);
  }

  public function vincularProdutoSetorAction() {
    $this->_helper->layout->disableLayout();
    $this->_helper->viewRenderer->setNoRender(true);

    $pro_codigo = $this->_getParam("pro_codigo", FALSE);
    $set_codigo = $this->_getParam("set_codigo", FALSE);

    $tbProset = new Application_Model_ProdutoSetor();
    $data = array("set_codigo" => $set_codigo, "pro_codigo" => $pro_codigo);
    try {
      $tbProset->salvar($data);
      $this->view->dados = 1;
    } catch (Exception $exc) {
      $this->view->dados = $exc->getMessage();
    }

    return $this->render("dados", NULL, TRUE);

  }

  public function getLotesAction() {
    $pro_codigo = $this->_getParam("pro_codigo", FALSE);
    $set_codigo = $this->_getParam("set_codigo", FALSE);
    $ite_codbarras = $this->_getParam("ite_codbarras", FALSE);

    $enviados = $this->_getParam("enviados", FALSE); // esse parametro irá definir se ele vai buscar a quanTIDADE - as quantidades enviadas na requisicao
    $tipo = $this->_getParam("tipo", FALSE);
    if ($tipo == "S") {
      $somenteVencidos = FALSE;
    } else {
      $somenteVencidos = TRUE;
    }

    $tbSal = new Application_Model_Saldo();
    $this->view->dados = $tbSal->getLotesComCodBarras($pro_codigo, $set_codigo, $ite_codbarras, $somenteVencidos, $enviados)->toArray();

    return $this->render("dados", NULL, TRUE);
  }

  public function verificaProdutoSetorAction() {
    $pro_codigo = $this->_getParam("pro_codigo", FALSE);
    $set_codigo = $this->_getParam("set_codigo", FALSE);
    $tbProSet = new Application_Model_ProdutoSetor();
    $verifica_vinculo_setor = $tbProSet->verificaVinculoProdutoSetor($pro_codigo, $set_codigo);
    $this->view->dados = $verifica_vinculo_setor;
    return $this->render("dados", NULL, TRUE);
  }

  public function getProdutoAction() {
    $pro_codigo = $this->_getParam("pro_codigo", FALSE);
    $tbPro = new Application_Model_Produto();
    $dados = $tbPro->getProduto($pro_codigo);
    if ($dados)
      $this->view->dados = $dados->toArray();

    return $this->render("dados", NULL, TRUE);
  }

  public function getProdutoComEstoqueAction() {
    $pro_codigo = $this->_getParam("pro_codigo", FALSE);
    $set_codigo = $this->_getParam("set_codigo", FALSE);
    $ite_codbarras = $this->_getParam("ite_codbarras", FALSE);

    $tbPro = new Application_Model_Produto();
    $dados = $tbPro->getProdutoComEstoqueComCodBarras($pro_codigo, $set_codigo, $ite_codbarras);
    if ($dados)
      $this->view->dados = $dados->toArray();

    return $this->render("dados", NULL, TRUE);
  }

  public function getLoteAutomaticoAction() {
    $pro_codigo = $this->_getParam("pro_codigo", FALSE);
    $set_codigo = $this->_getParam("set_codigo", FALSE);
    $ite_codbarras = $this->_getParam("ite_codbarras", FALSE);
    $sal_quantidade = $this->_getParam("quantidade", FALSE);
    $tbSal = new Application_Model_Saldo();
    $lotes = $tbSal->getLotesComCodBarras($pro_codigo, $set_codigo, $ite_codbarras, true, 1)->toArray();
    $lotes_dispensar = array();
    $pegar = 0;
    $faltam = $sal_quantidade;
    foreach ($lotes as $lote) {
      if ($lote[sal_qtde] > $faltam) {
        $pegar = $faltam;
      } else {
        $pegar = $lote[sal_qtde];
      }
      $faltam -= $pegar;

      $lotes_dispensar[$lote[sal_lote]] = $pegar . "|" . $lote[sal_validade] . "|" . $lote[ite_codbarras];

      if ($faltam == 0) {
        break;
      }
    }

    if ($faltam > 0) {
      $lotes_dispensar["faltam"] = $faltam;
    }
    $this->view->dados = $lotes_dispensar;
    return $this->render("dados", null, true);
  }

  public function verificaSeDispensouNoDiaAction() {
    $pro_codigo = $this->_getParam("pro_codigo", FALSE);
    $usu_codigo = $this->_getParam("usu_codigo", FALSE);
    $ite_codbarras = $this->_getParam("ite_codbarras", FALSE);
    $params = array("mov_data" => date("d/m/Y"), "usu_codigo" => $usu_codigo, "pro_codigo" => $pro_codigo, "ite_codbarras" => $ite_codbarras);
    $tbIte = new Application_Model_ItensMovimento();
    if ($tbIte->verificaSeJaDispensou($params)) {
      $this->view->dados = 0;
    } else {
      $this->view->dados = 1;
    }

    return $this->render("dados", null, true);
  }

  public function buscaUltimoRegistroAction() {
    $this->_helper->viewRenderer->setNoRender(true);
    $this->_helper->layout->disableLayout();
    $tbPro = new Application_Model_Produto();
    $retorno = $tbPro->getUltimoRegistro();

    $this->view->dados = $retorno;
    return $this->render("dados", null, true);
  }

  public function saldoEstoqueSetorAction() {
    $pro_codigo = $this->_getParam("pro_codigo", FALSE);
    $set_codigo = $this->_getParam("set_codigo", FALSE);

    $tbPro = new Application_Model_Produto();
    $this->view->dados = $tbPro->buscarSaldoProdutosComEstoqueSetorSolicitante($pro_codigo, $set_codigo);
    return $this->render("dados", null, true);
  }

  public function produtosHorusAction() {
    $tbHorus = new Application_Model_ProdutoHorus();
    $tbHorus->limparDados();
    // É necessário utilizar arquivos .CSV com delimitador ; e final de linha \n
    $delimitador = ';';
    $cerca = '\n';
    // Buscar arquivos para leitura

    $pasta = dir(HORUS_PATH . "/arquivos");
    $i = 0;
    while (false !== ($entry[$i] = $pasta->read())) {
      $i++;
    }

    for ($i = 2; $i < (count($entry)); $i++) {
      $tipo = explode("_", $entry[$i]);

      if (strpos($entry[$i], ".csv") !== false) {
        $caminho = $pasta->path . "/" . $entry[$i];
        $f = fopen($caminho, "r");
        if ($f) {
          $cabecalho = fgetcsv($f, 0, $delimitador, $cerca);
          $cabecalho = array("descricao", "codigo_horus");
          while (!feof($f)) {
            $linha = fgetcsv($f, 0, $delimitador, $cerca);
            if (!$linha) {
              continue;
            }
            $linha[0] = $this->remover_acentos($linha[0]);
            $linha[0] = mb_convert_encoding($linha[0], "UTF-8");
            $linha[0] = strtoupper($linha[0]);

            $registro = array_combine($cabecalho, $linha);

            switch ($tipo[2]) {
              case 'basico':
                $registro['tipo_horus'] = "B";
                break;
              case 'especializado':
                $registro['tipo_horus'] = "E";
                break;
              case 'estrategico':
                $registro['tipo_horus'] = "S";
                break;
            }
            $tbHorus->salvar($registro);
          }
          fclose($f);
        }
      }
    }
  }

  public function atualizaCatmatAction() {
    $this->produtosHorusAction();
    $produtos = new Application_Model_Produto();
    $produtosHorus = new Application_Model_ProdutoHorus();
    $this->view->title = "Vincula Produto CATMAT";
    $pro_codigo = $this->_getParam("pro_codigo", FALSE);
    $codigo_horus = $this->_getParam("cod_catmat", FALSE);
    $tipo_horus = $this->_getParam("tipo_horus", FALSE);
    $pro_nome = strtoupper($this->_request->getPost("pro_nome"));
    if ($pro_nome) {
      $this->view->produtos = $produtos->produtosSemCatMatPorNome($pro_nome);
    } else {
      $this->view->produtos = $produtos->produtosSemCatMat($pro_codigo);
    }
    if ($pro_codigo) {
      if ($codigo_horus) {
        $array = array("pro_codigo" => $pro_codigo, "pro_horus" => $codigo_horus, "pro_horus_tipo" => $tipo_horus);
        $produtos->salvar($array);
      } else {
        $prod_escolhido = $produtos->getProduto($pro_codigo);
        if ($prod_escolhido) {
          $prod = explode(" ", trim($prod_escolhido->pro_nome));
          $this->view->produtoshorus = $produtosHorus->buscaPorNome($prod[0]);
          $this->view->produto_escolhido = $pro_codigo;
        }
      }
    }
  }

  public function remover_acentos($string) {
    $string = preg_replace("/[áàâãä]/ui", "a", $string);
    $string = preg_replace("/[ÁÀÂÃÄ]/ui", "A", $string);
    $string = preg_replace("/[éèê]/ui", "e", $string);
    $string = preg_replace("/[ÉÈÊ]/ui", "E", $string);
    $string = preg_replace("/[íì]/ui", "i", $string);
    $string = preg_replace("/[ÍÌ]/ui", "I", $string);
    $string = preg_replace("/[óòôõö]/ui", "o", $string);
    $string = preg_replace("/[ÓÒÔÕÖ]/ui", "O", $string);
    $string = preg_replace("/[úùü]/ui", "u", $string);
    $string = preg_replace("/[ÚÙÜ]/ui", "U", $string);
    $string = preg_replace("/ç/", "c", $string);
    $string = preg_replace("/Ç/", "C", $string);
    $string = preg_replace("/[][><}{)(:;,!?*~^`&#@]/", "", $string);
    return $string;
  }

  public function materialHospitalarAction() {
    $term = $this->_getParam("term", FALSE);
    $tbUsr = new Application_Model_Usuarios();
    $setor = $tbUsr->getUsrAtual()->set_codigo;

    if (!$term)
      return false;

    $tbPro = new Application_Model_Produto();
    $this->view->dados = $tbPro->buscarMaterialHospitalar($term, $setor);

    return $this->render("dados", NULL, TRUE);
  }

  public function excluirVinculoAction(){
    $id = $this->_getParam("id", FALSE);
    $tbProset = new Application_Model_ProdutoSetor();
    try{
      $tbProset->excluirVinculo($id);
      $this->view->dados = array("success" => true);
    }catch (Exception $e){
      $this->view->dados = array("success" => false,"mensagem" => $e->getMessage());
    }
    return $this->render("dados", NULL, TRUE);
  }

}
