<?php

require_once __DIR__ . '/../../Util.php';


class RotinaController extends Zend_Controller_Action {

    public function init() {
        $this->view->title = ("Configurações");

    }

    public function corrigecustomedioAction() {
        //Valores E (Entrada) e S (Saídas e Transferências)
        $tipo_movimento = $this->_getParam("tipo", 'E');

        //Código do setor desejado
        $setor = $this->_getParam("setor");

        //Código do setor desejado
        $data_inicial = $this->_getParam("data");

        //Valores 0 e 1
        $producao = $this->_getParam("producao", 0);

        /*
        * Exemplo de utilização:
        *
        * http://localhost:8081/WebSocialSaude/zf/rotina/corrigecustomedio/tipo/E/setor/999/data/2018-06-21/producao/0 (Modo de visualização)
        *
        * ou
        *
        * http://localhost:8081/WebSocialSaude/zf/rotina/corrigecustomedio/tipo/E/setor/999/data/2018-06-21/producao/1 (Modo de produção)
        */

        $tbIte = new Application_Model_ItensMovimento();
        $tbPro = new Application_Model_Produto();

        //Busca os produtos disponíveis para selecionar os movimentos
        $produtos = $tbPro->getTodosProdutos()->toArray();

        $listaProdutos = [];

        foreach ($produtos as $produto) {
            array_push($listaProdutos, $produto['pro_codigo']);
        }

        //Se o parâmetro do tipo de movimento for 'E', entra aqui...
        if ($tipo_movimento == 'E') {
            foreach ($listaProdutos as $prod) {
                //Busca os itens de entradas
                $itensEntrada = $tbIte->getItensEntradaPorProduto($prod, $setor, $data_inicial, TRUE)->toArray();

                foreach ($itensEntrada as $entrada) {
                    //Calcula o custo médio de cada item
                    $custo_medio_entrada = $tbIte->calculaCustoMedio($entrada['ite_vlrunit'], $entrada['ite_quantidade'], $entrada['mov_data'], $entrada['pro_codigo']);

                    echo "Código do item: " . $entrada['ite_codigo'] . "<br/>
					Tipo de movimento: ENTRADA <br/>
					Código do Produto: " . $entrada['pro_codigo'] . "<br/>
					Quantidade informada: " . $entrada['ite_quantidade'] . "<br/>
					Valor unitário: " . $entrada['ite_vlrunit'] . "<br/>
					Data do movimento: " . $entrada['mov_data'] . "<br/>
					Custo médio calculado: " . $custo_medio_entrada . "<br/><br/><br/>";

                    //Se o modo de produção estiver ligado, monta o array de dados e atualiza o registro
                    if ($producao == 1) {
                        $data = [
                            "ite_codigo" => $entrada['ite_codigo'],
                            "ite_quantidade" => $entrada['ite_quantidade'],
                            "mov_codigo" => $entrada['mov_codigo'],
                            "ite_custo_medio" => $custo_medio_entrada
                        ];

                        try {
                            $tbIte->atualizaCustoMedio($data);
                        } catch (Exception $ex) {
                            throw new Zend_Validate_Exception("Falha ao atualizar os itens da movimentação!" . $ex->getMessage());
                        }
                    }
                }
            }
        }

        if ($tipo_movimento == 'S') {
            $cont = 0;
            foreach ($listaProdutos as $prod) {
                $itensSaida = $tbIte->getItensSaidaPorProduto($prod, $setor, $data_inicial)->toArray();

                foreach ($itensSaida as $saida) {
                    $custo_medio_saida = $tbIte->buscaCustoMedio($saida['ite_lote'], $saida['pro_codigo'], $saida['mov_data']);

                    echo "Código do item: " . $saida['ite_codigo'] . "<br/>
					Tipo de movimento: SAÍDA <br/>
					Código do Produto: " . $saida['pro_codigo'] . "<br/>
					Data do movimento: " . $saida['mov_data'] . "<br/>
					Custo médio: " . $custo_medio_saida . "<br/><br/><br/>";

                    if ($producao == 1) {
                        $data = [
                            "ite_codigo" => $saida['ite_codigo'],
                            "ite_quantidade" => $saida['ite_quantidade'],
                            "mov_codigo" => $saida['mov_codigo'],
                            "pro_codigo" => $saida['pro_codigo'],
                            "ite_lote" => $saida['ite_lote'],
                            "ite_validade" => $saida['ite_validade'],
                            "ite_custo_medio" => $custo_medio_saida
                        ];

                        try {
                            $tbIte->atualizaCustoMedio($data);
                            $cont++;
                        } catch (Exception $ex) {
                            throw new Zend_Validate_Exception("Falha ao atualizar os itens da movimentação!" . $ex->getMessage());
                        }
                    }
                }
            }
        }

        if ($producao == 1) {
            echo("<span style='font-size: larger; font-weight: bolder; color: red'>" . $cont . " registros atualizados com sucesso!</span><br/><br/><br/>");
        } else {
            echo("<span style='font-size: larger; font-weight: bolder; color: red'>Nenhum registro foi atualizado. Previsão de " . $cont . " registros. Log disponível apenas para visualização.</span><br/><br/><br/>");
        }

        die();
    }

    public function converteagendaAction() {
        //Valores 0 e 1
        $producao = $this->_getParam("producao", 0);

        /*
        * Exemplo de utilização:
        *
        * http://localhost:8081/WebSocialSaude/zf/rotina/converteagenda/producao/0 (Modo de visualização)
        *
        * ou
        *
        * http://localhost:8081/WebSocialSaude/zf/rotina/converteagenda/producao/1 (Modo de produção)
        */

        $cont = 0;

        $tbCondi = new Application_Model_ConvenioDiasSemanaAgendamento();
        $tbConho = new Application_Model_ConvenioHorarios();
        $tbConv = new Application_Model_Convenio();
        $tbConi = new Application_Model_ConvenioItens();
        $tbAge = new Application_Model_Agendamento();

        $convenios = $tbConv->buscaTodosConvenios()->toArray();

        foreach ($convenios as $convenio) {
            $convenio_itens = $tbConv->buscaItensConvenioAgenda($convenio['conv_codigo'])->toArray();
        }

        foreach ($convenio_itens as $coni_codigo) {
            //Busca os dados da agenda antiga
            $agenda_old = $tbCondi->listaDadosPordia($coni_codigo['coni_codigo']);

            foreach ($agenda_old as $key => $agenda_antiga) {
                echo("<table><tr><td>");
                echo("<b>Dados antigos da agenda: </b><br/>");
                switch ($key) {
                    case '1':
                        echo "Dia da semana: Segunda-feira<br/>";
                        break;
                    case '2':
                        echo "Dia da semana: Terça-feira<br/>";
                        break;
                    case '3':
                        echo "Dia da semana: Quarta-feira<br/>";
                        break;
                    case '4':
                        echo "Dia da semana: Quinta-feira<br/>";
                        break;
                    case '5':
                        echo "Dia da semana: Sexta-feira<br/>";
                        break;
                    case '6':
                        echo "Dia da semana: Sábado<br/>";
                        break;
                    case '7':
                        echo "Dia da semana: Domingo<br/>";
                        break;
                }
                echo("Cota antiga: " . $agenda_antiga['condi_age_cota_dia'] . "<br/>");
                echo("Cota de encaixes antiga: " . $agenda_antiga['condi_age_encaixe'] . "<br/>");
                echo("Intervalo antigo: " . $agenda_antiga['condi_age_intervalo'] . " minutos. <br/><br/>");

                //Busca os dados da agenda nova relacionados
                $agenda_new = $tbConho->getConvenioHorarios($coni_codigo['coni_codigo'], $agenda_antiga['condi_age_codigo']);
                $tempo_agenda = "";

                //Calcula tempo total da agenda no dia selecionado
                foreach ($agenda_new as $agenda_nova) {
                    $hora_inicial = DateTime::createFromFormat('H:i:s', $agenda_nova['hora_inicial']);
                    $hora_fim = DateTime::createFromFormat('H:i:s', $agenda_nova['hora_final']);

                    $intervalo = $hora_inicial->diff($hora_fim);

                    $tempo = $intervalo->h + ($intervalo->i / 60) + ($intervalo->s / 3600);
                    $tempo_agenda += $tempo;
                }

                echo("<b>Dados novos da agenda: </b><br/>");
                echo("Tempo total da agenda nova: " . $tempo_agenda . " horas.");
                echo "<br/><br/>";
                echo("</td></tr></table>");
                echo("<table><tr>");

                foreach ($agenda_new as $agenda_nova) {
                    echo("<td style='padding-right: 40px;'>");
                    $hora_inicial = DateTime::createFromFormat('H:i:s', $agenda_nova['hora_inicial']);
                    $hora_fim = DateTime::createFromFormat('H:i:s', $agenda_nova['hora_final']);

                    $intervalo = $hora_inicial->diff($hora_fim);

                    $tempo = $intervalo->h + ($intervalo->i / 60) + ($intervalo->s / 3600);

                    echo("Horário do turno: " . $agenda_nova['hora_inicial'] . " às " . $agenda_nova['hora_final'] . "<br/>");

                    $porcentagem = round((($tempo / $tempo_agenda) * 100));
                    echo("Tempo total do turno: " . $tempo . " horas (" . $porcentagem . "%)" . "<br/>");

                    $nova_cota = round($agenda_antiga['condi_age_cota_dia'] * ($porcentagem / 100));
                    echo("Nova cota do turno: " . $nova_cota . "<br/>");

                    $nova_cota_encaixe = round($agenda_antiga['condi_age_encaixe'] * ($porcentagem / 100));
                    echo("Nova cota de encaixes do turno: " . $nova_cota_encaixe . "<br/>");

                    $novo_intervalo = ($tempo * 60) / ($nova_cota + $nova_cota_encaixe);
                    echo("Novo intervalo entre consultas: " . round($novo_intervalo, 2) . " minutos.<br/><br/>");

                    echo("</td>");

                    if ($producao == 1) {
                        $data = [
                            "hora_codigo" => $agenda_nova['hora_codigo'],
                            "hora_inicial" => $agenda_nova['hora_inicial'],
                            "hora_final" => $agenda_nova['hora_final'],
                            "coni_codigo" => $agenda_nova['coni_codigo'],
                            "condi_age_codigo" => $agenda_nova['condi_age_codigo'],
                            "conh_intervalo" => round($novo_intervalo, 2),
                            "conh_encaixe" => $nova_cota_encaixe,
                            "conh_cota_dia" => $nova_cota
                        ];

                        try {
                            $tbConho->salvar($data);
                            $cont++;
                        } catch (Exception $ex) {
                            throw new Zend_Validate_Exception("Falha ao atualizar os itens da movimentação!" . $ex->getMessage());
                        }
                    }
                }

                echo("</tr></table>");
                echo "----------------------------------------------------------------------------------------------------------------------------------<br/><br/>";
            }
        }

        if ($producao == 1) {
            echo("<span style='font-size: larger; font-weight: bolder; color: red'>$cont registros atualizados com sucesso!</span><br/><br/><br/>");
        } else {
            echo("<span style='font-size: larger; font-weight: bolder; color: red'>Nenhum registro foi atualizado. Previsão de $cont registros. Log disponível apenas para visualização.</span><br/><br/><br/>");
        }

        die();
    }

    public function integracaoagenticAction() {
        /*
        * Exemplo de utilização:
        *
        * http://localhost:8081/WebSocialSaude/zf/rotina/integracaoagentic
        */

        $integracoesRealizadas = [
            'sucessos' => [
                'medico' => 0,
                'medico_externo' => 0,
                'paciente' => 0,
            ],
            'erros' => [
                'medico' => 0,
                'medico_externo' => 0,
                'paciente' => 0,
            ],
        ];
        // Cadastrar médicos
		$tipo = 'medico';
		$this->integrarRegistros(new Application_Model_Usuarios(), $tipo, $integracoesRealizadas);
		$this->mensagemConclusao($integracoesRealizadas, $tipo);

        // Cadastrar médicos externos
		$tipo = 'medicoExterno';
		$this->integrarRegistros(new Application_Model_Medico(), $tipo, $integracoesRealizadas);
		$this->mensagemConclusao($integracoesRealizadas, $tipo);

        // Cadastrar pacientes
        $tipo = 'paciente';
        $this->integrarRegistros(new Application_Model_Usuario(), $tipo, $integracoesRealizadas);
        $this->mensagemConclusao($integracoesRealizadas, $tipo);

        // Informa o fim da integração e a quantidade de erros/sucessos
        $this->mensagemConclusao($integracoesRealizadas);
    }

    private function integrarRegistros($obj, $tipo, &$arrIntegracao) {
        $token = Util::gerarToken();
        $dados = $obj->getDadosAgentic();
        foreach ($dados as $dado) {
            $dado["access_token"] = $token->response->dados->access_token;
            if ($this->registroPodeSerIntegrado($dado, $tipo)) {
                if ($tipo == 'medico') {
                    $dado["usr_codigo_agentic"] = Util::sendRequestAgentic($dado, $tipo, $this->getEndpoint($tipo));
                    unset($dado['cid_nome']);
                    unset($dado['uf_sigla']);
                    unset($dado['esp_nome']);
                    unset($dado['con_codigo']);
                    unset($dado['con_descricao']);
                    $arrIntegracao['sucessos']['medico']++;
                }
                elseif ($tipo == 'medicoExterno') {
                    $dado["med_codigo_agentic"] = Util::sendRequestAgentic($dado, $tipo, $this->getEndpoint($tipo));
					unset($dado['con_codigo']);
					unset($dado['con_descricao']);
                    $arrIntegracao['sucessos']['medico_externo']++;
                }
                elseif ($tipo == 'paciente') {
                    $dado["usu_codigo_agentic"] = Util::sendRequestAgentic($dado, $tipo, $this->getEndpoint($tipo));
                    $dado["usu_sera_integrado"] = 'false';
                    $arrIntegracao['sucessos']['paciente']++;
                }
                unset($dado['access_token']);
                unset($dado['cid_nome']);
                unset($dado['uf_sigla']);

                $obj->salvar($dado);
                continue;
            }

            if ($tipo == 'medico') {
                $arrIntegracao['erros']['medico']++;
            }
            elseif ($tipo == 'medicoExterno') {
                $arrIntegracao['erros']['medico_externo']++;
            }
            elseif ($tipo == 'paciente') {
                $arrIntegracao['erros']['paciente']++;
            }
        }
    }

    private function registroPodeSerIntegrado($dado, $tipo) {
        if ($tipo == 'medico' && (
                !empty($dado['usr_nome']) &&
                !empty($dado['usr_codigo']) &&
                !empty($dado['esp_nome'])) &&
            !empty($dado['usr_num_conselho']) &&
            !empty($dado['con_descricao'])) {
            return true;
        }
        elseif ($tipo == 'medicoExterno' && (
                !empty($dado['med_nome']) &&
                !empty($dado['med_codigo'])
            )) {
            return true;
        }
        elseif ($tipo == 'paciente' && (
                !empty($dado['usu_nome']) &&
                !empty($dado['usu_data_cad']) &&
                !empty($dado['usu_datanasc']) &&
                !empty($dado['usu_codigo']) &&
                !empty($dado['usu_celular']))) {
            return true;
        }

        return false;
    }

    private function getEndpoint($tipo) {
        return $tipo == 'medico' || $tipo == 'medicoExterno' ? '/medicos/cadastrar' : '/pacientes/cadastrar';
    }

    private function mensagemConclusao($arrIntegracao, $tipo = '') {
        if ($tipo == 'medico') {
            echo "<span style='font-size: larger; font-weight: bolder; color: red'>Integração de médicos realizada!</span><br/><br/><br/>";
            return;
        }
        elseif ($tipo == 'medicoExterno') {
            echo "<span style='font-size: larger; font-weight: bolder; color: red'>Integração de médicos externos realizada!</span><br/><br/><br/>";
            return;
        }
        elseif ($tipo == 'paciente') {
            echo "<span style='font-size: larger; font-weight: bolder; color: red'>Integração de pacientes realizada!</span><br/><br/><br/>";
            return;
        }

        echo "<span style='font-size: larger; font-weight: bolder; color: red'>Integração concluída!</span><br/>";

        foreach ($arrIntegracao as $key => $dado) {
            if ($key == 'sucessos') {
                echo "<span style='font-size: larger; font-weight: bolder; color: blue'>Registros integrados:</span><br/>";
                echo "<span style='font-size: larger; font-weight: bolder; color: black'>Médicos: " . $dado['medico'] . "</span><br/>";
                echo "<span style='font-size: larger; font-weight: bolder; color: black'>Médicos Externos: " . $dado['medico_externo'] . "</span><br/>";
                echo "<span style='font-size: larger; font-weight: bolder; color: black'>Pacientes: " . $dado['paciente'] . "</span><br/><br/>";

                continue;
            }

            echo "<span style='font-size: larger; font-weight: bolder; color: blue'>Registros não integrados: </span><br/>";
            echo "<span style='font-size: larger; font-weight: bolder; color: black'>Médicos: " . $dado['medico'] . "</span><br/>";
            echo "<span style='font-size: larger; font-weight: bolder; color: black'>Médicos Externos: " . $dado['medico_externo'] . "</span><br/>";
            echo "<span style='font-size: larger; font-weight: bolder; color: black'>Pacientes: " . $dado['paciente'] . "</span><br/><br/>";
        }

        die();
    }

}
