<?php

require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";

class VacinaController extends Zend_Controller_Action {

	public function init() {
		$this->view->title = "Vacina";
	}

	public function indexAction() {
		$this->view->estrategias = (new Application_Model_Estrategia())->getEstrategias();
		$this->view->campanhas = (new Application_Model_VacinaCampanha())->getAll();
	}

	public function carteirinhaAction() {
		$this->loadCarteirinha();
	}

	public function dadosEstoqueAction() {
		return $this->melhoresVacina();
	}

	/**
	* Esta view retorna as vacinas que foram aplicadas (a/p/z) no paciente
	*/
	public function dadosAction() {
		$usu_codigo = $this->_getParam("id",FALSE);
		if(!$usu_codigo)
			return $this->_redirect("/vacina");

		$tbVac = new Application_Model_VacinaUsuario();
		$this->view->dados = $tbVac->getHistorico($usu_codigo)->toArray();
		return $this->render("dados", NULL, TRUE);
	}

	public function abrirDescartarFrascoAction() {
		$acao = $this->_getParam("acao", FALSE);
		$pro_codigo = $this->_getParam("pro", FALSE);
		if(!$pro_codigo || !$acao)
			return false;

		$tbPro = new Application_Model_Produto();
		if($acao == "abrir") {
			$tbPro->fracionar($pro_codigo);
		} elseif($acao == "descartar") {
			$motivo = $this->_getParam("motivo", NULL);
			$tbPro->descartar($pro_codigo, $motivo);
		}

		return $this->melhoresVacina();
	}

	/**
	* Trata todas os tipo de ação (A/P/Z/C)
	*/
	public function salvarAction() {
		if ($this->_request->isPost()) {
			$dados = [
				"usu_codigo" => $this->_getParam("usu",false),
				"pro_codigo" => $this->_getParam("pro",false),
				"vac_acao" => $this->_getParam("acao",false),
				"vac_data" => $this->_getParam("data",false),
				"vac_dose" => $this->_getParam("dose",false),
				"est_codigo" => $this->_getParam("especialidade",false),
			];
            if ($this->_getParam("campanha",false)){
                $dados["vcam_codigo"] = $this->_getParam("campanha",NULL);
            }
            if ($this->_getParam("vuc",false)){
                $dados["vac_usu_codigo"] = $this->_getParam("vuc",NULL);
            }
            $ficha = null;
            if($dados['vac_acao'] == "A"){
                $usr = (new Application_Model_Usuarios())->getUsrAtual();
                $viajante = $this->_getParam("viajante",false);
                $gestante = $this->_getParam("gestante",false);
                $puerpera = $this->_getParam("puerpera",false);
                $hanseniase = $this->_getParam("hanseniase",false);
                $equipe = (new Application_Model_UsuariosEquipe())->getEquipePorUnidadeUsuario($usr->usr_codigo,$usr->uni_codigo)->co_seq_equipe;

                $ficha = array(
                    "usr_codigo"=>$usr->usr_codigo,
                    "esp_codigo"=>$usr->esp_codigo,
                    "uni_codigo"=>$usr->uni_codigo,
                    "usr_equipe_codigo"=>$equipe,
                    "efv_data"=> date("Y-m-d"),
                    "efv_cod_igbe_mun"=>$usr->uni_codigo_ibge,
                    "efv_turno"=>1,
                    "usu_codigo"=>$dados['usu_codigo'],
                    "co_local_atend"=>1,
                    "efv_viajante"=>$viajante,
                    "efv_hanseniase"=>$hanseniase,
                    "efv_gestante"=>$gestante,
                    "efv_puerpera"=>$puerpera
                );
            }
			try {
				$tbVac = new Application_Model_VacinaUsuario();
				$tbVac->salvar($dados, $ficha);
				$json = array("success"=>true);
			} catch (Zend_Exception $exc) {
				$json = array(
					"success" => false,
					"mensagem" => array(
						"titulo" => "Erro",
						"mensagem" => $exc->getMessage(),
						"x" => 300,
						"y" => 200
					)
				);
			}
			$this->view->dados = $json;
			return $this->render("dados", NULL, TRUE);
		} else {
			$this->_redirect("/vacina");
		}
	}

	/**
	* Para deletar uma vacina pelo vac_usu_codigo
	*/
	public function deletarAction() {
		$vac_usu_codigo = $this->_request->getPost("vac",FALSE);
		if(!$vac_usu_codigo){
			$this->view->dados = array("success"=>false,"mensagem"=>"Informe o parâmetro \"vac\"");
			return $this->render("dados", NULL, TRUE);
		}

		$tbVac = new Application_Model_VacinaUsuario();
		try {
			$tbVac->deletar($vac_usu_codigo);
		} catch (Exception $exc) {
			$this->view->dados = array("success"=>false,"mensagem"=>$exc->getMessage());
			return $this->render("dados", NULL, TRUE);
		}

		$this->view->dados = array("success"=>true);
		return $this->render("dados", NULL, TRUE);
	}

	public function imprimirCarteirinhaAction() {
		$usu_codigo = $this->_getParam("usu_codigo", FALSE);
		$gerador = new GeradorRelatorio();
		$this->view->dados = $gerador->gerar("SAUDE", "carteirinhaVacinacao", ["usuario" => $usu_codigo]);


		return $this->render("dados", NULL, TRUE);
	}

	public function imprimirAtestadoAction(){
        $tbVac = new Application_Model_VacinaUsuario();
		$data_atestado = $this->_getParam("dataAtestado", NULL);
		$usu_codigo = $this->_getParam("usuCodigo", NULL);

		$dataProx = $tbVac->getDataProxVacina($usu_codigo);

		if($dataProx){
		    if($data_atestado > $dataProx->vac_data){
		        $data_atestado = $dataProx->vac_data;
            }
        }

		if(!$usu_codigo)
			return false;

		$gerador = new GeradorRelatorio();
		$this->view->dados = $gerador->gerar("SAUDE", "atestadoVacina", [
			"dataAtestado" => $data_atestado,
			"usuCodigo" => $usu_codigo,
			"usrLogado" => $_SESSION['id_login']
		]);

		$this->render("dados", NULL, TRUE);
	}

	private function melhoresVacina() {
		$tbPro = new Application_Model_Produto();
		$this->view->dados = $tbPro->selecionaMelhoresVacinas();
		return $this->render("dados", NULL, TRUE);
	}

	private function loadCarteirinha() {
		$tbCar = new Application_Model_Carteirinha();

		try{
			$this->view->vacinas = $tbCar->carregarCarteirinha();
		} catch (Zend_Validate_Exception $e){
			$this->view->erro = $e->getMessage();
			return $this->render("erro", NULL, TRUE);
		}
	}

	public function campanhaAction(){
        $this->view->title = "Cadastro de Campanhas";
        $tbVcam = new Application_Model_VacinaCampanha();
        $this->view->itens = $tbVcam->getAll();
    }
    public function pesquisaAction(){
        $term = $this->_getParam("busca");
        $tbVcam = new Application_Model_VacinaCampanha();
        $this->view->itens = $tbVcam->buscar($term);

	    $this->render("campanha");
    }
    public function formCampanhaAction(){
        $this->_helper->layout()->setLayout("vazio");
        $id = $this->_getParam("id", FALSE);
        if($id){
            $tbVcam = new Application_Model_VacinaCampanha();
            $this->view->dados = $tbVcam->getById($id);
        }
    }

    public function salvarCampanhaAction(){
        $vcam_codigo = $this->_request->getPost("codigo",NULL);
        $vcam_nome = $this->_request->getPost("nome",NULL);
        $vcam_ano = $this->_request->getPost("ano",FALSE);
        $vcam_abreviacao = $this->_request->getPost("abrev",FALSE);
        $tbVcam = new Application_Model_VacinaCampanha();

        $data = array(
            "vcam_nome" => $vcam_nome,
            "vcam_ano" => $vcam_ano,
            "vcam_abreviacao" => $vcam_abreviacao,
        );
        if($vcam_codigo){
            $data['vcam_codigo'] = $vcam_codigo;
        }

        try{
            $cod = $tbVcam->salvar($data);
            $this->view->dados = array("success" => true);
        } catch (Exception $e){
            $this->view->dados = array("success" => false, "mensagem" => $e->getMessage());
        }

        return $this->render("dados", NULL, TRUE);
    }

    public function excluirCampanhaAction(){
        $tbVcam = new Application_Model_VacinaCampanha();
        $id = $this->_getParam("id", FALSE);
        if($id){
            try{
                $tbVcam->excluir($id);
                $this->view->dados = array("success" => true);
            } catch (Exception $e){
                $this->view->dados = array("success" => false, "mensagem" => $e->getMessage());
            }
            return $this->render("dados", NULL, TRUE);
        }
    }

    public function vacinasPendentesAction(){
        $id = $this->_getParam("id", FALSE);
        $tbVac = new Application_Model_VacinaUsuario();
        if($id){

               $vacProx = $tbVac->getDataProxVacina($id);

               if($vacProx != null && $vacProx->vac_data <= getdate()){
                   $this->view->dados = array("success" => true);
               } else {
                   $this->view->dados = array("success" => false);
               }
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function verificaImunobiologicoAction(){
	    $pro_codigo = $this->_getParam("pro_codigo", FALSE);
	    $tbPro = new Application_Model_Produto();
	    if($tbPro->getImunobiologico($pro_codigo)->tvi_codigo == 15){
            $this->view->dados = array("success" => true, "tvi_codigo"=> $tbPro->getImunobiologico($pro_codigo)->tvi_codigo);
        } else{
            $this->view->dados = array("success" => false, "tvi_codigo"=> $tbPro->getImunobiologico($pro_codigo)->tvi_codigo);
        }
        return $this->render("dados", NULL, TRUE);
    }
}
