<?php

class Domicilio_DomicilioController extends Zend_Controller_Action
{

    public function init()
    {

        $this->view->title = "Cadastro de Domicilio";
        parent::init();
    }

    public function indexAction()
    {
        $tbBai = new Application_Model_Bairro();
        $this->view->itens = $tbBai->getBairros();
    }

    public function novoAction()
    {
        $dom_codigo = $this->_getParam("id");
        $this->view->popup = $term = $this->_getParam("popup", 0);
        $tbDist = new Application_Model_Distrito();
        $tbConf = new Application_Model_Configuracao();
        $tbCid = new Application_Model_Cidade();
        $tbDom = new Application_Model_Domicilio();
        $tbTi = new Application_Model_TbCdsTipoImovel();
        $this->view->tipo_imovel = $tbTi->getDados();
        $cid_codigo_ibge = $tbConf->getConfig("CID_CODIGO_IBGE");
        $this->view->cidade = $tbCid->getCidadePeloCodigoIbge($cid_codigo_ibge);
        $this->view->distritos = $tbDist->fetchAll();

        if ($dom_codigo)
            $this->view->dados = $tbDom->getDomicilio($dom_codigo);
    }

    public function salvarAction()
    {
        $tbDom = new Application_Model_Domicilio();
        $tbUsu = new Application_Model_Usuario();
        $this->_helper->layout->disableLayout();

        if ($this->_request->getPost("sn", "") == 1) {
            $dom_numero = "0";
        } else {
            $dom_numero = $this->_request->getPost("dom_numero", "");
        }

        $dados = array("usu_codigo_responsavel" => $this->_request->getPost("usu_codigo", FALSE),
            "rua_codigo" => mb_strtoupper($this->_request->getPost("rua_codigo", FALSE), "UTF-8"),
            "dom_numero" => $dom_numero,
            "dom_complemento" => $this->_request->getPost("dom_complemento", FALSE),
            "dom_ponto_referencia" => $this->_request->getPost("dom_ponto_referencia", FALSE),
            "dom_telefone" => $this->_request->getPost("dom_telefone", FALSE),
            "tipo_imovel" => $this->_request->getPost("tipo_imovel", FALSE));

        if ($dados['usu_codigo_responsavel'] == '' && $dados['tipo_imovel'] != 1) {
            $dados['usu_codigo_responsavel'] = null;
        }


        if ($this->_request->getPost("dom_codigo", false)) {
            $dados["dom_codigo"] = $this->_request->getPost("dom_codigo", false);
            $tbCdsDom = new Application_Model_TbCdsDomicilioResposta();
            $dadosDom = array(
                "co_cds_cad_domiciliar" => $dados["dom_codigo"],
                "co_data_atendimento" => date('Y-m-d')
            );
            $tbCdsDom->salvar($dadosDom);
        }

        try {
            $dom_codigo = $tbDom->salvar($dados);

            if (!$this->_request->getPost("dom_complemento", FALSE)) {
                $tbDom->deletaComplementoDoDomicilio($dom_codigo);
            }

            if ($dados['usu_codigo_responsavel'] != '' && $dados['tipo_imovel'] == 1) {
                $data_usu = array("usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
                    "dom_codigo" => $dom_codigo);
                $tbUsu->salvar($data_usu);
            }
            $this->view->dados = array("dom_codigo" => $dom_codigo);
        } catch (Exception $ex) {
            $this->view->dados = array("msg" => $ex->getMessage());
        }

        return $this->render("dados", null, true);
    }

    public function excluiCondicoesMoradiaAction() {
        $tbDom = new Application_Model_Domicilio();
        $tbIpe = new Application_Model_InstituicaoPermanencia();
        $tbCdr = new Application_Model_TbCdsDomicilioResposta();

        $dom_codigo = $this->_getParam("dom_codigo", false);

        $array_dom = array("dom_codigo" => $dom_codigo,
                            "usu_recusa" => null,
                            "estrat_risco_familiar" => null);

        $tbDom->salvar($array_dom);
        $tbIpe->excluirPorDomicilio($dom_codigo);
        $tbCdr->deletaTodosPorDomicilio($dom_codigo);
    }

    public function pesquisaAction()
    {
        if ($this->_request->isPost()) {
            $tbBairro = new Application_Model_Bairro();
            $this->view->busca = $this->_request->getPost("busca");
            $this->view->itens = $tbBairro->pesquisar($this->view->busca);
            $this->render("index");
        } else {
            $this->_redirect("/domicilio/area/index");
        }
    }

    public function verificaVinculoAction()
    {
        $tbBai = new Application_Model_Domicilio();
        $rua_codigo = $this->_getParam("rua_codigo", false);
        $dom_numero = $this->_getParam("dom_numero", false);
        $usu_codigo = $this->_getParam("usu_codigo", false);
        $dom_complemento = $this->_getParam("dom_complemento", false);
        $qtde = $tbBai->verificaVinculo($rua_codigo, $dom_numero, $usu_codigo, $dom_complemento)->toArray();
        $this->view->dados = $qtde["qtde"];
        return $this->render("dados", null, true);
    }

}

?>
