<?php

class Domicilio_PsfController extends Zend_Controller_Action {

	public function init() {
	}

	public function indexAction() {
		$dom_codigo = $this->_getParam("dom_codigo", FALSE);
		$this->view->dom_codigo = $dom_codigo;
		$this->view->title = "Cadastro de Endereço";
		$valida = $this->_getParam("valida", FALSE);
		$this->view->valida = $valida;
		$tpe = new Application_Model_TbPergunta();
		$tped = new Application_Model_TbPerguntaDetalhe();
		$tbDom = new Application_Model_Domicilio();
		$tbIpe = new Application_Model_InstituicaoPermanencia();
		$this->view->dados_header = $tbDom->getHeaderCadDomiciliar($this->view->dom_codigo);
		$this->view->tipo_imovel = $tbDom->getSelecionado($this->view->dom_codigo)->toArray();
		$this->view->domicilio = $tbDom->getDomicilio($this->view->dom_codigo);
		$this->view->instituicao = $tbIpe->getDadosPorDomicilio($this->view->dom_codigo);

		$psf_dados = $tbDom->getDomicilioPsf($this->view->dom_codigo)->toArray();

		if (count($psf_dados)) {
			$this->view->dados = $this->montaArrayEditAction($psf_dados);
		}
		$this->view->qtdMorador = $tbDom->getQtdMoradores($dom_codigo)->qtdMorador;
		$perguntas = $tpe->getPerguntasPorContexto(2)->toArray();
		$psf = array();
		foreach ($perguntas as $pergunta) {
			if (empty($pergunta[co_pergunta_pai])) {
				$psf[$pergunta[co_seq_pergunta]] = array("ds_pergunta" => $pergunta[ds_pergunta],
					"tp_pergunta" => $pergunta[tp_pergunta],
					"detalhes" => $tped->getPerguntaDetalhe($pergunta[co_seq_pergunta])->toArray());
			} else {
				$psf[$pergunta[co_pergunta_pai]]["pergunta_filho"][$pergunta[co_seq_pergunta]] = array("ds_pergunta" => $pergunta[ds_pergunta],
					"tp_pergunta" => $pergunta[tp_pergunta],
					"detalhes" => $tped->getPerguntaDetalhe($pergunta[co_seq_pergunta])->toArray());
			}

		}
		$this->view->perguntas = $psf;
	}

	private function montaArrayEditAction($psf_dados) {
		$array_edit = array();
		foreach ($psf_dados as $psf) {
			$i++;
			if ($psf[tp_pergunta] != "3") {
				$array_edit[$psf[co_pergunta]] = array("co_pergunta" => $psf[co_pergunta],
					"co_cds_cad_domiciliar" => $psf[co_cds_cad_domiciliar],
					"co_pergunta_detalhe" => $psf[co_pergunta_detalhe],
					"ds_resposta" => $psf[ds_resposta],
					"co_resposta" => $psf[co_resposta],
					"co_seq_cds_domicilio_resposta" => $psf[co_seq_cds_domicilio_resposta]);
				$array_edit[co_data_atendimento] = $psf[co_data_atendimento];
			} else {
				$array_multiplo[$psf[co_pergunta_detalhe]] = array("co_pergunta" => $psf[co_pergunta],
					"co_cds_cad_domiciliar" => $psf[co_cds_cad_domiciliar],
					"co_pergunta_detalhe" => $psf[co_pergunta_detalhe],
					"ds_resposta" => $psf[ds_resposta],
					"co_resposta" => $psf[co_resposta],
					"co_seq_cds_domicilio_resposta" => $psf[co_seq_cds_domicilio_resposta]);
				$array_edit[$psf[co_pergunta]] = $array_multiplo;
			}
		}
		return $array_edit;
	}

	public function salvarAction() {
		$tbCdr = new Application_Model_TbCdsDomicilioResposta();
		$tbDom = new Application_Model_Domicilio();
		$tbIpe = new Application_Model_InstituicaoPermanencia();
		$valida = $this->_getParam("valida", FALSE);
		$arr = $this->_request->getPost();
		if ($arr["dom_microarea_fa"] != 't') {
			$microarea = $arr["dom_microarea"];
		} else {
			$microarea = 0;
		}
		$array_dom = array("dom_codigo" => $arr["dom_codigo"],
			"usr_codigo" => $arr["prof_resp_codigo"],
			"uni_codigo" => $arr["cod_cnes_uni"],
			"cod_equipe" => $arr["cod_equipe"],
			"dom_microarea" => $microarea,
			"dom_microarea_fa" => $arr["dom_microarea_fa"],
			"usu_recusa" => $arr["usu_recusa"],
			"tipo_imovel" => $this->_request->getPost("tipo_imovel", FALSE),
			"estrat_risco_familiar" => trim($this->_request->getPost("estrat_risco_familiar", FALSE)));
		$tbDom->salvar($array_dom);
		$tbIpe->excluirPorDomicilio($arr["dom_codigo"]);
		if ($arr["ipe_resp_nome"] != null) {
			$array_ipe = array("dom_codigo" => $arr["dom_codigo"],
				"ipe_nome" => $arr["ipe_nome"],
				"ipe_st_outros" => $arr["ipe_st_outros"],
				"ipe_resp_nome" => $arr["ipe_resp_nome"],
				"ipe_resp_cns" => $arr["ipe_resp_cns"],
				"ipe_resp_cargo" => $arr["ipe_resp_cargo"],
				"ipe_resp_telefone" => $arr["ipe_resp_telefone"]);
			$tbIpe->salvar($array_ipe);
		}
		Zend_Db_Table::getDefaultAdapter()->beginTransaction();
		unset($arr["valid_57"],
			$arr["valid_58"],
			$arr["dom_codigo"],
			$arr["valid_66"],
			$arr["prof_resp_codigo"],
			$arr["cod_cnes_uni"],
			$arr["tipo_imovel"],
			$arr["cod_equipe"],
			$arr["dom_microarea"],
			$arr["dom_microarea_fa"],
			$arr["usu_recusa"],
			$arr["prof_resp"],
			$arr["cod_cnes_edit"],
			$arr["cod_equipe_ine"],
			$arr["dom_microarea_codigo"],
			$arr["co_data_atendimento"],
			$arr["estrat_risco_familiar"],
			$arr["ipe_nome"],
			$arr["ipe_st_outros"],
			$arr["ipe_resp_nome"],
			$arr["ipe_resp_cns"],
			$arr["ipe_resp_cargo"],
			$arr["ipe_resp_telefone"],
			$arr["co_data_atual"]);
		try {
			$data = array();
			$tbCdr->deletaTodosPorDomicilio($this->_request->getPost("dom_codigo"));
			if ($array_dom['usu_recusa'] != 't') {
				foreach ($arr as $ind => $val) {
					if ($ind == 71) {
						foreach ($val as $checkbox) {
							$data = array("co_pergunta" => $ind,
								"co_pergunta_detalhe" => $checkbox,
								"co_cds_cad_domiciliar" => $this->_request->getPost("dom_codigo"),
								"co_data_atendimento" => $this->_request->getPost("co_data_atendimento"));
							$tbCdr->salvar($data);
						}
					} else {
						$data = array("co_pergunta" => $ind,
							"co_pergunta_detalhe" => ($ind != 60 && $ind != 61 && $ind != 63 && $ind != 72 && $ind != 70 ? "$val" : ""),
							"ds_resposta" => ($ind == 60 || $ind == 61 || $ind == 63 || $ind == 72 ? "$val" : ""),
							"co_cds_cad_domiciliar" => $this->_request->getPost("dom_codigo"),
							"co_data_atendimento" => $this->_request->getPost("co_data_atendimento"),
							"co_resposta" => ($ind == 63 || $ind == 70 ? "$val" : ""));
						$tbCdr->salvar($data);
					}
				}
			} else {
				/*
				  O exportador exige pelo menos um registro na tabela "tb_cds_domicilio_resposta" com o UUID nulo para
				   identificar que a ficha deve ser exportada. Porém, como os dados são exclúidos
				   e o status de recusa limpa todos os campos, ele não criava o registro necessário.
				  Portanto, é criado esse registro fictíceo para garantir que a ficha seja exportada com o termo de recusa.
				 */
				$data = array("co_pergunta" => 9999,
					"co_pergunta_detalhe" => "",
					"ds_resposta" => "",
					"co_cds_cad_domiciliar" => $this->_request->getPost("dom_codigo"),
					"co_data_atendimento" => $this->_request->getPost("co_data_atendimento"),
					"co_resposta" => "");
				$tbCdr->salvar($data);
			}
			Zend_Db_Table::getDefaultAdapter()->commit();

		} catch (Exception $exc) {
			Zend_Db_Table::getDefaultAdapter()->rollBack();
			$this->view->dados = $exc->getMessage();
			return $this->render("dados", NULL, TRUE);
		}
		if (!$valida)
			return $this->_redirect("../domicilio.php");
		else
			return $this->_redirect("programas-federais/cadastro-domiciliar/inconsistencias");
	}
}

?>
