<?php

require_once HORUS_PATH . '/SoapHorus.php';
require_once HORUS_PATH . '/sync/SyncController.php';
require_once HORUS_PATH . '/HorusEnum.php';
require_once HORUS_PATH . '/Util.php';

use Saude\Horus, Saude\Horus\Sync\SyncController, SoapFault;

class Farmacia_FarmaciaController extends Zend_Controller_Action {

	private $horus;
	private $sync;

	public function init() {
		$this->_helper->acl->allow(NULL);
		$this->view->title = "Dispensação";
	}

	public function indexAction() {

		$tbUsr = new Application_Model_Usuarios();
		$tbConf = new Application_Model_Configuracao();
		$tbSet = new Application_Model_Setor();

		$this->view->set_codigo = $tbUsr->getUsrAtual()->set_codigo;

		if ($tbSet->verificaInventarioSetor($this->view->set_codigo)) {
			return $this->render("inventario", null, true);
		}
		if ($this->view->set_codigo == null) {
			$this->_redirect("default/farmacia/restrito");
		}

		if ($tbSet->verificaFuncaoSetor($this->view->set_codigo)->set_farmacia != "S") {
			return $this->render("erro", null, true);
		}

		$this->view->lote_automatico = $tbConf->getConfig("LOTE_AUTOMATICO");
		$this->view->via_medicamentos = $tbConf->getConfig("VIA_FARMACIA");
		$this->view->cadastro_aise = $tbConf->getConfig("CADASTRO_AISE");
		$this->view->validade_medicamentos = $tbConf->getConfig("VALIDADE_DOS_MEDICAMENTOS");
		$this->view->mov_data_status = $tbConf->getConfig("DISPENSACAO RETROATIVA EM DIAS");
		$cod_barras = $this->_getParam("cod_barras", FALSE);
		$this->view->cod_barras = $cod_barras;
		$this->view->via_medicamentos = $tbConf->getConfig("VIA_FARMACIA");

		$tbMov = new Application_Model_Movimento();
		if($this->_request->getParam("mov_codigo")){
			$mov_codigo = $this->_request->getParam("mov_codigo");
			$this->view->dados = $tbMov->getDadosEdicaoDispensacao($mov_codigo);
		}
	}

	public function erroAction() {
		$this->view->title = "Acesso restrito";
	}

	public function salvarAction() {
		$this->view->dados = array(
			"id" => null,
			"msg" => null,
			"protocolos" => array(),
			"horus" => array()
		);
		$mov_codigo = $this->_getParam("mov_codigo", NULL);
		$usu_codigo = $this->_getParam("usu_codigo", FALSE);
		$set_codigo = $this->_getParam("set_codigo", FALSE);
		$usr_codigo = $this->_getParam("usr_codigo", FALSE);
		$rec_codigo = $this->_getParam("rec_codigo", FALSE);
		$mov_data = $this->_getParam("mov_data", FALSE);
		$mov_observacao = $this->_getParam("mov_observacao", FALSE);
		$interno = $this->_getParam("interno", FALSE);
		$itens = $this->_getParam("itens", FALSE);
        $tipo_receita = $this->_getParam("tipo_receita", NULL);
		$tbMov = new Application_Model_Movimento();
		$tbIte = new Application_Model_ItensMovimento();
		$tbItensRec = new Application_Model_ReceitaItens();
		$tbProduto = new Application_Model_Produto();
		$tbUsuario = new Application_Model_Usuario();
		$usuario = $tbUsuario->getUsuarioPorId($usu_codigo)->toArray();

		Zend_Db_Table::getDefaultAdapter()->beginTransaction();
		$dados_mov = array(
			"mov_codigo" => $mov_codigo,
			"usu_codigo" => $usu_codigo,
			"set_saida" => $set_codigo,
			($interno == 0 ? "med_codigo_externo" : "med_codigo_interno") => $usr_codigo,
			"mov_data" => $mov_data,
			"mov_tipo" => "S",
			"mov_data_inclusao" => "NOW()",
			"mov_saida" => "D",
			"mov_observacao" => $mov_observacao,
			"mov_num_receita" => $itens[0]['cod_receita'],
            "tr_codigo" => $tipo_receita
		);


		if(!empty($dados_mov['mov_num_receita'])){
			$itens = $this->balancearLotes($itens, $dados_mov);
		}

		try {
			$mov_codigo = $tbMov->salvar($dados_mov);
			$qtd_pendente = 0;

			$tbSet = new Application_Model_Setor();
			$setor = $tbSet->getSetorPorCodigo($set_codigo);

			if($setor->set_usa_horus == "S"){
				$this->horus = new Horus\SoapHorus();
				if ($this->horus->isSincrono()) {
					$this->sync = new SyncController();
					$ddHorus = $this->sync->getDados();
				}
			}

			foreach ($itens as $item) {
				if($item['item_editado'] == 'N'){
					$pro_nome = $tbProduto->getProduto($item['pro_codigo'])->pro_nome;
					if (!empty($item['cod_receita'])) {
						$tbRec = new Application_Model_Receita();
						$ate_rec = $tbRec->getAtendimentoDaReceitaPorCodigo($item['cod_receita']);
						$peso = null;
						$altura = null;
						$cid10 = null;
						if(isset($ate_rec)){
							$ate_rec = $ate_rec->toArray();
							$peso =   (isset($ate_rec['ate_peso']) ? $ate_rec['vd_peso'] : (isset($ate_rec['vd_peso']) ? $ate_rec['vd_peso'] : null));
							$altura = (isset($ate_rec['ate_altura']) ? $ate_rec['ate_altura'] : (isset($ate_rec['vd_altura']) ? $ate_rec['vd_altura'] : null));
							$cid10 =  (isset($ate_rec['cd10_codigo']) ? $ate_rec['cd10_codigo'] : null);
						}
					}

					$item['ite_lote'] = str_replace(array("'"), "", $item['ite_lote']);
					$params = array(
						"mov_data" => $mov_data,
						"usu_codigo" => $usu_codigo,
						"pro_codigo" => $item['pro_codigo'],
						"ite_lote" => $item['ite_lote'],
						"ite_qtde_pendente" => $item['ite_qtde_pendente']
					);


					if ($tbIte->verificaSeJaDispensouParcial($params)) {
						//Horus
						$protocolo_horus = null;

						if($setor->set_usa_horus == "S"){
							if ($this->sync->getCadastroHorus()) {
								if (!empty($item['horus']) && !empty($item['horus_tipo'])) {
									if ($this->sync != null && !empty($usuario['usu_cartao_sus'])) {
										$dtValidade = new DateTime($item['ite_validade']);
										$dtRegistro = new DateTime();
										$nuProduto = $item['horus_tipo'] . $item['horus'];
										$protocolo = $this->sync->informarDispensacaoMedicamento(
											$ddHorus['idOrigem'],
											$ddHorus['coIBGE'],
											Horus\TP_IDENTIFICACAO::CNES,
											$ddHorus['coCNES'],
											$item['pro_codigo'],
											$nuProduto,
											$item['ite_lote'],
											$dtValidade->format('d-m-Y'),
											$item['ite_quantidade'],
											$dtRegistro->format('d-m-Y'),
											null,
											$dtRegistro->format('m-Y'),
											$usuario['usu_cartao_sus'],
											$peso, $altura, $cid10, null, null, null
										);
										if ($protocolo instanceof \SoapFault) {
											$this->view->dados['horus'][] = "\nErro Horus: " . $protocolo->getMessage() . "\n Consulte o log de erros para mais detalhes.";
										} else {
											$this->view->dados['protocolos'][] =
												"<br/>Registro: " . $protocolo->produto->coRegistroOrigem
												. " - Protocolo: " . $protocolo->protocolo->nuProtocoloEntrada;
											$protocolo_horus = $protocolo->protocolo->nuProtocoloEntrada;
										}

									} else {
										$this->view->dados['horus'][] = "<br/> Paciente não possue CNS. Item não será enviado ao Horus.";
									}
								} else {
									$this->view->dados['horus'][] = "<br/>$pro_nome não possue CATMAT";
								}
							}
						}
						$custo_medio = $tbIte->buscaCustoMedio($item['ite_lote'], $item['pro_codigo'], $mov_data);
						if ($custo_medio == "" || $custo_medio == NULL)
							$custo_medio = 0;

						$dados_itens = array(
							"mov_codigo" => $mov_codigo,
							"pro_codigo" => $item['pro_codigo'],
							"ite_lote" => $item['ite_lote'],
							"ite_quantidade" => ($item['ite_quantidade_solicitada'] !== "undefined" ? $item['ite_quantidade_solicitada'] : $item['ite_quantidade']),
							"ite_validade" => "$item[ite_validade]",
							"ite_duracao" => ($item['ite_duracao'] == "undefined" || $item['ite_duracao'] == "" ? NULL : $item['ite_duracao']),
							"ite_custo_medio" => $custo_medio,
							"ite_cod_receita" => ($item['cod_receita'] == "" || $item['cod_receita'] == "undefined" || $item['cod_receita'] == NULL ? "0" : $item['cod_receita']),
							"protocolo_horus" => $protocolo_horus
						);
						$qtd_pendente += $item['ite_qtde_pendente'];
						$tbIte->salvar($dados_itens);

						if ($rec_codigo) {
							$itemObj = array(
								"irec_codigo" => ($item['ite_cod_receita'] ? $item['ite_cod_receita'] : null),
								"rec_codigo" => $item['cod_receita'],
								"pro_codigo" => $item['pro_codigo'],
								"irec_quantidade" => $item['ite_quantidade'],
								"irec_qtde_pendente" => ($item['ite_qtde_pendente'] ? $item['ite_qtde_pendente'] : 0),
								"irec_quantidade_solicitada" => ($item['ite_quantidade_solicitada'] ? $item['ite_quantidade_solicitada'] : $item['ite_quantidade'])
							);
							$tbItensRec->salvar($itemObj);
						}
					}
				}
			}

			$this->view->dados['msg'] = "Dados cadastrados com sucesso";
			$this->view->dados['id'] = $mov_codigo;

			if ($rec_codigo && $qtd_pendente <= 0) {
				$dados_rec = array("rec_codigo" => $rec_codigo, "rec_finalizada" => "S");
				$tbRec = new Application_Model_Receita();
				$tbRec->alteraStatus($dados_rec);
			}

			Zend_Db_Table::getDefaultAdapter()->commit();
		} catch (Exception $exc) {
			Zend_Db_Table::getDefaultAdapter()->rollBack();
			$this->view->dados['msg'] = $exc->getMessage();
		}

		return $this->render("dados", NULL, TRUE);

	}

	public function bcdiv_cust($first, $second, $scale = 0) {
		$res = $first / $second;
		return round($res, $scale);
	}

	public function imprimirViaAction() {
		Zend_Layout::getMvcInstance()->setLayout("simples");
		$this->view->title = "Imprimir Via de Medicamentos";
		$tbMov = new Application_Model_Movimento();
		$tbIte = new Application_Model_ItensMovimento();
		$tbSec = new Application_Model_Secretaria();
		$tbUsr = new Application_Model_Usuarios();
		$this->view->set_nome = $tbUsr->getUsrAtual()->set_nome;

		//$tbConf = new Application_Model_Configuracao();
		$this->view->usr = $tbUsr->getUsrAtual()->usr_nome;
		$mov_codigo = $this->_getParam("mov_codigo", FALSE);
		$this->view->mov_codigo = $mov_codigo;
		$this->view->movimento = $tbMov->getMovimento($mov_codigo);
		$itens = $tbIte->getProdutosPorMovimento($mov_codigo);

		$this->view->itens_mov = $itens;
	}

	public function getHistoricoPacienteAction() {
		$usu_codigo = $this->_getParam("usu_codigo", FALSE);
		$tbMovimento = new Application_Model_Movimento();
		$this->view->dados = $tbMovimento->getDispensados($usu_codigo)->toArray();

		return $this->render("dados", NULL, TRUE);
	}

	public function getUltimosDispensadosAction() {
		$usu_codigo = $this->_getParam("usu_codigo", FALSE);
		$tbMov = new Application_Model_Movimento();
		$this->view->dados = $tbMov->getUltimosDispensados($usu_codigo)->toArray();
		return $this->render("dados", NULL, TRUE);
	}

	public function getObservacaoAction() {
		$usu_codigo = $this->_getParam("usu_codigo", FALSE);
		$tbMov = new Application_Model_Movimento();
		$this->view->dados = $tbMov->getObservacao($usu_codigo)->toArray();
		return $this->render("dados", NULL, TRUE);
	}

	public function getReceitaAction() {
		$rec_codigo = $this->_getParam("rec_codigo", FALSE);

		$tbRec = new Application_Model_Receita();
		$rec = $tbRec->getReceitaPorCodigo($rec_codigo);
		if ($rec->rec_codigo) {
			$rec->toArray();
			$tbIrec = new Application_Model_ReceitaItens();
			$irec = $tbIrec->getItensReceita($rec_codigo)->toArray();

			$dados = array("usu_codigo" => $rec['usu_codigo'],
				"usu_nome" => $rec['usu_nome'],
				"usr_codigo" => $rec['usr_codigo'],
				"usr_nome" => $rec['usr_nome'],
				"itens" => $irec);

			$this->view->dados = $dados;
		} else {
			$this->view->dados = "";
		}

		return $this->render("dados", NULL, TRUE);
	}

	//Administracao da dispensacao
	public function administracaoAction() {
		$this->view->title = "Administração da Dispensação";
		$id_login = $this->_getParam('id_login');
		$tbMov = new Application_Model_Movimento();
		$this->view->dados = $tbMov->listarDispensacoes($id_login)->toArray();
	}

	public function pesquisaDispensacaoAction() {
		session_start();
		$this->view->title = "Administração da Dispensação";
		$tbMov = new Application_Model_Movimento();
		$pesquisa = $this->_request->getParam("busca");
		$this->view->dados = $tbMov->listarDispensacoes($_SESSION['id_login'], $pesquisa)->toArray();
		$this->render("administracao");
	}

	public function removerItemAction(){
		$result = array(
			"msg" => "",
			"horus" => false,
			"protocolo" => false
		);
		$tbIte = new Application_Model_ItensMovimento();
		$ite_codigo = $this->_request->getParam('ite_codigo', FALSE);
		$item = $tbIte->fetchRow("ite_codigo=$ite_codigo");
		if($item){
			if(!empty($item->protocolo_horus)){
				$this->horus = new Horus\SoapHorus();
				if ($this->horus->isSincrono()) {
					$sync = new SyncController();
					$protocolo = $sync->excluirRegistros($item->protocolo_horus, date('d-m-Y H:i:s'));
					if ($protocolo instanceof \SoapFault) {
						$result['horus'] = "Erro Horus: " . $protocolo->getMessage();
						$result['msg'] = "Erro ao remover item";
					} else {
						$result['protocolos'] = " Protocolo: " . $protocolo->protocolo->nuProtocoloEntrada;
						$res = $tbIte->deletar($ite_codigo);
						$result['msg'] = "Item removido com sucesso";
					}
				}
			}else{
				$res = $tbIte->deletar($ite_codigo);
				$result['msg'] = "Item removido com sucesso";
			}
		}

		$this->view->dados = $result;
		return $this->render("dados", NULL, TRUE);
	}

	public function removerMovimentoAction() {
		$tbMov = new Application_Model_Movimento();
		$mov_codigo = $this->_request->getParam("mov_codigo", FALSE);
		$result = array();
		if($mov_codigo){
			try {
				$tbMov->delete("mov_codigo=$mov_codigo");
				$result['sucesso'] = true;
			} catch (Exception $e) {
				$result["sucesso"] = false;
				$result["erro"] = $e->getMessage();
			}
		}
		$this->view->dados = $result;
		return $this->render("dados", NULL, TRUE);
	}

	private function balancearLotes($itens, $dados_mov) {

		function custom_sort($a,$b) {
			return $a['ite_validade'] > $b['ite_validade'];
		}
		usort($itens, 'custom_sort');

		$qtde_solicitada = $itens[0]['ite_quantidade_solicitada'];
		$tbSal = new Application_Model_Saldo();
		$novos_itens = array();
		foreach ($itens as $key => $item){
			$saldo_lote = $tbSal->getSaldoAtual($item['pro_codigo'], $dados_mov['set_saida'], str_replace("'", "", $item['ite_lote']), $item['ite_validade']);
			if($qtde_solicitada > 0){
				if($qtde_solicitada <= $saldo_lote){
					$item['ite_quantidade_solicitada'] = $qtde_solicitada;
				}else{
					$item['ite_quantidade_solicitada'] = $saldo_lote;
				}
				$qtde_solicitada = ($qtde_solicitada - $saldo_lote);
			}
			$novos_itens[] = $item;
		}
		return $novos_itens;
	}



}
