<?php

class Filaespera_FilaController extends Zend_Controller_Action
{
    public function init()
    {
        $this->view->title = "Filas de Espera";
    }


    public function indexAction()
    {
        $tbFila = new Application_Model_Filas();
        $this->view->dados = $tbFila->listartudo();
    }

    public function formAction()
    {
        $id = $this->_request->getParam('id');
        if ($id) {
            $tbFila = new Application_Model_Filas();
            $this->view->dados = $tbFila->getdados($id);
        }
        $this->view->title = "Cadastro de Fila de Espera";
        $tbOrd = new Application_Model_FilasTipoordenacao();
        $this->view->ordenacao = $tbOrd->listar();
    }

    public function formReguladoresAction()
    {
        $this->view->title = "Vinculo de Profissionais";
        $fila_codigo = $this->_request->getParam('fila_codigo');
        $usr_codigo = $this->_request->getParam('usr_codigo');
        $fire_codigo = $this->_request->getParam('fire_codigo');
        $tbUsr = new Application_Model_FilasReguladores();
        if ($usr_codigo) {
            $this->view->reguladores = $tbUsr->listar($fila_codigo);
            $this->view->usr = $tbUsr->getRegulador($fila_codigo, $usr_codigo);
            $this->view->fila = $fila_codigo;
            $this->view->fire_codigo = $fire_codigo;

        } else {
            $this->view->reguladores = $tbUsr->listar($fila_codigo);
            $this->view->fila = $fila_codigo;
        }
    }

    public function salvarAction()
    {

        $tbFila = new Application_Model_Filas();
        $id = $this->_request->getPost("fila_codigo");
        $nome = $this->_request->getPost("fila_nome");
        $nome = strtoupper($nome);
        $descricao = $this->_request->getPost("fila_descricao");
        $fila_tipo = $this->_request->getPost("fila_tipo");
        $tipo_ordenacao = $this->_request->getPost("fior_codigo");
        $fila_regulacao = $this->_request->getPost("fila_regulacao");
        $fila_consulta = $this->_request->getPost("fila_consulta_publica");
        $fila_status = $this->_request->getPost("fila_status");
        $nome_controle = $this->_request->getPost("fila_nome_controle");
        $array = array('fila_nome' => $nome,
            'fila_descricao' => $descricao,
            'fila_tipo' => $fila_tipo,
            'fior_codigo' => $tipo_ordenacao,
            'fila_regulacao' => $fila_regulacao,
            'fila_consulta_publica' => $fila_consulta,
            'fila_status' => $fila_status);
        $aux = $tbFila->verificaSeJaExiste($nome);
        if ($id) {
            $array['fila_codigo'] = $id;
            if($nome === $nome_controle){
                $aux = true;
            }
        }
        if ($aux) {
            $tbFila->salvar($array);
            $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Fila cadastrada com Sucesso!");
        } else {
            $this->view->dados = array("success" => FALSE, "titulo" => "Erro", "mensagem" => "Ja existe uma Fila com este Nome!");
        }
        return $this->render("dados", NULL, TRUE);

    }

    public function salvarReguladoresAction()
    {
        $tbFilaReg = new Application_Model_FilasReguladores();
        $fire_codigo = $this->_request->getParam('fire_codigo');
        $fila_codigo = $this->_request->getParam('fila_codigo');
        $fire_regulador = $this->_request->getPost('fire_regulador');
        $usr_codigo = $this->_request->getPost('usr_codigo');
        $aux = $tbFilaReg->getReguladorIncluir($fila_codigo, $usr_codigo);
        $array = array(
            'fila_codigo' => $fila_codigo,
            'fire_regulador' => $fire_regulador,
            'usr_codigo' => $usr_codigo
        );
        if ($fire_codigo) {
            $array['fire_codigo'] = $fire_codigo;
            $tbFilaReg->salvar($array);
            $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Vinculo alterado com Sucesso!");
            return $this->render("dados", NULL, TRUE);
        } elseif (!$aux) {
            $this->view->dados = array("success" => FALSE, "titulo" => "Erro", "mensagem" => "Profissional já possui vinculo com a Fila!");
            return $this->render("dados", NULL, TRUE);
        }
        $tbFilaReg->salvar($array);
        $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Vinculo criado com Sucesso!");
        return $this->render("dados", NULL, TRUE);
    }

    public function buscarAction()
    {
        $this->view->title = "Filas de Espera";

        $tbFila = new Application_Model_Filas();

        if ($this->_request->isPost()) {

            $busca = array(
                "fila_nome" => $this->_request->getPost("fila_nome")
            );
            $this->view->dados = $tbFila->listartudo($busca['fila_nome']);
            return $this->render("index");
        }
    }

    public function excluirAction()
    {
        $id = $this->_request->getParam('id');
        $tbFila = new Application_Model_Filas();
        $tbFila->excluir($id);
        $tbFila = new Application_Model_Filas();
        $this->view->dados = $tbFila->listartudo();
        return $this->render("index");
    }

    public function excluirUsuariosAction()
    {

        $usr_codigo = $this->_getParam("usr_codigo", false);
        $fila_codigo = $this->_getParam("fila_codigo", false);
        $tbUsr = new Application_Model_FilasReguladores();
        $tbUsr->excluir($fila_codigo, $usr_codigo);
        $fire_codigo = $this->_request->getParam('fire_codigo');
        $tbUsr = new Application_Model_FilasReguladores();
        if ($usr_codigo) {
            $this->view->reguladores = $tbUsr->listar($fila_codigo);
            $this->view->usr = $tbUsr->getRegulador($fila_codigo, $usr_codigo);
            $this->view->fila = $fila_codigo;
            $this->view->fire_codigo = $fire_codigo;

        } else {
            $this->view->reguladores = $tbUsr->listar($fila_codigo);
            $this->view->fila = $fila_codigo;
        }
        $this->render("form-reguladores");
    }

    public function getListaAction(){
        $fila_codigo = $this->_getParam("fila_codigo", false);
        $tbFila = new Application_Model_Filas();
        $fila_tipo = $tbFila->getdados($fila_codigo)->fila_tipo;
        $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => $fila_tipo);
        return $this->render("dados", NULL, TRUE);
    }

}

