<?php

class Filaespera_FilasUsuarioController extends Zend_Controller_Action
{
    public function init()
    {
        $this->view->title = "Página Inicial - Filas de Espera";
    }


    public function indexAction()
    {
        $this->view->title = "Solicitações para Fila de Espera";

        $tbUsr = new Application_Model_Usuarios();
        $usr = $tbUsr->getUsrAtual()->usr_codigo;

        $tbFila = new Application_Model_Filas();
        $this->view->filas = $tbFila->listar($usr);

        $tbTipoatend = new Application_Model_FilasTipoatendimentos();
        $this->view->tipoatend = $tbTipoatend->listar();

        $prio = new Application_Model_FilasPrioridades();
        $this->view->prioridade = $prio->listar();

        $tbCon = new Application_Model_Configuracao();
        $qtde_agendamento = $tbCon->getConfig("QTD_FILA_AGENDAMENTO");
        $this->view->qtde_fila_agendamento = $qtde_agendamento;
    


    }

    public function buscarAction()
    {
        $this->view->title = "Solicitações para Fila de Espera";

        $tbUsr = new Application_Model_Usuarios();
        $usr = $tbUsr->getUsrAtual()->usr_codigo;

        $tbFila = new Application_Model_Filas();
        $this->view->filas = $tbFila->listar($usr);

        $tbCon = new Application_Model_Configuracao();
        $qtde_agendamento = $tbCon->getConfig("QTD_FILA_AGENDAMENTO");
        $this->view->qtde_fila_agendamento = $qtde_agendamento;

        $tbTipoatend = new Application_Model_FilasTipoatendimentos();
        $this->view->tipoatend = $tbTipoatend->listar();

        $prio = new Application_Model_FilasPrioridades();
        $this->view->prioridade = $prio->listar();

        $tbFilasReg = new Application_Model_FilasReguladores();

        if ($this->_request->isPost()) {
            $busca = array(
                "fiusu_data_entrada" => $this->_request->getPost("busca_data"),
                "fila_codigo" => $this->_request->getPost("busca_fila"),
                "usu_codigo" => $this->_request->getPost("usu_codigo"),
                "status" => $this->_request->getPost("status"),
                "uni_codigo" => $this->_request->getPost("uni_codigo"),
                "esp_codigo" => $this->_request->getPost("esp_codigo"),
                "proc_codigo" => $this->_request->getPost("proc_codigo"),
                "usr_codigo" => $this->_request->getPost("usr_codigo"),
                "fiti_codigo" => $this->_request->getPost("fiti_codigo"),
                "fipr_codigo" => $this->_request->getPost("fipr_codigo")
            );
            if ($busca['fila_codigo'] != "") {
                $tipo_usuario = $tbFilasReg->getReguladorFila($busca['fila_codigo'], $usr);
            }
            $tbSoli = new Application_Model_FilasUsuario();
            $this->view->dados = $tbSoli->listar($busca['fiusu_data_entrada'], $busca['fila_codigo'], $busca['usu_codigo'], $busca['status'], $busca['uni_codigo'], $busca['esp_codigo'], $busca['proc_codigo'], $busca['usr_codigo'], $busca['fiti_codigo'], $busca['fipr_codigo'], $tipo_usuario);
            return $this->render("index");
        } else {
            $busca = array(
                "fila_codigo" => $this->_getParam("fila")
            );
            $tipo_usuario = $tbFilasReg->getReguladorFila($busca['fila_codigo'], $usr);

            $tbSoli = new Application_Model_FilasUsuario();
            $this->view->dados = $tbSoli->listar(NULL, $busca['fila_codigo'], NULL, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, $tipo_usuario);
            return $this->render("index");
        }



    }

    public function formAction()
    {
        $tbUsr = new Application_Model_Usuarios();
        $tbFila = new Application_Model_Filas();
        $usr = $tbUsr->getUsrAtual()->usr_codigo;
        $this->view->filas = $tbFila->listar($usr);
        $tbTipoatend = new Application_Model_FilasTipoatendimentos();
        $this->view->tipoatend = $tbTipoatend->listar();
        $prio = new Application_Model_FilasPrioridades();
        $this->view->prioridade = $prio->listar();
        $this->view->title = "Cadastrar solicitação";
        $id = $this->_request->getParam('fiusu_codigo');

        $tbFilaUsu = new Application_Model_FilasUsuario();
        $tbRegu = new Application_Model_FilasReguladores();
        $tbFilProc = new Application_Model_FilasUsuarioProcedimento();


        if ($id) {

            $aux = $tbFilaUsu->getDados($id);

            $this->view->solicitacao = $aux;
            if ($aux['med_codigo'] != "") {

                $this->view->interno = 0;
                $this->view->profissional_codigo = $aux['med_codigo'];
                $this->view->profissional_nome = $aux['med_nome'];
            } else {
                $this->view->interno = 1;
                $this->view->profissional_codigo = $aux['usr_codigo'];
                $this->view->profissional_nome = $aux['usr_nome'];
            }
            $regulador = $tbRegu->getReguladorFila($aux['fila_codigo'], $usr);
            $this->view->regulador = $regulador;
            $procedimentos = $tbFilProc->listar($id);
            $this->view->procedimentos = $procedimentos;
        }
    }

    public function cancelarAction()
    {

        $id = $this->_request->getPost("fiusu_codigo");
        $fila = $this->_request->getPost("fila_codigo");
        $motivo = $this->_request->getPost("fiusu_motivo_saida");
        $motivo = trim($motivo);
        $status = "CA";
        $tbFilausu = new Application_Model_FilasUsuario();
        $tbFila = new Application_Model_Filas();
        $tbFilausu->setStatus($id, $status, $motivo);
        $tbFila->ordenaFilaAction($fila);
        $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Solicitação cancelada com Sucesso!");
        return $this->render("dados", NULL, TRUE);
    }

    public function excluirAction()
    {
        $id = $this->_request->getParam("fiusu_codigo");
        $fila = $this->_request->getParam("fila_codigo");
        $this->view->title = "Agendamento Fila Unificada";
        $this->_helper->layout->setLayout("vazio");
        $this->view->fiusu_codigo = $id;
        $this->view->fila_codigo = $fila;
        return $this->render("excluir");
    }


    public function salvarAction()
    {
        $tbHist = new Application_Model_FilasHistoricos();
        $tbFilausu = new Application_Model_FilasUsuario();
        $tbUsr = new Application_Model_Usuarios();
        $tbFila = new Application_Model_Filas();
        $tbFilProc = new Application_Model_FilasUsuarioProcedimento();
        $fiusu_codigo = $this->_request->getPost("fiusu_codigo");
        $fila_codigo = $this->_request->getPost("fila_codigo");
        $uni_codigo = $this->_request->getPost("uni_codigo");
        $usr_codigo = $this->_request->getPost("usr_codigo");
        $fipr_codigo = $this->_request->getPost("fipr_codigo");
        $fiti_codigo = $this->_request->getPost("fiti_codigo");
        $usr_codigo_solicitante = $this->_request->getPost("interno");
        $fiusu_data_entrada = $this->_request->getPost("fiusu_data_entrada");
        $fiusu_motivo_solicitacao = ($this->_request->getPost("fiusu_motivo_solicitacao"));
        if ($fiusu_motivo_solicitacao):$fiusu_motivo_solicitacao = strtoupper($fiusu_motivo_solicitacao); endif;
        $fiusu_data_saida = $this->_request->getPost("fiusu_data_saida");
        $fiusu_motivo_saida = ($this->_request->getPost("fiusu_motivo_saida"));
        if ($fiusu_motivo_saida):$fiusu_motivo_saida = strtoupper($fiusu_motivo_saida); endif;
        $fiusu_data_pedido = $this->_request->getPost("fiusu_data_pedido");
        $usu_codigo = $this->_request->getPost("usu_codigo");
        $fiusu_status = $this->_request->getPost("fiusu_status");
        $fiusu_ordem = $this->_request->getPost("fiusu_ordem");
        $esp_codigo = $this->_request->getPost("esp_codigo");
        $procedimentos = $this->_request->getPost("proc");
        if (!$fiusu_codigo) {
            $verifica = $tbFilausu->verificaSolicitacoes($usu_codigo, $esp_codigo);
            $existe = false;
            if (count($verifica) > 0) {
                foreach ($verifica as $soli) {
                    $procs = $tbFilProc->listar($soli['fiusu_codigo']);
                    foreach ($procs as $proc) {
                        for ($j = 0; (count($procedimentos)) >= $j; $j++) {
                            if ($proc->proc_codigo == ($procedimentos[$j]['proc_codigo'])) {
                                $existe = TRUE;


                            }
                        }
                    }


                }
            }
            if ($existe) {
                $this->view->dados = array("success" => FALSE, "titulo" => "Atenção", "mensagem" => "Solicitação duplicada!"."<br/>"." Usuário já encontra-se na fila com esta especialidade e procedimento.");
                return $this->render("dados", NULL, TRUE);
            }
        }
        $array = array(
            'fila_codigo' => $fila_codigo,
            'uni_codigo' => $uni_codigo,
            'fipr_codigo' => $fipr_codigo,
            'fiti_codigo' => $fiti_codigo,
            'fiusu_data_entrada' => $fiusu_data_entrada,
            'fiusu_motivo_solicitacao' => $fiusu_motivo_solicitacao,
            'fiusu_data_saida' => $fiusu_data_saida,
            'fiusu_motivo_saida' => $fiusu_motivo_saida,
            'fiusu_data_pedido' => $fiusu_data_pedido,
            'usu_codigo' => $usu_codigo,
            'fiusu_status' => $fiusu_status,
            'fiusu_ordem' => $fiusu_ordem,
            'esp_codigo' => $esp_codigo,
        );
        if ($fiusu_codigo) {
            $array['fiusu_codigo'] = $fiusu_codigo;
        }
        switch ($usr_codigo_solicitante) {
            case 1:
                $array['usr_codigo'] = $usr_codigo;
                $array['med_codigo'] = null;
                break;
            case 0:
                $array['med_codigo'] = $usr_codigo;
                $array['usr_codigo'] = null;
                break;
        }
        $arrayHist = array(
            'fila_codigo' => $fila_codigo,
            'uni_codigo' => $uni_codigo,
            'usr_codigo' => $array['usr_codigo'],
            'med_codigo' => $array['med_codigo'],
            'fipr_codigo' => $fipr_codigo,
            'fiti_codigo' => $fiti_codigo,
            'fihi_data_entrada' => $fiusu_data_entrada,
            'fihi_motivo_solicitacao' => $fiusu_motivo_solicitacao,
            'fihi_data_saida' => $fiusu_data_saida,
            'fihi_motivo_saida' => $fiusu_motivo_saida,
            'fihi_data_pedido' => $fiusu_data_pedido,
            'usu_codigo' => $usu_codigo,
            'fihi_status' => $fiusu_status,
            'fihi_ordem' => $fiusu_ordem,
            'esp_codigo' => $esp_codigo,
            'fihi_usr_historico' => $tbUsr->getUsrAtual()->usr_codigo,
            'fihi_datahora_historico' => Date("d/m/Y H:i:s"),
        );

        $arrayHist['fiusu_codigo'] = $tbFilausu->salvar($array);
        $ordemHist = ($tbHist->buscarOrdemHistorico($arrayHist['fiusu_codigo']) + 1);
        $arrayHist['fihi_ordem_historico'] = $ordemHist;
        $tbHist->salvar($arrayHist);


        foreach ($procedimentos as $key => $part) {
            $procedimentos[$key]['fiusu_codigo'] = $arrayHist['fiusu_codigo'];
            $tbFilProc->salvar($procedimentos[$key]);
        }

        $tbFila->ordenaFilaAction($fila_codigo);

        $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Solicitação cadastrada com Sucesso!", "fiusu_codigo" => $arrayHist['fiusu_codigo'], "fila_codigo" => $fila_codigo);
        return $this->render("dados", NULL, TRUE);
    }

    public function checaRegulacaoAction()
    {

        $fila_codigo = $this->_request->getPost("fila_codigo", false);

        $tbUsr = new Application_Model_Usuarios();
        $usr = $tbUsr->getUsrAtual()->usr_codigo;
        $tbFila = new Application_Model_Filas();
        $filaReg = $tbFila->getRegulacao($fila_codigo);
        $tbFilaReg = new Application_Model_FilasReguladores();
        $regulador = $tbFilaReg->getReguladorFila($fila_codigo, $usr);


        if (!$filaReg) {
            $this->view->dados = array("regulador" => TRUE, "usa_regulacao" => FALSE);
            return $this->render("dados", NULL, TRUE);
        } elseif ($filaReg && $regulador) {
            $this->view->dados = array("regulador" => TRUE, "usa_regulacao" => TRUE );
            return $this->render("dados", NULL, TRUE);
        } else{
            $this->view->dados = array("regulador" => FALSE, "usa_regulacao" => TRUE);
        }

        return $this->render("dados", NULL, TRUE);

    }


    public function agendarAction()
    {
        if ($this->_request->isPost()) {
            $fiusu_codigo = $this->_request->getPost("fiusu_codigo");
            $fila_tipo = $this->_request->getPost("fila_tipo");

            switch ($fila_tipo) {
                case "I":
                    $this->view->dados = array("success" => TRUE, "link" => "/agendamento/index/index/fiusu_codigo/");
                    return $this->render("dados", NULL, TRUE);
                    break;
                case "E":
                    $this->view->dados = array("success" => TRUE, "link" => "/agendamento-externo/index/fiusu_codigo/");
                    return $this->render("dados", NULL, TRUE);
                    break;
                case "P":
                    $this->view->dados = array("success" => TRUE, "link" => "/agenda/agenda/novo/fiusu_codigo/");
                    return $this->render("dados", NULL, TRUE);
                    break;
            }
        } else {
            $fiusu_codigo = $this->_request->getParam("fiusu_codigo");
            $fila_tipo = $this->_request->getParam("fila_tipo");

            switch ($fila_tipo) {
                case "I":
                    return $this->_redirect("/agendamento/index/index/fiusu_codigo/$fiusu_codigo");
                    break;
                case "E":
                    return $this->_redirect("/agendamento-externo/index/fiusu_codigo/$fiusu_codigo");
                    break;
                case "P":
                    return $this->_redirect("/agenda/agenda/novo/fiusu_codigo/$fiusu_codigo");
                    break;
            }
        }


    }

    public function getdadoAction()
    {
        $fiusu_codigo = $this->_request->getParam("fiusu_codigo");
        $tbFilausu = new Application_Model_FilasUsuario();
        $this->view->dados = $tbFilausu->getdados($fiusu_codigo)->toArray();
        $tbFilaProc = new Application_Model_FilasUsuarioProcedimento();
        $procedimentos = $tbFilaProc->listar($fiusu_codigo);
        $this->view->dados['proc_codigo'] = $procedimentos[0]->proc_codigo;
        $this->view->dados['proc_nome'] = $procedimentos[0]->proc_nome;
        return $this->render("dados", NULL, TRUE);
    }

    public function imprimirAction()
    {
        $copias = $this->_getParam("copias", FALSE);

        Zend_Layout::getMvcInstance()->setLayout("simples");
        $tbSec = new Application_Model_Secretaria();
        $this->view->sec = $tbSec->getDadosSec()->toArray();
        $tbUsr = new Application_Model_Usuarios();
        $this->view->usr = $tbUsr->getUsrAtual();

        $this->view->vias = $copias;


        $this->view->title = "Imprimir Comprovante";

        $this->view->tipo_impressao = "Comprovante de Inclusão em Fila de Espera";

        $fiusu_codigo = $this->_getParam("fiusu_codigo", FALSE);
        if (!$fiusu_codigo)
            return $this->_redirect("index");

        $tbFilaUsu = new Application_Model_FilasUsuario();
        $this->view->dados = $tbFilaUsu->imprimir($fiusu_codigo);
        $tbFilProc = new Application_Model_FilasUsuarioProcedimento();
        $this->view->procedimentos = $tbFilProc->listar($fiusu_codigo);
    }

    public function excluirProcedimentoAction()
    {
        $proc = $this->_getParam("fiproc_codigo");
        $tbFilProc = new Application_Model_FilasUsuarioProcedimento();
        try {
            $tbFilProc->excluir($proc);
            $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Procedimento excluido com Sucesso!");

        } catch (Exception $exc) {

            $this->view->dados = array("success" => FALSE, "titulo" => "ERRO", "mensagem" => $exc->getMessage());
        }

        return $this->render("dados", NULL, TRUE);

    }

    public function verificaAgendamentoAction()
    {
        $fiusu_codigo = $this->_getParam("fiusu_codigo", FALSE);
        $tbAgeInt = new Application_Model_Agendamento();
        $tbAgeExt = new Application_Model_AgendamentoExterno();
        $tbAgeProc = new Application_Model_Agenda();
        $interno = $tbAgeInt->getDadosAgendamentoFila($fiusu_codigo);
        if ($interno) {
            $this->view->dados = array("success" => TRUE, "tipo_agendamento" => "I");
            return $this->render("dados", NULL, TRUE);
        }
        $externo = $tbAgeExt->buscarFila($fiusu_codigo);
        if ($externo) {
            $this->view->dados = array("success" => TRUE, "tipo_agendamento" => "E");
            return $this->render("dados", NULL, TRUE);
        }
        $procedimentos = $tbAgeProc->getAgendamentoFila($fiusu_codigo);
        if ($procedimentos) {
            $this->view->dados = array("success" => TRUE, "tipo_agendamento" => "P");
            return $this->render("dados", NULL, TRUE);
        }

    }

    public function getMotivosAction(){
        $fiusu_codigo = $this->_getParam("fiusu_codigo", FALSE);

        if($fiusu_codigo){
            $tbFiUsu = new Application_Model_FilasUsuario();
            $mensagem = $tbFiUsu->getMotivo($fiusu_codigo)->fiusu_motivo_saida;

            if($mensagem){
                $this->view->dados = array("success" => TRUE, "mensagem" => $mensagem);
                return $this->render("dados", NULL, TRUE);
            } else{
                $this->view->dados = array("success" => TRUE, "mensagem" => "Nenhum motivo cadastrado!");
                return $this->render("dados", NULL, TRUE);
            }
        }
    }

}