<?php

class Laboratorio_GrupoDeExamesController extends Zend_Controller_Action
{

    public function init()
    {
        $this->view->title = "Grupos de Exames";
    }

    public function indexAction()
    {
        $tbGruEx = new Application_Model_GrupoExame();
        $this->view->dados = $tbGruEx->getGrupos();
        $this->render("index");
    }

    public function salvarConfigGrupoDeExamesAction()
    {
        // Utilizado em mais de um lugar por isso esta aqui
        $tbGruex = new Application_Model_TipoExameGrupo();
        $qtdeProcedimentos = $this->_request->getPost("proc_qtd_total");
        $procedimentos = $this->_request->getPost("proc");
        $gruexCodigo = $this->_request->getParam("gruex_codigo");
        foreach ($procedimentos as $key => $part) {
            $procedimentos[$key]['gruex_codigo'] = $gruexCodigo;
            $tbGruex->salvarConfigGrupoDeExames($procedimentos[$key]);
        }
        $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Grupo cadastrado com Sucesso!", "gruex_codigo" => "$gruexCodigo");
        return $this->render("dados", NULL, TRUE);

    }

    public function atualizaOrdemConfiguracoesAction()
    {
        $tbTipGruex = new Application_Model_TipoExameGrupo();
        $ordem = $this->_request->getPost("ordem", FALSE);
        $ordemCont = 1;
        foreach ($ordem as $item) {
            $tbTipGruex->atualizaOrdemConfigGrupoDeExames($ordemCont, $item);
            $ordemCont++;
        }
        $this->view->dados = NULL;
        $this->render("dados", NULL, TRUE);
    }

    public function excluirConfiguracoesAction()
    {
        $tbGruex = new Application_Model_GrupoExame();
        $gruexCodigo = $this->_request->getParam("gruex_codigo", FALSE);
        $tbGruex->excluir($gruexCodigo);
        $this->_redirect("/laboratorio/grupo-de-exames/index");
    }

    public function excluirProcedimentosVinculadosAction()
    {
        $tbGruex = new Application_Model_TipoExameGrupo();
        $txg_codigo = $this->_request->getParam("txg_codigo", FALSE);
        $tbGruex->excluirConfigGrupoDeExames($txg_codigo);
        $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Procedimento excluído com Sucesso!");
        return $this->render("dados", NULL, TRUE);
    }

    public function listaDadosEdicaoConfiguracao($txgCodigo = FALSE)
    {
        if ($txgCodigo != FALSE) {
            $tbTipGruex = new Application_Model_TipoExameGrupo();
            $dadosEdicao = $tbTipGruex->listaDadosEdicaoConfigGrupoDeExames($txgCodigo);
            return $dadosEdicao;
        }
    }

    public function buscaConfiguracoesAction()
    {
        $tbGruex = new Application_Model_GrupoExame();
        $busca = $this->_request->getPost("grupo_nome", FALSE);
        $this->view->dados = $tbGruex->getGruposPorNome($busca);
        $this->render("index");
    }

    public function formAction()
    {

        $this->view->title = "Cadastro de Grupo de Exames";
        $codGrupo = $this->_request->getParam("id");
        if ($codGrupo) {
            $tbGruex = new Application_Model_GrupoExame();
            $tbGruProc = new Application_Model_TipoExameGrupo();
            $this->view->grupo_exame = $tbGruex->getGruposPorId($codGrupo);
            $this->view->procedimentos = $tbGruProc->listaDadosConfigGrupoDeExames($codGrupo);
        }
    }

    public function salvarFormGrupoDeExameAction()
    {
        $grupoDescricao = strtoupper($this->_request->getPost("gruex_descricao"));
        $grupoDescricaoControle = strtoupper($this->_request->getPost("gruex_descricao_controle"));
        $grupoCodigo = $this->_request->getPost("gruex_codigo");

        $pre_natal = $this->_request->getPost("pre_natal", FALSE);
        try {
            // Validando se já existe grupo cadastrado
            $tbGruEx = new Application_Model_GrupoExame();
            if ($grupoDescricao === $grupoDescricaoControle) {
                $verificaNome = 0;
            } else {
                $verificaNome = $tbGruEx->verificaNome($grupoDescricao);
            }
            if ($verificaNome == 0) {
                $dados = array(
                    'gruex_descricao' => $grupoDescricao,
                    'pre_natal' => $pre_natal
                );
                if ($grupoCodigo) {
                    $dados['gruex_codigo'] = $grupoCodigo;
                }
                $codGruEx = $tbGruEx->salvar($dados);
                $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Grupo cadastrado com Sucesso!", "gruex_codigo" => "$codGruEx");
            } else {
                $this->view->dados = array("success" => FALSE, "titulo" => "Erro", "mensagem" => "Ja existe um Grupo com este Nome!");
            }

        } catch (Exception $exc) {
            $mensagem = $exc->getMessage();
            $this->view->dados = array("success" => FALSE, "titulo" => "Erro", "mensagem" => "$mensagem");

        }
        return $this->render("dados", NULL, TRUE);
    }

    public function grupoPrenatalAction(){

        $this->view->title = "Procedimentos do Grupo de Exames";
        $this->_helper->layout->setLayout("vazio");
        $codGrupo = $this->_request->getParam("gruex_codigo");
        $inserir = $this->_request->getParam("inserir");
        $tbGruex = new Application_Model_GrupoExame();
        $tbGruProc = new Application_Model_TipoExameGrupo();
        if ($codGrupo) {

            $this->view->grupo_exame = $tbGruex->getGruposPorId($codGrupo);
            $this->view->procedimentos = $tbGruProc->listaDadosConfigGrupoDeExames($codGrupo);
        }
        if($inserir){
            $this->view->dados = $tbGruProc->listaDadosConfigGrupoDeExames($codGrupo)->toArray();
            return $this->render("dados", NULL,TRUE);
        }
    }
}

