<?php
class Leito_CategoriaController extends Zend_Controller_Action {

	public function init() {
		$this->view->title = "Modelos para Dispensação de Medicamentos";
	}

	public function indexAction() {
		$this->view->itens = (new Application_Model_LeitoGradeCategoria())->getCategorias();
	}

	public function salvarAction() {
		$dados = [
			"lgc_codigo" => $this->_request->getPost("lgc_codigo", FALSE),
			"lgc_descricao" => strtoupper($this->_request->getPost("lgc_descricao", FALSE))
		];

		$idModelo = (new Application_Model_LeitoGradeCategoria())->salvar($dados);
		$this->_redirect("leito/categoria/editar/id/$idModelo");
	}

	public function salvarModeloAction() {
		$dados = [
			"lgm_codigo" => $this->_request->getPost("lgm_codigo", FALSE),
			"lgc_codigo" => $this->_request->getPost("lgc_codigo", FALSE),
			"pro_codigo" => $this->_request->getPost("pro_codigo", FALSE),
			"adm_codigo" => $this->_request->getPost("adm_codigo", FALSE),
			"lgm_quantidade" => $this->_request->getPost("lgm_quantidade", FALSE),
		];
		(new Application_Model_LeitoGradeModelo())->salvar($dados);
	}

	public function editarAction() {
		$id = (int) $this->_getParam("id", 0);
		$tbLGC = new Application_Model_LeitoGradeCategoria();
		$this->view->dados = $tbLGC->find($id)->current();

		$this->view->administracoes = (new Application_Model_TbAdministracaoProduto())->getTodasAdministracoes();
		$this->view->modelos = (new Application_Model_LeitoGradeModelo())->getModelos($id);

		return $this->render("novo");
	}

	public function novoAction() {
		$this->view->fechaPopUp = $this->_getParam("pop", 0);
	}

	public function pesquisaAction() {
		if ($this->_request->isPost()) {
			$dados = $this->_request->getPost("busca");
			$tbProc = new Application_Model_LeitoGradeCategoria();
			$ouch = $tbProc->pesquisarCategoria($dados);
			$this->view->itens = $ouch;
			$this->render("index");
		} else {
			$this->_redirect("agenda/procedimento");
		}
	}

	public function excluirAction() {
		$id = $this->_getParam("id", 0);
		try {
			$tbLGC = new Application_Model_LeitoGradeCategoria();
			$tbLGC->excluir($id);
			return $this->_redirect("leito/categoria/index");
		} catch (Zend_Validate_Exception $exc) {
			$this->view->erro = $exc->getMessage();
      $this->view->itens = (new Application_Model_LeitoGradeCategoria())->getCategorias();
			return $this->render("categoria/index", NULL, TRUE);
		}
	}

	public function excluirModeloAction() {
		(new Application_Model_LeitoGradeModelo())->excluir($this->_getParam("id", 0));
	}

}
