<?php

class Leito_MedicamentosController extends Zend_Controller_Action
{

  public function init()
  {
    $this->view->title = "Dispensação de Medicamentos";
  }

  /**
  * Lista as grades que precisam ser dispensadas.
  * Quais são os proximos leitos a receber medicamentos.
  */
  public function indexAction()
  {
    $tbLGra = new Application_Model_LeitoGrade();
    $this->view->itens = $tbLGra->getProximos();
    $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/leito/medicamentos/index.js');
    $this->view->headLink()->appendStylesheet($this->view->baseUrl() . '/public/css/leito/medicamentos/index.css', 'all');
  }

  /**
  * Lista as grades criadas para este leito/paciente
  */
  public function verAction()
  {
    $io_codigo = $this->_getParam("io_codigo", FALSE);
    $prontuario = $this->_getParam("prontuario", FALSE);
    $readonly = $this->_getParam("readonly", FALSE);

    $impresso = $this->_getParam("impresso", FALSE);
    $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/leito/medicamentos/ver.js');
    if (!$io_codigo)
      return $this->_redirect("/leito");

    if (!empty($prontuario)) {
      $this->view->prontuario = $prontuario;
    }

    if (!empty($impresso)) {
      $this->view->impresso = $impresso;
    }

    $tbLGra = new Application_Model_LeitoGrade();
    $this->view->grades = $tbLGra->buscarGrades($io_codigo);
    $this->view->io_codigo = $io_codigo;
    $this->view->readonly = $readonly == true ? true : false;
    $tbIo = new Application_Model_InternacaoObservacao();
    $io_observacao = $tbIo->buscar($io_codigo);
    $this->view->io_observacao = $io_observacao['io_observacao'];
  }

  public function haReservasAction()
  {
    $lgra_codigo = $this->_getParam("lgra", FALSE);;
    if (!$lgra_codigo)
    $this->view->dados = array("reservas" => FALSE);

    else {

      $tbLGra = new Application_Model_LeitoGrade();
      $reservas = $tbLGra->buscarRerservas($lgra_codigo);
      $this->view->dados = array("reservas" => (bool)$reservas->count());
    }

    return $this->render("dados", NULL, TRUE);
  }

  public function historicoAction()
  {
    $this->_helper->layout->disableLayout();
    $lgra_codigo = $this->_getParam("lgra", FALSE);
    $usu = $this->_getParam("usu", FALSE);
    if (!$lgra_codigo)
    return FALSE;

    $tbLGD = new Application_Model_LeitoDispensacao();
    if ($lgra_codigo) {
      $this->view->itens = $tbLGD->getHistorico($lgra_codigo);
    }
    if ($usu) {
      $usu_codigo = $tbLGD->getUsuarioByLeito($lgra_codigo);
      if ($usu_codigo) {
        $this->view->itens = $tbLGD->getHistoricoPorUsuario($usu_codigo->usu_codigo);
      }

    }
  }


  /**
  * Lista os produtos que serão usados no leito
  * Procura se há revervas, ou então procura
  * @return type
  */
  public function listarProdutosAction()
  {
    $lgra_codigo = $this->_getParam("lgra", FALSE);
    $tbUsr = new Application_Model_Usuarios();

    if (!$lgra_codigo)
    return $this->_redirect("/leito/medicamentos");

    $this->_helper->layout->disableLayout();
    $tbLGra = new Application_Model_LeitoGrade();
    $tbLgp = new Application_Model_LeitoGradeProdutos();
    $this->view->lgra = $tbLGra->find($lgra_codigo)->current();

    if ($this->view->lgra->lgra_status != 1) {
      return FALSE; // páre por aqui
    }

    $this->view->lgra_codigo = $lgra_codigo;

    $this->view->itens = $tbLGra->buscarRerservas($lgra_codigo);

    $this->view->produtos = $tbLgp->buscarRerservas($lgra_codigo);


    $this->view->tipo = "1"; // reserva=>dispensar
    if (!$this->view->itens->count()) {
      $this->view->itens = $tbLGra->getMelhoresLotes($lgra_codigo);
      $this->view->tipo = "2"; // saldo/fracionado => reservar
    } else {
      $tbCFR = new Application_Model_ControleFracionadoReserva();
      $this->view->itens = $tbCFR->reservasToTable($this->view->itens);
    }
  }

  public function dispensarDaReservaAction()
  {

    $reservas = $this->_request->getPost("cfr", FALSE);
    $lgra_codigo = $this->_request->getPost("lgra_codigo", FALSE);
    $usr_codigo = $this->_request->getPost("usr_codigo", FALSE);
    $num = $this->_request->getPost("num", FALSE); // 1ª dispensacao, 2ª dispensação...
    $produtos = $this->_request->getPost("pro");
    $data_hora = $this->_request->getPost("data_hora");
    $tbLDis = new Application_Model_LeitoDispensacao();
    $tbLgp = new Application_Model_LeitoGradeProdutos();

    try {
      $tbLgp->alterarStatus($produtos, "D");
      $tbLDis->dispensar($lgra_codigo, $reservas, $num, $usr_codigo, $data_hora);
      $this->view->dados = array("success" => TRUE, "reload" => TRUE);
    } catch (Exception $exc) {
      $this->view->dados = array("error" => TRUE, "mensagem" => $exc->getMessage());
      if ($exc->getCode() == 999) {
        $this->view->dados['reload'] = TRUE;
      }
    }

    return $this->render("dados", NULL, TRUE);
  }

  /**
  * View para criar a grade para dispensação
  */
  public function dispensarAction()
  {
    $io_codigo = $this->_getParam("io_codigo", FALSE);
    $ate_codigo = $this->_getParam("ate_codigo", FALSE);
    $prontuario = $this->_getParam("prontuario", FALSE);
    $leito_grade = $this->_getParam("leito-grade", FALSE);

    $this->view->prontuario = $prontuario;
    $this->_helper->layout->setLayout("simples"); // abas manuais
    $this->view->headMeta()->setName('viewport', 'width=device-width, user-scalable=no');

    $this->view->io_codigo = $io_codigo;
    $this->view->ate_codigo = $ate_codigo;
    //Pega todos as administrações e as informa a view
    $this->view->administracoes = (new Application_Model_TbAdministracaoProduto())->getTodasAdministracoes();
    $this->view->modelos = (new Application_Model_LeitoGradeCategoria())->getCategorias();

    if($leito_grade){
        $this->view->dados = (new Application_Model_LeitoGrade())->getDadosGrade($leito_grade);
    }
  }

  public function listagemModelosAction()
  {
    $idModelo = $this->_getParam("id", FALSE);

    $this->view->dados = (new Application_Model_LeitoGradeModelo())->getModelos($idModelo)->toArray();
    return $this->render("dados", NULL, TRUE);
  }

  public function modeloAction()
  {
    $this->_helper->layout->disableLayout();
  }

  public function salvarAction()
  {
    $tbLGra = new Application_Model_LeitoGrade();
    return $tbLGra->salvarFromArray($_POST);
  }

  public function cancelarGradeAction()
  {
    $lgra_codigo = $this->_request->getPost("lgra_codigo", FALSE);
    if (!$lgra_codigo)
    $this->view->dados = array("error" => TRUE, "mensagem" => "Informe o lgra_codigo!");

    else {
      $tbLGra = new Application_Model_LeitoGrade();
      $tbLgp = new Application_Model_LeitoGradeProdutos();
      $tbLGra->cancelar($lgra_codigo);
      $tbLgp->cancelar($lgra_codigo);
      $this->view->dados = array("success" => TRUE);
    }
    $this->render("dados", NULL, TRUE);
  }

  public function validacaoAction()
  {
    $this->_helper->layout->disableLayout();
    $this->view->url = "/WebSocialSaude/biometria/retornaUsuario.php";
    $this->view->height = 200;
    $this->render("iframe", NULL, TRUE);
  }

  public function loginAction()
  {
    $this->_helper->layout->disableLayout();
    $tbSet = new Application_Model_UsuariosSetores();
    $tbUsr = new Application_Model_Usuarios();

    $this->view->profissionais = $tbSet->getUsuariosSetoresPorUnidade($tbUsr->getUsrAtual()->uni_codigo, $tbUsr->getUsrAtual()->set_codigo);
  }

  public function devolucaoAction()
  {
    $lgra_codigo = $this->_getParam("lgra", FALSE);

    if (!$lgra_codigo)
    return $this->_redirect("/leito/medicamentos");

    $this->_helper->layout->disableLayout();
    $tbLGra = new Application_Model_LeitoGrade();
    $tbLgp = new Application_Model_LeitoGradeProdutos();
    $this->view->lgra = $tbLGra->find($lgra_codigo)->current();

    if ($this->view->lgra->lgra_status != 1) {
      return FALSE; // páre por aqui
    }

    $this->view->lgra_codigo = $lgra_codigo;

    $this->view->itens = $tbLGra->buscarRerservas($lgra_codigo);

    $this->view->produtos = $tbLgp->buscarRerservas($lgra_codigo);


    $this->view->tipo = "1"; // reserva=>dispensar
    if (!$this->view->itens->count()) {
      $this->view->itens = $tbLGra->getMelhoresLotes($lgra_codigo);
      $this->view->tipo = "2"; // saldo/fracionado => reservar
    } else {
      $tbCFR = new Application_Model_ControleFracionadoReserva();
      $this->view->itens = $tbCFR->reservasToTable($this->view->itens);
    }
  }
}
