<?php

class Materiais_ControleMovimentosController extends Zend_Controller_Action {

  public function init() {
    $this->view->title = "Controle de Movimentos";
    $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/materiais/movimentacao.js');
    $this->view->headLink()->appendStylesheet($this->view->baseUrl().'/public/css/materiais/movimentacao.css','all');
  }

  public function indexAction() {
    $tbMov = new Application_Model_Movimento();
    $movimentos = $tbMov->getMovimentos(15);

    $this->view->nomesSetor = $this->montaSetoresPorMovimento($movimentos);
    $this->view->itens = $movimentos;
  }

  public function novoAction() {
    return $this->_redirect("materiais/movimentacao/index");
  }

  public function editarAction() {
    $mov_codigo = $this->_getParam("id",FALSE);
    $mov_tipo = $this->_getParam("tipo",FALSE);
    if($mov_tipo == "S") {
      return $this->_redirect("materiais/saida/index/id/$mov_codigo");
    } else if($mov_tipo == "E") {
      return $this->_redirect("materiais/entrada/index/id/$mov_codigo");
    }

    return $this->_redirect("materiais/transferencia/index/id/$mov_codigo");
  }

  public function buscarAction() {
    if ($this->_request->isPost()) {
      $tbMov = new Application_Model_Movimento();
      $busca = $this->_request->getPost("term", NULL);
      $mov_tipo = $this->_request->getPost("mov_tipo");
      $limit = NULL;
      if(empty($busca)){
      	$limit = 15;
      }
      $this->view->itens = $tbMov->getMovimentos($limit, $busca, $mov_tipo);
      $this->render("index");
    }
  }

  private function montaSetoresPorMovimento($movimentos) {
    $tbSet = new Application_Model_Setor;

    $arrayNomeSetor = [];
    foreach ($movimentos as $movimento) {
      if ($movimento->tipo == 'T') {
        $arrayNomeSetor[$movimento->mov_codigo] = [
          'origem' => $this->getNomeSetor($movimento->set_saida, $tbSet),
          'destino' => $this->getNomeSetor($movimento->set_entrada, $tbSet),
        ];
      } else if ($movimento->tipo == 'E') {
        $arrayNomeSetor[$movimento->mov_codigo] = [
          'origem' => '',
          'destino' => $this->getNomeSetor($movimento->set_entrada, $tbSet),
        ];
      } else {
        $arrayNomeSetor[$movimento->mov_codigo] = [
          'origem' => $this->getNomeSetor($movimento->set_saida, $tbSet),
          'destino' => '',
        ];
      }
    }

    return $arrayNomeSetor;
  }

  private function getNomeSetor($codigoSetor, $setorModel) {
    return $setorModel->getSetorNomePorCodigo($codigoSetor)['set_nome'];
  }

}
