<?php

class Materiais_EntradaController extends Zend_Controller_Action {

    public function init() {
        $this->view->title = "Entrada";
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/materiais/movimentacao.js');
        $this->view->headLink()->appendStylesheet($this->view->baseUrl() . '/public/css/materiais/movimentacao.css', 'all');
    }

    public function indexAction() {
        // action body
        $tbFor = new Application_Model_Fornecedor();
        $tbSet = new Application_Model_Setor();
        $tbConf = new Application_Model_Configuracao();

        $mov_codigo = $this->_getParam("id", FALSE);

        if ($mov_codigo) {
            $tbMov = new Application_Model_Movimento();
            $movimento = $tbMov->getMovimento($mov_codigo)->toArray();
            $this->view->itens = $movimento;
            $tbIte = $tbIte = new Application_Model_ItensMovimento();
            $itens_movimento = $tbIte->getProdutosPorMovimento($mov_codigo)->toArray();
            $this->view->itens_movimento = $itens_movimento;
        }

        $this->view->config_imp = $tbConf->getDadosConfigPelaChave("IMPRIMIR_COMPROVANTES_MOVIMENTACAO")->conf_valor_bool;
        $this->view->fornecedores = $tbFor->selectTag(NULL, $movimento['for_codigo']);
        $this->view->setores = $tbSet->selectTag(TRUE, NULL, $movimento['set_entrada']);

    }

    public function itemSalvarAction() {

        Zend_Layout::getMvcInstance()->setLayout("vazio");

        $pro_codigo = $this->_request->getPost('pro_codigo', FALSE);
        $ite_doses = $this->_request->getPost('ite_doses', FALSE);
        $ite_lote = $this->_request->getPost('ite_lote', FALSE);
        $ite_vlrunid = $this->_request->getPost('ite_vlrunid', FALSE);
        $valortotal = $this->_request->getPost('valortotal', FALSE);
        $ite_codbarras = $this->_request->getPost('ite_codbarras', FALSE);
        $ite_codigo = $this->_request->getPost('ite_codigo', FALSE);
        $ite_validade = $this->_request->getPost('ite_validade', FALSE);
        $ite_quantidade = $this->_request->getPost('ite_quantidade', FALSE);
        $fab_codigo = $this->_request->getPost('fab_codigo', FALSE);
//        $fab_descricao = $this->_request->getPost('fab_descricao',FALSE);
//        $pro_fracionado = $this->_request->getPost('pro_fracionado',FALSE);
        $mov_codigo = $this->_request->getPost('mov_codigo', FALSE);
//        $produto_vinculo_setor = $this->_request->getPost('produto_vinculo_setor',FALSE);
//        $data_atual = $this->_request->getPost('data_atual',FALSE);

        $tbUsr = new Application_Model_Usuarios();
        $usr = $tbUsr->getUsrAtual();

        $dadosArray = array(
            'ite_aux_codigo' => $ite_codigo,
            'mov_codigo' => $mov_codigo,
            'pro_codigo' => $pro_codigo,
//            'ite_aux_vlrdesc',
            'ite_aux_lote' => $ite_lote,
            'ite_aux_validade' => $ite_validade,
            'usr_codigo' => $usr->usr_codigo,
//            'ite_aux_timestamp',
//            'ite_aux_ip',
//            'ite_aux_status',
            'ite_aux_quantidade' => $ite_quantidade,
//            'ite_aux_consolidado',
            'ite_aux_vlrunit' => $ite_vlrunid,
//            'ite_aux_qtde_solicitada',
//            'ite_aux_posologia',
//            'ite_aux_detalhes_tratamento',
//            'ite_aux_observacoes',
//            'ite_aux_qtde_dia',
            'ite_aux_vlrtotal' => $valortotal,
//            'ite_aux_lote_bkp',
//            'ite_aux_validade_bkp',
            'ite_aux_dose' => $ite_doses,
//            'ite_aux_dose_lote',
//            'ite_aux_duracao',
//            'ite_aux_custo_medio',
            'fab_codigo' => $fab_codigo,
//            'ite_aux_cod_receita',
            'ite_aux_codbarras' => $ite_codbarras,
        );

        $tbIma = new Application_Model_ItensMovimentoAux();
        $this->view->dados = $tbIma->salvar($dadosArray);

        //TODO renderizar "1"

        return $this->render('dados', null, true);
    }

    public function itemRemoverAction() {

        Zend_Layout::getMvcInstance()->setLayout("vazio");

        $pro_codigo = $this->_request->getPost('pro_codigo', FALSE);
        $ite_codigo = $this->_request->getPost('ite_codigo', FALSE);
        $mov_codigo = $this->_request->getPost('mov_codigo', FALSE);

        $tbUsr = new Application_Model_Usuarios();
        $usr = $tbUsr->getUsrAtual();

        $tbIma = new Application_Model_ItensMovimentoAux();
        $tbIma->deletarItem($ite_codigo,$mov_codigo);

        //TODO renderizar "1"

        return "1";
    }

    public function itemRemoverProdutoAction() {

        Zend_Layout::getMvcInstance()->setLayout("vazio");

        $pro_codigo = $this->_request->getPost('pro_codigo', FALSE);
        $mov_codigo = $this->_request->getPost('mov_codigo', FALSE);

        $tbUsr = new Application_Model_Usuarios();
        $usr = $tbUsr->getUsrAtual();

        $tbIma = new Application_Model_ItensMovimentoAux();
        $tbIma->deletarItemPorProduto($pro_codigo,$mov_codigo);

        //TODO renderizar "1"

        return "1";
    }

}

