<?php

require_once HORUS_PATH . "/SoapHorus.php";
require_once HORUS_PATH . "/sync/SyncController.php";
require_once HORUS_PATH . "/HorusEnum.php";

use Saude\Horus;
use Saude\Horus\SoapHorus;
use Saude\Horus\Sync\SyncController;

class Materiais_EnvioDeMateriaisController extends Zend_Controller_Action {

	private $horus;
	private $sync;

	public function init() {
		$this->view->title = "Envio de Materiais";
		$this->view->headLink()->appendStylesheet($this->view->baseUrl() . '/public/css/materiais/movimentacao.css', 'all');
	}

	public function indexAction() {
		// action body
		$tbReq = new Application_Model_RequisicaoMateriais();
		$this->view->itens = $tbReq->getRequisicoesPorEnvio(15);


	}

	public function formAction() {
		$tbSet = new Application_Model_Setor();
		$tbUsr = new Application_Model_Usuarios();
		$this->view->usr_nome = $tbUsr->getUsrAtual()->usr_nome;

		$rem_codigo = $this->_getParam("id", FALSE);
		$this->view->rem_codigo = $rem_codigo;
		if ($rem_codigo) {
			$tbRem = new Application_Model_RequisicaoMateriais();
			$requisicao = $tbRem->getRequisicao($rem_codigo)->toArray();
			$this->view->itens = $requisicao;
			$tbRemi = $tbRemi = new Application_Model_RequisicaoMateriaisItens();
			$itens_requisicao = $tbRemi->getProdutosRequisicao($rem_codigo)->toArray();
			$this->view->itens_requisicao = $itens_requisicao;
		}

		$this->view->setor_origem = $tbSet->selectTag(FALSE, "set_codigo_req", $requisicao['set_codigo_req']);
		$this->view->setores = $tbSet->selectTag(FALSE, "set_codigo_sol", $requisicao['set_codigo_sol']);
	}

	public function salvarAction() {
		$tbUsr = new Application_Model_Usuarios();
		$usr_codigo = $tbUsr->getUsrAtual()->usr_codigo;

		$requisicao = array("set_codigo_req" => $this->_request->getPost("set_codigo_req", NULL),
			"set_codigo_sol" => $this->_request->getPost("set_codigo_sol", NULL),
			"rem_observacao" => ($this->_request->getPost("rem_observacao", NULL) == "0" ? "5003" : $this->_request->getPost("for_codigo", NULL)),
			"rem_data" => 'NOW()',
			"usr_codigo" => $usr_codigo,
			"rem_status" => $this->_request->getPost("rem_status", NULL));

		$tbReq = new Application_Model_RequisicaoMateriais();
		try {
			$rem_codigo = $tbReq->salvar($requisicao);
			$this->view->dados = array("msg" => "Dados cadastrados com sucesso", "id" => $rem_codigo);
		} catch (Zend_Validate_Exception $exc) {
			$this->view->dados = $exc->getMessage();
		}
		//$this->view->dados = $mov_codigo;
		return $this->render("dados", NULL, TRUE);
	}

	public function editarAction() {
		$rem_codigo = $this->_getParam("id", FALSE);
		return $this->_redirect("materiais/envio-de-materiais/form/id/$rem_codigo");
	}

	public function buscarAction() {
		if ($this->_request->isPost()) {
			$busca = $this->_request->getPost("busca");
			$rem_status = $this->_request->getPost("rem_status");
			$tbReq = new Application_Model_RequisicaoMateriais();
			$this->view->busca = $busca;
			$this->view->rem_status = $rem_status;
			$this->view->itens = $tbReq->getRequisicoesPorEnvio(NULL, $busca, $rem_status);
			$this->render("index");
		} else {
			$this->_redirect("/materiais/controle-movimentos/index");
		}
	}

	public function salvarItensAction() {

		$this->view->dados = array(
			"id" => null,
			"msg" => null,
			"protocolos" => array(),
			"horus" => array()
		);

		$tbIteLo = new Application_Model_RequisicaoMateriaisItensLote();
		$tbIte = new Application_Model_RequisicaoMateriaisItens();
		$tbRem = new Application_Model_RequisicaoMateriais();
		$tbPro = new Application_Model_Produto();
		$tbFab = new Application_Model_Fabricante();
		$tbMov = new Application_Model_Movimento();

		$rem_codigo = $this->_request->getPost("rem_codigo");
		$requisicao = $tbRem->getRequisicao($rem_codigo);

		$tbSet = new Application_Model_Setor();
		$set_sol = $tbSet->getSetorPorCodigo($requisicao->set_codigo_sol);

		Zend_Db_Table::getDefaultAdapter()->beginTransaction();
		try {
			if (count($this->_request->getPost("itens"))) {
				$dadosMov = array(
					"mov_tipo" => "S",
					"mov_saida" => "S-TR",
					"req_codigo" => $requisicao->rem_codigo,
					"set_saida" => $requisicao->set_codigo_sol,
					"mov_observacao" => $requisicao->rem_observacao,
					"mov_data" => 'NOW()',
					"mov_data_inclusao" => 'NOW()',
					"usr_codigo" => $requisicao->usr_codigo
				);

				$codMov = $tbMov->salvarMovimentacaoRequisicao($dadosMov);

				if($set_sol->set_usa_horus === "S"){
					$this->horus = new SoapHorus();
					if ($this->horus->isSincrono()) {
						$this->sync = new SyncController();
						$ddHorus = $this->sync->getDados();
					}
				}

				foreach ($this->_request->getPost("itens") as $item) {
					$array_lotes = explode("-", $item['remil_lote']);
					$array_itens_lote = array(
						"remi_codigo" => $item['remi_codigo'],
						"remil_quantidade" => $item['remil_quantidade'],
						"remil_lote" => $array_lotes[0],
						"remil_validade" => $array_lotes[2]

					);
					if($set_sol->set_usa_horus === "S") {
						$pro = $tbPro->getProduto($item['pro_codigo']);
						$fabricante = $tbFab->getFabricantePorLoteEItemRequisicao($item['remi_codigo'], $array_lotes[0]);
						$noFabricanteInternacional = "FABRICANTE";
						$nuCNPJFabricante = null;
						if ($fabricante && isset($fabricante->fab_codigo) && $fabricante->fab_internacional == FALSE) {
							$array_itens['fab_codigo'] = $fabricante->fab_codigo;
							if (!empty($fabricante->fab_cnpj)) {
								$nuCNPJFabricante = str_replace(['-', '.', '/'], "", $fabricante->fab_cnpj);
								$noFabricanteInternacional = NULL;
							}
						}

						$protocolo = NULL;
						if ($this->sync->getCadastroHorus()) {
							if (!empty($pro->pro_horus) && !empty($pro->pro_horus_tipo)) {
								if ($this->sync != null) {

									if (empty($set_sol->set_tipo_estab)) {
										$this->view->dados['msg'] = "Tipo estabelecimento Horus não cadastrado no setor $set_sol->set_nome";
										return $this->render("dados", NULL, TRUE);
									}

									if (empty($set_sol->uni_cnes)) {
										$this->view->dados['msg'] = "CNES da unidade do setor $set_sol->set_nome não cadastrado.";
										return $this->render("dados", NULL, TRUE);
									}

									$nuProduto = $pro->pro_horus_tipo . $pro->pro_horus;
									$dtValidade = DateTime::createFromFormat('d/m/Y', $array_itens_lote['remil_validade']);
									$dtRegistro = new DateTime();

									$protocolo = $this->sync->informarSaidaMedicamento(
										$ddHorus['idOrigem'],
										$ddHorus['coIBGE'],
										$ddHorus['coCNES'],
										$set_sol->set_tipo_estab,
										$pro->pro_codigo,
										$nuProduto,
										$array_itens_lote['remil_lote'],
										$dtValidade->format('d-m-Y'),
										intval($array_itens_lote['remil_quantidade']),
										$dtRegistro->format('d-m-Y'),
										null,
										$nuCNPJFabricante,
										$noFabricanteInternacional,
										Horus\TP_SAIDA::TRANSFERENCIA_REMANEJAMENTO,
										Horus\TP_IDENTIFICACAO::CNES,
										$set_sol->uni_cnes
									);
									if ($protocolo instanceof \SoapFault) {
										$this->view->dados['horus'][] = "\nErro Horus: " . $protocolo->getMessage() . "\n Consulte o log de erros para mais detalhes.";
									} else {
										$this->view->dados['protocolos'][] =
											"<br/>Registro: " . $protocolo->produto->coRegistroOrigem
											. " - Protocolo: " . $protocolo->protocolo->nuProtocoloEntrada;
									}
								}
							}
						}
					}

					$tbIteLo->salvar($array_itens_lote);

					$array_itens = array(
						"remi_codigo" => $item['remi_codigo'],
						"remi_status" => "E"
					);
					$tbIte->salvar($array_itens);

					$array_itens_lote["remil_vlunit"] = $item['remil_vlunit'];
					$array_itens_lote["remil_custo"] = $item['remil_custo'];
					$this->geraSaidaAction($codMov, $rem_codigo, $array_itens_lote, $protocolo);
				}
			}
			$array_rem = array(
				"rem_codigo" => $rem_codigo,
				"rem_status" => "E"
			);
			$id = $tbRem->salvar($array_rem);

			Zend_Db_Table::getDefaultAdapter()->commit();
			$this->view->dados['msg'] = "Dados cadastrados com sucesso";
			$this->view->dados['id'] = $id;
		} catch (Exception $exc) {
			$this->view->dados['msg'] = $exc->getMessage();
			Zend_Db_Table::getDefaultAdapter()->rollBack();
		}
		return $this->render("dados", NULL, TRUE);
	}

	public function geraSaidaAction($codMov, $codRequisicao, $array_itens, $protocolo = NULL) {

		$tbRem = new Application_Model_RequisicaoMateriais();
		$tbRemi = new Application_Model_RequisicaoMateriaisItens();
		$tbIteMov = new Application_Model_ItensMovimento();
		$pro_codigo = $tbRemi->getItem($array_itens['remi_codigo'])->pro_codigo;


		if (count($array_itens) > 0) {
			try {

				if(isset($protocolo) && isset($this->sync)){
					$this->sync->atualizaProtocolo($protocolo->protocolo->nuProtocoloEntrada, $codMov);
				}
				$dadosIteMov = array(
					"pro_codigo" => $pro_codigo,
					"ite_quantidade" => $array_itens['remil_quantidade'],
					"ite_lote" => $array_itens['remil_lote'],
					"ite_validade" => $array_itens['remil_validade'],
					"ite_vlrunit" => $array_itens['remil_vlunit'],
					"ite_custo_medio" => $array_itens['remil_custo'],
					"ite_vlrtotal" => ($array_itens['remil_vlunit'] * $array_itens['remil_quantidade']),
					"mov_codigo" => $codMov
				);

				$dadosAtuIteReq = array(
					"remi_codigo" => $array_itens->remi_codigo,
					"remi_status" => "F"
				);

				$tbIteMov->salvarItensMovimentacaoRequisicao($dadosIteMov);
				$tbRemi->atualizaStatusItemRequisicao($dadosAtuIteReq);
				// Atualizando status da requisição para concluída
				$dadosAtuRequisicao = array(
					"rem_codigo" => $codRequisicao,
					"rem_status" => "E"
				);
				$tbRem->atualizaStatusRequisicao($dadosAtuRequisicao);

				return true;
			} catch (Exception $exc) {
				throw new Zend_Validate_Exception($exc->getMessage());
				return false;
			}
		} else {
			throw new Zend_Validate_Exception("não encontrou itens");
		}
	}

	public function imprimirAction() {
		//Zend_Layout::getMvcInstance()->setLayout("print");
		$this->_helper->layout->setLayout("modelo-print");
		$tbUsr = new Application_Model_Usuarios();

		$this->view->title = "Requisição Materiais";

		$rem_codigo = $this->_getParam("rem_codigo", FALSE);
		$rem_status = $this->_getParam("rem_status", FALSE);

		$tbRemi = new Application_Model_RequisicaoMateriaisItens();
		$tbRem = new Application_Model_RequisicaoMateriais();
		$this->view->dados_req = $tbRem->getRequisicao($rem_codigo);

		if ($rem_status == "F" || $rem_status == "E") {
			$this->view->itens_lote = 1;
		}

		$this->view->itens = $tbRemi->getItensPorRequisicao($rem_codigo);
		$this->view->dados_gerais = "<b>Setor de Requisição: </b>" . $this->view->dados_req->set_nome_req;
		$this->view->dados_gerais_sec = "<b>Setor de Solicitação: </b>" . $this->view->dados_req->set_nome_sol;
		$this->view->dados_complementares = "<b>Solicitante: </b>" . $this->view->dados_req->usr_nome;
		$this->view->dados_complementares_sec = "<b>Data da Requisição:</b>" . $this->view->dados_req->rem_data;

	}

	public function cancelarItemAction() {
		$remi_codigo = $this->_getParam("remi_codigo", FALSE);
		$pro_codigo = $this->_getParam("pro_codigo", FALSE);

		$tbRemi = new Application_Model_RequisicaoMateriaisItens();
		$array_produto = array("remi_codigo" => $remi_codigo,
			"remi_status" => "N");
		try {
			$tbRemi->cancelarItem($array_produto);
			$this->view->dados = $remi_codigo;
		} catch (Exception $exe) {

		}

		return $this->render("dados", NULL, TRUE);
	}
}



