<?php

require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";
class Materiais_InventarioController extends Zend_Controller_Action {

	public function init() {
		$this->view->title = "Inventário";
	}

	public function indexAction() {
		$codigoUsuario = (new Application_Model_Usuarios())->getUsrAtual()->usr_codigo;
		$codigoUnidade = (new Application_Model_Logon())->getDadosPeloUsuario($codigoUsuario)->uni_codigo;

		$this->view->codigoUsuario = $codigoUsuario;
		$this->view->setores = (new Application_Model_Setor())->getSetorInventario($codigoUnidade);
		$this->view->grupos = (new Application_Model_ProdutoGrupo())->getGrupos();
	}

	public function checkInventarioAction() {
		$data = $this->_getParam("data", FALSE);
		$grupo = $this->_getParam("grupo", FALSE);
		$setor = $this->_getParam("setor", FALSE);

		$this->view->dados = [
			'codigoInventario' => (new Application_Model_Inventario())->getInventarioById($data, $grupo, $setor)->inv_codigo,
		];
		return $this->render("dados", NULL, TRUE);
	}

	public function inventarioItensAction() {
		$this->view->codigoUsuario = $this->_getParam("codigoUsuario", FALSE);
		$this->view->dados = (new Application_Model_Inventario())->getItensInventario();
	}

	public function inventarioDadosAction() {
		$this->_helper->layout->disableLayout();
	}

	public function imprimirInventarioAction(){
        $codigoInventario = $this->_getParam("codigoInventario", NULL);
        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "inventario", [
            "codigo" => $codigoInventario,
        ]);
        $this->render("dados", NULL, TRUE);
    }
}
