<?php

require_once HORUS_PATH . "/SoapHorus.php";
require_once HORUS_PATH . "/sync/SyncController.php";
require_once HORUS_PATH . "/HorusEnum.php";

use Saude\Horus\SoapHorus;
use Saude\Horus\Sync\SyncController;

class Materiais_MovimentacaoController extends Zend_Controller_Action {

	private $horus;
	private $sync;

	public function init() {
		$this->view->title = "Movimentação";
		set_time_limit(100000000000);
		ini_set('memory_limit', '-1');
	}

	public function indexAction() {
		// action body
		$tbUsr = new Application_Model_Usuarios();
		$usr_codigo = $tbUsr->getUsrAtual()->usr_codigo;

		$tbIteAux = new Application_Model_ItensMovimentoAux();
		$results = $tbIteAux->getByUsuarios($usr_codigo);

		$this->view->pendencia = count($results);
	}

	public function cancelarPendenciaAction() {
		$this->_helper->layout->setLayout("vazio");

		$tbMov = new Application_Model_Movimento();
		$tbIteAux = new Application_Model_ItensMovimentoAux();
		Zend_Db_Table::getDefaultAdapter()->beginTransaction();

		$tbUsr = new Application_Model_Usuarios();
		$usr = $tbUsr->getUsrAtual();

		$results = $tbIteAux->getByUsuarios($usr->usr_codigo);
		$mov_codigo = 0;
		try {
			foreach ($results as $row) {
				$mov_codigo = $row['mov_codigo'];
				$row->delete();
			}

			Zend_Db_Table::getDefaultAdapter()->commit();

			Zend_Db_Table::getDefaultAdapter()->beginTransaction();

			$tbMov->getDadosMovimento($mov_codigo)->delete();
			Zend_Db_Table::getDefaultAdapter()->commit();

			$this->view->result = "1";

		} catch (Exception $exc) {
			Zend_Db_Table::getDefaultAdapter()->rollBack();
			$this->view->result = $exc;
		}
		$this->view->result = "1";
	}

	public function processarPendenciaAction() {
		$this->_helper->layout->setLayout("vazio");

		$tbMov = new Application_Model_Movimento();
		$tbIte = new Application_Model_ItensMovimento();
		$tbIteAux = new Application_Model_ItensMovimentoAux();
		$tbPro = new Application_Model_Produto();
		Zend_Db_Table::getDefaultAdapter()->beginTransaction();

		$tbUsr = new Application_Model_Usuarios();
		$usr = $tbUsr->getUsrAtual();

		$results = $tbIteAux->getByUsuarios($usr->usr_codigo);
		try {
			foreach ($results as $row) {
				if (!$tbMov->ValidaData($row['ite_aux_validade']) && $row['ite_aux_validade'] != "") {
					$pro = $tbPro->getProduto($row['pro_codigo']);
					throw new Exception($pro->pro_nome . " com validade inválida!");
				}
				$mov = $tbMov->getDadosMovimento($row['mov_codigo']);
				$array_valores = $tbIte->getValorPorProdutoLote($row['pro_codigo'], $row['ite_aux_lote']);
				$custo_medio = $tbIte->buscaCustoMedio($row['ite_lote'], $row['pro_codigo'], $mov->mov_data);
				if ($custo_medio == "" || $custo_medio == NULL)
					$custo_medio = 0;

				$array_itens = array(
					"pro_codigo"      => $row['pro_codigo'],
					"ite_quantidade"  => $row['ite_aux_quantidade'],
					"ite_lote"        => ($row['ite_aux_lote'] == "" ? "SEM_LOTE" : $row['ite_aux_lote']),
					"ite_codbarras"   => ($row['ite_aux_codbarras'] == "" ? " " : $row['ite_aux_codbarras']),
					"ite_validade"    => ($row['ite_aux_validade'] == "" ? "" : $row['ite_aux_validade']),
					"ite_vlrunit"     => ($row['ite_aux_vlrunit'] == "" ? "0.0" : $row['ite_aux_vlrunit']),
					"mov_codigo"      => $row['mov_codigo'],
					"ite_dose"        => ($row['ite_aux_dose'] == "" ? "" : $row['ite_dose']),
					"ite_vlrtotal"    => ($row['ite_aux_vlrtotal'] == "" ? "0.0" : $row['ite_aux_vlrtotal']),
					"ite_custo_medio" => $custo_medio
				);

				if ($row['fab_codigo'] != "" || $row['fab_codigo'] != NULL) {
					$array_itens['fab_codigo'] = $row['fab_codigo'];
				}

				$ite_codigo = $tbIte->salvar($array_itens);
				$row->delete();
			}
			Zend_Db_Table::getDefaultAdapter()->commit();
			$this->view->result = "1";
		} catch (Exception $exc) {
			$this->view->dados = array("msg" => $exc->getMessage());
			Zend_Db_Table::getDefaultAdapter()->rollBack();
			$this->view->result = $exc;
		}
		$this->view->result = "1";
	}

	public function zeraMovimentacaoAction() {
		$this->view->title = "Remove Estoque de Produtos";
		$tbSet = new Application_Model_Setor();
		$tbUsr = new Application_Model_Usuarios();
		$usr_codigo = $tbUsr->getUsrAtual()->usr_codigo;
		$this->view->setores = $tbSet->buscaSetorPorUsuario($usr_codigo);
	}

	public function trataSetorAction($setor) {
		if ($setor) {
			$setores = "";
			foreach ($setor as $value) {
				$setores .= $value . ",";
			}
			return substr($setores, 0, -1);
		}
	}

	public function zeraMovimentacaoEnviaAction() {
		$this->view->title = "Remove Estoque de Produtos";
		$setores = $this->trataSetorAction($this->_request->getPost("setor"));
		$data = $this->_request->getPost("data");
		// Inicio da transação
		Zend_Db_Table::getDefaultAdapter()->beginTransaction();
		try {
			//Trazendo dados view
			$tbSet = new Application_Model_Setor();
			$tbUsr = new Application_Model_Usuarios();
			$usr_codigo = $tbUsr->getUsrAtual()->usr_codigo;
			$this->view->setores = $tbSet->buscaSetorPorUsuario($usr_codigo);
			// Tabelas Utilizadas
			$tbIteMov = new Application_Model_ItensMovimento();
			$tbMov = new Application_Model_Movimento();
			$tbSal = new Application_Model_Saldo();
			$tbMvb = new Application_Model_MovimentoBkp();
			$tbIteBkp = new Application_Model_ItensMovimentoBkp();
			//Realizando backup dos dados de Movimentação
			$tbMvb->salvarPorSetor($setores, $data);
			// Realizando backups dos Itens de Movimentação
			$tbIteBkp->salvarItensPorSetor($setores, $data);
			// Desabilitando triggers para remoção dos dados
			$this->desabilitaTriggersAction();
			// Deletando os dados da tabela saldo
			$tbSal->excluiSaldoPorSetor($setores);
			// Deletando os dados da tabela de itens_movimento
			$tbIteMov->excluiItensMovimentacoesPorSetor($setores, $data);
			// Deletando os dados da tabela de movimento
			$tbMov->excluiMovimentacaoPorSetor($setores, $data);
			// Ativando as triggers da tabela de itens_movimento
			$this->habilitaTriggersAction();
			// Executa operações realizadas
			Zend_Db_Table::getDefaultAdapter()->commit();
			$this->view->dialog = array("Confirmação", "Dados removido com sucesso!", 300, 140);
		} catch (Exception $exc) {
			$this->view->erro = $exc->getMessage();
			Zend_Db_Table::getDefaultAdapter()->rollBack();
		}
		return $this->render("movimentacao/zera-movimentacao", NULL, TRUE);
	}

	public function desabilitaTriggersAction() {
		$tbIteMov = new Application_Model_ItensMovimento();
		$tbIteMov->desabilitaTrigger01();
		$tbIteMov->desabilitaTrigger02();
		$tbIteMov->desabilitaTrigger03();
		$tbIteMov->desabilitaTrigger04();
	}

	public function habilitaTriggersAction() {
		$tbIteMov = new Application_Model_ItensMovimento();
		$tbIteMov->habilitaTrigger01();
		$tbIteMov->habilitaTrigger02();
		$tbIteMov->habilitaTrigger03();
		$tbIteMov->habilitaTrigger04();
	}

	public function salvarAction() {
		$tbUsr = new Application_Model_Usuarios();
		$usr_codigo = $tbUsr->getUsrAtual()->usr_codigo;

		$movimento = array(
			"mov_tipo"          => $this->_request->getPost("mov_tipo", NULL),
			"mov_entrada"       => $this->_request->getPost("mov_entrada", NULL),
			"mov_saida"         => $this->_request->getPost("mov_saida", NULL),
			"for_codigo"        => ($this->_request->getPost("for_codigo", NULL) == "0" ? "5003" : $this->_request->getPost("for_codigo", NULL)),
			($this->_request->getPost("mov_tipo", NULL) == "E" ? "set_entrada" : "set_saida") => $this->_request->getPost("set_codigo", NULL),
			"mov_observacao"    => $this->_request->getPost("mov_observacao", NULL),
			"mov_data"          => 'NOW()',
			"mov_data_inclusao" => 'NOW()',
			"usr_codigo"        => $usr_codigo,
			"mov_nr_nota"       => ($this->_request->getPost("mov_nr_nota", NULL) == "" ? "" : $this->_request->getPost("mov_nr_nota", NULL))
		);

		if ($this->_request->getPost("mov_tipo", NULL) == "T") {
			$movimento["set_entrada"] = $this->_request->getPost("set_codigo_destino", NULL);
			$movimento["set_saida"] = $this->_request->getPost("set_codigo", NULL);
		}

		$tbMov = new Application_Model_Movimento();

		if ($this->_request->getPost("mov_codigo")) {
			$movimento['mov_codigo'] = $this->_request->getPost("mov_codigo", NULL);
			unset($movimento["mov_data"]);
		}

		try {
			$mov_codigo = $tbMov->salvar($movimento);
			$this->view->dados = array("msg" => "Dados cadastrados com sucesso", "id" => $mov_codigo);
		} catch (Zend_Validate_Exception $exc) {
			$this->view->dados = $exc->getMessage();
		}

		return $this->render("dados", NULL, TRUE);
	}

	public function salvarItensAction() {
		$this->view->dados = array(
			"id" => null,
			"msg" => null,
			"protocolos" => array(),
			"horus" => array()
		);
		$ENTRADA = 0;
		$SAIDA = 1;
		$tbMov = new Application_Model_Movimento();
		$tbIte = new Application_Model_ItensMovimento();
		$tbPro = new Application_Model_Produto();
		$tbFab = new Application_Model_Fabricante();
		$tbFor = new Application_Model_Fornecedor();
		Zend_Db_Table::getDefaultAdapter()->beginTransaction();
		try {
			$itens_request = $this->_request->getPost("itens");

			if (count($itens_request) > 0) {
				$mov = $tbMov->getDadosMovimento($itens_request[0]['mov_codigo']);

				$setor = $tbMov->getSetorMovimento($mov->mov_codigo, ($mov->mov_tipo == "T"));

				if ($mov->mov_tipo == "T") {
					if($setor[$ENTRADA]['set_usa_horus'] === "S" && $setor[$SAIDA]['set_usa_horus'] === "S"){
						$this->horus = new SoapHorus();
						if ($this->horus->isSincrono()) {
							$this->sync = new SyncController();
							$ddHorus = $this->sync->getDados();
						}
					}
				}else if($setor->set_usa_horus == "S"){
					$this->horus = new SoapHorus();
					if ($this->horus->isSincrono()) {
						$this->sync = new SyncController();
						$ddHorus = $this->sync->getDados();
					}
				}

				foreach ($itens_request as $itens) {
					$pro = $tbPro->getProduto($itens['pro_codigo']);

					if (!$tbMov->ValidaData($itens['ite_validade']) && $itens['ite_validade'] != "") {
						throw new Exception($pro->pro_nome . " com validade inválida!");
					}

					if ($mov->mov_tipo == "E" && ($mov->mov_entrada != "E-AE" && $mov->mov_entrada != "E-SI")){
						$custo_medio = $tbIte->calculaCustoMedio($itens['ite_vlrunid'], $itens['ite_quantidade'], $mov->mov_data, $itens['pro_codigo']);
					}else{
						$custo_medio = $tbIte->buscaCustoMedio($itens['ite_lote'], $itens['pro_codigo'], $mov->mov_data);
					}

					if ($custo_medio == "" || $custo_medio == NULL)
						$custo_medio = 0;

					$array_itens = array(
						"pro_codigo"      => $itens['pro_codigo'],
						"ite_quantidade"  => $itens['ite_quantidade'],
						"ite_lote"        => ($itens['ite_lote'] == "" ? "SEM_LOTE" : $itens['ite_lote']),
						"ite_codbarras"   => ($itens['ite_codbarras'] == "" ? "" : $itens['ite_codbarras']),
						"ite_validade"    => ($itens['ite_validade'] == "" ? "" : $itens['ite_validade']),
						"ite_vlrunit"     => ($itens['ite_vlrunid'] == "" ? "0.0" : $itens['ite_vlrunid']),
						"mov_codigo"      => $itens['mov_codigo'],
						"ite_dose"        => ($itens['ite_doses'] == "" ? "" : $itens['ite_doses']),
						"ite_vlrtotal"    => ($itens['ite_vlrtotal'] == "" || isset($itens['ite_vlrtotal']) ? "0.0" : $itens['ite_vlrtotal']),
						"ite_custo_medio" => $custo_medio,
						"fab_codigo" => $itens['fab_codigo'],
						"qntd_anterior" => ($itens['qntd_anterior'] == 'undefined' ? NULL : $itens['qntd_anterior'])
					);

					if ($itens['ite_codigo'] != "") {
						$array_itens['ite_codigo'] = $itens['ite_codigo']; // se for editar
					}

					if($mov->mov_tipo == "T"){
						$usa_horus = ($setor[$ENTRADA]['set_usa_horus'] === "S" && $setor[$SAIDA]['set_usa_horus'] === "S");
					}else {
						$usa_horus = ($setor->set_usa_horus === "S");
					}
					if ($usa_horus) {
						$noFabricanteInternacional = "FABRICANTE";
						$nuCNPJFabricante = null;
						if ($itens['fab_codigo'] != "" || $itens['fab_codigo'] != NULL) {
							$array_itens['fab_codigo'] = $itens['fab_codigo'];
							$fabricante = $tbFab->getFabricante($itens['fab_codigo']);
							if ($fabricante && !empty($fabricante->fab_cnpj) && $fabricante->fab_internacional == FALSE) {
								$nuCNPJFabricante = str_replace(['-', '.', '/'], "", $fabricante->fab_cnpj);
								$noFabricanteInternacional = NULL;
							}
						}

						if($this->sync->getCadastroHorus()) {
							if ($mov->mov_tipo == "T") {
								if (!empty($pro->pro_horus) && !empty($pro->pro_horus_tipo)) {
									if ($this->sync != null) {
										//Saida do setor de origem
										if (empty($setor[$SAIDA]['set_tipo_estab'])) {
											$this->view->dados['msg'] = "Tipo estabelecimento Horus não cadastrado no setor de origem " . $setor[$SAIDA]['set_nome'];
											return $this->render("dados", NULL, TRUE);
										}

										if (empty($setor[$SAIDA]['uni_cnes'])) {
											$this->view->dados['msg'] = "CNES da unidade do setor de origem " . $setor[$SAIDA]['set_nome'] . " não cadastrado.";
											return $this->render("dados", NULL, TRUE);
										}

										//Entrada do setor de destino
										if (empty($setor[$ENTRADA]['set_tipo_estab'])) {
											$this->view->dados['msg'] = "Tipo estabelecimento Horus não cadastrado no setor de destino " . $setor[$ENTRADA]['set_nome'];
											return $this->render("dados", NULL, TRUE);
										}

										if (empty($setor[$ENTRADA]['uni_cnes'])) {
											$this->view->dados['msg'] = "CNES da unidade do setor de entrada " . $setor[$ENTRADA]['set_nome'] . " não cadastrado.";
											return $this->render("dados", NULL, TRUE);
										}

										$nuProduto = $pro->pro_horus_tipo . $pro->pro_horus;
										if(strpos($array_itens['ite_validade'], "/") != false){
											$dt = explode("/", $array_itens['ite_validade']);
											$array_itens['ite_validade'] = $dt[2]."-".$dt[1]."-".$dt[0];
										}
										$dtValidade = new DateTime($array_itens['ite_validade']);
										$dtRegistro = new DateTime();

										$protocolo_saida = $this->sync->informarSaidaMedicamento(
											$ddHorus['idOrigem'],
											$ddHorus['coIBGE'],
											$ddHorus['coCNES'],
											$setor[$SAIDA]['set_tipo_estab'],
											$pro->pro_codigo,
											$nuProduto,
											$array_itens['ite_lote'],
											$dtValidade->format('d-m-Y'),
											intval($array_itens['ite_quantidade']),
											$dtRegistro->format('d-m-Y'),
											null,
											$nuCNPJFabricante,
											$noFabricanteInternacional,
											\Saude\Horus\TP_SAIDA::TRANSFERENCIA_REMANEJAMENTO,
											\Saude\Horus\TP_IDENTIFICACAO::CNES,
											$setor[$SAIDA]['uni_cnes'],
											'TRANSFERENCIA'
										);
										if ($protocolo_saida instanceof \SoapFault) {
											$this->view->dados['horus'][] = "\nErro Horus: " . $protocolo_saida->getMessage() . "\n Consulte o log de erros para mais detalhes.";
										} else {
											$this->view->dados['protocolos'][] =
											"<br/>Registro Saída: " . $protocolo_saida->produto->coRegistroOrigem
											. " - Protocolo Saída: " . $protocolo_saida->protocolo->nuProtocoloEntrada;
											$array_itens['protocolo_horus'] = $protocolo_saida->protocolo->nuProtocoloEntrada;
											$this->sync->atualizaProtocolo($protocolo_saida->protocolo->nuProtocoloEntrada, $mov->mov_codigo);

											//Somente informa a entrada caso a saída existir
											$fornecedor = $tbFor->getFornecedorPorProdutoELote($pro->pro_codigo, $array_itens['ite_lote']);

											$protocolo_entrada = $this->sync->informarEntradaMedicamento(
												$ddHorus['idOrigem'],
												$ddHorus['coIBGE'],
												$ddHorus['coCNES'],
												$setor[$ENTRADA]['set_tipo_estab'],
												$array_itens['pro_codigo'],
												$pro->pro_horus_tipo . $pro->pro_horus,
												$array_itens['ite_lote'],
												$dtValidade->format('d-m-Y'),
												intval($array_itens['ite_quantidade']),
												$dtRegistro->format('d-m-Y'),
												null,
												$nuCNPJFabricante,
												$noFabricanteInternacional, //obrigatorio quando cnpjFab é null
												$mov->mov_nr_nota,
												$array_itens['ite_vlrunit'],
												$fornecedor->for_cnpj,
												\Saude\Horus\TP_ENTRADA::TRANSFERENCIA_REMANEJAMENTO,
												'TRANSFERENCIA'
											);

											if ($protocolo_entrada instanceof \SoapFault) {
												$this->view->dados['horus'][] = "\nErro Horus: " . $protocolo_entrada->getMessage() . "\n Consulte o log de erros para mais detalhes.";
												$this->sync->excluirRegistros($protocolo_saida->protocolo->nuProtocoloEntrada, date('d-m-Y H:i:s'));
												$this->view->dados['protocolos'] = array();
											} else {
												$this->view->dados['protocolos'][] =
												"<br/>Registro Entrada: " . $protocolo_entrada->produto->coRegistroOrigem
												. " - Protocolo Entrada: " . $protocolo_entrada->protocolo->nuProtocoloEntrada;
												$array_itens['protocolo_horus'] = $protocolo_entrada->protocolo->nuProtocoloEntrada;
												$this->sync->atualizaProtocolo($protocolo_entrada->protocolo->nuProtocoloEntrada, $mov->mov_codigo);
											}
										}
									}
								} else {
									$this->view->dados['horus'][] = "<br/>$pro->pro_nome não possue CATMAT";
								}

							} else if($mov->mov_tipo == "S") {
								if (!empty($pro->pro_horus) && !empty($pro->pro_horus_tipo)) {
									if ($this->sync != null) {
										if (empty($setor->set_tipo_estab)) {
											$this->view->dados['msg'] = "Tipo estabelecimento Horus não cadastrado no setor $setor->set_nome";
											return $this->render("dados", NULL, TRUE);
										}

										if (empty($setor->uni_cnes)) {
											$this->view->dados['msg'] = "CNES da unidade do setor $setor->set_nome não cadastrado.";
											return $this->render("dados", NULL, TRUE);
										}

										$nuProduto = $pro->pro_horus_tipo . $pro->pro_horus;
										if(strpos($array_itens['ite_validade'], "/") != false){
											$dt = explode("/", $array_itens['ite_validade']);
											$array_itens['ite_validade'] = $dt[2]."-".$dt[1]."-".$dt[0];
										}
										$dtValidade = new DateTime($array_itens['ite_validade']);
										$dtRegistro = new DateTime();

										if ($itens['ite_codigo'] != "") {
											$protocolo_item = $tbIte->getProtocoloHorus($itens['ite_codigo']);
											if($protocolo_item){
												$cod_registro = $tbIte->getCodigoRegistroProtocoloHorus($protocolo_item);
												$protocolo = $this->sync->retificarSaidaMedicamento(
													$ddHorus['idOrigem'],
													$ddHorus['coIBGE'],
													$protocolo_item,
													$ddHorus['coCNES'],
													$setor->set_tipo_estab,
													$nuProduto,
													$array_itens['ite_lote'],
													$dtValidade->format('d-m-Y'),
													intval($array_itens['ite_quantidade']),
													$dtRegistro->format('d-m-Y'),
													NULL,
													$nuCNPJFabricante,
													$noFabricanteInternacional,
													trim($mov->mov_saida),
													$cod_registro,
													\Saude\Horus\TP_IDENTIFICACAO::CNES,
													$setor->uni_cnes
												);
											}
										}else{
											$protocolo = $this->sync->informarSaidaMedicamento(
												$ddHorus['idOrigem'],
												$ddHorus['coIBGE'],
												$ddHorus['coCNES'],
												$setor->set_tipo_estab,
												$pro->pro_codigo,
												$nuProduto,
												$array_itens['ite_lote'],
												$dtValidade->format('d-m-Y'),
												intval($array_itens['ite_quantidade']),
												$dtRegistro->format('d-m-Y'),
												null,
												$nuCNPJFabricante,
												$noFabricanteInternacional,
												trim($mov->mov_saida),
												\Saude\Horus\TP_IDENTIFICACAO::CNES,
												$setor->uni_cnes
											);
										}

										if ($protocolo instanceof \SoapFault) {
											$this->view->dados['horus'][] = "\nErro Horus: " . $protocolo->getMessage() . "\n Consulte o log de erros para mais detalhes.";
										} else {
											$this->view->dados['protocolos'][] =
											"<br/>Registro: " . $protocolo->produto->coRegistroOrigem
											. " - Protocolo: " . $protocolo->protocolo->nuProtocoloEntrada;
											$array_itens['protocolo_horus'] = $protocolo->protocolo->nuProtocoloEntrada;
											$this->sync->atualizaProtocolo($protocolo->protocolo->nuProtocoloEntrada, $mov->mov_codigo);
										}
									}
								} else {
									$this->view->dados['horus'][] = "<br/>$pro->pro_nome não possue CATMAT";
								}
							}else{
								if (!empty($pro->pro_horus) && !empty($pro->pro_horus_tipo)) {
									if ($this->sync != null) {

										if (empty($setor->set_tipo_estab)) {
											$this->view->dados['msg'] = "Tipo estabelecimento Horus não cadastrado no setor $setor->set_nome";
											return $this->render("dados", NULL, TRUE);
										}

										if (empty($setor->uni_cnes)) {
											$this->view->dados['msg'] = "CNES da unidade do setor $setor->set_nome não cadastrado.";
											return $this->render("dados", NULL, TRUE);
										}

										$produto = $tbPro->getProduto($array_itens['pro_codigo']);
										$nuProduto = $produto->pro_horus_tipo . $produto->pro_horus;
										if(strpos($array_itens['ite_validade'], "/") != false){
											$dt = explode("/", $array_itens['ite_validade']);
											$array_itens['ite_validade'] = $dt[2]."-".$dt[1]."-".$dt[0];
										}
										$dtValidade = new DateTime($array_itens['ite_validade']);
										$dtRegistro = new DateTime();

										$fornecedor = $tbFor->getFornecedorPorProdutoELote($pro->pro_codigo, $array_itens['ite_lote']);

										$protocolo_item = $tbIte->getProtocoloHorus($itens['ite_codigo']);

										if($protocolo_item){
											$coRegistro = $tbIte->getCodigoRegistroProtocoloHorus($protocolo_item);
											$protocolo = $this->sync->retificarEntradaMedicamento(
												$ddHorus['idOrigem'],
												$ddHorus['coIBGE'],
												$protocolo_item,
												$ddHorus['coCNES'],
												$setor->set_tipo_estab,
												$produto->pro_codigo,
												$nuProduto,
												$array_itens['ite_lote'],
												$dtValidade->format('d-m-Y'),
												intval($array_itens['ite_quantidade']),
												$dtRegistro->format('d-m-Y'),
												null,
												$nuCNPJFabricante,
												$noFabricanteInternacional,
												$mov->mov_nr_nota,
												$array_itens['ite_vlrunit'],
												$fornecedor->for_cnpj,
												$mov->mov_entrada,
												$coRegistro
											);
										}

										if ($protocolo instanceof \SoapFault) {
											$this->view->dados['horus'][] = "\nErro Horus: " . $protocolo->getMessage() . "\n Consulte o log de erros para mais detalhes.";
										} else {
											$this->view->dados['protocolos'][] =
											"<br/>Registro: " . $protocolo->produto->coRegistroOrigem
											. " - Protocolo: " . $protocolo->protocolo->nuProtocoloEntrada;
											$array_itens['protocolo_horus'] = $protocolo->protocolo->nuProtocoloEntrada;
											$this->sync->atualizaProtocolo($protocolo->protocolo->nuProtocoloEntrada, $mov->mov_codigo);
										}
									}
								}
							}
						}
					}
					$ite_codigo = $tbIte->salvar($array_itens);
				}
			}
			if (count($this->_request->getPost("itens_deletar_banco"))) {
				foreach ($this->_request->getPost("itens_deletar_banco") as $itens_remover) {
					$protocolo = $tbIte->getProtocoloHorus($itens_remover);
					if($protocolo){
						$protocolo = $this->sync->excluirRegistros($protocolo, date('d-m-Y H:i:s'));
						if ($protocolo instanceof \SoapFault) {
							$this->view->dados['horus'][] = "\nErro Cancelamento Horus: " . $protocolo->getMessage() . "\n Consulte o log de erros para mais detalhes.";
						} else {
							$this->view->dados['protocolos'][] = "<br/>Protocolo Cancelamento: " . $protocolo->protocolo->nuProtocoloEntrada;
						}
					}
					$ite_codigo_removido = $itens_remover;
					$tbIte->deletar($itens_remover);
				}
			}

			if($ite_codigo){
				$this->view->dados['id']  = $ite_codigo;
			}else if($ite_codigo_removido){
				$this->view->dados['id']  = $ite_codigo_removido;
			}
			$this->view->dados['msg'] = "Dados cadastrados com sucesso";

			Zend_Db_Table::getDefaultAdapter()->commit();
		} catch (Exception $exc) {
			$this->view->dados['msg'] = $exc->getMessage();
			Zend_Db_Table::getDefaultAdapter()->rollBack();
		}
		return $this->render("dados", NULL, TRUE);
	}

	public function verificaSeMovimentouAction() {
		$ite_codigo = $this->_getParam("ite_codigo", FALSE);
		$ite_lote = $this->_getParam("ite_lote", FALSE);
		$tbIte = new Application_Model_ItensMovimento();
		$this->view->dados = $tbIte->verificaSeMovimentou($ite_lote, $ite_codigo)->movs;
		return $this->render("dados", NULL, TRUE);
	}

	public function imprimeEntradasAction() {
		$this->_helper->layout->setLayout("simples");
		$this->view->headLink()->setStylesheet($this->view->baseUrl() .
		'/public/css/materiais/movimentacao-impressoes.css', 'all');
		$mov_codigo = $this->_request->getParam("mov_codigo", NULL);
		$tbIteMov = new Application_Model_ItensMovimento();
		$tbSec = new Application_Model_Secretaria();
		$tbConf = new Application_Model_Configuracao();
		$tbUsr = new Application_Model_Usuarios();
		$this->view->usr = $tbUsr->getUsrAtual();
		$this->view->secretaria = $tbSec->getDadosSec();
		$this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
		$this->view->dados = $this->dadosCabecalhoComprovante($mov_codigo, "E");
		$this->view->itens = $tbIteMov->getProdutosPorMovimento($mov_codigo);
	}

	public function imprimeSaidasAction() {
		$this->_helper->layout->setLayout("simples");
		$this->view->headLink()->setStylesheet($this->view->baseUrl() .
		'/public/css/materiais/movimentacao-impressoes.css', 'all');
		$mov_codigo = $this->_request->getParam("mov_codigo", NULL);
		$tbIteMov = new Application_Model_ItensMovimento();
		$tbSec = new Application_Model_Secretaria();
		$tbConf = new Application_Model_Configuracao();
		$tbUsr = new Application_Model_Usuarios();
		$this->view->usr = $tbUsr->getUsrAtual();
		$this->view->secretaria = $tbSec->getDadosSec();
		$this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
		$this->view->dados = $this->dadosCabecalhoComprovante($mov_codigo, "S");
		$this->view->itens = $tbIteMov->getProdutosPorMovimento($mov_codigo);
	}

	public function imprimeTransferenciasAction() {
		$this->_helper->layout->setLayout("simples");
		$this->view->headLink()->setStylesheet($this->view->baseUrl() .
		'/public/css/materiais/movimentacao-impressoes.css', 'all');
		$mov_codigo = $this->_request->getParam("mov_codigo", NULL);
		$tbIteMov = new Application_Model_ItensMovimento();
		$tbSec = new Application_Model_Secretaria();
		$tbConf = new Application_Model_Configuracao();
		$tbUsr = new Application_Model_Usuarios();
		$this->view->usr = $tbUsr->getUsrAtual();
		$this->view->secretaria = $tbSec->getDadosSec();
		$this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
		$this->view->dados = $this->dadosCabecalhoComprovante($mov_codigo, "T");
		$this->view->itens = $tbIteMov->getProdutosPorMovimento($mov_codigo);
	}

	public function dadosCabecalhoComprovante($mov_codigo, $mov_tipo) {
		$tbMov = new Application_Model_Movimento();
		$dados_mov = $tbMov->getDadosMovimento($mov_codigo);
		$this->view->dados_mov_tipo = $mov_tipo;
		$this->view->dados_mov = $dados_mov->mov_codigo;
		$this->view->dados_mov_data = $dados_mov->mov_data;
		$this->view->dados_mov_nota = ($dados_mov->mov_nr_nota == "" ? "-" : $dados_mov->mov_nr_nota);
		$this->view->dados_mov_forn = ($dados_mov->for_nome == "" ? "-" : $dados_mov->for_nome);
		// Validações Centro Estocadores
		if ($mov_tipo == "E") {
			//die($dados_mov->setor_entrada);
			$this->view->tipo_impressao = "COMPROVANTE DE ENTRADA";
			$this->view->dados_mov_centroo = $dados_mov->setor_entrada;
		}
		if ($mov_tipo == "S") {
			$this->view->tipo_impressao = "COMPROVANTE DE SAÍDA";
			$this->view->dados_mov_centroo = $dados_mov->setor_saida;
		}
		if ($mov_tipo == "T") {
			$this->view->tipo_impressao = "COMPROVANTE DE TRANSFERÊNCIA";
			$this->view->dados_mov_centroo = $dados_mov->setor_saida;
			$this->view->dados_mov_centros = ($dados_mov->setor_entrada != "" ?
			$dados_mov->setor_entrada : "-");
		}
		$this->view->mov_observacao = $dados_mov->mov_observacao;
	}

	public function finalizarEntradaAction() {
		$this->view->dados = array(
			"id" => null,
			"msg" => null,
			"protocolos" => array(),
			"horus" => array()
		);

		$num_nota = $this->_request->getPost("nota_fiscal", NULL);

		$tbMov = new Application_Model_Movimento();
		$tbFor = new Application_Model_Fornecedor();
		$tbFab = new Application_Model_Fabricante();
		$tbIte = new Application_Model_ItensMovimento();
		$tbIteAux = new Application_Model_ItensMovimentoAux();
		$tbPro = new Application_Model_Produto();
		Zend_Db_Table::getDefaultAdapter()->beginTransaction();

		$tbUsr = new Application_Model_Usuarios();
		$usr = $tbUsr->getUsrAtual();
		$results = $tbIteAux->getByUsuarios($usr->usr_codigo);
		try {
			if(count($results) > 0){
				$setor = $tbMov->getSetorMovimento($results[0]['mov_codigo']);

				if($setor->set_usa_horus === "S"){
					$this->horus = new SoapHorus();
					if ($this->horus->isSincrono()) {
						$this->sync = new SyncController();
						$ddHorus = $this->sync->getDados();
					}
				}

				foreach ($results as $row) {
					$pro = $tbPro->getProduto($row['pro_codigo']);
					$mov = $tbMov->getDadosMovimento($row['mov_codigo']);
					if (!$tbMov->ValidaData($row['ite_aux_validade']) && $row['ite_aux_validade'] != "") {
						throw new Exception($pro->pro_nome . " com validade inválida!");
					}

					if($mov->mov_entrada != "E-AE" && $mov->mov_entrada != "E-SI"){
						$custo_medio = $tbIte->calculaCustoMedio($row['ite_aux_vlrunit'], $row['ite_aux_quantidade'], $mov->mov_data, $row['pro_codigo']);
					}
					if ($custo_medio == "" || $custo_medio == NULL)
						$custo_medio = 0;

					$array_itens = array(
						"pro_codigo"      => $row['pro_codigo'],
						"ite_quantidade"  => $row['ite_aux_quantidade'],
						"ite_lote"        => ($row['ite_aux_lote'] == "" ? "SEM_LOTE" : $row['ite_aux_lote']),
						"ite_codbarras"   => ($row['ite_aux_codbarras'] == "" ? " " : $row['ite_aux_codbarras']),
						"ite_validade"    => ($row['ite_aux_validade'] == "" ? "" : $row['ite_aux_validade']),
						"ite_vlrunit"     => ($row['ite_aux_vlrunit'] == "" ? "0.0" : $row['ite_aux_vlrunit']),
						"mov_codigo"      => $row['mov_codigo'],
						"ite_dose"        => ($row['ite_aux_dose'] == "" ? "" : $row['ite_aux_dose']),
						"ite_vlrtotal"    => ($row['ite_aux_vlrtotal'] == "" ? "0.0" : $row['ite_aux_vlrtotal']),
						"ite_custo_medio" => $custo_medio,
						"fab_codigo"      => $row['fab_codigo']
					);

					if($setor->set_usa_horus === "S"){
						$cnpjFab = null;
						$fabInter = "FORNECEDOR";
						if ($array_itens['fab_codigo'] != "" || $array_itens['fab_codigo'] != NULL) {
							$fabricante = $tbFab->getFabricante($array_itens['fab_codigo']);
							if ($fabricante && !empty($fabricante->fab_cnpj) && $fabricante->fab_internacional == FALSE) {
								$cnpjFab = str_replace(['-', '.', '/'], "", $fabricante->fab_cnpj);
								$fabInter = null;
							}
						}

						$fornecedor = $tbFor->getFornecedorPorCodigo($mov->for_codigo);
						if($this->sync->getCadastroHorus()) {
							if (!empty($pro->pro_horus) && !empty($pro->pro_horus_tipo) && (strlen(trim($mov->mov_entrada)) > 1)) {
								if ($this->sync != null) {
									if (empty($setor->set_tipo_estab)) {
										$this->view->dados['msg'] = "Tipo estabelecimento Horus não cadastrado no setor $setor->set_nome";
										return $this->render("dados", NULL, TRUE);
									}
									if (empty($mov->mov_nr_nota) && empty($num_nota)) {
										$this->view->dados['msg'] = "É obrigatório informar a N.F. quando o Hórus estiver habilitado.";
										return $this->render("dados", NULL, TRUE);
									}else if(empty($mov->mov_nr_nota) && !empty($num_nota)){
										$tbMov->atualizaNotaMovimento($mov->mov_codigo, $num_nota);
									}

									$dtValidade = new DateTime($row['ite_aux_validade']);
									$dtRegistro = new DateTime();
									$protocolo = $this->sync->informarEntradaMedicamento(
										$ddHorus['idOrigem'],
										$ddHorus['coIBGE'],
										$ddHorus['coCNES'],
										$setor->set_tipo_estab,
										$array_itens['pro_codigo'],
										$pro->pro_horus_tipo . $pro->pro_horus,
										$array_itens['ite_lote'],
										$dtValidade->format('d-m-Y'),
										intval($array_itens['ite_quantidade']),
										$dtRegistro->format('d-m-Y'),
										null,
										$cnpjFab,
										$fabInter, //obrigatorio quando cnpjFab é null
										$mov->mov_nr_nota,
										$array_itens['ite_vlrunit'],
										$fornecedor['for_cnpj'],
										trim($mov->mov_entrada)
									);
									if ($protocolo instanceof \SoapFault) {
										$this->view->dados['horus'][] = "\nErro Horus: " . $protocolo->getMessage() . "\n Consulte o log de erros para mais detalhes.";
									} else {
										$this->view->dados['protocolos'][] =
										"<br/>Registro: " . $protocolo->produto->coRegistroOrigem
										. " - Protocolo: " . $protocolo->protocolo->nuProtocoloEntrada;
										$array_itens['protocolo_horus'] = $protocolo->protocolo->nuProtocoloEntrada;
										$this->sync->atualizaProtocolo($protocolo->protocolo->nuProtocoloEntrada, $row['mov_codigo']);
									}
								}
							} else {
								$this->view->dados['horus'][] = "<br/>$pro->pro_nome não possue CATMAT";
							}
						}
					}
					$ite_codigo = $tbIte->salvar($array_itens);
					$row->delete();
				}
			}

			$this->view->dados["msg"] = "Dados cadastrados com sucesso";
			$this->view->dados["id"] = $ite_codigo;
			Zend_Db_Table::getDefaultAdapter()->commit();
		} catch (Exception $exc) {
			$this->view->dados['msg'] = $exc->getMessage();
			Zend_Db_Table::getDefaultAdapter()->rollBack();
		}
		return $this->render("dados", NULL, TRUE);
	}

	public function verificaSetorInventarioAction() {
		$set_codigo = $this->_getParam("set_codigo", FALSE);
		$tbSet = new Application_Model_Setor();
		$this->view->dados = $tbSet->verificaInventarioSetor($set_codigo)->toArray();
		return $this->render("dados", NULL, TRUE);;
	}

	public function getValoresItemAction(){
		$lote = $this->_getParam("lote", FALSE);
		if(!$lote){
			$lote = $this->_request->getPost("lote", FALSE);
		}
		$produto = $this->_getParam("produto", FALSE);
		if(!$produto){
			$produto = $this->_request->getPost("produto", FALSE);
		}
		$data_movimento = date('Y-m-d');
		$tbItem = new Application_Model_ItensMovimento();
		$this->view->dados = $tbItem->buscaCustoMedioEValorUnitario($lote, $produto, $data_movimento);

		return $this->render("dados", NULL, TRUE);
	}

}
