<?php

require_once HORUS_PATH . "/SoapHorus.php";
require_once HORUS_PATH . "/sync/SyncController.php";
require_once HORUS_PATH . "/HorusEnum.php";

use Saude\Horus;
use Saude\Horus\SoapHorus;
use Saude\Horus\Sync\SyncController;

class Materiais_RequisicaoMateriaisController extends Zend_Controller_Action {

	private $horus;
	private $sync;

	public function init() {
		$this->view->title = "Requisição de Materiais";
	}

	public function indexAction() {
		$tbReq = new Application_Model_RequisicaoMateriais();
		$this->view->itens = $tbReq->getRequisicoes(15)->toArray();
	}

	public function confirmAction() {
		$tbSet = new Application_Model_Setor();
		$tbUsr = new Application_Model_Usuarios();
		$this->view->usr_nome = $tbUsr->getUsrAtual()->usr_nome;

		$rem_codigo = $this->_getParam("id", FALSE);
		if ($rem_codigo) {
			$tbRem = new Application_Model_RequisicaoMateriais();
			$requisicao = $tbRem->getRequisicao($rem_codigo)->toArray();
			$this->view->itens = $requisicao;
			$tbRemi = new Application_Model_RequisicaoMateriaisItens();
			$itens_requisicao = $tbRemi->getProdutosRequisicao($rem_codigo)->toArray();
			$this->view->itens_requisicao = $itens_requisicao;
		}

		$this->view->setor_origem = $tbSet->selectTag(TRUE, "set_codigo_req", $requisicao['set_codigo_req']);
		$this->view->setores = $tbSet->selectTag(FALSE, "set_codigo_sol", $requisicao['set_codigo_sol']);
	}

	public function listaLotesPorRequisicaoAction() {
		$codRequisicaoItens = $this->_request->getPost("codRequisicaoItens");
		$tbRemil = new Application_Model_RequisicaoMateriaisItensLote();
		$this->view->dados = $tbRemil->listaLotesPorRequisicao($codRequisicaoItens)->toArray();
		$this->render("dados", NULL, TRUE);
	}

	public function atualizaStatusItemRequisicaoAction() {
		$tbRemi = new Application_Model_RequisicaoMateriaisItens();
		$codRequisicaoItens = $this->_request->getPost("codRequisicaoItens");
		$statusAtualReq = $tbRemi->getStatusItemRequisicao($codRequisicaoItens)->remi_status;
		if ($statusAtualReq == "E") {
			$statusReq = "C";
		} else {
			$statusReq = "E";
		}
		$dados = array(
			"remi_codigo" => $codRequisicaoItens,
			"remi_status" => $statusReq
		);
		$tbRemi->atualizaStatusItemRequisicao($dados);
		$this->view->dados = $statusReq;
		$this->render("dados", NULL, TRUE);
	}

	public function confirmaRequisicaoAction() {
	    $this->view->dados = array(
		    "id" => null,
		    "msg" => null,
		    "protocolos" => array(),
		    "horus" => array()
	    );

		$tbRem = new Application_Model_RequisicaoMateriais();
		$tbRemi = new Application_Model_RequisicaoMateriaisItens();
		$tbMov = new Application_Model_Movimento();
		$tbIteMov = new Application_Model_ItensMovimento();
		$tbPro = new Application_Model_Produto();
		$tbFab = new Application_Model_Fabricante();
		$tbFor = new Application_Model_Fornecedor();


		$codRequisicao = $this->_getParam("id", FALSE);
		$dadosRequisicao = $tbRem->getRequisicao($codRequisicao);
		$dadosIteRequisicao = $tbRem->getDadosRequisicao($codRequisicao);

		if (count($dadosIteRequisicao) > 0) {
			$dadosMov = array(
				"mov_tipo" => "E",
				"mov_entrada" => "E-T",
				"req_codigo" => $codRequisicao,
				"set_entrada" => $dadosRequisicao->set_codigo_req,
//                "set_saida" => $dadosRequisicao->set_codigo_sol,
				"mov_observacao" => $dadosRequisicao->rem_observacao,
				"mov_data" => 'NOW()',
				"mov_data_inclusao" => 'NOW()',
				"usr_codigo" => $dadosRequisicao->usr_codigo
			);

			$tbSet = new Application_Model_Setor();
			$set_req = $tbSet->getSetorPorCodigo($dadosRequisicao->set_codigo_req);


			Zend_Db_Table::getDefaultAdapter()->beginTransaction();
			try {
				$codMov = $tbMov->salvarMovimentacaoRequisicao($dadosMov);

				if($set_req->set_usa_horus === "S"){
					$this->horus = new SoapHorus();
					if ($this->horus->isSincrono()) {
						$this->sync = new SyncController();
						$ddHorus = $this->sync->getDados();
					}
				}

				foreach ($dadosIteRequisicao as $iteMov) {
					$pro = $tbPro->getProduto($iteMov->pro_codigo);
	                $itemMovHorus = $tbIteMov->getDadosProdutoHorus($iteMov->pro_codigo, $iteMov->remil_lote);
	                $dadosMovHorus = $tbMov->getDadosMovimentoHorus($iteMov->pro_codigo, $iteMov->remil_lote);

					if($set_req->set_usa_horus === "S"){
						$noFabricanteInternacional = "FABRICANTE";
						$nuCNPJFabricante = null;
						if ($dadosMovHorus && isset($dadosMovHorus->fab_codigo)) {
							$array_itens['fab_codigo'] = $dadosMovHorus->fab_codigo;
							if (!empty($dadosMovHorus->fab_cnpj)) {
								$nuCNPJFabricante = str_replace(['-', '.', '/'], "", $dadosMovHorus->fab_cnpj);
								$noFabricanteInternacional = NULL;
							}
						}

						if($this->sync->getCadastroHorus()) {
							if (!empty($pro->pro_horus) && !empty($pro->pro_horus_tipo)) {
								if ($this->sync != null) {

									if (empty($set_req->set_tipo_estab)) {
										$this->view->dados['msg'] = "Tipo estabelecimento Horus não cadastrado no setor $set_req->set_nome";
										return $this->render("dados", NULL, TRUE);
									}

									if (empty($set_req->uni_cnes)) {
										$this->view->dados['msg'] = "CNES da unidade do setor $set_req->set_nome não cadastrado.";
										return $this->render("dados", NULL, TRUE);
									}

									if (empty($dadosMovHorus->for_cnpj)) {
										$this->view->dados['msg'] = "CNPJ do fornecedor não informado!";
										return $this->render("dados", NULL, TRUE);
									}

									$nuProduto = $pro->pro_horus_tipo . $pro->pro_horus;
									$dtValidade = new DateTime($iteMov->sal_validade);
									$dtRegistro = new DateTime();

									$protocolo = $this->sync->informarEntradaMedicamento(
										$ddHorus['idOrigem'],
										$ddHorus['coIBGE'],
										$ddHorus['coCNES'],
										$set_req->set_tipo_estab,
										$pro->pro_codigo,
										$nuProduto,
										$itemMovHorus->ite_lote,
										$dtValidade->format('d-m-Y'),
										intval($iteMov->remil_quantidade),
										$dtRegistro->format('d-m-Y'),
										null,
										$nuCNPJFabricante,
										$noFabricanteInternacional, //obrigatorio quando cnpjFab é null
										$dadosMovHorus->mov_nr_nota,
										$itemMovHorus->ite_vlrunit, //Falta adicionar valor unitário (Verificar Horus)
										str_replace(['-', '.', '/'], "", $dadosMovHorus->for_cnpj), //Falta adicionar cnpj fornecedor (Verificar Horus)
										Horus\TP_ENTRADA::TRANSFERENCIA_REMANEJAMENTO
									);

									if ($protocolo instanceof \SoapFault) {
										$this->view->dados['horus'][] = "\nErro Horus: " . $protocolo->getMessage() . "\n Consulte o log de erros para mais detalhes.";
									} else {
										$this->view->dados['protocolos'][] =
											"<br/>Registro: " . $protocolo->produto->coRegistroOrigem
											. " - Protocolo: " . $protocolo->protocolo->nuProtocoloEntrada;
										$this->sync->atualizaProtocolo($protocolo->protocolo->nuProtocoloEntrada, $dadosMovHorus->mov_codigo);
									}
								}
							} else {
								$this->view->dados['horus'][] = "<br/>$pro->pro_nome não possue CATMAT";
							}
						}
					}

					$dadosIteMov = array(
						"pro_codigo" => $iteMov->pro_codigo,
						"ite_quantidade" => $iteMov->remil_quantidade,
						"ite_lote" => $iteMov->remil_lote,
						"ite_validade" => $iteMov->sal_validade,
						"mov_codigo" => $codMov,
						"ite_dose" => $iteMov->sal_dose_lote,
						"ite_vlrunit" => $iteMov->ite_vlrunit,
						"ite_vlrtotal" => ($iteMov->ite_vlrunit * $iteMov->remil_quantidade) ,
						"ite_custo_medio" => $iteMov->ite_custo_medio
					);
					$dadosAtuIteReq = array(
						"remi_codigo" => $iteMov->remi_codigo,
						"remi_status" => "F"
					);
					$tbIteMov->salvarItensMovimentacaoRequisicao($dadosIteMov);
					$tbRemi->atualizaStatusItemRequisicao($dadosAtuIteReq);
				}
				$dadosAtuRequisicao = array(
					"rem_codigo" => $codRequisicao,
					"rem_status" => "F"
				);

				$tbRem->atualizaStatusRequisicao($dadosAtuRequisicao);
				Zend_Db_Table::getDefaultAdapter()->commit();
				$this->view->dados['msg'] = "Requisição confirmada";
				$this->view->dados['id'] = $codRequisicao;
//                return $this->_redirect("materiais/requisicao-materiais/index/id/$codRequisicao");
			} catch (Exception $exc) {
				Zend_Db_Table::getDefaultAdapter()->rollBack();
				$this->view->dados['msg'] = $exc->getMessage();
			}
		} else {
			$dadosAtuRequisicao = array(
				"rem_codigo" => $codRequisicao,
				"rem_status" => "F"
			);
			$tbRem->atualizaStatusRequisicao($dadosAtuRequisicao);
			$this->view->dados['msg'] = "Nenhum item nessa requisição";
//            return $this->_redirect("materiais/requisicao-materiais/index/id/$codRequisicao");
		}

		return $this->render("dados", NULL, TRUE);
	}

	public function formAction() {
		$tbSet = new Application_Model_Setor();
		$tbUsr = new Application_Model_Usuarios();
		$this->view->usr_nome = $tbUsr->getUsrAtual()->usr_nome;

		$rem_codigo = $this->_getParam("id", FALSE);
		if ($rem_codigo) {
			$tbRem = new Application_Model_RequisicaoMateriais();
			$requisicao = $tbRem->getRequisicao($rem_codigo)->toArray();
			$this->view->itens = $requisicao;
			$tbRemi = $tbRemi = new Application_Model_RequisicaoMateriaisItens();
			$itens_requisicao = $tbRemi->getProdutosRequisicao($rem_codigo)->toArray();
			$this->view->itens_requisicao = $itens_requisicao;
		}

		$this->view->setor_origem = $tbSet->selectTag(TRUE, "set_codigo_req", $requisicao['set_codigo_req']);
		$this->view->setores = $tbSet->selectTag(FALSE, "set_codigo_sol", $requisicao['set_codigo_sol']);
	}

	public function salvarAction() {

		$tbUsr = new Application_Model_Usuarios();
		$usr_codigo = $tbUsr->getUsrAtual()->usr_codigo;

		$requisicao = array("set_codigo_req" => $this->_request->getPost("set_codigo_req", NULL),
			"set_codigo_sol" => $this->_request->getPost("set_codigo_sol", NULL),
			//"rem_observacao" => ($this->_request->getPost("rem_observacao", NULL) == "0" ? "5003" : $this->_request->getPost("for_codigo", NULL)),
			"rem_observacao" => $this->_request->getPost("rem_observacao", NULL),
			"rem_data" => 'NOW()',
			"usr_codigo" => $usr_codigo,
			"rem_status" => $this->_request->getPost("rem_status", NULL));

		$tbReq = new Application_Model_RequisicaoMateriais();
		try {
			$rem_codigo = $tbReq->salvar($requisicao);
			$this->view->dados = array("msg" => "Dados cadastrados com sucesso!", "id" => $rem_codigo);
		} catch (Zend_Validate_Exception $exc) {
			$this->view->dados = $exc->getMessage();
		}
		return $this->render("dados", NULL, TRUE);
	}

	public function editarAction() {
		$rem_codigo = $this->_getParam("id", FALSE);
		return $this->_redirect("materiais/requisicao-materiais/form/id/$rem_codigo");
	}

	public function buscarAction() {
		if ($this->_request->isPost()) {
			$tbReq = new Application_Model_RequisicaoMateriais();
			$this->view->busca = $this->_request->getPost("busca");
			$this->view->rem_status = $this->_request->getPost("rem_status");
			$this->view->itens = $tbReq->getRequisicoes(NULL, $this->view->busca, $this->view->rem_status);
			$this->render("index");
		} else {
			$this->_redirect("/materiais/controle-movimentos/index");
		}
	}

	public function salvarItensAction() {

		$tbIte = new Application_Model_RequisicaoMateriaisItens();
		Zend_Db_Table::getDefaultAdapter()->beginTransaction();
		try {
			if (count($this->_request->getPost("itens"))) {
				foreach ($this->_request->getPost("itens") as $itens) {
					$array_itens = array("pro_codigo" => $itens[pro_codigo],
						"remi_quantidade" => $itens[remi_quantidade],
						"rem_codigo" => $itens[rem_codigo],
						"remi_status" => $itens[remi_status]);
					if ($itens[remi_codigo] != "") {
						$array_itens[remi_codigo] = $itens[remi_codigo]; // se for editar
					}
					$remi_codigo = $tbIte->salvar($array_itens);
				}
			}

			if (count($this->_request->getPost("itens_deletar_banco"))) {

				foreach ($this->_request->getPost("itens_deletar_banco") as $itens_remover) {
					$tbIte->deletar($itens_remover);
				}
			}

			$this->view->dados = array("msg" => "Dados cadastrados com sucesso", "id" => 1);
			Zend_Db_Table::getDefaultAdapter()->commit();
		} catch (Exception $exc) {
			$this->view->dados = $exc->getMessage();
			Zend_Db_Table::getDefaultAdapter()->rollBack();
		}
		return $this->render("dados", NULL, TRUE);
	}

	public function verificaMostraSaldoAction() {
		$cod_solicitante = $this->_getParam("cod_solicitante", FALSE);
		$tbSetor = new Application_Model_Setor();
		$this->view->dados = $tbSetor->getParamSetorPorCodigo($cod_solicitante, array("mostra_saldo_estoque"));
		return $this->render("dados", NULL, TRUE);
	}

	public function imprimirAction() {
		$this->_helper->layout->setLayout("modelo-print");
		$tbUsr = new Application_Model_Usuarios();

		$this->view->title = "Requisição Materiais";

		$rem_codigo = $this->_getParam("rem_codigo", FALSE);

		$tbRemi = new Application_Model_RequisicaoMateriaisItens();
		$tbRem = new Application_Model_RequisicaoMateriais();
		$this->view->dados_req = $tbRem->getRequisicao($rem_codigo);

		$this->view->itens = $tbRemi->getItensPorRequisicao($rem_codigo, true);
		$this->view->dados_gerais = "<b>Setor de Requisição: </b>" . $this->view->dados_req->set_nome_req;
		$this->view->dados_gerais_sec = "<b>Setor de Solicitação: </b>" . $this->view->dados_req->set_nome_sol;
		$this->view->dados_complementares = "<b>Solicitante: </b>" . $this->view->dados_req->usr_nome;
		$this->view->dados_complementares_sec = "<b>Data da Requisição:</b>" . $this->view->dados_req->rem_data;
	}


}
