<?php

class Materiais_TipoProdutoController extends Zend_Controller_Action
{


    public function init()
    {

    }

    public function indexAction()
    {
        $this->view->title = "Tipos de Produtos";
        $this->view->tipos = (new Application_Model_TipoProduto())->getAll();
    }

    public function novoAction()
    {
        $this->view->title = "Cadastro de Tipos de Produtos";
        $this->render('form');
    }

    public function pesquisaAction()
    {
        $term = $this->_getParam("busca");
        $this->view->tipos = (new Application_Model_TipoProduto())->buscar($term);
        $this->render('index');
    }

    public function formAction()
    {
        $this->view->title = "Cadastro de Tipos de Produtos";

        $id = $this->_getParam("id", FALSE);

        if($id){
            $this->view->dados = (new Application_Model_TipoProduto())->getById($id);
        }
    }

    public function excluirAction()
    {
        $id = $this->_getParam("id");
        try {
            $tbTp = new Application_Model_TipoProduto();
            $tbPro = new Application_Model_Produto();
            $count = $tbPro->fetchRow("pro_tipo = '$id'");
            if(!$count){
                $tbTp->excluir($id);
                $this->view->dados = array("success" => TRUE, "mensagem" => "Tipo de Produto excluído com sucesso!");
            } else {
                $dados = $tbTp->getById($id)->toArray();
                $dados['tp_status'] = 0;
                $tbTp->salvar($dados);
                $this->view->dados = array("success" => TRUE, "mensagem" => "Tipo de Produto não pode ser excluído, será inativado!");
            }
        } catch (Exception $e) {
            $this->view->dados = array("success" => FALSE, "mensagem" => $e->getMessage());
        }
        return $this->render("dados", NULL, TRUE);

    }

    public function salvarAction(){
        $data = $this->_request->getPost();
        $tbTp = new Application_Model_TipoProduto();

        try{
            $tp_codigo = $tbTp->salvar($data);
            $this->view->dados = array("success" => true);
        }catch (Exception $e){
            $this->view->dados = array("success" => false,"mensagem" => $e->getMessage());
        }
        return $this->render("dados", NULL, TRUE);
    }
}

