<?php

class ProcedimentoClassificacao_ProcedimentoController extends Zend_Controller_Action
{
    public function init()
    {
        $this->view->title = "Procedimentos";
    }

    public function indexAction()
    {
        $tbProc = new Application_Model_Procedimento();
        $this->view->itens = $tbProc->getAll();
    }

    public function excluirAction()
    {
        $id = $this->_getParam("id");
        try {
            $tbProc = new Application_Model_Procedimento();
            $tbProc->excluir($id);
            $this->view->dados = array("success" => TRUE);

        } catch (Exception $e) {
            $this->view->dados = array("success" => FALSE, "mensagem" => $e->getMessage());
        }
        return $this->render("dados", NULL, TRUE);

    }

    public function novoAction()
    {
        $tbComp = new Application_Model_TbComplexidade();
        $this->view->complexidade = $tbComp->fetchAll();
        $tbFinan = new Application_Model_TbFinanciamento();
        $this->view->financiamento = $tbFinan->fetchAll();
        $tbServ = new Application_Model_ProcedimentoClassificacaoServico();
        $this->view->servico = $tbServ->getServicoByCod();
        $this->view->classificacao = $tbServ->getClassificacaoByCod();
        $this->render('form');
    }

    public function formAction()
    {
        $tbComp = new Application_Model_TbComplexidade();
        $this->view->complexidade = $tbComp->fetchAll();
        $tbFinan = new Application_Model_TbFinanciamento();
        $this->view->financiamento = $tbFinan->fetchAll();
        $tbServ = new Application_Model_ProcedimentoClassificacaoServico();
        $id = $this->_getParam("id", FALSE);
        if ($id) {
            $tbProc = new Application_Model_Procedimento();
            $this->view->dados = $tbProc->editar($id);
            $this->view->parametros = $tbServ->getByProc($id);
        }
        $this->view->servico = $tbServ->getServicoByCod($id);
        $this->view->classificacao = $tbServ->getClassificacaoByCod($id);

    }

    public function salvarAction(){
        $data = $this->_request->getPost();
        $tbPro = new Application_Model_Procedimento();

        try{
            $proc_codigo = $tbPro->salvar($data);
            $this->view->dados = array("success" => true);
        }catch (Exception $e){
            $this->view->dados = array("success" => false,"mensagem" => $e->getMessage());
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function salvarVinculoAction(){
        $tbPcs = new Application_Model_ProcedimentoClassificacaoServico();
        $uni_codigo = $this->_request->getPost("unidade");
        $co_servico = $this->_request->getPost("servico");
        $co_classificacao = $this->_request->getPost("classificacao");
        $proc_codigo = $this->_request->getPost("procedimento");

        $data = array(
            "proc_codigo" => $proc_codigo,
            "uni_codigo" => $uni_codigo,
            "co_servico" => $co_servico,
            "co_classificacao" => $co_classificacao,
        );

        if (!$tbPcs->verificaExiste($uni_codigo,$proc_codigo)){

            try{
                $pcs_codigo = $tbPcs->salvar($data);
                $this->view->dados = array("success" => true,"pcs_codigo" => $pcs_codigo,);
            }catch (Exception $e){
                $this->view->dados = array("success" => false,"mensagem" => $e->getMessage());
            }
        } else{
            $this->view->dados = array("success" => false,"mensagem" => "Serviço e Classificação já vinculados para esta unidade!");
        }

        return $this->render("dados", NULL, TRUE);
    }

    public function excluirVinculoAction(){
        $id = $this->_getParam("id", FALSE);
        $tbServ = new Application_Model_ProcedimentoClassificacaoServico();
        try{
            $tbServ->excluir($id);
            $this->view->dados = array("success" => true);
        }catch (Exception $e){
            $this->view->dados = array("success" => false,"mensagem" => $e->getMessage());
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function pesquisaAction(){
        $term = $this->_getParam("busca");

        $tbPro = new Application_Model_Procedimento();

        $this->view->itens = $tbPro->pesquisar($term);

        $this->render('index');
    }

}