<?php

class ProgramasFederais_BpaController extends Zend_Controller_Action {


	public function init() {
		//session_start();
		$this->_helper->acl->allow(NULL,array('index'));
		$this->view->title = "BPA MAG";
		$this->dbtable = new Application_Model_DbTable_BPA();
		$this->model = new Application_Model_BPA();
		$this->unidade = new Application_Model_Unidade();
		$this->medico = new Application_Model_Medico();
		$this->quebra = chr(13) . chr(10);
	}

	function getDiaExistente($data) {
		list($dia, $mes, $ano) = explode("-", $data);
		$mes = (int) $mes;

		$bissexto = (($ano % 4 == 0 && $ano % 100 != 0) || $ano % 400 == 0);
		$dias = array(
			'1' => 31,
			'2' => ($bissexto) ? 29 : 28,
			'3' => 31,
			'4' => 30,
			'5' => 31,
			'6' => 30,
			'7' => 31,
			'8' => 31,
			'9' => 30,
			'10' => 31,
			'11' => 30,
			'12' => 31
		);

		if ($dia <= $dias[$mes]) {
			return $data;
		}
		return $dias[$mes] . "-" . $mes . "-" . $ano;
	}

	function getMesAnterior($mes_ano, $separador = "-") {
		list($mes,$ano) = explode($separador, $mes_ano);
		$mes = (int) $mes;
		$ano = (int) $ano;
		if($mes > 12) {
			throw new Exception("Mês não pode ser maior que 12", 1);
		}
		if($mes == 1) {
			return "12".$separador.($ano - 1);
		}
		return ($mes - 1).$separador.$ano;
	}

	public function geraBpaAction() {
		ini_set("display_errors", 1);
		$tbConfig = new Application_Model_Configuracao();
		$ibge = $tbConfig->getConfig("CID_CODIGO_IBGE");
		$tipo_finan = $this->_request->getPost("tipoBpa");
		$tipo_origem = $this->_request->getPost("tipo");
		$uni_codigo = $this->_request->getPost("codigo");
		$data = $this->_request->getPost("competencia");

		$diaCompetencia = $tbConfig->getConfig("BPA_DIA_COMPETENCIA");
		$dataExplode = explode('/', $data);
		$dataSerapadaPorTraco = $dataExplode[0].'-'.$dataExplode[1];
		$dataCompetenciaFim = $this->getDiaExistente($diaCompetencia.'-'.$dataSerapadaPorTraco);
		$dataCompetenciaInicio = $this->getDiaExistente($diaCompetencia.'-'.$this->getMesAnterior($dataSerapadaPorTraco));


		$dataCompetenciaInicio = date('d/m/Y', strtotime($dataCompetenciaInicio));
		$dataCompetenciaFim = date('d/m/Y', strtotime('-1 day', strtotime($dataCompetenciaFim)));


		$msg = $this->montaCabecalho($tipo_finan,$data,$tipo_origem,$uni_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
		$msg .= $this->montaConsolidadoAction($tipo_finan,$data,$tipo_origem,$uni_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
		$msg .= $this->montaIndividualizadoAction($tipo_finan,$data,$tipo_origem,$uni_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);

		$meses = array("01"=>"JAN", "02"=>"FEV", "03"=>"MAR", "04"=>"ABR", "05"=>"MAI", "06"=>"JUN", "07"=>"JUL", "08"=>"AGO", "09"=>"SET", "10"=>"OUT", "11"=>"NOV", "12"=>"DEZ");
		$data = explode("/", $data);

		$path = $_SESSION["root"]."WebSocialSaude/zf/public/arqs/";

		$this->criaArquivo("PA".$ibge, $msg, $path, "." . $meses[$data[0]]);

		$nomeDoArquivo = "PA".$ibge.".".$meses[$data[0]];

		$this->downloadBpa($path, $nomeDoArquivo);
	}

	public function downloadBpa($path, $nomeDoArquivo ){
		$link = $path.$nomeDoArquivo;
		header("Content-Disposition: attachment; filename=".$nomeDoArquivo."");
		header("Content-Type: application/plain");
		readfile($link);

		//NECESSARIO DESABILITAR A VIEW...!!! OU O ARQUIVO IRA IMPRIMIR UM ERRO ZEND !!!!!
		$this->view->layout()->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
	}


	public function montaCabecalho($tp_financiamento=FALSE,$data=FALSE,$origem=FALSE,$origem_codigo=FALSE,$dataCompetenciaInicio=FALSE,$dataCompetenciaFim=FALSE) {
		$tbSec = new Application_Model_Secretaria();
		$dados_sec = $tbSec->getDadosSec();
		$quebra = explode("/", $data);
		$ano = $quebra[1];
		$mes = $quebra[0];
		if($tp_financiamento == '04'){
			$procedimento_qtde = $this->dbtable->getProcedimentosBPAPorPeriodo('04',$data,$origem,$origem_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
			$procedimento_qtde = $procedimento_qtde + $this->dbtable->getProcedimentosBPAPorPeriodo('05',$data,$origem,$origem_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
			$procedimento_qtde = $procedimento_qtde + $this->dbtable->getProcedimentosBPAPorPeriodo('06',$data,$origem,$origem_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
		}else{
			$procedimento_qtde = $this->dbtable->getProcedimentosBPAPorPeriodo($tp_financiamento,$data,$origem,$origem_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
		}
		$numFolhas = $this->corta((round(($procedimento_qtde->count / 20)) + 1),6,"0");
		$numLinhaBpa = $this->corta($procedimento_qtde->count,6,"0");
		$calculaControle = $this->corta($this->model->calculaControle($procedimento_qtde->sum,$procedimento_qtde->count),4,"0");
		$array_origem = $this->origem($origem, $origem_codigo);

		$versaoSistema = $this->corta(trim(preg_replace('/\s/',' ',$_SESSION['versao'])), 10, " ");
		$quebra = chr(13) . chr(10);
		$cabecalho = "01#BPA#".$ano.$mes.$numLinhaBpa.$numFolhas.$calculaControle.$array_origem["nome"].substr($array_origem["nome"], 0, 6).preg_replace("/[^0-9]+/", "", $array_origem["cnpj"]).$dados_sec["nome_secretaria"]."M".$versaoSistema.$quebra;
		return $cabecalho;
	}

	public function montaConsolidadoAction($tp_financiamento=FALSE,$data=FALSE,$origem=FALSE,$origem_codigo=FALSE,$dataCompetenciaInicio=FALSE,$dataCompetenciaFim=FALSE) {

		if($tp_financiamento == '04'){
			$linhas06 = $this->dbtable->getRegistrosBpaNovo('06',$data,$origem,$origem_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
			$linhas05 = $this->dbtable->getRegistrosBpaNovo('05',$data,$origem,$origem_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
			$linhas04 = $this->dbtable->getRegistrosBpaNovo('04',$data,$origem,$origem_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
			$linhas = array_merge($linhas06, $linhas05);
			$linhas = array_merge($linhas, $linhas04);
		}else{
			$linhas = $this->dbtable->getRegistrosBpaNovo($tp_financiamento,$data,$origem,$origem_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
		}
		$data = explode("/", $data);
		$dataAnoMes = $data[1].$data[0];
		$codCnes = "";
		foreach($linhas as $linha) {
			$cnes = $this->corta($linha['cnes'], 7, " ");
			if ($codCnes <> $cnes) {
				$codCnes = $cnes;
				$numFolhaBpa = 1;
				$numLinhaBpa = 1;
			}
			if ($numLinhaBpa > 20) {
				$numFolhaBpa++;
				$numLinhaBpa = 1;
			}
			$numFolhaBpa = $this->corta($numFolhaBpa,3,"0");
			$numLinhaBpa = $this->corta((strlen($numLinhaBpa) == 1 ? "0".$numLinhaBpa : $numLinhaBpa),2," ");

			$quebra = chr(13) . chr(10);
			$cboMedico = $this->corta($linha['cod_cbo'], 6, " ");
			$proc_codigo_sus = str_replace(array('.', '-'), array('', ''), $linha['proc_codigo_sus']);
			$codProcAmbulatorial = $this->corta($proc_codigo_sus, 10, "0");
			$qtdeProc = $this->corta($linha['qtde'], 6, "0");
			$idade = $this->corta($linha['idade'], 3, "0");
			$consolidado .=  "02".$codCnes.$dataAnoMes.$cboMedico.$numFolhaBpa.$numLinhaBpa.$codProcAmbulatorial.$idade.$qtdeProc."EXT".$quebra;
			$numLinhaBpa++;
		}
		return $consolidado;
	}

	public function montaIndividualizadoAction($tp_financiamento=FALSE,$data=FALSE,$origem=FALSE,$origem_codigo=FALSE,$dataCompetenciaInicio=FALSE,$dataCompetenciaFim=FALSE) {

		if($tp_financiamento == '04'){
			$linhas05 = $this->dbtable->getRegistrosIndividualizadoBpa('05',$data,$origem,$origem_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
			$linhas06 = $this->dbtable->getRegistrosIndividualizadoBpa('06',$data,$origem,$origem_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
			$linhas04 = $this->dbtable->getRegistrosIndividualizadoBpa('04',$data,$origem,$origem_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
			$linhas = array_merge($linhas06, $linhas05);
			$linhas = array_merge($linhas, $linhas04);
		}else{
			$linhas = $this->dbtable->getRegistrosIndividualizadoBpa($tp_financiamento,$data,$origem,$origem_codigo,$dataCompetenciaInicio,$dataCompetenciaFim);
		}

		$data = explode("/", $data);
		$dataAnoMes = $data[1].$data[0];
		$codCnes = "";
		$cnsProf = "";
		$controle = false;
		foreach ($linhas as $linha) {
			$cnes = $this->corta($linha['cnes'], 7, "0"); // tamanho 7
			$cnsMedico = $this->corta($linha['cnes_cod_cns'], 15, " "); // tamanho 15
			if ($codCnes <> $cnes) {
				$codCnes = $cnes;
				$numFolhaBpa = 1;
				$numLinhaBpa = 1;
				$controle = false;
			}
			if ($cnsProf <> $cnsMedico) {
				$cnsProf = $cnsMedico;
				if($controle == true){
					$numFolhaBpa++;
					$numLinhaBpa = 1;
				}
				$controle = true;
			}
			if ($numLinhaBpa > 99) {
				$numFolhaBpa++;
				$numLinhaBpa = 1;
			}
			$numFolhaBpa = $this->corta((strlen($numFolhaBpa) == 1 ? "00".$numFolhaBpa : $numFolhaBpa),3,"0");
			$numLinhaBpa = $this->corta((strlen($numLinhaBpa) == 1 ? "0".$numLinhaBpa : $numLinhaBpa),2," ");
			$cboMedico = $this->corta($linha['cod_cbo'], 6, " ");
			$dataAtendimento = $this->corta($linha['bpa_data'],8," ");   // tamanho 8 AAAAMMDD
			$proc_codigo_sus = str_replace(array('.', '-'), array('', ''), $linha['proc_codigo_sus']);
			$codProcAmbulatorial = $this->corta($proc_codigo_sus, 10, "0");
			$cnsPaciente = $this->corta($linha['usu_cartao_sus'], 15, " "); // tamanho 15
			$pacSexo = $this->corta($linha['usu_sexo'], 1, " ");
			$cid = $this->corta($linha['cd10_codigo_cid'], 4, " ");
			$idade = $this->corta($linha['idade'], 3, "0"); // tamanho 3
			$qtdeProc = $this->corta($linha['qtde'], 6, "0");
			$caracterAtendimento = $this->corta($linha['ci_codigo'], 2, "0");
			$numAutorizacaoEstabelecimento = $this->corta($linha['bpa_autorizacao'], 13, " ");
			$nomeUsuario = $this->corta($linha['usu_nome'], 30, " "); // se menor que 30, preenche com :space:
			$dataNascUsuario = str_replace('-', '', $linha['usu_datanasc']);
			$racaUsuario = ($linha['raca']  < 9 ? "0" . $linha['raca'] : "99");
			$racaUsuario = $this->corta($this->trocaRacaAction($racaUsuario),2,"0");
			if ($racaUsuario == "00") {
				$racaUsuario = 99;
			}
			/*PARTE NAO CONTEMPLADA*/
			$codServico = $this->corta($linha['co_servico'],3," ");
			$codClassificacao = $this->corta($linha['co_classificacao'],3," ");
			$codSeqEquipe = $this->corta("",8," ");
			$codAreaEquipe = $this->corta("",4," ");
			$codIne = $this->corta($linha["nu_ine"],10," ");
			$cnpj = $this->corta (str_replace("/", "", $linha["cnpj"]),14," ");
			/*----*/
			/*DOMICILIO*/
			$cep= $this->corta(str_replace("-", "", $linha["rua_cep"]),8," ");
			$codLogradouro = $this->corta($linha["co_tipo_logradouro"],3," ");
			$nomeRua = $this->corta($linha["rua_nome"],30," ");
			$complemento = $this->corta($linha["dom_complemento"],10," ");
			$numeroEnd = $this->corta($linha["dom_numero"],5," ");
			$bairro = $this->corta($linha["bai_nome"],30," ");
			$telefone = $this->corta($this->formataTelefone($linha["dom_telefone"]),11," ");
			$email = $this->corta("",40," ");
			$quebra = chr(13) . chr(10);

			if ($racaUsuario == "05") {
				$etniaUsuario = $this->corta($linha['etnia'], 4, "0");
			} else {
				$etniaUsuario = $this->corta("    ", 4, " ");
			}
			$nacionalidade = $this->corta("010", 3, " ");
			$ibge =$this->corta($linha["ibge_dom"],6," ");
			$individualizado .= "03".$codCnes . $dataAnoMes . $cnsMedico . $cboMedico . $dataAtendimento . $numFolhaBpa .
				$numLinhaBpa . $codProcAmbulatorial . $cnsPaciente . $pacSexo . $ibge . $cid . $idade .
				$qtdeProc . $caracterAtendimento . $numAutorizacaoEstabelecimento . "EXT" . $nomeUsuario .
				$dataNascUsuario  . $racaUsuario . $etniaUsuario . $nacionalidade . $codServico. $codClassificacao.$codSeqEquipe.
				$codAreaEquipe.$cnpj.$cep.$codLogradouro.$nomeRua.$complemento.$numeroEnd.$bairro.$telefone.$email.$codIne.$quebra;

			$numLinhaBpa++;

		}
		return $individualizado;
	}


	public function trocaRacaAction($raca) { // A TABELA DO BPA INVERTE OS CODIGOS 03 - 04 COM OS PARÂMETROS DO ESUS
		if ($raca == "03") {
			$raca = "04";
		} else if ($raca == "04") {
			$raca = "03";
		}
		return $raca;
	}

	public function criaArquivo($nome, $msg, $path = "./", $ext = ".xml", $modo = "w") {
		if (!is_dir($path)) {
			die($path);
			return "DIR '$path' nao existe";
		}
		$completePath = $path.$nome.$ext;

		$open = fopen($completePath, $modo);//pode ver os parametros do fopen no php.net
		if ($open) {
			chmod($completePath, 0777);
		}
		fwrite($open, $msg);
		return fclose($open);

	}
	public function origem($origem,$origem_codigo) {
		if ($origem == "U") {
			$dados_origem = $this->unidade->getUnidade($origem_codigo)->toArray();
			$origem_nome = $dados_origem[0]["uni_desc"];
			$origem_cnpj = $dados_origem[0]["uni_cnpj"];
		} else if ($origem == "M") {
			$dados_origem = $this->medico->getInfoMedico($origem_codigo)->toArray();
			$origem_nome = $dados_origem["med_nome"];
			$origem_cnpj = $dados_origem["med_cnpj"];
		} else if ($origem == "") {
			$origem_nome = "";
			$origem_cnpj = "";
		}
		return array("cnpj" => $origem_cnpj,"nome"=>$origem_nome);
	}

	public function corta($str, $max=10, $preencherCom="0") {
		$lado = ($preencherCom === "0" ? STR_PAD_LEFT : STR_PAD_RIGHT);

		if (strlen($str) > $max) {
			$str = substr($str, 0, $max);
		}

		return str_pad($str, $max, $preencherCom, $lado);
	}


	public function formataTelefone($telefone) {
		$novoTelefone;
		for ($index = 0; $index < strlen($telefone); $index++) {
			$arrayNumero = array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
			if (in_array($telefone[$index], $arrayNumero)) {
				$novoTelefone .= $telefone[$index];
			}
		}
		return $novoTelefone;
	}

	public function exportacaoAction() {
		// $this->view->title = "Exportação E-SUS";
	}


	public function lerArquivoAction() {
		// O nome original do arquivo no computador do usuário
		$arqName = $_FILES['arquivo']['name'];
		// O código de erro associado a este upload de arquivo
		$arqError = $_FILES['arquivo']['error'];
		if ($arqError == 0) {
			$pasta = $_SESSION["root"]."WebSocialSaude/e-sus/inconsistencias/";
			$arquivo = $_SESSION["root"]."WebSocialSaude/e-sus/inconsistencias/".$arqName;
		}

		$zip = new ZipArchive;
		$zip->open($arquivo);
		$zip->extractTo($pasta);
		$zip->close();
		unlink($arquivo);
		$this->importaInconsistencias();
		return $this->render("index");
	}

	public function importaInconsistencias($arquivo=FALSE) {
		$arquivo = $_SESSION["root"]."WebSocialSaude/e-sus/inconsistencias/importacao_cidadao.resultado";
		$lines = file($arquivo);
		$tbEsus = new Application_Model_EsusImportacaoResultado();
		Zend_Db_Table::getDefaultAdapter()->beginTransaction();
		try {
			foreach($lines as $line) {
				$rest = substr($line, 23, -2); // remove os lixos da string
				list($cidadao,$cns,$cpf,$nome,$dtNascimento,$nomeMae,$mensagem) = explode(",", $rest);
				list($ind,$val) = explode("=", $cidadao);
				list($ind_cns,$val_cns) = explode("=", $cns);
				list($ind_cpf,$val_cpf) = explode("=", $cpf);
				list($ind_nome,$val_nome) = explode("=", $nome);
				list($ind_dt,$val_dt) = explode("=", $dtNascimento);
				list($ind_mae,$val_mae) = explode("=", $nomeMae);
				list($ind_msg,$val_msg) = explode("=", $mensagem);
				$mensagemOk = explode(":", $val_msg);

				if (count($tbEsus->verificaEsus($val_nome,$mensagemOk[1])->toArray())==0) {
					$dados = array(
						"eir_cod_cidadao_esus" => $val,
						"eir_cns" => $val_cns,
						"eir_cpf" => $val_cpf,
						"eir_nome" => $val_nome,
						"eir_data_nascimento" => $val_dt,
						"eir_nome_mae" => $val_mae,
						"eir_mensagem" => $mensagemOk[1]
					);
					$tbEsus->salvarTeste($dados);
				}
			}
			Zend_Db_Table::getDefaultAdapter()->commit();
			$this->_redirect("programas-federais/esus/importacao-resultado");
		} catch (Exception $exc) {
			Zend_Db_Table::getDefaultAdapter()->rollBack();
			$this->view->dados = $exc->getMessage();
			return $this->render("dados",NULL,TRUE);
		}
	}

	public function importacaoResultadoAction() {
		$tbImr = new Application_Model_EsusImportacaoResultado();
		$this->view->dados = $tbImr->listar();
	}

	public function buscaImportacaoResultadoAction() {
		$status = $this->_request->getPost("status");
		$tbImr = new Application_Model_EsusImportacaoResultado();
		$this->view->dados = $tbImr->listar($status);
		return $this->render("importacao-resultado");
	}

	public function alteraStatusImportacaoAction() {
		$tbEir = new Application_Model_EsusImportacaoResultado();
		$eir_codigo = $this->_request->getPost("eir_codigo");
		$dados = array("eir_status_correcao" => 'T');
		$tbEir->atualizaStatusImp($dados, $eir_codigo);
		$this->view->dados = "";
		return $this->render("dados",NULL,TRUE);
	}

	public function importacaoDomicilioAction() {
		$this->view->title = "Importação de domicílios E-SUS";
	}

	public function historicoExportacaoAction() {
		$tbEeh = new Application_Model_EsusExportacaoHistorico();
		$this->view->itens = $tbEeh->ultimasExportacoes();
	}

	public function buscarAction() {
		if ($this->_request->isPost()) {
			$tbMov = new Application_Model_Movimento();
			$this->view->busca = $this->_request->getPost("busca");
			$this->view->mov_tipo = $this->_request->getPost("mov_tipo");
			$this->view->itens = $tbMov->getMovimentos(NULL,$this->view->busca,$this->view->mov_tipo);
			$this->render("index");
		} else {
			$this->_redirect("/materiais/controle-movimentos/index");
		}
	}

	public function indexAction() {
		$this->view->title = "BPA";

		$TbConfig = new Application_Model_Configuracao();
		$data_competencia = $TbConfig->getConfig('DATA_COMPETENCIA');
		$dataFormatada = date("m/Y", strtotime($data_competencia));
		$this->view->dataCompetencia = $dataFormatada;

		$TbBpa = new Application_Model_BPA();
		$prestadorUnidade = $TbBpa->buscaPrestadorParaBpa();
		$this->view->listaUnidade = $prestadorUnidade;

		$TbMed = new Application_Model_Medico();
		$prestadorMedico = $TbMed->buscaPrestadorParaBpa();
		$this->view->listaPrestador = $prestadorMedico;
	}
}

?>