<?php

class ProgramasFederais_FichaOdontologicaController extends Zend_Controller_Action
{

    public function init()
    {

    }

    public function indexAction()
    {
        $this->view->title = "Ficha Odontológica";
        $tbAte = new Application_Model_Atendimento();

        $tbAcessosFichaEsus = new Application_Model_AcessosFichaEsus();
        $tbUsr = new Application_Model_Usuarios();
        $tbEsp = new Application_Model_Especialidade();
        $usr = $tbUsr->getUsrAtual();

        if ($usr->usr_digitador == 'N' && !$valida) {
            if (!$usr->esp_codigo) {
                return $this->_redirect("/atendimento/atendimento-simplificado/erro");
            } else {
                $especialidade = $tbEsp->getEspecialidade($usr->esp_codigo);
                if (!$tbAcessosFichaEsus->getAcessosFichaEsus($especialidade->cod_cbo, "o") && $usr->usr_digitador == 'N') {
                    return $this->_redirect("/atendimento/atendimento-simplificado/erro");
                }
            }
        }


        $this->view->dados = $tbAte->getAtendimentosOdontologicos();


    }

    public function formAction()
    {
        $codFicha = $this->_request->getParam("id");
        $this->carregaDadosForm($codFicha);
        $this->view->title = "Ficha Odontológica";
        $valida = $this->_getParam("valida");
        $this->view->valida = $valida;

        if ($codFicha) {
            $tbAte = new Application_Model_Atendimento();
            $tbEsp = new Application_Model_Especialidade();
            $this->view->dados = $tbAte->getDadosAtendimentosOdontologico($codFicha);
            $this->view->especialidades = $tbEsp->getEspecialidadePorProfissional($this->view->dados->usr_codigo, $this->view->dados->uni_codigo);
            $tbProc = new Application_Model_ProcedimentoAtendimento();
            $procedimento = $tbAte->getAtendimentoPorAteCodigoComQuantidade($codFicha);

            if (count($procedimento) > 0) {
                $this->view->procedimento = $procedimento->toArray();
            }
            $this->view->ate_codigo = $codFicha;

        }

        $uni_desc_controle = $this->_getParam("uni_desc_controle");
        $this->view->uni_desc_controle = $uni_desc_controle;

        $uni_codigo_controle = $this->_getParam("uni_codigo_controle");
        $this->view->uni_codigo_controle = $uni_codigo_controle;

        $data_atendimento_controle = $this->_getParam("data_atendimento_controle");
        $data_atendimento_controle = explode('-', $data_atendimento_controle);
        $data_atendimento_controle = implode('/', $data_atendimento_controle);
        $this->view->data_atendimento_controle = $data_atendimento_controle;

        $usr_nome_controle = $this->_getParam("usr_nome_controle");
        $this->view->usr_nome_controle = $usr_nome_controle;

        $usr_codigo_controle = $this->_getParam("usr_codigo_controle");
        $this->view->usr_codigo_controle = $usr_codigo_controle;

        $esp_codigo_controle = $this->_getParam("esp_codigo_controle");
        $this->view->esp_codigo_controle = $esp_codigo_controle;


    }

    public function carregaDadosForm($codFicha)
    {
        $tbTipVig = new Application_Model_TbCdsTipoVigSaudeBucal();
        $tbTipCond = new Application_Model_TbCdsTipoEncamOdonto();
        $tbTipAte = new Application_Model_TipoAtendimento();
        $tbTipCons = new Application_Model_TipoConsulta();
        $tbLocal = new Application_Model_TbLocalAtend();
        $this->view->selectLocais = $tbLocal->selectTag();
        if ($codFicha) {
            $this->view->vigilancia = $tbTipVig->getDadosEdit($codFicha);
            $this->view->conduta = $tbTipCond->getDadosEdit($codFicha);
            $this->view->encaminhamentos = $tbTipCond->getEncaminhamentosEdit($codFicha);
            $this->view->codigoFicha = $codFicha;
        } else {
            $this->view->vigilancia = $tbTipVig->getDados();
            $this->view->conduta = $tbTipCond->getDados();
            $this->view->encaminhamentos = $tbTipCond->getEncaminhamentos();
            $this->view->codigoFicha = '';
        }
        $this->view->tipoAtendFicha = $tbTipAte->getTiposDeAtendimentoFicha();
        $this->view->demandaEspontanea = $tbTipAte->getDemandaEspontanea();
        $this->view->tipoCons = $tbTipCons->getDados();
    }

    public function salvarAction()
    {
        $this->view->title = "Ficha Odontológica";
//        $tbOdoTrat = new Application_Model_OdontoTratamento();
        $tbOdoTratRealizados = new Application_Model_OdontoProcedimentosRealizados();
//        $tbOdoTratControle = new Application_Model_OdontoProcedimentosControle();
        if ($this->_request->getPost("odo_trat_codigo", FALSE)) {
            $odoAll = $tbOdoTratRealizados->listaProcedimentosRealizados($this->_request->getPost("odo_trat_codigo", FALSE));

            foreach ($odoAll as $a) {
                $tbOdoTratRealizados->excluirProcedimentoRealizado($a->odo_preal_codigo);
            }
        }


        Zend_Db_Table::getDefaultAdapter()->beginTransaction();

        try {
            $post = $_POST;
            $ageCod = $this->salvarAgendamento($post);
            $ateCod = $this->salvarAtendimento($post, $ageCod);

            $tbUsu = new Application_Model_Usuario();
            $dadosUsuario = array(
                "usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
                "usu_esta_gestante" => $this->_request->getPost("gestante", FALSE),
                "usu_deficiencia" => $this->_request->getPost("neces_especial", FALSE),
	            "risco_odonto" => $this->_request->getPost("risco_odonto", FALSE)
            );

            $tbUsu->salvar($dadosUsuario);

            $this->salvarCondutas($post, $ateCod);
            $this->salvarVigilanciaBucal($post, $ateCod);
            $odoTratCod = $this->salvarTratamento($post, $ateCod);
            $odoPconCod = $this->salvarProcedimentoControle($odoTratCod, $ateCod);
            $odoPrealCod = $this->salvarProcedimentosRealizados($post, $odoPconCod);
            Zend_Db_Table::getDefaultAdapter()->commit();
            $this->carregaDadosForm();
            $this->view->dialog = array("Confirmação", "Dados salvo com sucesso!", 300, 140);

            $uni_desc_controle = $this->_request->getParam("uni_desc");
            $uni_codigo_controle = $this->_request->getParam("uni_codigo");

            $data_atendimento_controle = $this->_getParam("data_atendimento");
            $data_atendimento_controle = explode('/', $data_atendimento_controle);
            $data_atendimento_controle = implode('-', $data_atendimento_controle);

            $usr_nome_controle = $this->_request->getParam("usr_nome");

            $usr_codigo_controle = $this->_request->getParam("usr_codigo");

            $usr_codigo_controle = $this->_request->getParam("usr_codigo");

            $esp_codigo_controle = $this->_request->getParam("esp_codigo");

            $valida = $this->_getParam("valida");

            //return $this->_redirect("/programas-federais/ficha-odontologica/");
            if (!$valida)
                return $this->_redirect("/programas-federais/ficha-odontologica/form/uni_desc_controle/" . $uni_desc_controle . "/uni_codigo_controle/" . $uni_codigo_controle . "/data_atendimento_controle/" . $data_atendimento_controle . "/usr_nome_controle/" . $usr_nome_controle . "/usr_codigo_controle/" . $usr_codigo_controle . "/esp_codigo_controle/" . $esp_codigo_controle . "/");
            else
                return $this->_redirect("/programas-federais/ficha-odontologica/inconsistencias");

        } catch (Exception $exc) {
            Zend_Db_Table::getDefaultAdapter()->rollBack();
            $this->carregaDadosForm();
            $this->view->erro = $exc->getMessage();
            return $this->render("form");
        }
    }

    public function salvarAgendamento($post = FALSE)
    {
        $dados = array(
            "coni_codigo" => 0,
            "uni_codigo" => $this->_request->getPost("uni_codigo", FALSE),
            "usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
            "age_paciente" => $this->_request->getPost("usu_nome", FALSE),
            "age_data" => $this->_request->getPost("data_atendimento", FALSE),
            "age_horario" => $this->_request->getPost("dt_hora_inicial", FALSE),
            "esp_codigo" => $this->_request->getPost("esp_codigo", FALSE),
            "med_codigo" => $this->_request->getPost("usr_codigo", FALSE),
            "esp_codigo" => $this->_request->getPost("esp_codigo", FALSE),
            "age_atendido" => "A",
            "dt_cadastro" => "NOW()",
            "tat_codigo" => $this->_request->getPost("tipo_atend", FALSE),
            "tp_cod" => $this->_request->getPost("tipo_cons", FALSE),
            "proc_codigo" => 5450
        );
        if ($this->_request->getPost("age_codigo", FALSE)) {
            $dados["age_codigo"] = $this->_request->getPost("age_codigo", FALSE);
        }
        $tbAge = new Application_Model_Agendamento();
        try {
            return $tbAge->salvar($dados);
        } catch (Exception $exc) {
            return $exc->getMessage();
        }
    }

    public function salvarAtendimento($post = FALSE, $ageCod = FALSE)
    {
        $dados = array(
            "ate_data" => $this->_request->getPost("data_atendimento", FALSE),
            "ate_hora" => $this->_request->getPost("dt_hora_inicial", FALSE),
            "med_codigo" => $this->_request->getPost("usr_codigo", NULL),
            "usu_codigo" => $this->_request->getPost("usu_codigo", NULL),
            "usr_equipe_codigo" => $this->_request->getPost("cod_equipe", NULL),
            "age_codigo" => $ageCod,
            "uni_codigo" => $this->_request->getPost("uni_codigo"),
            "ate_atendido" => "S",
            "co_local_atend" => $this->_request->getPost("co_local_atend", FALSE),
            "turno" => $this->_request->getPost("turno", FALSE),
            "neces_especial" => ($this->_request->getPost("neces_especial", FALSE) ? 't' : 'f'),
            "gestante" => ($this->_request->getPost("gestante", FALSE) ? 't' : 'f')
        );
        if ($this->_request->getPost("ate_codigo", FALSE)) {
            $dados["ate_codigo"] = $this->_request->getPost("ate_codigo", FALSE);
        }
        $tbAte = new Application_Model_Atendimento();
        try {
            return $tbAte->salvarAtendimento($dados);
        } catch (Exception $exc) {
            die($exc->getMessage());
            return $exc->getMessage();
        }
    }

    public function salvarCondutas($post = FALSE, $ateCod = FALSE)
    {
        $tbTipEnc = new Application_Model_RlCdsAtendOdontoTipoEncam();
        try {
            $tbTipEnc->excluirPorAtendimento($ateCod);
        } catch (Exception $exc) {
            die($exc->getMessage());
            return $exc->getMessage();
        }
        foreach ($post["conduta"] as $val) {
            $dados = "";
            $dados = array(
                "ate_codigo" => $ateCod,
                "tp_cds_encam_odonto" => $val
            );
//            if ($this->_request->getPost("co_rl_cds_atend_odonto_tipo_encam", FALSE)) {
//                $dados["co_rl_cds_atend_odonto_tipo_encam"] = $this->_request->getPost("co_rl_cds_atend_odonto_tipo_encam", FALSE);
//            }

            try {
                $tbTipEnc->salvar($dados);
            } catch (Exception $exc) {
                die($exc->getMessage());
                return $exc->getMessage();
            }
        }
        //die("salvou");
    }

    public function salvarVigilanciaBucal($post = FALSE, $ateCod = FALSE)
    {
        $tbRlVig = new Application_Model_RlCdsAtendOdontTipVigBuc();
        try {
            $tbRlVig->excluirPorAtendimento($ateCod);
        } catch (Exception $exc) {
            die($exc->getMessage());
            return $exc->getMessage();
        }
        foreach ($post["vigilancia"] as $val) {
            $dados = "";
            $dados = array(
                "ate_codigo" => $ateCod,
                "tp_cds_vig_saude_bucal" => $val
            );

//            if ($this->_request->getPost("co_rl_cds_atend_odont_tip_vig_buc", FALSE)) {
//                $dados["co_rl_cds_atend_odont_tip_vig_buc"] = $this->_request->getPost("co_rl_cds_atend_odont_tip_vig_buc", FALSE);
//            }

            try {
                $tbRlVig->salvar($dados);
            } catch (Exception $exc) {
                die($exc->getMessage());
                return $exc->getMessage();
            }
        }
    }

    public function salvarTratamento($post = FALSE, $ateCod = FALSE)
    {
        $dados = array(
            "odo_trat_dtinicial" => $this->_request->getPost("dt_atend_inicial") . " " . $this->_request->getPost("dt_hora_inicial"),
            "odo_trat_dtfinal" => "NOW()",
            "odo_trat_status" => 'F',
            "ate_codigo_origem" => $ateCod
        );


        if ($this->_request->getPost("odo_trat_codigo", FALSE)) {
            $dados["odo_trat_codigo"] = $this->_request->getPost("odo_trat_codigo", FALSE);
        }

        $tbOdoTrat = new Application_Model_OdontoTratamento();
        try {
            return $tbOdoTrat->salvar($dados);
        } catch (Exception $exc) {
            die($exc->getMessage());
            return $exc->getMessage();
        }
    }

    public function salvarProcedimentoControle($odoTratCod = FALSE, $ateCod = FALSE)
    {
        $dados = array(
            "odo_trat_codigo" => $odoTratCod,
            "ate_codigo" => $ateCod
        );

        if ($this->_request->getPost("odo_pcon_codigo", FALSE)) {
            $dados["odo_pcon_codigo"] = $this->_request->getPost("odo_pcon_codigo", FALSE);
        }

        $tbProcCont = new Application_Model_OdontoProcedimentosControle();
        try {
            return $tbProcCont->salvar($dados);
        } catch (Exception $exc) {
            die($exc->getMessage());
            return $exc->getMessage();
        }
    }

    public function salvarProcedimentosRealizados($post, $odoPconCod)
    {
        $procedimentos = $post["procedimento"];
        $qtdeProcedimentos = $post["qtdeProc"];

        for ($i = 0; $i < count($procedimentos); $i++) {

            for ($j = 0; $j < $qtdeProcedimentos[$i]; $j++) {
                $dados = "";
                $dados = array(
                    "odo_pcon_codigo" => $odoPconCod,
                    "proc_codigo" => $procedimentos[$i],
                    "odo_preal_dtcadastro" => "NOW()"
                );
                $tbProcRea = new Application_Model_OdontoProcedimentosRealizados();

//                if($this->_request->getPost("odo_preal_codigo", FALSE)){
//                    $dados["odo_preal_codigo"] = $this->_request->getPost("odo_preal_codigo", FALSE);
//                }

                try {
                    $tbProcRea->salvar($dados);
                } catch (Exception $exc) {
                    die($exc->getMessage());
                    return $exc->getMessage();
                }
            }
        }
    }

    public function buscarAction()
    {
        $this->view->title = "Ficha Odontológica";

        if ($this->_request->getPost("busca") != "") {
            $term = $this->_request->getPost("busca");
        } else {
            $term = $this->_request->getPost("busca2");
        }
        $tipoBusca = $this->_request->getPost("tipo_busca");
        $tbAte = new Application_Model_Atendimento();
        $this->view->dados = $tbAte->getAtendimentosOdontologicosProfissionais($term, $tipoBusca);
        return $this->render("index");
    }

    public function excluirAction()
    {

        $this->view->title = "Ficha Odontológica";

        $ateCod = $this->_request->getParam("id");

        $tbCond = new Application_Model_RlCdsAtendOdontoTipoEncam();
        $tbVig = new Application_Model_RlCdsAtendOdontTipVigBuc();
        $tbProc = new Application_Model_OdontoProcedimentosRealizados();
        $tbProcCont = new Application_Model_OdontoProcedimentosControle();
        $tbTrat = new Application_Model_OdontoTratamento();
        $tbAte = new Application_Model_Atendimento();
        $tbEsusOdonto = new Application_Model_EsusOdonto();
        $tbProcAte = new Application_Model_ProcedimentoAtendimento();

        $dadosAte = $tbAte->getDadosAtendimentosOdontologico($ateCod);
        try {
            $tbCond->excluirPorAtendimento($ateCod);
            $tbVig->excluirPorAtendimento($ateCod);
            $tbProc->excluirPorProcedimentoControle($dadosAte->odo_pcon_codigo);
            $tbEsusOdonto->excluirPorOdoPconCodigo($dadosAte->odo_pcon_codigo);
            $tbProcCont->excluirPorAtendimento($ateCod);
            $tbTrat->excluirPorAtendimento($ateCod);
            $tbProcAte->excluirProcedimentosAtendimento($ateCod);
            $tbAte->excluir($ateCod);

            $this->view->dados = $tbAte->getAtendimentosOdontologicos();
            $this->view->dialog = array("Confirmação", "Dados excluído com sucesso!", 300, 140);

            return $this->render("ficha-odontologica/index", NULL, TRUE);
        } catch (Exception $ex) {
            $ex->getMessage();
            $this->view->dados = $tbAte->getAtendimentosOdontologicos();
            $this->view->erro = $ex->getMessage();

            return $this->render("index");
        }
    }

    public function inconsistenciasAction()
    {
        $this->view->title = 'E-SUS Inconsistências Odontologia';
        $uuid = $this->_request->getPost("uuid");
        if ($uuid) {
            $tbEsusOdo = new Application_Model_EsusOdonto();
            $this->view->dados = $tbEsusOdo->getDadosPorUuid($uuid);
        }
    }

    public function editaInconsistenciaAction()
    {
        $id = $this->_request->getParam("id");
        $tbEsusOdo = new Application_Model_EsusOdonto();
        $this->view->dados = $tbEsusOdo->getDadosPorId($id);
        $selected = $tbEsusOdo->getDadosPorId($id)->co_local_atend;
        $tbLocal = new Application_Model_TbLocalAtend();
        $this->view->selectLocais = $tbLocal->selectTag($selected);
    }

    public function salvarEditaInconsistenciasAction()
    {
        $dados = $_POST;
        $id = $dados["eo_codigo"];
        $dtNasc = $dados["eo_dtnascimento"];
        $cnsProf = $dados["eo_profissional_cns"];
        $cnsPac = $dados["eo_num_cartao_sus"];
        // Dados do atendimento
        $tbEsusOdo = new Application_Model_EsusOdonto();
        $this->view->dados = $tbEsusOdo->getDadosPorId($id);
        $selected = $tbEsusOdo->getDadosPorId($id)->co_local_atend;
        $tbLocal = new Application_Model_TbLocalAtend();
        $this->view->selectLocais = $tbLocal->selectTag($selected);
        // Funções de validação
        $tbFun = new Application_Model_Funcoes();
        if ($tbFun->ValidaData($dtNasc) == 1) {
            if ($tbFun->validaCnsGeral($cnsProf) == 1) {
                if ($tbFun->validaCnsGeral($cnsPac) == 1) {
                    try {
                        $dados["uuid"] = null;
                        $tbEsusOdo->salvar($dados);
                        $this->view->dialog = array("Confirmação", "Dados salvo com sucesso!", 300, 140);
                        $this->_redirect("programas-federais/ficha-odontologica/inconsistencias");
                    } catch (Exception $exc) {
                        $this->view->erro = $exc->getMessage();
                    }
                } else {
                    $this->view->erro = "Erro! CNS paciente inválido!";
                }
            } else {
                $this->view->erro = "Erro! CNS profissional inválido!";
            }
        } else {
            $this->view->erro = "Erro! Data de nascimento inválida!";
        }
        return $this->render("ficha-odontologica/edita-inconsistencia", NULL, TRUE);
    }


}
