<?php

class ProgramasFederais_FichaVacinacaoController extends Zend_Controller_Action
{

  public function init()
  {

  }

  public function indexAction()
  {
    $this->view->title = "Ficha de Vacinação";
    $tbEfv = new Application_Model_EsusFichaVacinacao();
    $this->view->dados = $tbEfv->buscarFichas();

  }

  public function formAction()
  {
    $codFicha = $this->_request->getParam("id");
    $this->carregaDadosForm($codFicha);
    $this->view->title = "Ficha de Vacinação";
  }

  public function carregaDadosForm($codFicha)
  {
    $tbEfv = new Application_Model_EsusFichaVacinacao();
    $tbFvv = new Application_Model_EsusFichaVacinacaoVacinas();
    $this->view->imunobiologico = (new Application_Model_TbVacinaImunobiologico())->getImunobiologicos();
    $this->view->estrategia = (new Application_Model_TbVacinaEstrategia())->getEstrategias();
    $this->view->dose = (new Application_Model_TbVacinaDose())->getDoses();
    if ($codFicha) {
      $dados = $tbEfv->getDadosPorId($codFicha);
      $this->view->dados = $dados;
      $this->view->dadosUsu = (new Application_Model_Usuario())->buscaDadosEspeciais($dados->usu_codigo);
      $this->view->especialidades = (new Application_Model_Especialidade())->getEspecialidadePorProfissional($dados->usr_codigo);
      $this->view->vacinas = $tbFvv->getDadosPorFicha($codFicha);
    }
    $this->view->locais = (new Application_Model_TbLocalAtend())->fetchAll("co_local_atend NOT IN (14,15)");
  }

  public function salvarAction()
  {
    $valida = $this->_request->getPost("uuid_ficha", FALSE);
    Zend_Db_Table::getDefaultAdapter()->beginTransaction();

    try {

      $tbUsu = new Application_Model_Usuario();
      $dadosUsu = array(
        "usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
        "usu_tem_diabete" => $this->_request->getPost("diabetico", FALSE),
        "usu_esta_gestante" => $this->_request->getPost("gestante", FALSE),
        "usu_tem_hipertensao" => $this->_request->getPost("hipertensao", FALSE),
        "risco_idoso" => $this->_request->getPost("risco_idoso", FALSE),
        "risco_crianca" => $this->_request->getPost("risco_crianca", FALSE),
        "risco_diabetes" => $this->_request->getPost("risco_diabetes", FALSE),
        "risco_gestacao" => $this->_request->getPost("risco_gestacao", FALSE),
        "risco_hipertensao" => $this->_request->getPost("risco_hipertensao", FALSE),
        "risco_psico" => $this->_request->getPost("risco_psico", FALSE)
      );
      $tbUsu->salvar($dadosUsu);

      $tbEfv = new Application_Model_EsusFichaVacinacao();
      $tbFvv = new Application_Model_EsusFichaVacinacaoVacinas();
      $dadosFicha = array(
          "co_local_atend" =>$this->_request->getPost("co_local_atend", FALSE),
          "uni_codigo"=>$this->_request->getPost("uni_codigo", FALSE),
          "efv_data"=>$this->_request->getPost("efv_data", FALSE),
          "efv_turno"=>$this->_request->getPost("efv_turno", FALSE),
          "usu_codigo"=>$this->_request->getPost("usu_codigo", FALSE),
          "usr_codigo"=>$this->_request->getPost("usr_codigo", FALSE),
          "esp_codigo"=>$this->_request->getPost("esp_codigo", FALSE),
          "usr_equipe_codigo"=>$this->_request->getPost("cod_equipe", FALSE),
          "efv_viajante"=>($this->_request->getPost("efv_viajante",NULL) == 'on' ? TRUE : FALSE),
          "efv_gestante"=>($this->_request->getPost("efv_gestante", NULL) == 'on' ? TRUE: FALSE) ,
          "efv_puerpera"=>($this->_request->getPost("efv_puerpera", NULL) == 'on' ? TRUE: FALSE),
      );
      if($this->_request->getPost("efv_codigo", FALSE)){
        $dadosFicha['efv_codigo'] = $this->_request->getPost("efv_codigo", FALSE);
      }
        if($this->_request->getPost("uuid_ficha", FALSE)){
            $dadosFicha['uuid_ficha'] = NULL;
        }
      $tbUni = new Application_Model_Unidade();
      $cod_ibge = $tbUni->buscarCidadeDaUnidade($dadosFicha['uni_codigo'])->toArray();
      $dadosFicha['efv_cod_igbe_mun'] = $cod_ibge[0]['uni_codigo_ibge'];

      $vacinas = $this->_request->getPost("fvv", FALSE);

      foreach ($vacinas as $vacina){
          if($vacina['tvi_codigo'] == 15){
              $dadosFicha['efv_hanseniase'] = $vacina['efv_hanseniase'];
          }
      }

      $efv_codigo = $tbEfv->salvar($dadosFicha);

      foreach ($vacinas as $vacina){
          $dadosVac = array(
            'efv_codigo' => $efv_codigo,
            'tvi_codigo' => $vacina['tvi_codigo'],
            'tve_codigo' => $vacina['tve_codigo'],
            'tvd_codigo' => $vacina['tvd_codigo'],
            'tvd_lote' => $vacina['tvd_lote'],
            'tvd_fabricante' => $vacina['tvd_fabricante'],
          );
          if($vacina['fvv_codigo']){
              $dadosVac['fvv_codigo'] = $vacina['fvv_codigo'];
          }
          $tbFvv->salvar($dadosVac);
      }

      Zend_Db_Table::getDefaultAdapter()->commit();

      if (!$valida){
          $this->view->dados = array("success"=>TRUE, "inconsistencia"=>FALSE);
          return $this->render("dados", NULL, TRUE);
      } else{
          $this->view->dados = array("success"=>TRUE, "inconsistencia"=>TRUE);
          return $this->render("dados", NULL, TRUE);
      }

    } catch (Exception $exc) {
      Zend_Db_Table::getDefaultAdapter()->rollBack();
      $this->view->dados = array("success"=>FALSE, "mensagem" => $exc->getMessage());
      return $this->render("dados", NULL, TRUE);
    }
  }


  public function buscarAction()
  {
    $this->view->title = "Ficha Vacinação";

    if ($this->_request->getPost("busca") != "") {
      $term = $this->_request->getPost("busca");
    } else {
      $term = $this->_request->getPost("busca2");
    }
    $tipoBusca = $this->_request->getPost("tipo_busca");
    $tbEfv = new Application_Model_EsusFichaVacinacao();
    $this->view->dados = $tbEfv->buscarFichas($term, $tipoBusca);
    return $this->render("index");
  }

  public function excluirAction()
  {

    $this->view->title = "Ficha Vacinação";

    $efcCod = $this->_request->getParam("id");

    $tbEfv = new Application_Model_EsusFichaVacinacao();
    $tbFvv = new Application_Model_EsusFichaVacinacaoVacinas();

      Zend_Db_Table::getDefaultAdapter()->beginTransaction();
    try {

      $vacinacoes = $tbFvv->getDadosPorFicha($efcCod);
      foreach ($vacinacoes as $vac){
          $tbFvv->excluir($vac->fvv_codigo);
      }
      $tbEfv->excluir($efcCod);
        Zend_Db_Table::getDefaultAdapter()->commit();
      $this->view->dados = $tbEfv->buscarFichas();
      $this->view->dialog = array("Confirmação", "Dados excluído com sucesso!", 300, 140);

      return $this->render("index");

    } catch (Exception $ex) {
      $ex->getMessage();
      $this->view->dados = $tbEfv->buscarFichas();
      $this->view->erro = $ex->getMessage();
        Zend_Db_Table::getDefaultAdapter()->rollBack();
      return $this->render("index");
    }
  }

  public function excluirVacinacaoAction()
  {
    $fvvCod = $this->_request->getParam("id");
    $tbEfvv = new Application_Model_EsusFichaVacinacaoVacinas();

    try {
      $tbEfvv->excluir($fvvCod);
      $this->view->dados = array("success"=> TRUE);
      return $this->render("dados", NULL, TRUE);
    } catch (Exception $ex) {
      $this->view->dados = array("success"=>FALSE, "mensagem"=>$ex->getMessage());
      return $this->render("dados", NULL, TRUE);
    }

  }

  public function inconsistenciasAction()
  {
    $this->view->title = 'E-SUS Inconsistências da Ficha de Vacinação';
    $uuid = $this->_request->getPost("uuid");
    if ($uuid) {
      $tbEsusVac = new Application_Model_EsusFichaVacinacao();
      $this->view->dados = $tbEsusVac->getDadosPorUuid($uuid);
    }
  }

  public function editaInconsistenciaAction()
  {
    $id = $this->_request->getParam("id");
    $tbEsusOdo = new Application_Model_EsusOdonto();
    $this->view->dados = $tbEsusOdo->getDadosPorId($id);
    $selected = $tbEsusOdo->getDadosPorId($id)->co_local_atend;
    $tbLocal = new Application_Model_TbLocalAtend();
    $this->view->selectLocais = $tbLocal->selectTag($selected);
  }

  public function salvarEditaInconsistenciasAction()
  {
    $dados = $_POST;
    $id = $dados["eo_codigo"];
    $dtNasc = $dados["eo_dtnascimento"];
    $cnsProf = $dados["eo_profissional_cns"];
    $cnsPac = $dados["eo_num_cartao_sus"];
    // Dados do atendimento
    $tbEsusOdo = new Application_Model_EsusOdonto();
    $this->view->dados = $tbEsusOdo->getDadosPorId($id);
    $selected = $tbEsusOdo->getDadosPorId($id)->co_local_atend;
    $tbLocal = new Application_Model_TbLocalAtend();
    $this->view->selectLocais = $tbLocal->selectTag($selected);
    // Funções de validação
    $tbFun = new Application_Model_Funcoes();
    if ($tbFun->ValidaData($dtNasc) == 1) {
      if ($tbFun->validaCnsGeral($cnsProf) == 1) {
        if ($tbFun->validaCnsGeral($cnsPac) == 1) {
          try {
            $dados["uuid"] = null;
            $tbEsusOdo->salvar($dados);
            $this->view->dialog = array("Confirmação", "Dados salvo com sucesso!", 300, 140);
            $this->_redirect("programas-federais/ficha-odontologica/inconsistencias");
          } catch (Exception $exc) {
            $this->view->erro = $exc->getMessage();
          }
        } else {
          $this->view->erro = "Erro! CNS paciente inválido!";
        }
      } else {
        $this->view->erro = "Erro! CNS profissional inválido!";
      }
    } else {
      $this->view->erro = "Erro! Data de nascimento inválida!";
    }
    return $this->render("ficha-odontologica/edita-inconsistencia", NULL, TRUE);
  }

  public function buscarEstrategiaPorImunobiologicoAction(){
      $tvi_codigo = $this->_request->getParam("tvi_codigo");

      $tbRl = new Application_Model_RlVacinaEstrategiaImunobiologico();

      $this->view->dados = $tbRl->getEstrategia($tvi_codigo)->toArray();

      return $this->render("dados",NULL,TRUE);
  }

  public function buscarDosePorImunobiologicoEstrategiaAction(){
      $imuno = $this->_request->getParam("tvi_codigo");
      $estrategia = $this->_request->getParam("tve_codigo");

      $tbRl = new Application_Model_RlVacinaEstrategiaImunobiologico();

      $this->view->dados = $tbRl->getDose($imuno,$estrategia)->toArray();

      return $this->render("dados",NULL,TRUE);
  }

}
