<?php
require_once __DIR__ . "/../../Util.php";

class Prontuario_AgendaDoDiaController extends Zend_Controller_Action {

	public function init() {
		$this->_helper->acl->copiarPermissao("zf/prontuario/index");
		Zend_Layout::getMvcInstance()->setLayout("prontuario");
	}

	public function indexAction() {
		$this->view->title = "Pacientes Agendados";
		$tbAgenda = new Application_Model_Agendamento();
		$usr_codigo = $this->_getParam("usr_codigo", FALSE);
		$tbAte = new Application_Model_Atendimento();
		$retornos = $tbAte->getRetorno();

		foreach ($retornos as $key => $retorno){
		    $retornos[$key]['pe_status'] = (new Application_Model_PostoEnfermagem)->getUltima($retorno['age_codigo'])->pe_status;
        }
		$this->view->retornos = $retornos;

		try {
			$this->view->itens = $tbAgenda->getAgenda($usr_codigo);
		} catch (Zend_Validate_Exception $e) {
			$this->view->erro = $e->getMessage();
			return $this->render("erro", NULL, TRUE);
		}

		$tbUsr = new Application_Model_Usuarios();
		$this->view->medico = $tbUsr->getUsrAtual();
		$this->view->data = date('d/m/Y');
		$pacem = $this->_getParam("pacem", FALSE);
		$this->view->pacem = $pacem;
		$this->view->isMedico = $tbUsr->isMedico();
		if ($pacem == 2) {
			$this->view->dialog = array("Alerta", "Esse paciente já está sendo atendido por outro profissional!", 300, 140);
			return;
		}
	}

	public function atendidosAction() {
		$this->view->title = "Pacientes Atendidos Hoje";
		$tbAte = new Application_Model_Atendimento();
		$this->view->itens = $tbAte->buscarAtendidos();
		$tbUsr = new Application_Model_Usuarios();
		$this->view->medico = $tbUsr->getUsrAtual();
		$this->view->data = date('d/m/Y');
	}

	public function ematendimentoAction() {
		$this->view->title = "Pacientes Em Atendimento";
		$tbAte = new Application_Model_Atendimento();
		$this->view->itens = $tbAte->buscarEmAtendimento();
		$tbUsr = new Application_Model_Usuarios();
		$this->view->medico = $tbUsr->getUsrAtual();
		$this->view->data = date('d/m/Y');
	}

	public function historicoAction() {
		$this->view->title = "Histórico de Atendimento";
		$tbAge = new Application_Model_Agendamento();
		$this->view->itens = $tbAge->getHistoricoAgendamento();
	}

	public function finalizarAction() {
		$condutasEncaminhamentos = $this->_request->getPost('condutas');
		$encaminhamento = $this->_request->getPost('encaminhamento', FALSE);
		$tipoMedico = $this->_request->getPost('tipoMedico');
		$ateCodigo = $this->_request->getPost('ateCodigo');

		$agess_codigo = $this->_getParam("age", 1);
		$tbAge = new Application_Model_Agendamento();
		$tbAte = new Application_Model_Atendimento();
		$tbUsr = new Application_Model_Usuarios();


		if($encaminhamento){
            $enc = $this->montaArrayCondutas($encaminhamento);
            $age = $tbAge->usuEmAberto();
            $dados = [
                "age_data"=> $age->age_data,
                "med_codigo"=>$enc[0],
                "usu_codigo"=>$age->usu_codigo,
                "age_tipo"=>"ES",
                "age_atendido"=>"P",
                "age_paciente"=>$age->age_paciente,
                "uni_codigo"=>$age->uni_codigo,
                "age_item"=>"AL",
                "age_status"=>"PF",
                "esp_codigo"=>$enc[1],
                "tat_codigo"=>$age->tat_codigo,
                "proc_codigo"=>$enc[2],
                "coni_codigo"=>null,
                "usr_codigo_cad" => $tbUsr->getUsrAtual()->usr_codigo,
                "age_horario" => date("H:i")
            ];
            try{
                $tbAge->salvarAgendamento($dados);
            } catch (Exception $e){
             die($e->getMessage());
            }
        }

		if ($tipoMedico == 'D') {
			$this->salvarCondutas($this->montaArrayCondutas($condutasEncaminhamentos), $ateCodigo);
		} else {
			$this->salvarCondutasInd($this->montaArrayCondutas($condutasEncaminhamentos), $ateCodigo);
		}
		$tbAge->finalizar();

		// Essa parte precisa ser arrumada porque ao finalizar um atendimento
		// que não é retorno da problema
		$retorno_origem = $tbAte->buscaRetornoOrigem($agess_codigo);
		$tbAte->finalizaRetorno($retorno_origem->ate_codigo);
		return $this->_redirect("/prontuario/agenda-do-dia/");
	}

	private function montaArrayCondutas($condutasEncaminhamentos) {
		$condutas = [];
		foreach ($condutasEncaminhamentos as $key => $value) {
			$condutas[$key] = $value['value'];
		}

		return $condutas;
	}

	private function salvarCondutas($post = FALSE, $ateCod = FALSE) {
		try {
			if (is_array($post) && count($post) > 0) {
				$tbTipEnc = new Application_Model_RlCdsAtendOdontoTipoEncam();
				$tbTipEnc->excluirPorAtendimento($ateCod);
				foreach ($post as $val) {
					$condutas = array(
						"ate_codigo" => $ateCod,
						"tp_cds_encam_odonto" => $val
					);
					$tbTipEnc->salvar($condutas);
				}
				return true;
			}
			return false;
		} catch (Exception $e) {
			return $e->getMessage();
		}
	}

	private function salvarCondutasInd($post = FALSE, $ateCod = FALSE) {
		try {
			if (is_array($post) && count($post) > 0) {
				$tbCond = new Application_Model_RlCdsAtendIndividualCondut();
				$tbCond->excluirPorAtendimento($ateCod);
				foreach ($post as $val) {
					$dados = array(
						"ate_codigo" => $ateCod,
						"tp_cds_conduta" => $val
					);
					$tbCond->salvar($dados);
				}
				return true;
			}
			return false;
		} catch (Exception $e) {
			return $e->getMessage();
		}
	}

	public function verificaStatusAction() {
		$age_codigo = $this->_getParam("age_codigo");
		$tbAge = new Application_Model_Agendamento();
		$usuario = $tbAge->getDadosAgendamentoUsuario($age_codigo)->usr_cod_status;
		if (trim($usuario) !== trim($_SESSION[id_login])) {
			$this->view->dados = "Este atendimento foi transferido para outro profissional";
		} else {
			$this->view->dados = "";
		}
		return $this->render("dados", NULL, TRUE);
	}

	public function retornoAction() {
		$age_codigo = $this->_getParam("age", 1);
		$ate_codigo = $this->_getParam("ate_codigo", 1);
		$condutasEncaminhamentos = $this->_getParam('condutas');
		$tipoMedico = $this->_getParam('tipoMedico');

		$tbAge = new Application_Model_Agendamento();
		$tbAge->alteraSituacao("A", $age_codigo);
		Util::alteraStatusAgendamento($age_codigo, Util::AGUARD_RETORNO);

		if ($tipoMedico == 'D') {
			$this->salvarCondutas($this->montaArrayCondutas($condutasEncaminhamentos), $ate_codigo);
		} else {
			$this->salvarCondutasInd($this->montaArrayCondutas($condutasEncaminhamentos), $ate_codigo);
		}

		$tbAte = new Application_Model_Atendimento();
		$dadosAte = array("ate_codigo" => $ate_codigo, "ate_encaminhamento" => "S");
		$tbAte->salvar($dadosAte);
	}

	public function buscarAction() {
		$dados = array("med_codigo" => $this->_request->getPost("usr_codigo", NULL),
			"usu_codigo" => $this->_request->getPost("usu_codigo", NULL),
			"ate_data" => $this->_request->getPost("ate_data", NULL),
			"pre" => $this->_request->getPost("pre", NULL),
			"ate" => $this->_request->getPost("ate", NULL));
		$tbAte = new Application_Model_Atendimento();
		$tbUsr = new Application_Model_Usuarios();
		$this->view->medico = $tbUsr->getInfoUsr($this->_request->getPost("usr_codigo", NULL));
		$this->view->data = $this->_request->getPost("ate_data", NULL);
		$this->view->itens = $tbAte->buscarAtendidos($dados);
		$this->view->title = "Pacientes Agendados";
		return $this->render("atendidos");
	}

}
