<?php

class Prontuario_AnexoController extends Zend_Controller_Action {

	public function init() {
		$this->_helper->acl->copiarPermissao("zf/prontuario/index");
		Zend_Layout::getMvcInstance()->setLayout("prontuario");
		$this->view->title = "Anexo de Arquivos";
	}

    public function anexarAction(){

        $this->view->title = "Anexo de Arquivos";
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/default/paciente/anexar.js');
        $usu_codigo = $this->_getParam("id", FALSE);

        if($usu_codigo){
            $tbUsu = new Application_Model_Usuario();
            $this->view->usuario = $tbUsu->getUsuarioPorId($usu_codigo);
            $this->view->itens = (new Application_Model_UsuarioAnexos())->getAnexosByUsuario($usu_codigo);
            $this->view->tipos = (new Application_Model_TipoDocumento())->listar();
        }
    }

}

