<?php

require_once __DIR__.'/../../Util.php';

class Prontuario_AtendimentoController extends Zend_Controller_Action {

    public function init() {
        $this->_helper->acl->copiarPermissao("zf/prontuario/index");
        Zend_Layout::getMvcInstance()->setLayout("prontuario");
        $this->view->title = "Atendimento";

    }

    public function indexAction() {

        $obs = $this->_getParam("obs", FALSE);
        $io_codigo = $this->_getParam("io_codigo", FALSE);
        $ate_codigo = $this->_getParam("ate_codigo", FALSE);
        $usu_codigo_leito = $this->_getParam("usu_codigo", FALSE);
        $readonly = $this->_getParam("readonly", FALSE);
        $tbAte = new Application_Model_Atendimento();
        $tbUsr = new Application_Model_Usuarios();
        $tbUsu = new Application_Model_Usuario();

        $tbAge = new Application_Model_Agendamento();
        $age_codigo = $this->_getParam("age_codigo", FALSE);
        if($age_codigo){
            $dados = $tbAge->getDadosAgendamentoUsuario($age_codigo);
            $this->view->tipo_consulta = $dados->tp_cod;
            $this->view->dadosPaciente = $dados;


            if(trim($dados->usr_cod_status) != trim($_SESSION['id_login'])){
                header('Location: '.$_SERVER['PHP_SELF']."prontuario/agenda-do-dia");
            }
        }

        if($_SESSION['prontuario']['age']->usu_codigo){
            $usuSexo = $tbUsu->getSexo($_SESSION['prontuario']['age']->usu_codigo);
        } else {
            $usuSexo = $tbUsu->getSexo($usu_codigo_leito);
        }
        $this->view->usu_sexo = $usuSexo[0]['usu_sexo'];
        $tbLocal = new Application_Model_TbLocalAtend();
        $tbTipoCond = new Application_Model_TbCdsTipoConduta();
        if(empty($ate_codigo) && !empty($io_codigo)){ // CASO SEJA PRIMEIRA TELA DA INTERNAÇÃO ENTRA AQUI PARA LIMPAR OS COOKIES
            setcookie("ate_reclamacao", ' ');
        }
        if (!$obs) {
            // traz o ultimo atendimento realizado e só é utilizado se não for um retorno
            $ate_dados = $tbAte->buscar();

            // traz o primeiro atendimento para verificar se é um retorno
            $ate_origem = $tbAte->buscaRetornoOrigem();
            // se nao for retorno carrega as informacoes do atendimento anterior na tela
            if ($ate_origem->ate_encaminhamento != "S") {
                $this->view->dados = $ate_dados;
                if(!$this->view->dadosPaciente){
                    $this->view->dadosPaciente  = $ate_dados;
                }


                /*
                 * CASO NAO FOR RETORNO ELE MANDA TODAS INFORMACOES DO ATENDIMENTO PRA VIEW (UPDATE OU INSERT)
                 */
            } else {//senao manda a informacao para a view de que é um retorno
                /*
                 * PEGA O ATENDIMENTO QUE GEROU O RETORNO E COLOCA NO HIDDEN DA VIEW
                 * O SALVAR PEGA A INFORMAÇÃO DO HIDDEN POR POST E COLOCA NO ATe_CODIGO_ORIGEM
                 */

                //Checa se o atendimento de origem já foi reavaliado
				$ate_codigo_reavaliado = $tbAte->checaReavaliacao($ate_origem->age_codigo);
				if(!$ate_codigo_reavaliado) {
					$this->view->dados = (object)array("ate_encaminhamento" => $ate_dados->ate_encaminhamento,
						"usu_nome" => $ate_dados->usu_nome,
						"ate_hora" => date("H:i"));
				} else {
					$this->view->dados = $tbAte->buscar($ate_codigo_reavaliado->ate_codigo);
				}
            }
        } else {
            if ($ate_codigo) {
                $dados = (object) $tbAte->buscarInternacao($ate_codigo)->toArray();
                $this->view->dados = $dados;

            } else {
                $this->view->ate_hora = date("H:i");
            }
        }
        $this->view->usu_codigo_leito = $usu_codigo_leito;
        $this->view->obs = $obs;
        $this->view->readonly = $readonly == true ? true : false;
        $this->view->io_codigo = $io_codigo;
        $tbConf = new Application_Model_Configuracao();
        if($tbConf->getConfig("GRUPO_DOENCAS") == 1){
            $tbGruDoen = new Application_Model_GrupoDeDoencas();
            $this->view->grupo_doencas = $tbGruDoen->listaGrupoDeDoencasCid();
        }
        // Válida CID10
        $tbConf = new Application_Model_Configuracao();
        if($tbConf->getConfig("CID_OBRIGATORIO")) {
            $this->view->cid_obrigatorio = true;
        }

        $tbCiap = new Application_Model_TbCiap();
        $rlAteCiap = new Application_Model_RlCdsAtendIndividualCiap();
        $ate_dados;
        if($ate_dados->ate_codigo)
            $this->view->ciap_selecionados = $rlAteCiap->getCiapAtendimento($ate_dados->ate_codigo);

        $this->view->usr_tipo_medico = $tbUsr->getUsrAtual()->usr_tipo_medico;
        $this->view->uni_tipo = $tbUsr->getUsrAtual()->uni_tipo;
        $this->view->ciap = $tbCiap->getCiaps($ate_dados);
        // Validação Dados Ficha Odontologica E-SUS
        if ($tbUsr->getUsrAtual()->usr_tipo_medico=="D") {
            $this->view->usr_tipo_medico = $tbUsr->getUsrAtual()->usr_tipo_medico;
            $tbTipVig = new Application_Model_TbCdsTipoVigSaudeBucal();
            $tbTipCond = new Application_Model_TbCdsTipoEncamOdonto();
            $this->view->vigilancia = $tbTipVig->getDados();
            $this->view->conduta = $tbTipCond->getDados($this->view->tipo_consulta);
            $this->view->encaminhamentosOdonto = $tbTipCond->getEncaminhamentos();
            if ($ate_dados->ate_codigo) {
                $tbRlTipCond = new Application_Model_RlCdsAtendOdontoTipoEncam();
                $tbRlTipVig = new Application_Model_RlCdsAtendOdontTipVigBuc();
                $this->view->tipCond = $tbRlTipCond->getDadosPorAtendimento($ate_dados->ate_codigo)->toArray();
                $this->view->tipVig = $tbRlTipVig->getDadosPorAtendimento($ate_dados->ate_codigo)->toArray();
            }
        }
        // Inclusão select Locais e Condutas
        $this->view->selectLocais = $tbLocal->selectTag($ate_dados->co_local_atend);
        $this->view->conduta_ind = $tbTipoCond->getDados();
        $this->view->encaminhamentos = $tbTipoCond->getDadosEncaminhamento();
        $this->view->postoEnfermagem = '';
        if ($ate_dados->ate_codigo) {
            $tbRlAtenInd = new Application_Model_RlCdsAtendIndividualCondut();
            $this->view->tipCondInd = $tbRlAtenInd->getDadosPorAtendimento($ate_dados->ate_codigo)->toArray();
            $this->view->postoEnfermagem = (new Application_Model_PostoEnfermagem)->getUltima()->pe_codigo;
        }
        $this->view->ateCod = $ate_dados->ate_codigo;
        $this->view->ageCodigo = $age_codigo;

		//Checa se o CBO do profissional está autorizado a realizar atendimentos ou somente procedimentos
	    $tbAcessosFichaEsus = new Application_Model_AcessosFichaEsus();
	    $tbEsp = new Application_Model_Especialidade();

	    $usr = $tbUsr->getUsrAtual();
	    $especialidade = $tbEsp->getEspecialidade($usr->esp_codigo);
	    $this->view->acesso_atendimento = $tbAcessosFichaEsus->getAcessosFichaEsus($especialidade->cod_cbo, 'ai');

        $this->render($tbAte->textareaUnico() ? "unico" : "multiplo");
    }

    public function listaCidsAtendimentoAction(){
        $tbAte = new Application_Model_Atendimento();
        $codAtend = $this->_request->getPost("codAtend");
        $this->view->dados = $tbAte->listaCidsAtendimento($codAtend)->toArray();
        return $this->render("dados",NULL,TRUE);
    }

    public function getCidAtendimentoAction(){
        $age_codigo = Application_Model_Agendamento::usuEmAberto()->age_codigo;
        $tbAte = new Application_Model_Atendimento();
        $codAtend = $tbAte->getCodigoAtendimentoPorAgendamento($age_codigo)->ate_codigo;
        $cidCodigo = $tbAte->listaCidsAtendimento($codAtend)->cd10_codigo;
        $cidDesc = $tbAte->listaCidsAtendimento($codAtend)->cd10_codigo_desc;
        $dadosCid = array (
            "cidCodigo" => $cidCodigo,
            "cidDesc" => $cidDesc
        );
        $this->view->dados = $dadosCid;
        return $this->render("dados",NULL,TRUE);
    }

    public function atualizarCidsAction(){
        $tbAte = new Application_Model_Atendimento();
        $contCid = 0;
        $dadosAtuCids = array(
            "ate_codigo" =>  $this->_request->getPost("ate_codigo"),
        );
        $dadosAte = $tbAte->verificaCidsLivres($this->_request->getPost("ate_codigo"));
        //Verifica qual campo cid está livre e atualiza apenas o primeiro que estiver
        if (empty($dadosAte->cd10_codigo)){
            if ($contCid == 0){
                $dadosAtuCids["cd10_codigo"] = $this->_request->getPost("cd10_codigo");
                $tbAte->atualizaCids($dadosAtuCids);
                $contCid++;
            }
        }
        if (empty($dadosAte->cd10_codigos)){
            if ($contCid == 0){
                $dadosAtuCids["cd10_codigos"] = $this->_request->getPost("cd10_codigo");
                $tbAte->atualizaCids($dadosAtuCids);
                $contCid++;
            }
        }
        if (empty($dadosAte->cd10_codigot)){
            if ($contCid == 0){
                $dadosAtuCids["cd10_codigot"] = $this->_request->getPost("cd10_codigo");
                $tbAte->atualizaCids($dadosAtuCids);
                $contCid++;
            }
        }
        return $this->render("dados",NULL,TRUE);
    }

    public function excluirCidsAction(){
        $tbAte = new Application_Model_Atendimento();
        $codAte = $this->_request->getPost("ate_codigo");
        $codCid = $this->_request->getPost("cd10_codigo");
        $qtdRegCid10 = $tbAte->getQtdRegistrosAtendCid10($codAte,$codCid)->qtd_reg_cid10;
        $qtdRegCid10s = $tbAte->getQtdRegistrosAtendCid10s($codAte,$codCid)->qtd_reg_cid10s;
        $qtdRegCid10t = $tbAte->getQtdRegistrosAtendCid10t($codAte,$codCid)->qtd_reg_cid10t;
        if ($qtdRegCid10 == 1){
            $dadosAtuCids = array(
                "ate_codigo" =>  $codAte,
                "cd10_codigo" => NULL
            );
        }
        if ($qtdRegCid10s == 1){
            $dadosAtuCids = array(
                "ate_codigo" =>  $codAte,
                "cd10_codigos" => NULL
            );
        }
        if ($qtdRegCid10t == 1){
            $dadosAtuCids = array(
                "ate_codigo" =>  $codAte,
            "cd10_codigot" =>  NULL
            );
        }
        $tbAte->atualizaCids($dadosAtuCids);
        return $this->render("dados",NULL,TRUE);
    }

    public function atendimentoInternacaoAction() {
        $obs = $this->_getParam("obs", FALSE);
        $tbAte = new Application_Model_Atendimento();
        $this->view->dados = $tbAte->buscar();
        $this->view->obs = $obs;
        $this->render($tbAte->textareaUnico() ? "unico" : "multiplo");
    }

    public function salvarAction() {
        $tbUsu = new Application_Model_Usuario();
        if ($this->_request->isPost()) {
            $tbConf = new Application_Model_Configuracao();
            if($tbConf->getConfig("GRUPO_DOENCAS") == 1){
                $tbGruDoen = new Application_Model_GrupoDeDoencas();
                $this->view->grupo_doencas = $tbGruDoen->listaGrupoDeDoencasCid();
            }

            $obs = $this->_getParam("obs", FALSE);
            $json = $this->_request->getPost("json", FALSE);

            $dadosCid = $this->_request->getPost("cid_codigo", NULL);

            //Determinar Turno
            //iniciar turno com valor 3, para caso ocorra algum problema não gerar inconsistencia no e-sus
            $turno = 3;
            $var = date('H:i');
            $var = explode(':', $var);

            if($var[0] >= 06 && $var[0] < 12){
                $turno = 1;
            }else if($var[0] >= 12 && $var[0] < 17){
                $turno = 2;
            }else if($var[0] >= 18 || ($var[0] >= 0 && $var[0] < 06 )){
                $turno = 3;
            }

            $dados = array(
                "ate_hora" => $this->_request->getPost("ate_hora", NULL),
                "ate_reclamacao" => $this->_request->getPost("ate_reclamacao", NULL),
                "ate_acidentetrab" => $this->_request->getPost("ate_acidentetrab", FALSE),
                "cd10_codigo" => $dadosCid[0],
                "cd10_codigos" => $dadosCid[1],
                "cd10_codigot" => $dadosCid[2],
                "gd_codigo" => $this->_request->getPost("grupo_doencas",FALSE),
                "ate_exame_fisico" => $this->_request->getPost("ate_exame_fisico", NULL),
                "ate_diagnostico" => $this->_request->getPost("ate_diagnostico", NULL),
                "ate_tratamento" => $this->_request->getPost("ate_tratamento", NULL),
                "ate_curativo" => $this->_request->getPost("ate_curativo", NULL),
                // tipo de atendimento
                "ate_puericultura" => $this->_request->getPost("ate_puericultura", 'F'),
                "ate_pre_natal" => $this->_request->getPost("ate_pre_natal", 'F'),
                "ate_cancer" => $this->_request->getPost("ate_cancer", 'F'),
                "ate_dst" => $this->_request->getPost("ate_dst", 'F'),
                "ate_diabetes" => $this->_request->getPost("ate_diabetes", 'F'),
                "ate_hipertensao" => $this->_request->getPost("ate_hipertensao", 'F'),
                "ate_hanseniase" => $this->_request->getPost("ate_hanseniase", 'F'),
                "ate_tuberculose" => $this->_request->getPost("ate_tuberculose", 'F'),
                "ate_outros" => $this->_request->getPost("ate_outros", 'F'),
                "age_codigo" => ($this->_request->getPost("age_codigo") != NULL ? $this->_request->getPost('age_codigo', NULL) : ""),
                "ate_data" => ($this->_request->getPost("ate_data") != NULL ? $this->_request->getPost('ate_data', NULL) : "NOW()"),
                "co_local_atend" => $this->_request->getPost("co_local_atend", FALSE),
                "ate_somente_procedimento" => $this->_request->getPost("ate_somente_procedimento", FALSE),
                "gestante" => $this->_request->getPost("gestante", FALSE) == '0' ? 'false' : 'true',
                "neces_especial" => $this->_request->getPost("neces_especial", FALSE) == '0' ? 'false' : 'true',
                "turno" => $turno,
	            "ate_codigo" => $this->_request->getPost("ate_codigo") ? $this->_request->getPost("ate_codigo") : ""
            );

            $dadosUsu = array(
              "usu_codigo" => $_SESSION['prontuario']['age']->usu_codigo, //$this->_request->getPost("usu_codigo", FALSE),
              "usu_esta_gestante" => $this->_request->getPost("gestante", FALSE) == '0' ? 'false' : 'true',
              "risco_gestacao" => $this->_request->getPost("risco_gestacao", FALSE),
              "usu_tem_diabete" => $this->_request->getPost("diabetico", FALSE) == '0' ? 'false' : 'true',
              "risco_diabetes" => $this->_request->getPost("risco_diabetes", FALSE),
              "usu_tem_hipertensao" => $this->_request->getPost("hipertensao", FALSE) == '0' ? 'false' : 'true',
	            "risco_hipertensao" => $this->_request->getPost("risco_hipertensao", FALSE),
	            "risco_idoso" => $this->_request->getPost("risco_idoso", FALSE),
	            "risco_crianca" => $this->_request->getPost("risco_crianca", FALSE),
	            "risco_odonto" => $this->_request->getPost("risco_odonto", FALSE),
	            "risco_psico" => $this->_request->getPost("risco_psico", FALSE),
              "usu_deficiencia" => $this->_request->getPost("neces_especial", FALSE) == '0' ? 'false' : 'true',
              "usu_origem_prontuario" => 'true'
            );

	        /*
	        Correção dos dados enviados em caso de formulário desabilitado, pois usuarios do tipo D e P não
	        podem alterar essas informações
	        */
			if($_SESSION['logon']['usr']->usr_tipo_medico == "D" || $_SESSION['logon']['usr']->usr_tipo_medico == "P"){
				unset($dadosUsu['usu_esta_gestante']);
				unset($dadosUsu['usu_tem_diabete']);
				unset($dadosUsu['usu_tem_hipertensao']);
				unset($dadosUsu['usu_deficiencia']);
				unset($dadosUsu['risco_gestacao']);
				unset($dadosUsu['risco_diabetes']);
				unset($dadosUsu['risco_hipertensao']);
				unset($dadosUsu['risco_idoso']);
				unset($dadosUsu['risco_crianca']);
			}

            /*
             * se nao for um retorno pode colocar ate_codigo e dar update
             * o if ta duplicado pois, primeiramente é necessário veriricar se tem o retorno ou nao para
             * colocar o ate_codigo no campo hidden, caso colocar ele vai considerar como um update e como o retorno
             * precisa de um novo atendimento é necessário que o mesmo não vá para a view
             *
             * O segundo if tem que ser depois do métod o SALVAR do atendimento pois precisa do ate_codigo após salvar para
             * salvar um retorno.
             */
            $tbAte = new Application_Model_Atendimento();
            $ate_origem = $tbAte->buscaRetornoOrigem();
            if ($ate_origem->ate_encaminhamento != "S") {
                $ate_codigo_array = array("ate_codigo" => $this->_request->getPost("ate_codigo", NULL));
                $dados = array_merge($ate_codigo_array, $dados);
            }
            /**
             * terá que ter um if igual no final do metodo pois se o else fosse aqui ele nao salvaria caso nao fosse retorno.
             * esse if é necessário para saber se eu coloco a PK ate_codigo ou não na hora de salvar.
             * By: Victor Marques
             */
            try {
                $tbRet = new Application_Model_Retorno();
                $tbUsr = new Application_Model_Usuarios();
                $tbAgn = new Application_Model_Agendamento();
                $tbProAte = new Application_Model_ProcedimentoAtendimento();

                /*
                 * antes de salvar um novo atendimento ele fexa o retorno do atendimento anterior
                 * caso tenha um novo retorno deve-se finalizar como um retorno
                 */

                $tbUsu->salvar($dadosUsu);
                $ate_codigo = $tbAte->salvar($dados, $obs);
                $atendimento = $tbAte->buscar($ate_codigo);
                $agendamento = $tbAgn->getAgendamento($atendimento->age_codigo);
                Util::alteraStatusAgendamento($agendamento->age_codigo, Util::EM_ATENDIMENTO);
                $procedimentoAtendimento = $tbProAte->buscarProcedimentoDoAgendamentoSalvo($ate_codigo, $agendamento->proc_codigo);

                $tbPreConsulta = new Application_Model_PreConsulta();
                $usrProcedimentoAgendamento = $tbAgn->buscaMedicoProcedimento($agendamento->age_codigo);

                $procCodigoPreConsulta = $tbPreConsulta->getDadosValidacaoProcedimentoPreConsulta($agendamento->age_codigo, $usrProcedimentoAgendamento['med_codigo']);

                if (count($procedimentoAtendimento) == 0 && $procCodigoPreConsulta['proc_codigo'] != $agendamento->proc_codigo) {
                    $med_codigo = $tbUsr->getUsrAtual()->usr_codigo;
                    $this->salvarProcedimentoAtendimento($ate_codigo, $med_codigo, $agendamento->proc_codigo);
                }

                $this->salvaCiap($this->_request->getPost("ciap-selecionados", 'F'),$ate_codigo);
                $this->salvarVigilanciaBucal($this->_request->getPost("vigilancia"),$ate_codigo);

                $this->salvarCondutas($this->_request->getPost("conduta"),$ate_codigo);
                // Salva dados conduta
                if ($this->_request->getPost("conduta_ind", FALSE)) {
                    $this->salvarCondutasInd($this->_request->getPost("conduta_ind", 'F'),$ate_codigo);
                }
                setcookie("ate_reclamacao", ' ');
                $tbAge = new Application_Model_Agendamento();
                if ($ate_origem->ate_encaminhamento == "S") {
                    $dados_retorno = array("ate_codigo_origem" => $ate_origem->ate_codigo,
                        "ate_codigo" => $ate_codigo);
                    $tbRet->salvar($dados_retorno);


                    setcookie("ate_reclamacao", ' ');
                }
                if ($obs) {
                    $dadosInternacao = array(
                        "ate_codigo" => $ate_codigo,
                        "io_codigo" => $this->_getParam("io_codigo", FALSE)
                    );
                    $tbAti = new Application_Model_AtendimentoInternacao();
                    $atin_codigo = $tbAti->salvar($dadosInternacao);
                    $this->view->dados = $tbAte->buscarInternacao($ate_codigo);
                } else {
                    $this->view->dados = $tbAte->buscar();

                }
                if ($json) {
                   return $this->jsonFicha($ate_codigo);
                }
                $this->view->dialog = array("Confirmação", "Atendimento salvo com sucesso!", 300, 140);
                $this->view->obs = $obs;
                if ($this->_request->getPost("ate_somente_procedimento", FALSE) == "f" ||
                        $this->_request->getPost("ate_somente_procedimento", FALSE) == "" ||
                        $this->_request->getPost("uni_tipo", FALSE) == "H") {
                    $this->_redirect("/prontuario/atendimento");
                } else {
                    $this->_redirect("/prontuario/procedimento");
                }
            } catch (Zend_Validate_Exception $exc) {
                if ($json) {
                    $this->view->dados = array("error" => TRUE, "mensagem" => $exc->getMessage());
                    return $this->render("dados", NULL, TRUE);
                }
                $this->view->erro = $exc->getMessage();
                $this->view->dados = $dados;
                $this->render($tbAte->textareaUnico() ? "unico" : "multiplo");
            }
        } else {
            $this->_redirect("/prontuario/atendimento");
        }
    }

    private function existeProcAtend() {
        return false;
    }

    private function salvarProcedimentoAtendimento($ate_codigo=FALSE, $med_codigo=FALSE, $age_codigo=FALSE){
        $tbProcAtend = new Application_Model_ProcedimentoAtendimento();
        $dados = array (
            "ate_codigo" => $ate_codigo,
            "proc_codigo" => $age_codigo,
            "usr_codigo" => $med_codigo
            );
            try {
                $tbProcAtend->salvarProcedimentosAtendimento($dados);
                return true;
            } catch (Exception $exc) {
                return $exc->getMessage();
            }
    }

    private function salvarCondutasInd($post=FALSE,$ateCod=FALSE){
	    try {
	    	if(is_array($post) && count($post) > 0){
			    $tbCond = new Application_Model_RlCdsAtendIndividualCondut();
			    $tbCond->excluirPorAtendimento($ateCod);
			    foreach ($post as $val) {
				    $dados = array(
					    "ate_codigo" => $ateCod,
					    "tp_cds_conduta" => $val
				    );
				    $tbCond->salvar($dados);
			    }
			    return true;
		    }
		    return false;
	    } catch (Exception $e) {
	    	return $e->getMessage();
	    }
    }

    private function salvarCondutas($post=FALSE,$ateCod=FALSE){
	    try {
		    if(is_array($post) && count($post) > 0) {
			    $tbTipEnc = new Application_Model_RlCdsAtendOdontoTipoEncam();
			    $tbTipEnc->excluirPorAtendimento($ateCod);
			    foreach ($post as $val) {
				    $condutas = array(
					    "ate_codigo" => $ateCod,
					    "tp_cds_encam_odonto" => $val
				    );
				    $tbTipEnc->salvar($condutas);
			    }
			    return true;
		    }
		    return false;
	    } catch (Exception $e) {
		    return $e->getMessage();
	    }
    }

    private function salvarVigilanciaBucal($post=FALSE,$ateCod=FALSE){
        $tbRlVig = new Application_Model_RlCdsAtendOdontTipVigBuc();
        $tbRlVig->excluirPorAtendimento($ateCod);
        foreach ($post as $val) {
            $vigilancia = "";
            $vigilancia = array(
                "ate_codigo" => $ateCod,
                "tp_cds_vig_saude_bucal" => $val
            );
            try{
                $tbRlVig->salvar($vigilancia);
            } catch (Exception $exc) {
                return $exc->getMessage();
            }
        }
    }

    private function salvaCiap($data,$ate_codigo){
        $rlAteCiap = new Application_Model_RlCdsAtendIndividualCiap();
        $dados = array();
        $rlAteCiap->limpaCiapAtendimento($ate_codigo);
        foreach ($data as $item){
            $dados = array("ate_codigo"=>$ate_codigo,
                           "co_ciap"=>$item);
            $rlAteCiap->salvar($dados);

        }
        return true;
    }

    private function jsonFicha($id) {
    		$tbAte = new Application_Model_Atendimento();

        $ate = $tbAte->getDetalhes($id);

    		if (!$ate)
    			return $this->_redirect("/prontuario/atendimento");

    		$this->view->dados = $ate->toArray();
    		$this->render("dados", NULL, TRUE);
  	}

    public function salvarInternacaoAction() {

        if ($this->_request->isPost()) {
            $tbAte = new Application_Model_Atendimento();

            $obs = $this->_getParam("obs", FALSE);

            $dados = array(
                "ate_codigo" => $this->_request->getPost("ate_codigo", NULL),
                "ate_hora" => $this->_request->getPost("ate_hora", NULL),
                "ate_reclamacao" => $this->_request->getPost("ate_reclamacao", NULL),
                "cd10_codigo" => $this->_request->getPost("cd10_codigo", NULL),
                "ate_atendido" => $this->_request->getPost("ate_atendido", NULL)
            );


            $io_codigo = $this->_getParam("io_codigo", FALSE);

            $ate_codigo = $tbAte->salvar($dados, $obs, $io_codigo);

            $tbUsu = new Application_Model_Usuario();
            $dadosUsu = array(
                "usu_codigo" => $tbAte->getUsuCodigoAtendimento($ate_codigo),
                "usu_esta_gestante" => $this->_request->getPost("gestante", FALSE) == '0' ? 'false' : 'true',
                "risco_gestacao" => $this->_request->getPost("risco_gestacao", FALSE),
                "usu_tem_diabete" => $this->_request->getPost("diabetico", FALSE) == '0' ? 'false' : 'true',
                "risco_diabetes" => $this->_request->getPost("risco_diabetes", FALSE),
                "usu_tem_hipertensao" => $this->_request->getPost("hipertensao", FALSE) == '0' ? 'false' : 'true',
                "risco_hipertensao" => $this->_request->getPost("risco_hipertensao", FALSE),
                "risco_idoso" => $this->_request->getPost("risco_idoso", FALSE),
                "risco_crianca" => $this->_request->getPost("risco_crianca", FALSE),
                "risco_odonto" => $this->_request->getPost("risco_odonto", FALSE),
                "risco_psico" => $this->_request->getPost("risco_psico", FALSE),
                "usu_deficiencia" => $this->_request->getPost("neces_especial", FALSE) == '0' ? 'false' : 'true',
            );
            $tbUsu->salvar($dadosUsu);

            if (!$this->_request->getPost("ate_codigo")) {
                $dadosInternacao = array(
                    "ate_codigo" => $ate_codigo,
                    "io_codigo" => $io_codigo
                );
                $tbAti = new Application_Model_AtendimentoInternacao();
                $atin_codigo = $tbAti->salvar($dadosInternacao);
            }
            $this->view->dados = $tbAte->buscarInternacao($ate_codigo);

            $this->view->dialog = array("Confirmação", "Atendimento salvo com sucesso!", 300, 140);
            $this->view->obs = $obs;

            $this->_redirect("/leito/atendimento/index/cod/$io_codigo/ate_codigo/$ate_codigo");
        } else {
            $this->_redirect("/prontuario/atendimento");
        }
    }

    public function historicoAction() {
        $tbAte = new Application_Model_Atendimento();

        // filtrar
        $this->view->term = $this->_getParam("term", FALSE);
        $this->view->itens = $tbAte->getHistorico($this->view->term);
    }

    /**
     * Esta é a página com as abas do atendimento (exames, atendimento, medicamento...)
     */
    public function verAction() {
        $ate_codigo = $this->_getParam("id", FALSE);
        $age_codigo = $this->_getParam("age", FALSE);
        $tbAte = new Application_Model_Atendimento();

        if ($age_codigo) {
            if ($ate_codigo) {
                $this->view->ate = $tbAte->buscar($ate_codigo);
                $this->view->ate_codigo = $ate_codigo;
            } else {
                $ate = $tbAte->temAtendimento($age_codigo);
                if ($ate) {
                    $ate_codigo = $ate->ate_codigo;
                    $this->view->ate = $tbAte->buscar($ate_codigo);
                    $this->view->ate_codigo = $ate_codigo;
                } else {
                    $tbPre = new Application_Model_PreConsulta();
                    $this->view->ate = $tbPre->buscar($age_codigo);
                }
            }
        } else {
            return $this->_redirect("/prontuario");
        }
    }

    /**
     * Esta é a página com os dados preenchidos na guia atendimento
     */
    public function detalhesAction() {
        $ate_codigo = $this->_getParam("id", FALSE);
        if (!$ate_codigo)
            return $this->_redirect("/prontuario");

        $tbAte = new Application_Model_Atendimento();
        $this->view->dados = $tbAte->getDetalhes($ate_codigo);
        $this->render($tbAte->textareaUnico() ? "detalhes-unico" : "detalhes-multiplo");
    }

    /**
     * Busca os dados do atendimento e retorna em json
     * Usado no modulo agenda para preencher a tela com os dados do atendimento
     */
    public function jsonAction() {
        $ate_codigo = $this->_getParam("ate", FALSE);
        if (!$ate_codigo)
            return $this->_redirect("/prontuario/atendimento");

        $tbAte = new Application_Model_Atendimento();
        $age = $tbAte->getDadosCabecalho($ate_codigo);

        if (!$age) {
            $this->view->dados = array("success" => FALSE, "mensagem" => "Código inválido");
            return $this->render("dados", NULL, TRUE);
        }

        $age = $age->toArray();

        $tbReq = new Application_Model_RequisicaoExame();
        $exames = $tbReq->getItens(FALSE, $ate_codigo)->toArray();

        // monta resultados
        $this->view->dados = array_merge(
                array("success" => TRUE), $age, array("exames" => $exames)
        );
        return $this->render("dados", NULL, TRUE);
    }

    public function verificaStatusAtendimentoAction() {
        $age_codigo = $this->_getParam("age_codigo", FALSE);
        $tbAge = new Application_Model_Agendamento();
        $usuarioStatus = $tbAge->verificaStatusAgendamento($age_codigo);

        $this->view->dados = $usuarioStatus->usr_nome;

        return $this->render("dados", NULL, TRUE);
    }

    public function verificaseestaematendimentoAction() {
        setcookie("ate_reclamacao",' ') ;
        unset($_COOKIE["ate_reclamacao"]);
        setcookie("ate_exame_fisico",' ') ;
        unset($_COOKIE["ate_exame_fisico"]);
        setcookie("ate_diagnostico",' ') ;
        unset($_COOKIE["ate_diagnostico"]);
        setcookie("ate_tratamento",' ') ;
        unset($_COOKIE["ate_tratamento"]);
        setcookie("ate_curativo",' ') ;
        unset($_COOKIE["ate_curativo"]);

        $tbUsr = new Application_Model_Usuarios;
        $age_codigo = $this->_getParam("age_codigo", FALSE);
        $tbAge = new Application_Model_Agendamento();

        if ($tbUsr->isMedico()) {
            $tbAte = new Application_Model_Atendimento();
            if ($age_codigo) {
                $ate = $tbAte->estaEmAtendimento($age_codigo);
                if ($ate) {
                    $med_codigo = $ate->med_codigo;
                }
            }
            $tbUsr = new Application_Model_Usuarios();
            $usr = $tbUsr->getUsrAtual();
            $tbAge->alteraMedico($age_codigo, $usr->usr_codigo, "E", $usr->usr_codigo);
        } else {
            $tbAge->alteraSituacao("E", $age_codigo);
        }

        $status = $tbAge->getDadosAgendamentoUsuario($age_codigo)->age_status;
        if(trim($status) === Util::PRE_CONSULTA_FINAL){
            Util::alteraStatusAgendamento($age_codigo, Util::ATEND_INICIADO_MED);
        }else if(trim($status) === Util::AGUARD_RETORNO){
            Util::alteraStatusAgendamento($age_codigo, Util::RETORNO_ATENDIM);
        }else{
            Util::alteraStatusAgendamento($age_codigo, Util::ATEND_INICIADO);
        }
        die(true);
    }

    public function recuperaatendimentoAction() {
        setcookie("ate_reclamacao",' ') ;
        unset($_COOKIE["ate_reclamacao"]);
        setcookie("ate_exame_fisico",' ') ;
        unset($_COOKIE["ate_exame_fisico"]);
        setcookie("ate_diagnostico",' ') ;
        unset($_COOKIE["ate_diagnostico"]);
        setcookie("ate_tratamento",' ') ;
        unset($_COOKIE["ate_tratamento"]);
        setcookie("ate_curativo",' ') ;
        unset($_COOKIE["ate_curativo"]);

        $tbUsr = new Application_Model_Usuarios;
        $age_codigo = $this->_getParam("age_codigo", FALSE);
        $tbAge = new Application_Model_Agendamento();

        if ($tbUsr->isMedico()) {
            $tbAte = new Application_Model_Atendimento();
            if ($age_codigo) {
                $ate = $tbAte->estaEmAtendimento($age_codigo);
                if ($ate) {
                    $med_codigo = $ate->med_codigo;
                }
            }
        }
        die(true);
    }

    public function excluirAction(){
      $id = (int) $this->_getParam("id", 0);

  		$tbAte = new Application_Model_Atendimento();
  		$tbAte->excluir($id);

  		if ($this->_getParam("json", FALSE)) {
  			$this->view->dados = array("success" => TRUE);
  			return $this->render("dados", NULL, TRUE);
  		}

  		return $this->render("dados", NULL, TRUE);
    }

    public function buscarCiapAction(){
        $term = $this->_getParam("term", FALSE);
        $tbCiap = new Application_Model_TbCiap();
        if($term)
            $this->view->dados = $tbCiap->buscar($term);

        return $this->render("dados",null,true);
    }

    public function novoBuscarCiapAction() {
        $ciapSelecionados = $this->_getParam("selecionados", FALSE);

        $term = $this->_getParam("term", FALSE);
        $tbCiap = new Application_Model_TbCiap();
        $out = $tbCiap->buscarCiapDescricoes($term,$ciapSelecionados);

        $this->view->dados = $out;
        return $this->render("dados",NULL,TRUE);
    }

    public function transferirProfissionalAction() {
        $age_codigo  = $this->_getParam("age_codigo", FALSE);
        $pro_origem  = $this->_getParam("pro_origem", FALSE);
        $pro_destino = $this->_getParam("pro_destino", FALSE);
        $motivo      = $this->_getParam("motivo", FALSE);
        $tipo_transf = $this->_getParam("tipo", FALSE);
        $age_status  = $this->_getParam("age_status", FALSE);

        $data = array(
            "age_codigo" => $age_codigo,
            "atp_id_profissional_origem" => ($pro_origem ? $pro_origem : null),
            "atp_id_profissional_destino" => ($pro_destino ? $pro_destino : 0),
            "atp_motivo_transferencia" => ($motivo ? $motivo : null),
            "data_hora" => date('Y-m-d His'),
            "tipo_transferencia" => $tipo_transf
        );

        $tbAte = new Application_Model_Atendimento();
        return $tbAte->transferirProfissional($data, $age_status);
    }

    public function getCondutasEncaminhamentosAction() {
      if ((new Application_Model_Usuarios())->getUsrAtual()->usr_tipo_medico == "D") {
        $dados = (new Application_Model_Agendamento())->getDadosAgendamentoUsuario($this->_getParam("age_codigo", FALSE));

        $tbTipCond = new Application_Model_TbCdsTipoEncamOdonto();
        $condutas = $tbTipCond->getDados($dados->tp_cod)->toArray();
        $encaminhamentos = $tbTipCond->getEncaminhamentos()->toArray();

        $this->view->dados = array_merge($condutas, $encaminhamentos);

        return $this->render("dados", NULL, TRUE);
      }

      $this->view->dados = (new Application_Model_TbCdsTipoConduta())->getDadosConduta()->toArray();

      return $this->render("dados", NULL, TRUE);
    }

    public function getCondutasAtendimentoAction() {
      $ateCodigo = $this->_getParam("ate_codigo", FALSE);
      $this->view->dados = $this->condEncDados($ateCodigo, (new Application_Model_Usuarios())->getUsrAtual()->usr_tipo_medico);

      return $this->render("dados", NULL, TRUE);
    }

    private function condEncDados($ateCodigo, $tipoMedico) {
      if ($tipoMedico == "D") {
        return (new Application_Model_TbCdsTipoEncamOdonto())->getCondutasEncaminhamentosAtendimento($ateCodigo)->toArray();
      }

      return (new Application_Model_TbCdsTipoConduta())->getCondutasEncaminhamentosAtendimento($ateCodigo)->toArray();
    }

	public function checaTipoAgendamentoOdontoAction() {
		$age_codigo = $this->_getParam("age_codigo", FALSE);

		$tbAge = new Application_Model_Agendamento();
		$tipo_agendamento = $tbAge->verificaTipoAgendamento($age_codigo);

		$this->view->dados = $tipo_agendamento->tp_cod;

		return $this->render("dados", NULL, TRUE);
	}

	public function checaSomenteProcedimentoAction(){
		$ate_codigo = $this->_getParam("ate_codigo", FALSE);

		$tbAte = new Application_Model_Atendimento();
		$this->view->dados = $tbAte->buscar($ate_codigo)->ate_somente_procedimento;

		return $this->render("dados", NULL, TRUE);
	}

}
