<?php

class Prontuario_CidController extends Zend_Controller_Action {
	
    public function init(){
        $this->_helper->acl->copiarPermissao("zf/prontuario/index");
    }

    /**
     * Retorna os CID's do procedimento informado
     * O retorno é formado por tags <option>'s para preencher um select via ajax
     * A tag <select> não é enviada na resposta.
     */
    public function procedimentoAction(){
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender();

        $procedimento = $this->_getParam("id",FALSE);
        if(!$procedimento)
                return false;

        $tbCID = new Application_Model_Cid();
        echo $tbCID->selectTag($procedimento);
    }

    /**
     * Retorna os CID's em JSON
     * O retorno é usado pelo plugin de busca
     */
    public function buscarAction(){
        $url = $_SERVER['HTTP_REFERER'];

        $tbCid = new Application_Model_Cid();
        $term = $this->_getParam("term",FALSE);
        if ((strpos(strtoupper($url), 'REL_') == true)||(strpos(strtoupper($url), 'RELATORIO') == true)){
            $this->view->dados = $tbCid->buscar($term);
        } else {
            $this->view->dados = $tbCid->buscarAtivos($term);
        }

        return $this->render("dados", NULL, TRUE);
    }

    public function searchCidAction() {
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender();
        $codigo = $this->_getParam("cd10_codigo",false);
        $cid = new Application_Model_Cid();
        $this->view->dados = $cid->getPorCodigo($codigo)->toArray();
        return $this->render("dados",null,true);
    }
}