<?php
require_once COMUM_PATH."/reportApi/GeradorRelatorio.php";

class Prontuario_EncaminhamentoController extends Zend_Controller_Action
{

    public function init()
    {
        $this->_helper->acl->copiarPermissao("zf/prontuario/index");
        //Zend_Layout::getMvcInstance()->setLayout("prontuario");
        $this->view->title = "Encaminhamento";
    }

    public function indexAction()
    {
        $this->_helper->layout->setLayout("prontuario");

        // no atendimento, é possivel carregar o historico por ajax.
        // Nesse caso, não deve enviar o layout junto
        $this->view->obs = $this->_getParam("obs", FALSE);
        $this->view->io_codigo = $this->_getParam("io_codigo", FALSE);
        $this->view->ate_codigo = $this->_getParam("ate_codigo", FALSE);

	    $this->view->tipo = 'I';
	    if ($this->view->obs) {
		    $this->_helper->layout->disableLayout();
		    //$this->render("itens");
	    }

	    $tbEsp = new Application_Model_Especialidade();
	    $this->view->especialidade = $tbEsp->selectTag();

	    $tbAte = new Application_Model_Atendimento();
        $this->view->usu_codigo = $_SESSION['prontuario']['age']->usu_codigo ? $_SESSION['prontuario']['age']->usu_codigo : $this->_getParam("usu_codigo", FALSE);
        if($this->view->usu_codigo == null)
        $this->view->usu_codigo = $tbAte->getUsuCodigoAtendimento($this->view->ate_codigo);

	    $tbEncaminhamentos = new Application_Model_Encaminhamento();
	    $this->view->historico = $tbEncaminhamentos->getHistoricoEncaminhamento($this->view->usu_codigo, $this->view->tipo);
    }

    public function itensAction()
    {
        $tbEnc = new Application_Model_Encaminhamento();
        $tbConf = new Application_Model_Configuracao();
        $this->view->tipo_impresso_simples = $tbConf->getConfig("ENCAMINHAMENTO_SIMPLES");
        $this->view->itens = $tbEnc->getItens();
        $this->view->obs = $this->_getParam("obs", FALSE);
    }

    /**
     * Mostra os encaminhamentos da internação atual
     */
    public function itensInternacaoAction()
    {
        $io_codigo = $this->_getParam("io_codigo", FALSE);
        $ate_codigo = $this->_getParam("ate_codigo", FALSE);
        $usu_codigo = $this->_getParam("usu_codigo", FALSE);
        $imprimi = $this->_getParam("imprimi", FALSE);
        $this->view->readonly = $this->_getParam("readonly", FALSE);

        $tbEnc = new Application_Model_Encaminhamento();
        $this->view->itens = $tbEnc->getItensInternacao($io_codigo);
        $this->view->obs = $this->_getParam("obs", FALSE);
        $this->view->io_codigo = $io_codigo;
        $this->view->usu_codigo = $usu_codigo;
        $this->view->ate_codigo = $ate_codigo;
        $this->view->imprimi = $imprimi;
        $this->render("itens");
    }

    public function historicoAction()
    {
        $ate_codigo = $this->_getParam("id", FALSE);
        if (!$ate_codigo)
            return $this->_redirect("/prontuario");

        $tbEnc = new Application_Model_Encaminhamento();
        $this->view->itens = $tbEnc->getHistorico($ate_codigo);
    }

    public function historicoEncaminhamentosAction(){
        $this->_helper->layout->setLayout("vazio");
        $usu_codigo = $_SESSION['prontuario']['age']->usu_codigo ? $_SESSION['prontuario']['age']->usu_codigo : $this->_getParam("usu_codigo", FALSE);
        $tipo = $this->_getParam("tipo", FALSE);
        $obs = $this->_getParam("obs", FALSE);
        $ate_codigo = $this->_getParam("ate_codigo", FALSE);
        if($usu_codigo == null) {
            $tbAte = new Application_Model_Atendimento();
            $usu_codigo = $tbAte->getUsuCodigoAtendimento($ate_codigo);
        }
        $tbEnc = new Application_Model_Encaminhamento();
        $this->view->itens = $tbEnc->getHistoricoEncaminhamento($usu_codigo,$tipo);
        $this->view->tipo = $tipo;
        $this->view->obs = $obs;
    }

    public function salvarAction()
    {
        //echo "<pre>".print_r($_POST,1);exit;
        if ($this->_request->isPost()) {

            $obs = $this->_request->getPost("obs", FALSE);
            $ate_codigo = $this->_request->getPost("ate_codigo", FALSE);
            $io_codigo = $this->_request->getPost("io_codigo", FALSE);


            $dados = array(
                "ate_codigo" => $this->_request->getPost("ate_codigo", 0),
                "enc_codigo" => $this->_request->getPost("enc_codigo", 0),
                "esp_codigo" => $this->_request->getPost("esp_codigo", NULL),
                "enc_descricao" => $this->_request->getPost("enc_descricao", NULL),
                "enc_internacao" => $this->_request->getPost("enc_internacao", NULL),
                "enc_urgencia" => $this->_request->getPost("enc_urgencia", NULL)
            );

            try {
                $tbEnc = new Application_Model_Encaminhamento();
                $tbEnc->salvar($dados, $obs);
                $this->view->dialog = array("Confirmação", "Encaminhamento registrado com sucesso!", 300, 140);
                $tbEsp = new Application_Model_Especialidade();
                $this->view->especialidade = $tbEsp->selectTag();
                $tbEncaminhamentos = new Application_Model_Encaminhamento();
                $this->view->historico = $tbEncaminhamentos->getHistoricoEncaminhamento($this->view->usu_codigo, $this->view->tipo);
                $this->view->tipo = 'I';
                if ($obs == "S") {
                    $this->_redirect("leito/atendimento/index/cod/$io_codigo/ate_codigo/$ate_codigo");
                } else {
                    $this->_helper->layout->setLayout("prontuario");
                    $this->render("index");
                }
            } catch (Zend_Validate_Exception $exc) {
                $this->view->erro = $exc->getMessage();
                $this->view->dados = (object)$dados;
                $this->render("index");
            }
        } else {
            $this->_redirect("/prontuario/encaminhamento");
        }
    }

    public function excluirAction()
    {
        $id = (int)$this->_getParam("id", 0);
        $ate_codigo = $this->_getParam("ate_codigo", FALSE);
        $io_codigo = $this->_getParam("cod", FALSE);
        //die($io_codigo."-".$ate_codigo);
        if (!$id)
            return $this->_redirect("/prontuario/encaminhamento");

        $tbEnc = new Application_Model_Encaminhamento();
        $tbEnc->excluir($id);
        //die($io_codigo);

        if ($io_codigo) {
            return $this->_redirect("/leito/atendimento/index/cod/$io_codigo/ate_codigo/$ate_codigo");
        } else {
            return $this->_redirect("/prontuario/encaminhamento");
        }
    }

    public function imprimirAction()
    {
        Zend_Layout::getMvcInstance()->setLayout("paisagem-print");
        $tbUsr = new Application_Model_Usuarios();
        $tbSec = new Application_Model_Secretaria();
        $tbConf = new Application_Model_Configuracao();
        $tbUsr = new Application_Model_Usuarios();
        $this->view->usr = $tbUsr->getUsrAtual();
        $this->view->secretaria = $tbSec->getDadosSec();
        $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
        $this->view->tipo_impressao = "ENCAMINHAMENTO";
        $this->view->title = "Imprimir Encaminhamento Médico";

        $io_codigo = $this->_getParam("cod", FALSE);
        $usu_codigo = $this->_getParam("usu_codigo", FALSE);

        //die($usu_codigo."0".$io_codigo);
        $id = (int)$this->_getParam("id", 0);
        if (!$id)
            return $this->_redirect("/prontuario/encaminhamento");

        $tbEnc = new Application_Model_Encaminhamento();
        $this->view->dados = $tbEnc->imprimir($id, $io_codigo, $usu_codigo);
        $this->view->tipo = $tipo;
        $this->view->isMedico = $tbUsr->isMedico();
    }

    public function encaminhamentoExternoAction()
    {
        $this->view->title = "Encaminhamento Externo";
        $this->view->ate_codigo = $this->_getParam("ate_codigo", FALSE);
        $this->view->usu_codigo = $_SESSION['prontuario']['age']->usu_codigo ? $_SESSION['prontuario']['age']->usu_codigo : $this->_getParam("usu_codigo", FALSE);
        //die($this->view->ate_codigo);
        $this->view->tipo = 'E';

        $tbEncaminhamentos = new Application_Model_Encaminhamento();
        $this->view->historico = $tbEncaminhamentos->getHistoricoEncaminhamento($this->view->usu_codigo, $this->view->tipo);
    }

    public function encaminhamentoExternoItensAction()
    {
        $tbEncExt = new Application_Model_EncaminhamentoExterno();
        $tbAte = new Application_Model_Atendimento();
        $ateCodigo = $tbAte->temAtendimentoMedico()->ate_codigo;
        $this->view->itens = $tbEncExt->listaEncExterno($ateCodigo);
    }

    public function salvarEncaminhamentoExternoAction()
    {
        if ($this->_request->isPost()) {
            $tbEncExt = new Application_Model_EncaminhamentoExterno();
            $tbAte = new Application_Model_Atendimento();
            $ateCodigo = $tbAte->temAtendimentoMedico()->ate_codigo;

            $dados = array(
                "ate_codigo" => $ateCodigo,
                "usr_codigo" => Application_Model_Agendamento::usuEmAberto()->med_codigo,
                "enc_ext_agendado_para" => $this->_request->getPost("enc_ext_agendado_para"),
                "enc_ext_contato" => $this->_request->getPost("enc_ext_contato"),
                "enc_ext_data" => ($this->_request->getPost("enc_ext_data") ? $this->_request->getPost("enc_ext_data") : NULL),
                "enc_ext_hora" => $this->_request->getPost("enc_ext_hora"),
                "enc_ext_internacao" => $this->_request->getPost("enc_internacao"),
                "enc_ext_urgencia" => $this->_request->getPost("enc_urgencia"),
                "enc_ext_descricao" => $this->_request->getPost("enc_descricao")
            );

            try {
                $tbEncExt->salvar($dados);
                $this->view->dialog = array("Confirmação", "Encaminhamento registrado com sucesso!", 300, 140);
                $this->_helper->layout->setLayout("prontuario");
                $tbEncaminhamentos = new Application_Model_Encaminhamento();
                $this->view->historico = $tbEncaminhamentos->getHistoricoEncaminhamento($this->view->usu_codigo, $this->view->tipo);
                $this->view->tipo = 'E';
                $this->_redirect("prontuario/encaminhamento/#tabs2-2");
                //$this->render("index");
            } catch (Exception $exc) {
                $this->view->erro = $exc->getMessage();
                $this->view->dados = (object)$dados;
                $this->render("index");
            }

        } else {
            $this->_redirect("prontuario/encaminhamento");
        }
    }

    public function excluirItemEncaminhamentoExternoAction()
    {
        if ($this->_getParam("id") == "") {
            $this->_redirect("prontuario/encaminhamento/index/#tabs2-2");
        } else {
            $tbEncExt = new Application_Model_EncaminhamentoExterno();
            $encExtCod = $this->_getParam("id");
            $tbEncExt->excluir($encExtCod);
            $this->_redirect("prontuario/encaminhamento/index/#tabs2-2");
        }
    }

    public function encaminhamentoExternoImprimirAction()
    {
        if ($this->_getParam("id") == "") {
            $this->_redirect("prontuario/encaminhamento/");
        } else {
            Zend_Layout::getMvcInstance()->setLayout("print");
            $this->view->title = "Imprimir Encaminhamento Médico Externo";
            // DADOS ENCAMINHAMENTO
            $tbEncExt = new Application_Model_EncaminhamentoExterno();
            $tbSec = new Application_Model_Secretaria();
            $sec = $tbSec->fetchRow();
            $encExtCod = $this->_getParam("id");
            $dados = $tbEncExt->getDadosImpEncaminhamentoExterno($encExtCod);
            $dados = (object)$dados->toArray();
            //echo "<pre>";
            //print_r($dados);
            //echo "</pre>";
            //die();
            $dados->secretaria = $sec->nome_secretaria;
            $this->view->dados = $dados;
        }
    }

    public function contraReferenciaAction()
    {
        $io_codigo = $this->_getParam("cod", FALSE);
        $usu_codigo = $this->_getParam("usu_codigo", FALSE);
        $ate_codigo = $this->_getParam("ate_codigo", FALSE);

        $tbAte = new Application_Model_Atendimento();
        $paciente = $tbAte->getUsuCodigoAtendimento($ate_codigo);
        $internacao = $tbAte->buscarCodigoInternacaoObservacaoPorAtendimento($ate_codigo)->io_codigo;

		$usu_codigo = ($usu_codigo != '' ? $usu_codigo : $paciente);
		$io_codigo = ($io_codigo != '' ? $io_codigo : $internacao);


        $id = (int)$this->_getParam("id", 0);
        $tbSec = new Application_Model_Secretaria();
        $this->view->sec = $tbSec->getDadosSec()->toArray();
        $tbUsr = new Application_Model_Usuarios();
        $this->view->usr = $tbUsr->getUsrAtual();
        $this->_helper->layout->disableLayout();
        $this->view->dados_usr = $tbUsr->getUsrAtual();
        $tbEnc = new Application_Model_Encaminhamento();
        $this->view->dados = $tbEnc->imprimir($id, $io_codigo, $usu_codigo);

    }

    public function gerarEncaminhamentoExternoAction(){
        $codigo = $this->_getParam("enc_ext_codigo", NULL);
        $tbConf = new Application_Model_Configuracao();
        $contra_referencia = null;
        if($tbConf->getConfig("ENCAMINHAMENTO_SIMPLES") != true){
         $contra_referencia = "SIM";
        }
        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "guiaEncaminhamentoExterno", [
            "codigo" => $codigo,
            "contraReferencia" => $contra_referencia
        ]);
        $this->render("dados", NULL, TRUE);
    }

}

