<?php

class Prontuario_ExameController extends Zend_Controller_Action
{

  public function init() {
    $this->_helper->acl->copiarPermissao("zf/prontuario/index");
    $this->view->title = "Exames";
  }

  public function indexAction() {
    $this->view->io_codigo = $this->_getParam("io_codigo", FALSE);
    $this->view->ate_codigo = $this->_getParam("ate_codigo", FALSE);
    $this->view->usu_codigo = $this->_getParam("usu_codigo", FALSE);
    $this->view->obs = $this->_getParam("obs", FALSE);

    $this->_helper->layout->setLayout("prontuario");
    if ($this->view->obs) {
      $this->_helper->layout->disableLayout();
    }
  }

  public function formAction() {
    $tbExa = new Application_Model_RequisicaoExame();
    $usuCodigo = (!empty($_SESSION['prontuario']['age']->usu_codigo) ? $_SESSION['prontuario']['age']->usu_codigo : $this->_getParam("usu_codigo", FALSE));

    $this->view->tipo = $this->_getParam("tipo", NULL);
    $this->view->obs = $this->_getParam("obs", NULL);
    $this->view->io_codigo = $this->_getParam("io_codigo", NULL);
    $this->view->ate_codigo = (!empty($this->_getParam("ate_codigo", FALSE)) ? $this->_getParam("ate_codigo", FALSE) : (new Application_Model_Atendimento())->temAtendimento($_SESSION['prontuario']['age']->age_codigo)->ate_codigo);
    $this->view->usu_codigo = $usuCodigo;
    $this->view->historicoSolicitado = $tbExa->getHistoricoExamePacienteSolicitado($usuCodigo);
    $this->view->historicoAvaliado = $tbExa->getHistoricoExamePacienteAvaliado($usuCodigo);
  }

  /**
  * Mostra os exames do atendimento atual
  * Atenção: exame solicitado pelo médico, mas não quer dizer que foi realizado, nem mesmo agendado
  */
  public function itensAction() {
    $tipo = $this->_getParam("tipo", NULL);
    $this->view->itens = (new Application_Model_RequisicaoExame())->getItens(FALSE, FALSE, $tipo);
  }

  public function itensHistoricoFormAction(){
    $this->_helper->layout->setLayout("vazio");
    $tipo = $this->_getParam("tipo", NULL);
    $this->view->tipo = $tipo;
    $usuCodigo = $this->_getParam("usuCodigo", NULL);
    $idExame = $this->_getParam("id", NULL);
    $this->view->historico = (new Application_Model_RequisicaoExame())->getItensHistoricoUsuario($usuCodigo, $tipo, $idExame);

    return $this->render("itens-historico-form");
  }

  /**
  * Mostra os exames da internação atual
  * Atenção: exame solicitado pelo médico, mas não quer dizer que foi realizado, nem mesmo agendado
  */
  public function itensInternacaoAction() {
    $obs = $this->_getParam('obs', NULL);
    $io_codigo = $this->_getParam("io_codigo", false);
    $ate_codigo = $this->_getParam("ate_codigo", false);
    $usu_codigo = $this->_getParam("usu_codigo", false);
    $imprimi = $this->_getParam("imprimi", false);

    $tbReq = new Application_Model_RequisicaoExame();
    $this->view->itens = $tbReq->getItensInternacao($io_codigo);
    $this->view->obs = $obs;
    $this->view->ate_codigo = $ate_codigo;
    $this->view->usu_codigo = $usu_codigo;
    $this->view->imprimi = $imprimi;
    $this->render("itens");
  }

  /**
  * Mostra uma lista com o histórico de todos os exames solicitados pelo(s) médico(s)
  * Se for informado o id será filtrado por atendimento
  * Atenção: exame solicitado pelo médico, mas não quer dizer que foi realizado, nem mesmo agendado
  */
  public function historicoAction() {
    $ate_codigo = $this->_getParam("id", NULL);

    $tbReq = new Application_Model_RequisicaoExame();
    $this->view->itens = $tbReq->getHistorico($ate_codigo);
  }

  /**
  * Mostra uma lista de exame (da tabela cadastroDoExame) que foram coletados/concluidos
  */
  public function coletadosAction() {
    $tbCad = new Application_Model_CadastroDoExame();
    $this->view->itens = $tbCad->getListaColetados();
  }

  /**
  * Mostra o resultado do exame (itx_codigo)
  */
  public function verAction() {
    Zend_Layout::getMvcInstance()->disableLayout();

    $agei_codigo = $this->_getParam("id", FALSE);
    if (!$agei_codigo)
    return FALSE;

    $tbRes = new Application_Model_ResultadoExame();
    $this->view->itens = $tbRes->getResultados($agei_codigo);
  }

  public function salvarAction() {
    $tipo = $this->_getParam("tipo", NULL);
    $ate_codigo = $this->_getParam("ate_codigo", NULL);
    $usu_codigo = $this->_getParam("usu_codigo", NULL);
    $reqCodigo = $this->_getParam("req_codigo", NULL);
    $pre_natal = $this->_getParam("pre_natal", FALSE);
    $dataSolicitacao = $this->_request->getPost("dataSolicitacao", NULL);

    if ($pre_natal) {
      $dados = array(
          "ate_codigo" => ($ate_codigo ? $ate_codigo : $this->_request->getPost("ate_codigo", NULL)),
          "proc_codigo" => $this->_request->getPost("proc_codigo", NULL),
          "req_observacao" => $this->_request->getPost("req_observacao", NULL),
          "req_encaminhamento" => $this->_request->getPost("req_encaminhamento", NULL),
          "proc_solicitado" => $this->_request->getPost("proc_solicitado", NULL),
          "proc_avaliado" => $this->_request->getPost("proc_avaliado", NULL),
          "data_solicitacao" => (!empty($dataSolicitacao) ? $dataSolicitacao : date('Y-m-d'))
      );

      if ($this->_request->getPost("usu_codigo")) {
          $dados['usu_codigo'] = $this->_request->getPost("usu_codigo");
      }
      if ($dados['req_encaminhamento'] == "") {
          $dados['req_encaminhamento'] = 'f';
      }

      $req_codigo = (new Application_Model_RequisicaoExame())->salvar($dados);
      $this->view->dados = array("success" => true, "req_codigo" => $req_codigo);
      return $this->render("dados", NULL, TRUE);
    }
    else {
      $dados = [
        "ate_codigo" => $ate_codigo,
        "proc_codigo" => $this->_getParam("proc_codigo", NULL),
        "req_observacao" => $this->_getParam("observacao", NULL),
        "req_encaminhamento" => 'f',
        "usu_codigo" => $usu_codigo,
        "proc_solicitado" => ($tipo == 'solicitado' ? 'S' : NULL),
        "proc_avaliado" => ($tipo == 'avaliado' ? 'A' : NULL),
        "data_solicitacao" => ($tipo == 'solicitado' ? $this->_getParam("data_solicitacao", NULL) : NULL),
        "data_realizacao" => ($tipo == 'avaliado' ? $this->_getParam("data_realizacao", NULL) : NULL),
        "data_resultado" => ($tipo == 'avaliado' ? $this->_getParam("data_resultado", NULL) : NULL),
      ];

      if (!empty($reqCodigo)) {
        $dados["req_codigo"] = $reqCodigo;
      }

      (new Application_Model_RequisicaoExame())->salvar($dados);
    }

    $this->_redirect("/prontuario/exame");
  }

  public function excluirAction() {
    (new Application_Model_RequisicaoExame())->excluir($this->_getParam("id", 0));

    if ($this->_getParam("pre_natal", FALSE)) {
      $this->view->dados = array("success" => true);
      return $this->render("dados", NULL, TRUE);
    }
    return $this->_redirect("/prontuario/exame");
  }

  public function editarAction() {
    $id = $this->_request->getPost("id", NULL);
    $tbReq = new Application_Model_RequisicaoExame();
    $dados = $tbReq->getDadosExame($id);

    return $dados;
  }

  public function imprimirAction() {
    Zend_Layout::getMvcInstance()->setLayout("paisagem-print");
    $this->view->title = "Imprimir Requisição de Exame";

    $io_codigo = $this->_getParam("cod", FALSE);
    $usu_codigo = $this->_getParam("usu_codigo", FALSE);
    $ate_codigo = $this->_getParam("ate_codigo", FALSE);
    $selecionados = $this->_getParam("selecionados", FALSE);

    if (empty($usu_codigo))
      $usu_codigo = $_SESSION['prontuario']['age']->usu_codigo;

    $tbSec = new Application_Model_Secretaria();
    $tbReq = new Application_Model_RequisicaoExame();
    $tbConf = new Application_Model_Configuracao();
    $tbUsr = new Application_Model_Usuarios();
    $this->view->usr = $tbUsr->getUsrAtual();
    $this->view->secretaria = $tbSec->getDadosSec();
    $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
    $this->view->tipo_impressao = "PEDIDO DE EXAMES";
    $this->view->duasvias = 'false';
    $this->view->dados = $tbReq->imprimir($selecionados, $io_codigo, $usu_codigo, $ate_codigo);
  }

  public function imprimirSelecionadosAction() {
    $this->_helper->layout->setLayout("prontuario");
    $tbUsr = new Application_Model_Usuarios();
    $this->view->selecionados = $this->_getParam("imprimir", array());
    $this->view->isMedico = $tbUsr->isMedico();

    return $this->render("index");
  }

  public function salvaObservacaoAction() {
    $dados = [
      "req_codigo" => $this->_request->getPost("req_codigo", FALSE),
      "req_observacao" => $this->_request->getPost("req_observacao", FALSE),
    ];

    $mensagem = (new Application_Model_RequisicaoExame())->salvaObs($dados);
    $this->view->dados = "Observação Salva com sucesso!";
    return $this->render("dados", NULL, TRUE);
  }

}
