<?php

require_once __DIR__ . '/../../Util.php';

class Prontuario_IndexController extends Zend_Controller_Action {

    private $_p;

    public function init() {
        Zend_Layout::getMvcInstance()->setLayout("prontuario");
        $this->_p = new Zend_Session_Namespace("prontuario");
    }

    public function indexAction() {

        $this->view->title = "Prontuário Eletrônico";
        // ha paciente em atendimento?
        $tbAgenda = new Application_Model_Agendamento();
        if (false !== ($age = $tbAgenda->usuEmAberto('true'))) {
            $this->view->age = $age;
            $this->view->term = $this->_request->getPost("term", FALSE);
        } else // vai para "agenda do dia"
            return $this->_redirect("/prontuario/agenda-do-dia");
    }

    public function menuAction() {
        $tbUsr = new Application_Model_Usuarios();
        $tbAte = new Application_Model_Atendimento();
        $tbPC = new Application_Model_PreConsulta();
        $tbAgenda = new Application_Model_Agendamento();
        $medicos = $tbAgenda->getAgenda();

        if ($tbUsr->isMedico()) {
            $this->view->medicos = $medicos;
        } else {
            $listaDeMedicos = array();
            foreach ($medicos as $medico) {
                $contadorControle = 0;
                foreach ($listaDeMedicos as $medicoDaLista) {
                    if ($medico['usr_nome'] == $medicoDaLista['usr_nome']) {
                        $contadorControle = $contadorControle + 1;
                    }
                }
                if ($contadorControle == 0) {
                    $listaDeMedicos[] = $medico;
                }
            }
            $this->view->medicos = $listaDeMedicos;
        }

        if (isset($this->_p->age)) {
            $this->view->age = $this->_p->age;

            $this->view->temAtendimento = $tbAte->temAtendimentoMedico($this->_p->age->age_codigo);


            $this->view->temPreConsulta = $tbPC->temPreConsulta($this->_p->age->age_codigo);
            $this->view->isConsultaComEnfermeiro = ($this->_p->age->med_codigo == $tbUsr->getUsrAtual()->usr_codigo);
            $this->view->enfUpa = $this->_p->age->med_codigo;
        }
        $this->view->isMedico = $tbUsr->isMedico();
        $this->view->fazPreConsulta = $tbUsr->fazPreConsulta();
        $this->view->tipo_usr = $tbUsr->getUsrAtual()->usr_tipo_medico;
    }

    public function iniciarAction() {
        $age_codigo = $this->_getParam("cod", FALSE);
        $tbAge = new Application_Model_Agendamento();
        if ($age_codigo && !$tbAge->usuEmAberto())
            $tbAge->iniciar($age_codigo);

        $tbCha = new Application_Model_Chamada();
        $chamada = $tbCha->getChamadaPorAgendamento($age_codigo);
        if(!$chamada){
            $agendamento = $tbAge->getDadosAgendamentoUsuario($age_codigo);
            $tbUsr = new Application_Model_Usuarios();
            $usuario_atual = $tbUsr->getUsrAtual();
            $setor = $usuario_atual->esp_nome;
            if($usuario_atual->set_nome){
                $set = explode('-',$usuario_atual->set_nome);
                $setor = $set[0];
            }
            $dataCha = array(
                "cha_codigo" => null,
                "age_codigo" => $age_codigo,
                "cha_usu_prontuario" => $agendamento->usu_prontuario,
                "cha_paciente" => $agendamento->age_paciente,
                "cha_profissional" => $usuario_atual->usr_nome,
                "cha_setor" => $setor,
                "uni_codigo" => $usuario_atual->uni_codigo,
                "cha_status" => "C",
                "cha_chamar" => '0'
            );
            Util::chamada($dataCha);
        }
        return $this->_redirect("/prontuario");
    }

    public function ausentarAction(){
        $age_codigo = $this->_getParam("age", FALSE);
        $tbAge = new Application_Model_Agendamento();

        $tbAge->alteraSituacao("F", $age_codigo);

        $s = new Zend_Session_Namespace("prontuario");
        $s->unsetAll();
        $this->_redirect("/prontuario/agenda-do-dia");
    }

    public function liberarAction() {
        Application_Model_Agendamento::cancelarAgendaAtual();
        $tbUsr = new Application_Model_Usuarios();
        $tbPc = new Application_Model_PreConsulta();
        $age_codigo = $this->_getParam("age", FALSE);
        $tbAte = new Application_Model_Atendimento();
        $ate = $tbAte->estaEmAtendimento($age_codigo);
        $tbAge = new Application_Model_Agendamento();

        if ($tbUsr->isMedico()) {
            $retorno = $tbAte->buscaRetornoOrigem($age_codigo);
            if ($retorno->ate_encaminhamento == "S") {
                $tbAge->alteraSituacao("I", $age_codigo);
            } else {
                $tbAge->alteraMedico($age_codigo, $ate->med_codigo, 'P');
            }
        } else {
            $retorno = $tbAte->buscaRetornoOrigem($age_codigo);
            if ($retorno->ate_encaminhamento == "S") {
                $tbAge->alteraSituacao("I", $age_codigo);
            } else {
                $tbAge->alteraMedico($age_codigo, $ate->med_codigo, 'S');
            }
        }

        $status = $tbAge->getDadosAgendamentoUsuario($age_codigo)->age_status;
        if(trim($status) == Util::ATEND_INICIADO){
            Util::alteraStatusAgendamento($age_codigo, Util::RECEPCIONADO);
        } else if(trim($status) == Util::PRE_CONSULTA){
            Util::alteraStatusAgendamento($age_codigo, Util::RECEPCIONADO_PRE);
        } else {
            Util::alteraStatusAgendamento($age_codigo, Util::PRE_CONSULTA_FINAL);
        }

        $s = new Zend_Session_Namespace("prontuario");
        $s->unsetAll();
        $this->_redirect("/prontuario/agenda-do-dia");
    }

    public function cancelarAction() {
        setcookie("ate_reclamacao",' ') ;
        unset($_COOKIE["ate_reclamacao"]);
        setcookie("ate_exame_fisico",' ') ;
        unset($_COOKIE["ate_exame_fisico"]);
        setcookie("ate_diagnostico",' ') ;
        unset($_COOKIE["ate_diagnostico"]);
        setcookie("ate_tratamento",' ') ;
        unset($_COOKIE["ate_tratamento"]);
        setcookie("ate_curativo",' ') ;
        unset($_COOKIE["ate_curativo"]);

        Application_Model_Agendamento::cancelarAgendaAtual();
        $tbUsr = new Application_Model_Usuarios();
        $tbPc = new Application_Model_PreConsulta();
        $age_codigo = $this->_getParam("age", FALSE);
        $tbAte = new Application_Model_Atendimento();
        $ate = $tbAte->estaEmAtendimento($age_codigo);
        $tbAge = new Application_Model_Agendamento();
        $dados = $tbAge->getDadosAgendamentoUsuario($age_codigo);
        if(trim($dados->usr_cod_status) !== $_SESSION[id_login]){
            return $this->_redirect("/prontuario/agenda-do-dia");
        }

        if ($tbUsr->isMedico()) {
            $retorno = $tbAte->buscaRetornoOrigem($age_codigo);
            if ($retorno->ate_encaminhamento == "S") {
                $tbAge->alteraSituacao("I", $age_codigo);
            } else {
                $tbAge->alteraMedico($age_codigo, $ate->med_codigo, 'P');
            }
        } else {
            $retorno = $tbAte->buscaRetornoOrigem($age_codigo);
            if ($retorno->ate_encaminhamento == "S") {
                $tbAge->alteraSituacao("I", $age_codigo);
            } else {
                $tbAge->alteraMedico($age_codigo, $ate->med_codigo, 'S');
            }
        }

        $status = $tbAge->getDadosAgendamentoUsuario($age_codigo)->age_status;
        if(trim($status) == Util::ATEND_INICIADO){
            Util::alteraStatusAgendamento($age_codigo, Util::RECEPCIONADO);
        } else if(trim($status) == Util::PRE_CONSULTA){
            Util::alteraStatusAgendamento($age_codigo, Util::RECEPCIONADO_PRE);
        } else {
            Util::alteraStatusAgendamento($age_codigo, Util::PRE_CONSULTA_FINAL);
        }

        $s = new Zend_Session_Namespace("prontuario");
        $s->unsetAll();
        $this->_redirect("/prontuario/agenda-do-dia");
    }

    public function destroiSessionAction() {
        $s = new Zend_Session_Namespace("logon");
        $s->unsetAll();
        $s = new Zend_Session_Namespace("prontuario");
        $s->unsetAll();
        return $this->_redirect("/prontuario/agenda-do-dia");
    }
}
