<?php

class Prontuario_ReceitaMedicaController extends Zend_Controller_Action {
	public function init() {
		$this->_helper->acl->copiarPermissao("zf/prontuario/index");
		$this->view->title = "Medicamento";
	}

	public function indexAction() {
		$this->_helper->layout->setLayout("prontuario");
		$tbIRec = new Application_Model_ReceitaItens();
		$tbUsu = new Application_Model_Usuario();

		$this->view->ate_codigo = $this->_getParam("ate_codigo", FALSE);
		$this->view->io_codigo = $this->_getParam("io_codigo", FALSE);
		$this->view->imprimi = $this->_getParam("imprimi", FALSE);

		$this->view->usu_codigo = $_SESSION['prontuario']['age']->usu_codigo
			? $_SESSION['prontuario']['age']->usu_codigo
			: $this->_getParam("usu_codigo", FALSE);

		$this->usuario = $this->view->usu_codigo;

		$age_codigo = $_SESSION['prontuario']['age']->age_codigo;
		if ($age_codigo) {
			$tbPC = new Application_Model_PreConsulta();
			$this->view->preconsulta = $tbPC->temPreConsulta($age_codigo);
		}

		//Obs = S: Abertto pela tela de Internação
		$this->view->obs = $this->_getParam("obs", FALSE);
		if ($this->view->obs) {
			$this->_helper->layout->disableLayout();
		}

		$this->view->itensPosto = $tbIRec->getItens("posto");
		$this->view->itensControlados = $tbIRec->getItens("controlados");
		$this->view->itensExternos = $tbIRec->getItens("externo");

		$tbRec = new Application_Model_Receita();
		$this->view->ddPosto = $tbRec->temReceita("posto");
		$this->view->ddControlados = $tbRec->temReceita("controlados");
		$this->view->ddExterno = $tbRec->temReceita("externo");

		$dataValidade = new DateTime('NOW');
		$dataValidade->add(new DateInterval('P1M'));
		$this->view->dataValidade = $dataValidade->format('d/m/Y');
	}

	public function verificaHistoricoAction() {
		$usu_codigo = $this->_getParam("usu_codigo", NULL);
		$tbIRec = new Application_Model_ReceitaItens();
		$hist_p = $tbIRec->getCountHistoricoReceitaItens($usu_codigo, "posto");
		$hist_c = $tbIRec->getCountHistoricoReceitaItens($usu_codigo, "controlados");
		$this->view->dados = array("hist_p" => ($hist_p > 0), "hist_c" => ($hist_c > 0));
		return $this->render("dados", NULL, FALSE);
	}

	public function salvarMedicamentoAction() {
		$tbAte = new Application_Model_Atendimento();
		$age_codigo = Application_Model_Agendamento::usuEmAberto()->age_codigo;
		$tbIRec = new Application_Model_ReceitaItens();

		$receita = $this->_request->getPost("receita", NULL);
		$itens   = $this->_request->getPost("itens", NULL);
		$tipo    = $this->_request->getPost("tipo", NULL);

		$ate_codigo = ($receita['ate_codigo'] ? $receita['ate_codigo'] : $tbAte->getCodigoAtendimentoPorAgendamento($age_codigo)->ate_codigo);

		$validade = date("Y-m-d", strtotime(str_replace('/', '-', $receita['rec_validade'])));
		$dadosRec = [
			"ate_codigo" => $ate_codigo,
			"rec_tipo" => $tipo,
			"rec_validade" => $validade,
			"rec_data" => ($_POST["rec_data"] != NULL ? $_POST['rec_data'] : date('Y-m-d')),
		];

		try {
			$rec_codigo = (new Application_Model_Receita())->salvar($dadosRec);
			foreach ($itens as $item) {
				$dadosItens = array(
					"rec_codigo" => $rec_codigo,
					"pro_codigo" => ($tipo == 'externo' ? NULL : $item['pro_codigo']),
					"irec_quantidade" => $item['irec_quantidade'],
					"irec_qtde_pendente" => $item['irec_quantidade'],
					"irec_recomendacao" => $item['irec_recomendacao'],
					"irec_produto" => ($tipo == 'externo' ? $item['irec_produto'] : NULL),
					"desc_produto" => ($tipo == 'externo' ? $item['desc_produto'] : NULL)
				);
				$tbIRec->salvar($dadosItens, $tipo);
			}
			$rec_itens = $tbIRec->getItens($tipo, $rec_codigo)->toArray();
			$this->view->dados = array("error" => FALSE, "mensagem" => "", "itens" => $rec_itens);
		} catch (Zend_Validate_Exception $e) {
			$this->view->dados = array("error" => TRUE, "mensagem" => $e->getMessage());
		}
		return $this->render("dados", NULL, FALSE);
	}

	public function excluirItemReceitaAction() {
		$irec_codigo = $this->_getParam("irec_codigo", FALSE);
		$tipo = $this->_getParam("tipo", FALSE);
		try {
			$item = (new Application_Model_ReceitaItens())->excluir($irec_codigo);
			if($item->rec_codigo){
				$rec_itens = (new Application_Model_ReceitaItens())->getItens($tipo, $item->rec_codigo)->toArray();
				$this->view->dados = array("error" => FALSE, "mensagem" => "", "itens" => $rec_itens);
			}else{
				$this->view->dados = array("error" => TRUE, "mensagem" => "Este item não pode ser excluido pois não pertence a este agendamento");
			}
		} catch (Exception $e) {
			$this->view->dados = array("error" => TRUE, "mensagem" => $e->getMessage());
		}
		return $this->render("dados", NULL, FALSE);
	}

	public function historicoAction(){
		$ate_codigo = $this->_getParam("id", FALSE);
		if(!$ate_codigo)
			return $this->_redirect ("/prontuario");

		$tipo = $this->_getParam("tipo","posto");

		$tbIRec = new Application_Model_ReceitaItens();
		$this->view->itens = $tbIRec->getHistorico($ate_codigo,$tipo);
		$this->view->tipo = $tipo;
	}

	public function historicoMedicamentoAction(){
		$this->_helper->layout->disableLayout();
		$this->view->tipo = $this->_getParam("tipo", NULL);
		$usu_codigo = $this->_getParam("usu_codigo", NULL);
		$tbIRec = new Application_Model_ReceitaItens();
		$this->view->itensHistorico = $tbIRec->getHistoricoReceitaItens($usu_codigo, $this->view->tipo);
	}

	public function imprimirAction(){
		Zend_Layout::getMvcInstance()->setLayout("simples");
		$tbSec = new Application_Model_Secretaria();
		$this->view->sec = $tbSec->getDadosSec()->toArray();
		$tbUsr = new Application_Model_Usuarios();
		$this->view->usr = $tbUsr->getUsrAtual();
		$selecionados = $this->_getParam("selecionados", FALSE);

		$tipo = $this->_getParam("caminhoTipo","posto");
		$seg = $this->_getParam("seg",FALSE);
		$this->view->seg = $seg;
		$this->view->tipo = $tipo;
		$io_codigo = $this->_getParam("io_codigo", FALSE);
		$usu_codigo = $this->_getParam("usu_codigo", FALSE);
		$tbRec = new Application_Model_Receita();
		$this->view->dados = $tbRec->imprimir($tipo,$io_codigo,$usu_codigo,$selecionados);

		$this->view->dados_usr = $tbUsr->getUsrAtual();
		$this->view->tipo_impressao = "RECEITUÁRIO";
	}

	public function imprimirAnvisaAction(){
		$tbSec = new Application_Model_Secretaria();
		$this->view->sec = $tbSec->getDadosSec()->toArray();
		$tbUsr = new Application_Model_Usuarios();
		$this->view->usr = $tbUsr->getUsrAtual();
		$this->_helper->layout->disableLayout();
		$selecionados = $this->_getParam("selecionados", FALSE);

		$tipo = $this->_getParam("caminhoTipo","posto");

		$this->view->tipo = $tipo;
		$io_codigo = $this->_getParam("io_codigo",FALSE);
		$usu_codigo = $this->_getParam("usu_codigo",FALSE);
		$tbRec = new Application_Model_Receita();
		$this->view->dados = $tbRec->imprimir($tipo,$io_codigo,$usu_codigo,$selecionados);
		$this->view->dados_usr = $tbUsr->getUsrAtual();
	}
}
