<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 24/07/2018
 * Time: 11:15
 */

require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";

class Relatorio_AgendamentoController extends Zend_Controller_Action
{

    //Iniciando Filtros
    public function agendamentoPorUnidadeAction()
    {
        $this->view->title = "Agendamento Por Unidade";
        //Pega a lista de Unidades para a view
        $tbUni = new Application_Model_Unidade();
        $tbUsr = new Application_Model_Usuarios();
        if($tbUsr->getUsrAtual()->usr_acesso_unidades == "S") {
            $this->view->unidade = $tbUni->getUnidades();
        }else{
            $this->view->unidade = $tbUni->getUnidadePorUsuario($tbUsr->getUsrAtual()->usr_codigo);
        }
    }

    //Gerando Relatórios
    public function gerarRelatorioPorUnidadeAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $data_inicial = $this->_getParam("data_inicial", NULL);
        $data_final = $this->_getParam("data_final", NULL);
        $tp_rel = $this->_getParam("tp_rel", NULL);
        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "agendamentoPorUnidade", [
            "unidade" => $unidade,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "tpRel" => $tp_rel
        ]);
        $this->render("dados", NULL, TRUE);
    }

    public function filaDeEsperaAction()
    {
        $this->view->title = "Relatório Fila de Espera";

        $tbFila = new Application_Model_Filas();
        $this->view->filas = $tbFila->listar();

        $tbTipoatend = new Application_Model_FilasTipoatendimentos();
        $this->view->tipoatend = $tbTipoatend->listar();

        $prio = new Application_Model_FilasPrioridades();
        $this->view->prioridade = $prio->listar();
    }

    public function gerarRelatorioFilaDeEsperaAction()
    {

        $fiusu_data_entrada = $this->_getParam("dataEntrada", NULL);
        $fila_codigo = $this->_getParam("filaCodigo", NULL);
        $usu_codigo = $this->_getParam("usuCodigo", NULL);
        $status = $this->_getParam("status", NULL);
        if($status == "TD"){
            $status = null;
        }
        $uni_codigo = $this->_getParam("uniCodigo", NULL);
        $esp_codigo = $this->_getParam("espCodigo", NULL);
        $proc_codigo = $this->_getParam("procCodigo", NULL);
        $usr_codigo = $this->_getParam("usrCodigo", NULL);
        $fiti_codigo = $this->_getParam("fitiCodigo", NULL);
        $fipr_codigo = $this->_getParam("fiprCodigo", NULL);
        $tp_rel = $this->_getParam("tp_rel", NULL);
        $agrupamento = $this->_getParam("agrupamento", NULL);


        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "filaDeEspera", [
            "dataEntrada" => $fiusu_data_entrada,
            "filaCodigo" => $fila_codigo,
            "usuCodigo" => $usu_codigo,
            "status" => $status,
            "uniCodigo" => $uni_codigo,
            "espCodigo" => $esp_codigo,
            "procCodigo" => $proc_codigo,
            "usrCodigo" => $usr_codigo,
            "fitiCodigo" => $fiti_codigo,
            "fiprCodigo" => $fipr_codigo,
            "tpRel" => $tp_rel,
            "agrupamento" => $agrupamento,
        ]);


        $this->render("dados", NULL, TRUE);
    }

	//Iniciando Filtros
	public function agendamentoPorProfissionalAction()
	{
		$this->view->title = "Agendamento Por Profissional";

		$tbUni = new Application_Model_Unidade();
        $tbUsr = new Application_Model_Usuarios();
        if($tbUsr->getUsrAtual()->usr_acesso_unidades == "S") {
            $this->view->unidade = $tbUni->getUnidades();
        }else{
            $this->view->unidade = $tbUni->getUnidadePorUsuario($tbUsr->getUsrAtual()->usr_codigo);
        }

		$tbUsr = new Application_Model_Usuarios();
		$this->view->profissionais = $tbUsr->getProfissionaisPorUnidade();
	}

	public function listaProfissionaisPorUnidadeAction(){
    	$uni_codigo = $this->_getParam("uni_codigo", NULL);
		$tbUsr = new Application_Model_Usuarios();
		$this->view->dados = $tbUsr->getProfissionaisPorUnidade($uni_codigo)->toArray();
		return $this->render("dados", null, TRUE);
	}

	//Gerando Relatórios
	public function gerarRelatorioPorProfissionalAction()
	{
		$unidade = $this->_getParam("unidade", NULL);
		$profissional = $this->_getParam("profissional", NULL);
		$situacao = $this->_getParam("situacao", NULL);
		$data_inicial = $this->_getParam("data_inicial", NULL);
		$data_final = $this->_getParam("data_final", NULL);
		$tp_rel = $this->_getParam("tp_rel", NULL);;
		$gerador = new GeradorRelatorio();
		$this->view->dados = $gerador->gerar("SAUDE", "agendamentoPorProfissional", [
			"unidade" => $unidade,
			"profissional" => $profissional,
			"situacao" => $situacao,
			"dtInicial" => $data_inicial,
			"dtFinal" => $data_final,
			"tpRel" => $tp_rel
		]);
		$this->render("dados", NULL, TRUE);
	}

	//Filtros
    public function consultasAgendadasAction()
    {
        $this->view->title = "Listagem de Consultas Agendadas";
        //Pega a lista de Unidades para a view
        $tbUni = new Application_Model_Unidade();
        $tbUsr = new Application_Model_Usuarios();
        if($tbUsr->getUsrAtual()->usr_acesso_unidades == "S") {
            $this->view->unidade = $tbUni->getUnidades();
        }else{
            $this->view->unidade = $tbUni->getUnidadePorUsuario($tbUsr->getUsrAtual()->usr_codigo);
        }
    }

    //Gerando Relatórios
    public function gerarRelatorioConsultasAgendadasAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $data_inicial = $this->_getParam("data_inicial", NULL);
        $data_final = $this->_getParam("data_final", NULL);
        $tp_rel = "SINTETICO";
        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "consultasAgendadas", [
            "unidade" => $unidade,
            "profissional" => $profissional,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "tpRel" => $tp_rel
        ]);
        $this->render("dados", NULL, TRUE);
    }

    public function formAgendamentoExternoMedicoAction(){
        $this->view->title = "Agendamento Externo por Médico e Especialidade";
    }

    public function gerarRelatorioAgendamentoExternoMedicoAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $especialidade = $this->_getParam("especialidade", NULL);
        $med_destino = $this->_getParam("medicoDestino", NULL);
        $med_solicitante = $this->_getParam("medicoSolicitante", NULL);
        $situacao = $this->_getParam("situacao", NULL);
        $grau_risco = $this->_getParam("grauRisco", NULL);
        $data_inicial = $this->_getParam("dataInicial", NULL);
        $data_final = $this->_getParam("dataFinal", NULL);
        $tp_rel = $this->_getParam("tpRel", NULL);;
        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "agendamentoExternoMedico", [
            "unidade" => $unidade,
            "especialidade" => $especialidade,
            "medicoDestino" => $med_destino,
            "medicoSolicitante" => $med_solicitante,
            "situacao" => $situacao,
            "grauRisco" => $grau_risco,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "tpRel" => $tp_rel
        ]);
        $this->render("dados", NULL, TRUE);
    }

    public function formAgendamentoExternoUnidadeAction(){
        $this->view->title = "Agendamento Externo por Unidade e Especialidade";
    }

    public function gerarRelatorioAgendamentoExternoUnidadeAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $especialidade = $this->_getParam("especialidade", NULL);
        $procedimento = $this->_getParam("procedimento", NULL);
        $situacao = $this->_getParam("situacao", NULL);
        $grau_risco = $this->_getParam("grauRisco", NULL);
        $data_inicial = $this->_getParam("dataInicial", NULL);
        $data_final = $this->_getParam("dataFinal", NULL);
        $tp_rel = $this->_getParam("tpRel", NULL);;
        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "agendamentoExternoUnidade", [
            "unidade" => $unidade,
            "especialidade" => $especialidade,
            "procedimento" => $procedimento,
            "situacao" => $situacao,
            "grauRisco" => $grau_risco,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "tpRel" => $tp_rel
        ]);
        $this->render("dados", NULL, TRUE);
    }

}