<?php

require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";

class Relatorio_AtendimentoController extends Elotech_Controller_Action_Relatorio {

	private $tbAte;

	public function init() {
		$this->_helper->acl->allow(NULL);
		$this->view->title = "Relatório de Atendimento por Idade";
		$this->tbAte = new Application_Model_Atendimento();
	}

	public function indexAction() {

	}

	public function procedimentosPorUnidadeAction() {
		$uni_codigo = $this->_request->getPost("uni_codigo", FALSE);
		$data_inicial = $this->_request->getPost("data_inicial", FALSE);
		$data_final = $this->_request->getPost("data_final", FALSE);

		if (!$uni_codigo) {
			$this->view->action = array("action" => "procedimentos-por-unidade");
			return $this->render("unidade-data", NULL, TRUE); // mostra action para pedir os dados
		}

		$where = $this->tbAte->relProcedimentoPorUnidade($this->view, $uni_codigo, $data_inicial, $data_final);
		$this->relatorio($where);
	}

	public function relAtendimentoPorIdadeAction() {
		$this->view->title = "Relatório de Atendimento por Idade";
		Zend_Layout::getMvcInstance()->setLayout("relatorio");

		$uni_codigo = $this->_request->getPost("uni_codigo", FALSE);
		$uni_desc = $this->_request->getPost("uni_desc", FALSE);
		$usr_codigo = $this->_request->getPost("usr_codigo", FALSE);
		$usr_nome = $this->_request->getPost("usr_nome", FALSE);
		$esp_codigo = $this->_request->getPost("esp_codigo", FALSE);
		$data_inicial = $this->_request->getPost("data_inicial", FALSE);
		$data_final = $this->_request->getPost("data_final", FALSE);

		$this->view->unidade = $uni_desc;
		$this->view->usr_nome = $usr_nome;
		$this->view->dados = $this->tbAte->relAtendimentoPorIdade($uni_codigo, $usr_codigo, $esp_codigo, $data_inicial, $data_final);
		$array = array('data_inicial' => $data_inicial,
			'data_final' => $data_final,
			'uni_desc' => $uni_desc,
			'usr_nome' => $usr_nome);
		$this->view->params = serialize($array);
		$this->view->title = "Relatório de Atendimento por Idade";

		return $this->render("atendimento-por-idade");
	}

	public function relAtendimentoPorAgravoAction() {
		$this->view->title = 'Atendimento por Agravo (CIAP)';
		Zend_Layout::getMvcInstance()->setLayout("relatorio");
		$dataInicial = $this->_request->getPost("data_inicial", FALSE);
		$dataFinal = $this->_request->getPost("data_final", FALSE);
		$ciapCodigos = $this->_request->getPost("ciap-selecionados", FALSE);
		$ciapCodigos = implode(',', $ciapCodigos);
		$profCodigo = $this->_request->getPost("usr_codigo", FALSE);
		$profNome = $this->_request->getPost("usr_nome", FALSE);
		$uniCodigo = $this->_request->getPost("uni_codigo", FALSE);
		$uniNome = $this->_request->getPost("uni_desc", FALSE);
		$tipo_relatorio = $this->_request->getPost("tipo_relatorio", FALSE);
//        echo "<pre>".print_r($ciapCodigos,1);
//        die();

		// Lista dados relatório
		$tbAte = new Application_Model_Atendimento();
		$dados = $tbAte->relListaAtendimentosPorAgravo($dataInicial, $dataFinal, $ciapCodigos, $profCodigo, $uniCodigo, $tipo_relatorio)->toArray();
		$this->view->dados = $dados;
		$this->view->tipo_relatorio = $tipo_relatorio;
//      echo "<pre>".print_r($dados,1);
//      die();

		// Dados Layout Padrão Relatório
		$tbUsr = new Application_Model_Usuarios();
		$tbUnidade = new Application_Model_Unidade();
		$_arrayNomeUnidade = $tbUnidade->getUnidade($uniCodigo);
		$nomeUnidade = $_arrayNomeUnidade[0]['uni_desc'];
		$unidade = $uniCodigo ? $nomeUnidade : 'TODAS';
		$this->view->unidade = $unidade;

		$array = array('data_inicial' => $dataInicial,
			'data_final' => $dataFinal,
			'uni_desc' => $uniNome,
			'usr_nome' => $profNome);
		if ($dataInicial) {
			$array["data_inicial"] = $dataInicial;
		}
		if ($dataFinal) {
			$array["data_final"] = $dataFinal;
		}
		$this->view->params = serialize($array);
	}

	public function relAtendimentoPorCidAction() {
		$this->view->title = 'Atendimento por CID';
		Zend_Layout::getMvcInstance()->setLayout("relatorio");
		$dataInicial = $this->_request->getPost("data_inicial", FALSE);
		$dataFinal = $this->_request->getPost("data_final", FALSE);
		$cidCodigo = $this->_request->getPost("cd10_codigo", FALSE);
		$uniCodigo = $this->_request->getPost("uni_codigo", FALSE);
		$uniNome = $this->_request->getPost("uni_desc", FALSE);


		// Lista dados relatório
		$tbAte = new Application_Model_Atendimento();
		$dados = $tbAte->relListaAtendimentosPorCid($dataInicial, $dataFinal, $cidCodigo, $uniCodigo)->toArray();
		$this->view->dados = $dados;
//      echo "<pre>".print_r($dados,1);
//      die();

		// Dados Layout Padrão Relatório
		$tbUnidade = new Application_Model_Unidade();
		$_arrayNomeUnidade = $tbUnidade->getUnidade($uniCodigo);
		$nomeUnidade = $_arrayNomeUnidade[0]['uni_desc'];
		$unidade = $uniCodigo ? $nomeUnidade : 'TODAS';
		$this->view->unidade = $unidade;

		$array = array('data_inicial' => $dataInicial,
			'data_final' => $dataFinal,
			'uni_desc' => $uniNome,
			'cid_nome' => $cidNome);
		if ($dataInicial) {
			$array["data_inicial"] = $dataInicial;
		}
		if ($dataFinal) {
			$array["data_final"] = $dataFinal;
		}
		$this->view->params = serialize($array);
	}

	public function relAtendimentoPorCondutaAction() {

		Zend_Layout::getMvcInstance()->setLayout("relatorio");
		$dataInicial = $this->_request->getPost("data_inicial", FALSE);
		$dataFinal = $this->_request->getPost("data_final", FALSE);

		$condutas = $this->_request->getPost("condutas-selecionadas", FALSE);
		$condutas = implode(",", $condutas);

		$condutas_odonto = $this->_request->getPost("condutas-odonto-selecionadas", FALSE);
		$condutas_odonto = implode(",", $condutas_odonto);

		$uniCodigo = $this->_request->getPost("uni_codigo", FALSE);
		$uniNome = $this->_request->getPost("uni_desc", FALSE);
		$tipoConduta = $this->_request->getPost("tipo_conduta", FALSE);

		if ($tipoConduta == 'A') {
			// Lista dados relatório de atendimento individual
			$this->view->title = 'Conduta por Atendimento Individual';
			$tbAte = new Application_Model_Atendimento();
			$dados = $tbAte->relListaAtendimentosPorConduta($dataInicial, $dataFinal, $condutas, $uniCodigo)->toArray();
		} else {
			// Lista dados relatório de atendimento odontológico
			$this->view->title = 'Conduta por Atendimento Odontológico';
			$tbAte = new Application_Model_Atendimento();
			$dados = $tbAte->relListaAtendimentosPorCondutaOdonto($dataInicial, $dataFinal, $condutas_odonto, $uniCodigo)->toArray();
		}
		$this->view->dados = $dados;

		// Dados Layout Padrão Relatório
		$tbUnidade = new Application_Model_Unidade();
		$_arrayNomeUnidade = $tbUnidade->getUnidade($uniCodigo);
		$nomeUnidade = $_arrayNomeUnidade[0]['uni_desc'];
		$unidade = $uniCodigo ? $nomeUnidade : 'TODAS';
		$this->view->unidade = $unidade;

		$array = array('data_inicial' => $dataInicial,
			'data_final' => $dataFinal,
			'uni_desc' => $uniNome,
			'cid_nome' => $cidNome);
		if ($dataInicial) {
			$array["data_inicial"] = $dataInicial;
		}
		if ($dataFinal) {
			$array["data_final"] = $dataFinal;
		}
		$this->view->params = serialize($array);
	}

	public function relAtendimentoPorTipoAction() {
		$this->view->title = 'Atendimento por Tipo e Estabelecimento';
		Zend_Layout::getMvcInstance()->setLayout("relatorio");
		$dataInicial = $this->_request->getPost("data_inicial", FALSE);
		$dataFinal = $this->_request->getPost("data_final", FALSE);
		$profCodigo = $this->_request->getPost("usr_codigo", FALSE);
		$profNome = $this->_request->getPost("usr_nome", FALSE);
		$uniCodigo = $this->_request->getPost("uni_codigo", FALSE);
		$uniNome = $this->_request->getPost("uni_desc", FALSE);
//        echo "<pre>".print_r($ciapCodigos,1);
//        die();

		// Lista dados relatório
		$tbAte = new Application_Model_Atendimento();
		$dados = $tbAte->relListaAtendimentosPorNivel($dataInicial, $dataFinal, $profCodigo, $uniCodigo)->toArray();
		$this->view->dados = $dados;
//      echo "<pre>".print_r($dados,1);
//      die();

		// Dados Layout Padrão Relatório
		$tbUsr = new Application_Model_Usuarios();
		$tbUnidade = new Application_Model_Unidade();
		$_arrayNomeUnidade = $tbUnidade->getUnidade($uniCodigo);
		$nomeUnidade = $_arrayNomeUnidade[0]['uni_desc'];
		$unidade = $uniCodigo ? $nomeUnidade : 'TODAS';
		$this->view->unidade = $unidade;

		$array = array('data_inicial' => $dataInicial,
			'data_final' => $dataFinal,
			'uni_desc' => $uniNome,
			'usr_nome' => $profNome);
		if ($dataInicial) {
			$array["data_inicial"] = $dataInicial;
		}
		if ($dataFinal) {
			$array["data_final"] = $dataFinal;
		}
		$this->view->params = serialize($array);
	}

	public function carregaEspecialidadePorMedicoAction() {
		$this->_helper->layout->disableLayout();
		$usr_codigo = $this->_getParam("usr_codigo", false);
		$tbMes = new Application_Model_MedicoEspecialidade();
		$this->view->dados = $tbMes->getEspecialidadePorMedico($usr_codigo)->toArray();
		return $this->render("dados", NULL, TRUE);
	}

	public function formRelAtendimentoSimplificadoAction() {
		$this->view->title = "Relatório de Procedimento por Profissional";
	}

	public function formRelAtendimentoPorAgravoAction() {
		$this->view->title = "Atendimento por Agravo (CIAP)";
	}

	public function formRelAtendimentoPorCidAction() {
		$this->view->title = "Relatório de Atendimento por CID";
	}

	public function formRelAtendimentoPorCondutaAction() {
		$this->view->title = "Relatório de Conduta por Atendimento";

		$tbCond = new Application_Model_TbCdsTipoConduta();
		$conduta = $tbCond->getDadosConduta();
		$this->view->condutas = $conduta;

		$tbCondOdo = new Application_Model_TbCdsTipoEncamOdonto();
		$conduta_odonto = $tbCondOdo->getCondutasGeral();
		$this->view->condutas_odonto = $conduta_odonto;
	}

	public function formRelAtendimentoPorTipoAction() {
		$this->view->title = "Relatório de Atendimento por Tipo e Estabelecimento";
	}

	public function relAtendimentoSimplificadoAction() {
		$this->view->title = 'Procedimento por Profissional';
		Zend_Layout::getMvcInstance()->setLayout("relatorio");
		$dataInicial = $this->_request->getPost("data_inicial", FALSE);
		$dataFinal = $this->_request->getPost("data_final", FALSE);
		$usuCodigo = $this->_request->getPost("usu_codigo", FALSE);
		$usrCodigo = $this->_request->getPost("usr_codigo", FALSE);
		$isOdonto = $this->_request->getPost("isOdonto", FALSE);
		$procCodigo = $this->_request->getPost("proc_codigo", FALSE);
		$uniCodigo = $this->_request->getPost("codigo_convenio", FALSE);
		$tipoRelatorio = $this->_request->getPost("tipo_relatorio", FALSE);
		// Lista dados relatório
		$tbAte = new Application_Model_Atendimento();
		$procedimentos = $tbAte->relListaAtendimentosSimplificados($dataInicial, $dataFinal, $usuCodigo, $usrCodigo, $procCodigo, $uniCodigo, $tipoRelatorio)->toArray();
		$this->view->dados = $this->montaArrayDetalhes($dataInicial, $dataFinal, $usuCodigo, $usrCodigo, $procedimentos, $uniCodigo, $tipoRelatorio);
		//echo '<pre>'.print_r($this->view->dados,1);
		//die();
		// Dados Layout Padrão Relatório
		$tbUsr = new Application_Model_Usuarios();
		$tbUnidade = new Application_Model_Unidade();
		$_arrayNomeUnidade = $tbUnidade->getUnidade($uniCodigo);
		$nomeUnidade = $_arrayNomeUnidade[0]['uni_desc'];
		$unidade = $uniCodigo ? $nomeUnidade : 'TODAS';
		$this->view->unidade = $unidade;
		$array = array(
			'uni_desc' => $unidade,
			'set_nome' => $set_nome
		);
		if ($data_inicial) {
			$array["data_inicial"] = $dataInicial;
		}
		if ($data_final) {
			$array["data_final"] = $dataFinal;
		}
		$this->view->params = serialize($array);
	}

	public function relProcedimentoPorProfissionalAction() {
		$this->view->title = 'Procedimento por Profissional - Analítico';
		Zend_Layout::getMvcInstance()->setLayout("relatorio");
		$dataInicial = $this->_request->getPost("data_inicial", FALSE);
		$dataFinal = $this->_request->getPost("data_final", FALSE);
		$usuCodigo = $this->_request->getPost("usu_codigo", FALSE);
		$usrCodigo = $this->_request->getPost("usr_codigo", FALSE);
		$isOdonto = $this->_request->getPost("isOdonto", FALSE);

		$procCodigo = ($this->_request->getPost("proc_codigo", FALSE) <> "") ? $this->_request->getPost("proc_codigo", FALSE) : 0;

		$uniCodigo = $this->_request->getPost("codigo_convenio", FALSE);
		$tipoRelatorio = $this->_request->getPost("tipo_relatorio", FALSE);

		// Lista dados relatório
		$this->view->dados = $this->montaArrayDetalhes($dataInicial, $dataFinal, $usuCodigo, $usrCodigo, $procCodigo, $uniCodigo, $tipoRelatorio);

		// Dados Layout Padrão Relatório
		$tbUsr = new Application_Model_Usuarios();
		$tbUnidade = new Application_Model_Unidade();
		$_arrayNomeUnidade = $tbUnidade->getUnidade($uniCodigo);
		$nomeUnidade = $_arrayNomeUnidade[0]['uni_desc'];
		$unidade = $uniCodigo ? $nomeUnidade : 'TODAS';
		$this->view->unidade = $unidade;
		$array = array(
			'uni_desc' => $unidade,
			'set_nome' => $set_nome
		);
		if ($dataInicial) {
			$array["data_inicial"] = $dataInicial;
		}
		if ($dataInicial) {
			$array["data_final"] = $dataFinal;
		}
		$this->view->params = serialize($array);

		if ($tipoRelatorio == 'S') {
			$this->view->title = 'Procedimento por Profissional - Sintético';
			$this->render('rel-procedimento-por-profissional-sintetico');
		}
	}

	public function montaArrayDetalhes($dataInicial, $dataFinal, $usuCodigo, $usrCodigo, $procCodigo, $uniCodigo, $tipoRelatorio) {
		$tbAte = new Application_Model_Atendimento();
		$procedimentos = $tbAte->relListaAtendimentosSimplificadosDetalhes($dataInicial, $dataFinal, $usuCodigo, $usrCodigo, $procCodigo, $uniCodigo, $tipoRelatorio)->toArray();
		return $procedimentos;
	}

	public function formRelHistoricoTempoAtendimentoAction() {
		$this->view->title = "Relatório de Histórico por Atendimento";
	}

	public function relHistoricoTempoAtendimentoAction() {

		$this->view->title = 'Histórico de Tempo por Atendimento';
		Zend_Layout::getMvcInstance()->setLayout("relatorio");
		$dataInicial = $this->_request->getPost("data_inicial", FALSE);
		$dataFinal = $this->_request->getPost("data_final", FALSE);
		$usrCodigo = $this->_request->getPost("usr_codigo", FALSE);
		$profNome = $this->_request->getPost("usr_nome", FALSE);
		$uniCodigo = $this->_request->getPost("uni_codigo", FALSE);
		$uniNome = $this->_request->getPost("uni_desc", FALSE);
//        echo "<pre>".print_r($ciapCodigos,1);
//        die();

		// Lista dados relatório
		$tbHdh = new Application_Model_HistoricoDataHora();

		$dados = $tbHdh->getDadosHistoricoDataHora($usrCodigo, $uniCodigo, $dataInicial, $dataFinal)->toArray();
		$this->view->dados = $dados;
//      echo "<pre>".print_r($dados,1);
//      die();

		// Dados Layout Padrão Relatório
		$tbUsr = new Application_Model_Usuarios();
		$tbUnidade = new Application_Model_Unidade();
		$_arrayNomeUnidade = $tbUnidade->getUnidade($uniCodigo);
		$nomeUnidade = $_arrayNomeUnidade[0]['uni_desc'];
		$unidade = $uniCodigo ? $nomeUnidade : 'TODAS';
		$this->view->unidade = $unidade;

		$array = array('data_inicial' => $dataInicial,
			'data_final' => $dataFinal,
			'uni_desc' => $uniNome,
			'usr_nome' => $profNome);
		if ($dataInicial) {
			$array["data_inicial"] = $dataInicial;
		}
		if ($dataFinal) {
			$array["data_final"] = $dataFinal;
		}
		$this->view->params = serialize($array);
	}
}
