<?php

require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";

class Relatorio_BpaController extends Elotech_Controller_Action_Relatorio
{

    private $tbBpa;

    public function init()
    {
        $this->tbBpa = new Application_Model_BPA();
        $this->tbAte = new Application_Model_Atendimento();
    }

    public function indexAction()
    {
        $rel = $this->_getParam("tipo", false);
        $this->view->title = "Bpa $rel";
        $this->view->action = $rel;
        $this->render("index");
    }

    function getDiaExistente($data)
    {
        list($dia, $mes, $ano) = explode("-", $data);
        $mes = (int)$mes;

        $bissexto = (($ano % 4 == 0 && $ano % 100 != 0) || $ano % 400 == 0);
        $dias = array(
            '1' => 31,
            '2' => ($bissexto) ? 29 : 28,
            '3' => 31,
            '4' => 30,
            '5' => 31,
            '6' => 30,
            '7' => 31,
            '8' => 31,
            '9' => 30,
            '10' => 31,
            '11' => 30,
            '12' => 31
        );

        if ($dia <= $dias[$mes]) {
            return $data;
        }

        return $dias[$mes] . "-" . $mes . "-" . $ano;
    }

    function getMesAnterior($mes_ano, $separador = "-")
    {
        list($mes, $ano) = explode($separador, $mes_ano);
        $mes = (int)$mes;
        $ano = (int)$ano;
        if ($mes > 12) {
            throw new Exception("Mês não pode ser maior que 12", 1);
        }
        if ($mes == 1) {
            return "12" . $separador . ($ano - 1);
        }
        return ($mes - 1) . $separador . $ano;
    }

    public function consolidadoAction()
    {
        Zend_Layout::getMvcInstance()->setLayout("relatorio");
        $tbConfig = new Application_Model_Configuracao();
        $this->view->title = "BPA Consolidado";

        $competencia = $this->_request->getPost("competencia", FALSE);
        $uni_cnes = $this->_request->getPost("codigo_convenio", FALSE);

        $diaCompetencia = $tbConfig->getConfig("BPA_DIA_COMPETENCIA");
        $dataExplode = explode('/', $competencia);
        $dataSerapadaPorTraco = $dataExplode[0] . '-' . $dataExplode[1];
        $dataCompetenciaFim = $this->getDiaExistente($diaCompetencia . '-' . $dataSerapadaPorTraco);
        $dataCompetenciaInicio = $this->getDiaExistente($diaCompetencia . '-' . $this->getMesAnterior($dataSerapadaPorTraco));

        $dataCompetenciaInicio = date('d/m/Y', strtotime($dataCompetenciaInicio));
        $dataCompetenciaFim = date('d/m/Y', strtotime('-1 day', strtotime($dataCompetenciaFim)));

        $comp_temp = explode("/", $competencia);
        $competencia = $comp_temp[1] . $comp_temp[0];
        $this->view->dados = $this->tbAte->relConsolidadoNovo($uni_cnes, $dataCompetenciaInicio, $dataCompetenciaFim, $competencia);

        $this->view->uni_cnes = $uni_cnes;
        $this->view->competencia = $this->_request->getPost("competencia", FALSE);

        $this->view->data_inicial = $dataCompetenciaInicio;
        $this->view->data_final = $dataCompetenciaFim;
        $array = array('data_inicial' => $dataCompetenciaInicio,
            'data_final' => $dataCompetenciaFim);
        $this->view->params = serialize($array);
    }

    public function buscarAction()
    {
        $term = $this->_getParam("term", FALSE);
        $tipo = $this->_getParam("tipo", FALSE);
        if (!$term) {
            return false;
        }

        if ($tipo == "consolidado") {
            $tbUni = new Application_Model_Unidade();
            $this->view->dados = $tbUni->buscarLocais($term);
        } else if ($tipo == "individualizado") {
            $tbUni = new Application_Model_Unidade();
            $this->view->dados = $tbUni->buscarLocais($term);
        }

        return $this->render("dados", NULL, TRUE);
    }

    public function formRelProcedimentosGeraisAction()
    {
        $this->view->title = "Relatório de Procedimentos Gerais";
        $tbUni = new Application_Model_Unidade();
        $tbUsr = new Application_Model_Usuarios();
        if ($tbUsr->getUsrAtual()->usr_acesso_unidades == "S") {
            $this->view->unidades = $tbUni->getUnidades();
        } else {
            $this->view->unidades = $tbUni->getUnidadePorUsuario($tbUsr->getUsrAtual()->usr_codigo);
        }
    }

    public function gerarRelatorioProcedimentosGeraisAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $procedimento = $this->_getParam("procedimento", NULL);
        $proc_sus = $this->_getParam("proc_sus", NULL);
        $data_inicial = $this->_getParam("data_inicial", NULL);
        $data_final = $this->_getParam("data_final", NULL);
        $faixa_etaria = $this->_getParam("faixa_etaria", []);
        $tp_rel = $this->_getParam("tp_rel", NULL);

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "procedimentosGerais", [
            "unidade" => $unidade,
            "profissional" => $profissional,
            "procedimento" => $procedimento,
            "procSus" => $proc_sus,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "faixaEtaria" => $faixa_etaria,
            "tpRel" => $tp_rel
        ]);
        $this->render("dados", NULL, TRUE);
    }

    public function formRelProcedimentosUnidadeAction()
    {
        $this->view->title = "Relatório de Procedimentos por Unidade";
        $tbUni = new Application_Model_Unidade();
        $tbUsr = new Application_Model_Usuarios();
        if ($tbUsr->getUsrAtual()->usr_acesso_unidades == "S") {
            $this->view->unidades = $tbUni->getUnidades();
        } else {
            $this->view->unidades = $tbUni->getUnidadePorUsuario($tbUsr->getUsrAtual()->usr_codigo);
        }
    }

    public function gerarRelatorioProcedimentosUnidadeAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $procedimento = $this->_getParam("procedimento", NULL);
        $proc_sus = $this->_getParam("proc_sus", NULL);
        $data_inicial = $this->_getParam("data_inicial", NULL);
        $data_final = $this->_getParam("data_final", NULL);
        $faixa_etaria = $this->_getParam("faixa_etaria", []);
        $tp_rel = $this->_getParam("tp_rel", NULL);

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "procedimentosUnidade", [
            "unidade" => $unidade,
            "profissional" => $profissional,
            "procedimento" => $procedimento,
            "procSus" => $proc_sus,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "faixaEtaria" => $faixa_etaria,
            "tpRel" => $tp_rel
        ]);
        $this->render("dados", NULL, TRUE);
    }

    public function formRelBpaIdadeAction()
    {
        $this->view->title = "Relatório BPA por Idade";
        $tbUni = new Application_Model_Unidade();
        $tbUsr = new Application_Model_Usuarios();
        if ($tbUsr->getUsrAtual()->usr_acesso_unidades == "S") {
            $this->view->unidades = $tbUni->getUnidades();
        } else {
            $this->view->unidades = $tbUni->getUnidadePorUsuario($tbUsr->getUsrAtual()->usr_codigo);
        }
    }

    public function gerarRelatorioBpaIdadeAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $procedimento = $this->_getParam("procedimento", NULL);
        $idade = $this->_getParam("idade", NULL);
        $proc_sus = $this->_getParam("proc_sus", NULL);
        $data_inicial = $this->_getParam("data_inicial", NULL);
        $data_final = $this->_getParam("data_final", NULL);
        $tp_rel = $this->_getParam("tp_rel", NULL);

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "bpaIdade", [
            "unidade" => $unidade,
            "procedimento" => $procedimento,
            "idade" => $idade,
            "procSus" => $proc_sus,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "tpRel" => $tp_rel
        ]);
        $this->render("dados", NULL, TRUE);
    }

}
