<?php

class Relatorio_ContabilController extends Elotech_Controller_Action_Relatorio {
    
    public function init(){
        ini_set('memory_limit','-1');
        set_time_limit(100000000000);
    }
    
    public function indexAction(){
        
    }
    
    public function filtroMovimentacaoClassificacaoAction(){
        $this->view->title = "Relatório Movimenta&ccedil&atildeo por Classifica&ccedil&atildeo";

        $tbUsr = new Application_Model_Usuarios();
        $usuarioCodigo = $tbUsr->getUsrAtual()->usr_codigo;
        
        $tbUsrSetores = new Application_Model_UsuariosSetores();
        $setores = $tbUsrSetores->getSetoresRelatorioContabil($usuarioCodigo);
        $this->view->setores = $setores;
        
    }
    
    public function movimentacaoClassificacaoAction(){
        
        Zend_Layout::getMvcInstance()->setLayout("simples");
        $this->view->title = "Movimentação por Classificação";
        
        $dataFinal = $this->_request->getPost("dataFinal");
        $this->view->dataFinal = $dataFinal;
        $dataInicial = $this->_request->getPost("dataInicial");
        $this->view->dataInicial = $dataInicial;
        $dataValida = $this->validaDatas($dataInicial, $dataFinal);
        $this->view->dataValida = $dataValida;
        
        $setor = $this->_request->getPost("setor");
        
        $this->view->exercicio = date('Y');
        
        if($setor != '0'){
            $tbSetor = new Application_Model_Setor();
            $infoSetor = $tbSetor->getSetorNomePorCodigo($setor);
            $this->view->nomeSetor = $infoSetor[set_nome];
        }else{
            $this->view->nomeSetor = '-';
        }
        
        $tbSaldo = new Application_Model_Saldo();
        $tbItensMovimento = new Application_Model_ItensMovimento();
        $movimentacoesEntrada = $tbSaldo->relatorioMovimentacaoClassificacaoEntrada($dataFinal, $dataInicial, $setor);
        $movimentacoesSaida = $tbSaldo->relatorioMovimentacaoClassificacaoSaida($dataFinal, $dataInicial, $setor);
        $movimentacoesSaidaComValor = array();
        foreach ($movimentacoesSaida as $movimentacao) {
            $valorUnitarioSaida = $tbItensMovimento->getValorRelatorioMovimentacaoClassificacaoSaida($movimentacao[sal_lote], $movimentacao[pro_codigo]);
            $movimentacao[valor_total] = $movimentacao[valor_total] * $valorUnitarioSaida[ite_vlrunit];
            $movimentacoesSaidaComValor[] = $movimentacao;
        }
        
        $valoresTotais = array();
        $valoresTotais[saldoEntradaTotal];
        $valoresTotais[valorEntradaTotal];
        $valoresTotais[saldoSaidaTotal];
        $valoresTotais[valorSaidaTotal];
        
        //normalizar o array Entrada
        $movimentacoesEntradaNormalizado = array();
        foreach ($movimentacoesEntrada as $movimentacao) {
            $movimentacoesEntradaNormalizado[$movimentacao[classificacao]] = $movimentacao;
            $valoresTotais[saldoEntradaTotal] = $valoresTotais[saldoEntradaTotal]+$movimentacao[saldo_total];
            $valoresTotais[valorEntradaTotal] = $valoresTotais[valorEntradaTotal]+$movimentacao[valor_total];
        }
        $valoresTotais[valorEntradaTotal] = number_format($valoresTotais[valorEntradaTotal], 2, ',', '.');
        $valoresTotais[saldoEntradaTotal] = number_format($valoresTotais[saldoEntradaTotal], 0, ',', '.');
        
        //normalizar o array Saida
        $movimentacoesSaidaNormalizado = array();
        foreach ($movimentacoesSaidaComValor as $movimentacao) {
            $movimentacoesSaidaNormalizado[$movimentacao[classificacao]][classificacao] = $movimentacao[classificacao];
            $movimentacoesSaidaNormalizado[$movimentacao[classificacao]][descricao] = $movimentacao[descricao];
            $movimentacoesSaidaNormalizado[$movimentacao[classificacao]][valor_total] = $movimentacoesSaidaNormalizado[$movimentacao[classificacao]][valor_total] + $movimentacao[valor_total];
            $movimentacoesSaidaNormalizado[$movimentacao[classificacao]][saldo_total] = $movimentacoesSaidaNormalizado[$movimentacao[classificacao]][saldo_total] + $movimentacao[saldo_total];
        }

        foreach ($movimentacoesSaidaNormalizado as $movimentacao) {
            $movimentacoesSaidaNormalizado[$movimentacao[classificacao]] = $movimentacao;
            $valoresTotais[saldoSaidaTotal] = $valoresTotais[saldoSaidaTotal]+$movimentacao[saldo_total];
            $valoresTotais[valorSaidaTotal] = $valoresTotais[valorSaidaTotal]+$movimentacao[valor_total];
        }
        $valoresTotais[valorSaidaTotal] = number_format($valoresTotais[valorSaidaTotal], 2, ',', '.');
        $valoresTotais[saldoSaidaTotal] = number_format($valoresTotais[saldoSaidaTotal], 0, ',', '.');
        
        //união dos 2 arrays
        $arrayContas = array();
        foreach ($movimentacoesEntradaNormalizado as $entrada) {
            $arrayContas[$entrada[classificacao]][classificacao] = $entrada[classificacao];
            $arrayContas[$entrada[classificacao]][descricao] = $entrada[descricao];
            $arrayContas[$entrada[classificacao]][valor_total_entrada] = $entrada[valor_total];
            $arrayContas[$entrada[classificacao]][quantidade_total_entrada] = $entrada[saldo_total];
        }
        foreach ($movimentacoesSaidaNormalizado as $saida) {
            $arrayContas[$saida[classificacao]][classificacao] = $saida[classificacao];
            $arrayContas[$saida[classificacao]][descricao] = $saida[descricao];
            $arrayContas[$saida[classificacao]][valor_total_saida] = $saida[valor_total];
            $arrayContas[$saida[classificacao]][quantidade_total_saida] = $saida[saldo_total];
        }
        
        $this->view->valoresTotais = $valoresTotais;
        $this->view->arrayContas = $arrayContas;
        
    }

    public function filtroPosicaoEstoqueClassificacaoAction(){
        $this->view->title = "Posição de estoque por classificação/conta contábil";
        $tbSaldo = new Application_Model_Saldo();
    }
    
    public function getContasAction() {
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender();
        $exercicio = $this->_getParam("exercicio",false);
        $tbSaldo = new Application_Model_Saldo();
        $contas = $tbSaldo->getContas($exercicio)->toArray();
        foreach ($contas as $conta) {
            $retorno .= '<option value="'.$conta[conta_plano].'">'.$conta[descricao].'</option>';
        }
        $this->view->dados = $retorno;
        return $this->render("dados",null,true);
    }

    public function posicaoEstoqueClassificacaoAction(){
        
        Zend_Layout::getMvcInstance()->setLayout("simples");
        $this->view->title = "Posição de estoque por classificação/conta contábil";
        
        $exercicio = $this->_request->getPost("exercicio");
        $contas = $this->_request->getPost("contas");
        
        $tbSaldo = new Application_Model_Saldo();
        
        $listaContas = array();
        $listaContas['totalGeral']['valor'] = 0;
        $listaContas['totalGeral']['saldo'] = 0;
        
        foreach ($contas as $conta) {
            
            $contaInformações = array();
            
            $valoresConta = $tbSaldo->relatorioPosicaoEstoqueContaContabil($exercicio,$conta);
            $valoresConta = $this->formatarValores($valoresConta);
            $contaInformações['valores'] = $valoresConta; 
            
            $contaInformações['nome'] = $tbSaldo->getContaNome($conta)[conta_plano_descricao]->toArray()['conta_plano_descricao'];
            $contaInformações['numero'] = $conta;
            
            $contaInformações['totais']['valor'] = 0;
            $contaInformações['totais']['saldo'] = 0;
            
            foreach ($contaInformações['valores'] as $valores) {
                $contaInformações['totais']['valor'] += $valores[valor_total] ;
                $listaContas['totalGeral']['valor'] += $valores[valor_total];
                
                $contaInformações['totais']['saldo'] += $valores[sal_qtde];
                $listaContas['totalGeral']['saldo'] += $valores[sal_qtde];
            }
            $contaInformações['totais']['saldo'] = number_format($contaInformações['totais']['saldo'], 0, ',', '.');
            $contaInformações['totais']['valor'] = number_format($contaInformações['totais']['valor'], 2, ',', '.');
            $listaContas['contas'][$conta] = $contaInformações;
        }
        $listaContas['totalGeral']['valor'] = number_format($listaContas['totalGeral']['valor'], 2, ',', '.');
        $listaContas['totalGeral']['saldo'] = number_format($listaContas['totalGeral']['saldo'], 0, ',', '.');
        
        $listaContas['contas'] = $this->ordernarContasPorNumeroDoSaldoTotal($listaContas['contas']);
        
        $this->view->listaContas = $listaContas;
        $this->view->exercicio = $exercicio;
        $this->view->data = date('d/m/Y');
        $this->view->dados = $valores;
    }
    
    public function validaDatas($dataInicio, $dataFinal){
        
        if(!$this->validaDataIndividual($dataInicio) || !$this->validaDataIndividual($dataFinal)){
            return false;
        }
        if($dataInicio > $dataFinal){
            return false;
        }
        return true;
    }
    
    public function validaDataIndividual($data){
              
        $dataExplode = explode('/', $data);
        $dataSerapadaPorTraco = $dataExplode[0].'-'.$dataExplode[1].'-'.$dataExplode[2];
        $data = date('d/m/Y',strtotime($dataSerapadaPorTraco));        
        
        $dataMinima = date('d/m/Y',strtotime('01-01-1980'));  
        $dataMaxima = date('d/m/Y');        
        
        if($data < $dataMinima || $data > $dataMaxima){
            return false;
        }else{
            return true;
        }
        
    }
    
    public function formatarValores($valores){
        
        $arrayRetorno = array();
        
        $tbSaldo = new Application_Model_Saldo();
        $tbSaldo->relatorioPosicaoEstoqueContaContabil();
        
        foreach ($valores as $valor):
            $valorUnitario = $tbSaldo->getValorUnidadeProduto($valor['pro_codigo']);
            $arrayRow = array('pro_codigo'=>$valor['pro_codigo'],
                'sal_qtde'=>$valor['sal_qtde'],
                'pro_nome'=>$valor['pro_nome'],
                'item'=>$valor['item'],
                'unidade'=>$valor['unidade'],
                'conta_plano'=>$valor['conta_plano'],
                'conta_plano_descricao'=>$valor['conta_plano_descricao'],
                'ite_vlrunit'=>$valorUnitario['ite_vlrunit'],
                'valor_total'=>$valor['sal_qtde']*$valorUnitario['ite_vlrunit']);
                
            $arrayRetorno[] = $arrayRow;
        
        endforeach;
        
        return $arrayRetorno;
        
    }
    
    
    function ordernarContasPorNumeroDoSaldoTotal(array $contas) {
            
        $contasArrayComum = array();
        
        foreach ($contas as $conta) {
            $contasArrayComum[] = $conta;
        }
        $size = count($contasArrayComum);
        
        for ($i=0; $i<$size; $i++) {
            for ($j=0; $j<$size-1-$i; $j++) {
                if ($contasArrayComum[$j+1]['totais']['valor'] > $contasArrayComum[$j]['totais']['valor']) {
                    $contasArrayComum = $this->trocarConta($contasArrayComum, $j, $j+1);
                }
            }
        }
        return $contasArrayComum;
    }

    function trocarConta($arr, $a, $b) {
        $tmp = $arr[$a];
        $arr[$a] = $arr[$b];
        $arr[$b] = $tmp;
        return $arr;
    }

}

?>
