<?php

class Relatorio_EsusController extends Elotech_Controller_Action_Relatorio {

	private $tbAte;

	public function init() {
		$this->_helper->acl->allow(NULL);
		$this->view->title = "Relatório de Atendimento por Idade";
		$this->tbAte = new Application_Model_Atendimento();
	}

	public function indexAction() {

	}

	public function formRelCadastroIndividualAction() {
		$this->view->title = "Relatório de Cadastro Individual";
	}

	public function relCadastroIndividualAction() {
		Zend_Layout::getMvcInstance()->setLayout("relatorio");
		$data_inicial = $this->_request->getPost("data_inicial", FALSE);
		$data_final = $this->_request->getPost("data_final", FALSE);
		$usrCodigo = $this->_request->getPost("usr_codigo", FALSE);
		$uniCodigo = $this->_request->getPost("uni_codigo", FALSE);
		$nu_ine = $this->_request->getPost("ine_codigo", FALSE);
		$tipo_relatorio = $this->_request->getPost("tipo_relatorio", FALSE);

		// Lista dados relatório
		$tbEci = new Application_Model_EsusCadastroIndividual();
		if ($tipo_relatorio == 'C') {
			$this->view->dados = $tbEci->relListaCadastroIndividual($data_inicial, $data_final, $usrCodigo, $uniCodigo, $nu_ine)->toArray();
			$this->view->title = 'Cadastro Individual por Profissional Cadastrante';
		} else {
			$this->view->dados = $tbEci->relListaCadastroIndividualPorResponsavel($data_inicial, $data_final, $usrCodigo, $uniCodigo, $nu_ine)->toArray();
			$this->view->title = 'Cadastro Individual por Responsável da Microárea';
		}
		//echo "<pre>".print_r($this->view->dados, 1);
		//die("TESTE");

		// Dados Layout Padrão Relatório
		//$tbUsr = new Application_Model_Usuarios();
		$tbUnidade = new Application_Model_Unidade();
		$_arrayNomeUnidade = $tbUnidade->getUnidade($uniCodigo);
		$nomeUnidade = $_arrayNomeUnidade[0]['uni_desc'];
		$unidade = $uniCodigo ? $nomeUnidade : 'TODAS';
		$this->view->unidade = $unidade;
		$array = array('data_inicial' => $data_inicial,
			'data_final' => $data_final
		);
		if ($data_inicial) {
			$array["data_inicial"] = $data_inicial;
		}
		if ($data_final) {
			$array["data_final"] = $data_final;
		}
		$this->view->params = serialize($array);

	}

}
