<?php
require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";
class Relatorio_FarmaciaController extends Elotech_Controller_Action_Relatorio {

    public function init() {
        $this->view->title = "Medicamentos dispensados";
    }

    public function indexAction() {
        $this->view->title = "Produtos dispensados por paciente e setor";
        $tbProdGrupo = new Application_Model_ProdutoGrupo();
        $this->view->grupos = $tbProdGrupo->getGrupos();
        $this->render("index");
    }

    public function relatorioAction() {
        $this->view->title = "Produtos dispensados por paciente e setor";
        Zend_Layout::getMvcInstance()->setLayout("relatorio");
        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);
        $set_codigo = $this->_request->getPost("set_codigo", FALSE);
        $set_nome = $this->_request->getPost("set_nome", FALSE);
        $usu_codigo = $this->_request->getPost("usu_codigo", FALSE);
        $usu_nome = $this->_request->getPost("usu_nome", FALSE);
        $gru_codigo = $this->_request->getPost("gru_codigo", FALSE);
        $tbMov = new Application_Model_Movimento();
        $this->view->itens = $tbMov->relDispensados($set_codigo, $data_inicial, $data_final, $usu_codigo,$gru_codigo)->toArray();

        $array = array('data_inicial' => $data_inicial,
            'data_final' => $data_final,
            'set_nome' => $set_nome,
            'usu_nome' => $usu_nome);
        $this->view->params = serialize($array);
    }

    public function buscarAction() {
        $term = $this->_getParam("term", FALSE);
        $tipo = $this->_getParam("tipo", FALSE);
        if (!$term) {
            return false;
        }

        if ($tipo == "consolidado") {
            $tbUni = new Application_Model_Unidade();
            $this->view->dados = $tbUni->buscarLocais($term);
        } else if ($tipo == "individualizado") {
            $tbUni = new Application_Model_Unidade();
            $this->view->dados = $tbUni->buscarLocais($term);
        }

        return $this->render("dados", NULL, TRUE);
    }


    public function formMedicamentosDispensadosPorProgramaAction(){
        $this->view->title = "Medicamentos dispensados por programa";

        $tbProgramas = new Application_Model_ProgramaAtendimento();
        $this->view->programas = $tbProgramas->getProgramas();
    }

    public function relMedicamentosDispensadosPorProgramaAction() {
        $this->view->title = "Medicamentos dispensados por programa";
        Zend_Layout::getMvcInstance()->setLayout("relatorio");

        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);

        $set_codigo = $this->_request->getPost("set_codigo", FALSE);
        $set_nome = $this->_request->getPost("set_nome", FALSE);

        $usu_nome = $this->_request->getPost("usu_nome", FALSE);

        $prg_codigo = $this->_request->getPost("prg_codigo", FALSE);
        $prg_nome = $this->_request->getPost("prg_nome", FALSE);

        $tipo_relatorio = $this->_request->getPost("tipo_relatorio", FALSE);

        $tbMov = new Application_Model_Movimento();

        if ($tipo_relatorio == "S"){
            $this->view->itens = $tbMov->getRelMovimentacaoProgramaPaciente($set_codigo, $data_inicial, $data_final, $prg_codigo)->toArray();
            $array = array('data_inicial' => $data_inicial,
                'data_final' => $data_final,
                'set_nome' => $set_nome,
                'usu_nome' => $usu_nome,
                'prg_nome' => $prg_nome);
        }else{
            $this->view->itens = $tbMov->getRelMovimentacaoPrograma($set_codigo, $data_inicial, $data_final, $prg_codigo)->toArray();
            $array = array('data_inicial' => $data_inicial,
                'data_final' => $data_final,
                'set_nome' => $set_nome,
                'prg_nome' => $prg_nome);
        }
        $this->view->tipo_relatorio = $tipo_relatorio;
        $this->view->params = serialize($array);
    }


    public function formNumeroDePacientesAtendidosPorMedicamentoAction() {
        $this->view->title = "Número de pacientes atendidos por medicamento";
    }

    public function numPacientesAtendidosPorMedicamentoDispensadoAction() {
        Zend_Layout::getMvcInstance()->setLayout("relatorio");
        $this->view->title = "NUMERO DE PACIENTES ATENDIDOS POR MEDICAMENTO";
        $tbMov = new Application_Model_Movimento();
        $tbUsr = new Application_Model_Usuarios();
        $codUnidade = $tbUsr->getUsrAtual()->uni_codigo;
        $codProd = $this->_request->getPost("pro_codigo");
        $codSetor = $this->_request->getPost("set_codigo");
        $setor = $this->_request->getPost("set_nome");
        $dataInicial = $this->_request->getPost("data_inicial");
        $dataFinal = $this->_request->getPost("data_final");
        $tbUsr = new Application_Model_Usuarios();
        $array = array('uni_desc' => $tbUsr->getUsrAtual()->uni_desc,
            'set_nome' => $setor ? $setor : "TODOS");
        if ($dataInicial)
            $array["data_inicial"] = $dataInicial;
        if ($dataFinal)
            $array["data_final"] = $dataFinal;

        $this->view->params = serialize($array);
        if ($this->_request->getPost("tp_rel") == 0) {
            $this->view->dados = $tbMov->getNumPacientesAtendidosPorMedicamentoDispensado($codUnidade, $codProd, $codSetor, $dataInicial, $dataFinal);
            $this->view->tipo_relatorio = 'S';
        } else {
            $this->view->dados = $tbMov->getNumPacientesAtendidosPorMedicamentoDispensadoAnalitico($codUnidade, $codProd, $codSetor, $dataInicial, $dataFinal);
            $this->view->tipo_relatorio = 'A';
        }

    }

    public function formNumeroPacientesAtendidosPorPeriodoSetorAction() {
        $this->view->title = "Número de Pacientes atendidos por período e setor";
    }

    public function formNumeroPacientesAtendidosPorIdadeAction() {
        $this->view->title = "Quantidade de pacientes atendidos por idade";
    }

    public function numPacientesAtendidosPorPeriodoSetorAction() {
        Zend_Layout::getMvcInstance()->setLayout("relatorio");
        $this->view->title = "Número de Pacientes atendidos por período e setor";
        // Parametros
        $tbMov = new Application_Model_Movimento();
        $tbUsr = new Application_Model_Usuarios();
        $codUnidade = $tbUsr->getUsrAtual()->uni_codigo;
        $codSetor = $this->_request->getPost("set_codigo");
        $setor = $this->_request->getPost("set_nome");
        $dataInicial = $this->_request->getPost("data_inicial");
        $dataFinal = $this->_request->getPost("data_final");
        $tbUsr = new Application_Model_Usuarios();
        $array = array(
            'uni_desc' => $tbUsr->getUsrAtual()->uni_desc,
            'set_nome' => $setor ? $setor : "TODOS"
        );
        if ($dataInicial)
            $array["data_inicial"] = $dataInicial;
        if ($dataFinal)
            $array["data_final"] = $dataFinal;
        // Dados título relatório
        $this->view->params = serialize($array);
        $dados = $tbMov->getNumPacientesAtendidosPorPeriodoSetor($codUnidade, $codSetor, $dataInicial, $dataFinal)->qtd_atendimento;
        $this->view->dados = $dados;
    }

    public function numPacientesAtendidosPorIdadeAction() {
        Zend_Layout::getMvcInstance()->setLayout("relatorio");
        $this->view->title = "Quantidade de pacientes atendidos por idade";
        // Parametros
        $tbMov = new Application_Model_Movimento();
        $tbUsr = new Application_Model_Usuarios();
        $codUnidade = $tbUsr->getUsrAtual()->uni_codigo;
        $codSetor = $this->_request->getPost("set_codigo");
        $setor = $this->_request->getPost("set_nome");
        $dataInicial = $this->_request->getPost("data_inicial");
        $dataFinal = $this->_request->getPost("data_final");
        $tbUsr = new Application_Model_Usuarios();
        $array = array(
            'uni_desc' => $tbUsr->getUsrAtual()->uni_desc,
            'set_nome' => $setor ? $setor : "TODOS"
        );
        if ($dataInicial)
            $array["data_inicial"] = $dataInicial;
        if ($dataFinal)
            $array["data_final"] = $dataFinal;
        // Dados título relatório
        $this->view->params = serialize($array);
        $dados = $tbMov->getNumPacientesAtendidosPorIdade($codUnidade, $codSetor, $dataInicial, $dataFinal)->toArray();
//        echo "<pre>".print_r($dados,1);
//        die();
        $this->view->dados = $dados;
    }

    public function formDispensacaoTipoReceitaAction(){
        $this->view->title = "Dispensação por Tipo de Receita";
    }

    public function gerarRelatorioDispensacaoTipoReceitaAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $data_inicial = $this->_getParam("dataInicial", NULL);
        $data_final = $this->_getParam("dataFinal", NULL);
        $tp_rec = $this->_getParam("tpReceita", NULL);;
        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "dispensacaoTipoReceita", [
            "unidade" => $unidade,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "tpRec" => $tp_rec,
        ]);
        $this->render("dados", NULL, TRUE);
    }
}

?>