<?php
require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";
class Relatorio_LaboratorioController extends Elotech_Controller_Action_Relatorio
{

    public function init()
    {
        $this->_helper->acl->allow(NULL);
    }

    public function indexAction()
    {
        $this->view->title = "Exames solicitados por prontuário eletrônico";
        $this->render("index");
    }

    public function relSolicitanteAgeAction()
    {
        $this->view->title = "Exames solicitados por agendamento";
    }

    public function formRelPacienteAction()
    {
        $this->view->title = "Livro do laboratório por paciente e solicitante";
    }

    public function formRelPrestadorAction()
    {
        $this->view->title = "Relatório de exames por prestador";
    }

    public function formRelProfissionalSolicitanteAction()
    {
        $this->view->title = "Relatório de exames por profissional solicitante";
    }

    public function formRelExamesRealizadosAction()
    {
        $this->view->title = "Relatorio de pacientes atendidos por exame";
    }

    public function formRelExamesSolicitadosAction()
    {
        $this->view->title = "Relatórios de pacientes com exames realizados por unidade";
    }

	public function formRelPacientesAgendadosAction()
	{
		$this->view->title = "Relatórios de pacientes agendados";
	}

    public function relPacienteAction()
    {
        $tbSec = new Application_Model_Secretaria();
        $tbConf = new Application_Model_Configuracao();
        $tbUsr = new Application_Model_Usuarios();
        $tbAge = new Application_Model_Agenda();
        $this->view->usr = $tbUsr->getUsrAtual();
        $this->view->secretaria = $tbSec->getDadosSec();
        $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
        $this->view->tipo_impressao = "RELATÓRIO DE EXAMES SOLICITADOS POR PACIENTE";
        $this->view->livro = 1;
        //$this->_helper->layout->setLayout("retrato-print");
        $this->_helper->layout->setLayout("simples");
        $solicitante = $this->_request->getPost("usr_codigo", FALSE);
        $usu_codigo = $this->_request->getPost("usu_codigo", FALSE);

        $interno = $this->_request->getPost("interno", FALSE);

        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);
        $rel = $tbAge->relPaciente($usu_codigo, $data_inicial, $data_final, $solicitante, $interno)->toArray();
        $rel = $this->montaArrayProcedimentos($rel, $data_inicial, $data_final);
        $this->view->rel = $rel;
    }

    public function relPrestadorAction()
    {
        $tbSec = new Application_Model_Secretaria();
        $tbConf = new Application_Model_Configuracao();
        $tbUsr = new Application_Model_Usuarios();
        $tbAge = new Application_Model_Agenda();
        //$this->view->usr = $tbUsr->getUsrAtual();
        $this->view->secretaria = $tbSec->getDadosSec();
        $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
        $this->view->tipo_impressao = "RELATÓRIO DE EXAMES SOLICITADOS POR PACIENTE";
        $this->view->livro = 1;
        //$this->_helper->layout->setLayout("retrato-print");
        $this->_helper->layout->setLayout("simples");
        $solicitante = $this->_request->getPost("usr_codigo", FALSE);
        $usu_codigo = $this->_request->getPost("usu_codigo", FALSE);
        $prestador = $this->_request->getPost("med_codigo", FALSE);
        $status = $this->_request->getPost("agei_status", FALSE);
        $interno = $this->_request->getPost("interno", FALSE);

        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);
        $rel = $tbAge->relPacientePorPrestador($usu_codigo, $data_inicial, $data_final, $solicitante, $interno, $prestador, $status)->toArray();
        $rel = $this->montaArrayProcedimentosPorPrestador($rel, $data_inicial, $data_final);
        $this->view->rel = $rel;
        $this->view->status = $status;
    }

    public function relProfissionalSolicitanteAction()
    {
        $tbSec = new Application_Model_Secretaria();
        $tbConf = new Application_Model_Configuracao();
        $tbUsr = new Application_Model_Usuarios();
        $tbAge = new Application_Model_Agenda();
        $this->view->usr = $tbUsr->getUsrAtual();
        $this->view->secretaria = $tbSec->getDadosSec();
        $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
        $this->view->tipo_impressao = "RELATÓRIO DE EXAMES SOLICITADOS POR PACIENTE";
        $this->view->livro = 1;
        //$this->_helper->layout->setLayout("retrato-print");
        $this->_helper->layout->setLayout("simples");
        $solicitante = $this->_request->getPost("usr_codigo", FALSE);
        $usu_codigo = $this->_request->getPost("usu_codigo", FALSE);
        $uni_codigo = $this->_request->getPost("uni_codigo", FALSE);

        $interno = $this->_request->getPost("interno", FALSE);

        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);
        $rel = $tbAge->relProfissionalSolicitante($usu_codigo, $uni_codigo, $data_inicial, $data_final, $solicitante, $interno)->toArray();
        $rel = $this->montaArrayProcedimentos($rel, $data_inicial, $data_final);
        $this->view->rel = $rel;
    }

    public function relExamesRealizadosAction()
    {
        $tbSec = new Application_Model_Secretaria();
        $tbConf = new Application_Model_Configuracao();
        $tbUsr = new Application_Model_Usuarios();
        $tbAge = new Application_Model_Agenda();
        $this->view->usr = $tbUsr->getUsrAtual();
        $this->view->secretaria = $tbSec->getDadosSec();
        $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
        $this->view->tipo_impressao = "RELATÓRIO DE EXAMES SOLICITADOS POR PACIENTE";
        $this->view->livro = 1;
        //$this->_helper->layout->setLayout("retrato-print");
        $this->_helper->layout->setLayout("simples");
        $proc_codigo = $this->_request->getPost("proc_codigo", FALSE);
        $usu_codigo = $this->_request->getPost("usu_codigo", FALSE);
        $uni_codigo = $this->_request->getPost("uni_codigo", FALSE);
        $tipo_relatorio = $this->_request->getPost("tipo_relatorio", FALSE);

        $interno = $this->_request->getPost("interno", FALSE);

        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);
        $rel = $tbAge->relExamesRealizados($proc_codigo, $usu_codigo, $uni_codigo, $data_inicial, $data_final, $solicitante, $interno, $tipo_relatorio)->toArray();
        $rel = $this->montaArrayPacientesPorProcedimento($rel, $data_inicial, $data_final, $tipo_relatorio);
        //var_dump($rel[0]['pacientes'][0]);
        //die();
        $this->view->rel = $rel;
    }

    public function relExamesSolicitadosAction()
    {
        $tbSec = new Application_Model_Secretaria();
        $tbConf = new Application_Model_Configuracao();
        $tbUsr = new Application_Model_Usuarios();
        $tbAge = new Application_Model_Agenda();
        $this->view->usr = $tbUsr->getUsrAtual();
        $this->view->secretaria = $tbSec->getDadosSec();
        $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
        $this->view->tipo_impressao = "RELATÓRIO DE SOLICITAÇÕES DE EXAMES";
        $this->view->livro = 1;
        //$this->_helper->layout->setLayout("retrato-print");
        $this->_helper->layout->setLayout("simples");
        $usu_codigo = $this->_request->getPost("usu_codigo", FALSE);
        $uni_codigo = $this->_request->getPost("uni_codigo", FALSE);

        $interno = $this->_request->getPost("interno", FALSE);

        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);
        $rel = $tbAge->relExamesSolicitados($usu_codigo, $uni_codigo, $data_inicial, $data_final, $interno)->toArray();
        //var_dump($rel[0]['pacientes'][0]);
        //die();
        $this->view->rel = $rel;
    }

    public function relPacienteExamesAction()
    {

        $tbSec = new Application_Model_Secretaria();
        $tbConf = new Application_Model_Configuracao();
        $tbUsr = new Application_Model_Usuarios();
        $tbAge = new Application_Model_Agenda();
        $this->view->usr = $tbUsr->getUsrAtual();
        $this->view->secretaria = $tbSec->getDadosSec();
        $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
        $this->view->tipo_impressao = "RELATÓRIO DE EXAMES SOLICITADOS POR PACIENTE";
        //$this->_helper->layout->setLayout("retrato-print");
        $this->_helper->layout->setLayout("simples");

        $med_codigo = $this->_getParam("med_codigo", FALSE);
        $proc_codigo = $this->_getParam("proc_codigo", FALSE);
        $data_inicial = $this->_getParam("data_inicial", FALSE);
        $data_final = $this->_getParam("data_final", FALSE);
        $rel = $tbAge->relProcedimento($usu_codigo, $data_inicial, $data_final, $proc_codigo, $med_codigo)->toArray();
        $rel = $this->montaArrayPacientes($rel, $data_inicial, $data_final);
        //echo "<pre>".print_r($rel,1);die("a");

        $this->view->rel = $rel;
    }

	public function relPacientesAgendadosAction()
	{

		$tbSec = new Application_Model_Secretaria();
		$tbConf = new Application_Model_Configuracao();
		$tbUsr = new Application_Model_Usuarios();
		$tbAge = new Application_Model_Agenda();
		$this->view->usr = $tbUsr->getUsrAtual();
		$this->view->secretaria = $tbSec->getDadosSec();
		$this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
		$this->view->tipo_impressao = "RELATÓRIO DE PACIENTES AGENDADOS";
//		$this->_helper->layout->setLayout("retrato-print");
		$this->_helper->layout->setLayout("simples");

		$uni_codigo = $this->_getParam("uni_codigo", FALSE);
		$data_inicial = $this->_getParam("data_inicial", FALSE);
		$data_final = $this->_getParam("data_final", FALSE);

//		die("data ini: " . $data_inicial . " - dt final: " . $data_final);
		$this->view->rel  = $tbAge->relPacientesAgendados($data_inicial, $data_final, $uni_codigo)->toArray();
	}

    private function montaArrayPacientes($rel, $data_inicial, $data_final)
    {
        $tbAge = new Application_Model_Agenda();
        $i = 0;
        foreach ($rel as $array_dados) {
            $rel[$i][pacientes] = $tbAge->relProcPac($array_dados[proc_codigo], $data_inicial, $data_final)->toArray();
            $i++;
        }
        return $rel;
    }

    private function montaArrayPacientesPorProcedimento($rel, $data_inicial, $data_final, $tipo_relatorio)
    {
        $tbAge = new Application_Model_Agenda();
        $i = 0;
        foreach ($rel as $array_dados) {
            $rel[$i][pacientes] = $tbAge->relProcPacPorProcedimento($array_dados[uni_codigo], $array_dados[proc_codigo], $data_inicial, $data_final, $tipo_relatorio)->toArray();
            $i++;
        }
        return $rel;
    }


    private function montaArrayProcedimentos($rel, $data_inicial, $data_final)
    {
        $tbAge = new Application_Model_Agenda();
        $i = 0;
        foreach ($rel as $array_dados) {
            $rel[$i][procedimentos] = $tbAge->relProcPac($array_dados[age_codigo], $data_inicial, $data_final)->toArray();
            $i++;
        }


        return $rel;
    }

    private function montaArrayProcedimentosPorPrestador($rel, $data_inicial, $data_final)
    {
        $tbAge = new Application_Model_Agenda();
        $i = 0;
        foreach ($rel as $array_dados) {
            $rel[$i][procedimentos] = $tbAge->relProcPacPorPrestador($array_dados[age_codigo], $data_inicial, $data_final)->toArray();
            $i++;
        }


        return $rel;
    }


    public function buscarAction()
    {
        $term = $this->_getParam("term", FALSE);
        $tipo = $this->_getParam("tipo", FALSE);
        if (!$term) {
            return false;
        }

        if ($tipo == "consolidado") {
            $tbUni = new Application_Model_Unidade();
            $this->view->dados = $tbUni->buscarLocais($term);
        } else if ($tipo == "individualizado") {
            $tbUni = new Application_Model_Unidade();
            $this->view->dados = $tbUni->buscarLocais($term);
        }

        return $this->render("dados", NULL, TRUE);
    }


    public function gerarRelPrestadorAction(){
        $usr_codigo = $this->_getParam("usr_codigo", NULL);
        $med_codigo = $this->_getParam("med_codigo", NULL);
        $usu_codigo = $this->_getParam("usu_codigo", NULL);
        $agei_status = $this->_getParam("agei_status", NULL);
        $data_inicial = $this->_getParam("dataInicial", NULL);
        $data_final = $this->_getParam("dataFinal", NULL);
        $tp_rel = $this->_getParam("tpRel", NULL);
        $agr_solicitante = $this->_getParam("agrSolicitante", NULL);
        $agr_paciente = $this->_getParam("agrPaciente", NULL);

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "examesPorPrestador", [
            "usrCodigo"=>$usr_codigo,
            "medCodigo"=>$med_codigo,
            "usuCodigo"=>$usu_codigo,
            "ageiStatus"=>$agei_status,
            "dataInicial"=>$data_inicial,
            "dataFinal"=>$data_final,
            "tpRel"=>$tp_rel,
            "agrSolicitante"=>$agr_solicitante,
            "agrPaciente"=>$agr_paciente
        ]);
        $this->render("dados", NULL, TRUE);
    }

}

?>