<?php

require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";
class Relatorio_MateriaisController extends Elotech_Controller_Action_Relatorio
{

    private $tbPro;

    public function init()
    {
        set_time_limit(100000000000);
        $this->view->title = "Materiais";
        $this->tbPro = new Application_Model_Produto();
    }

    public function indexAction()
    {

    }

    public function estoquePsicotropicosAction()
    {
        $this->view->title .= " - Psicotrópicos";

        $set_codigo = $this->_request->getPost("set_codigo", FALSE);

        if (!$set_codigo) {
            $this->view->action = array("action" => "estoque-psicotropicos");
            return $this->render("setor", NULL, TRUE); // mostra action para pedir os dados
        }

        $where = $this->tbPro->relEstoquePsicotropico($this->view, $set_codigo);
        $this->relatorio($where);
    }


    public function produtosAVencerAction()
    {
        $this->view->title .= " - Produtos a vencer";

        $set_codigo = $this->_request->getPost("set_codigo", FALSE);
        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);

        if (!$set_codigo) {
            $this->view->action = array("action" => "produtos-a-vencer");
            return $this->render("setor-data", NULL, TRUE); // mostra action para pedir os dados
        }

        $where = $this->tbPro->relMedicamentosPorValidade($this->view, $set_codigo, $data_inicial, $data_final);
        $this->relatorio($where);
    }

    public function estoqueMinimoAction()
    {
        $this->view->title .= " - Estoque M&iacute;nimo";

        $set_codigo = $this->_request->getPost("set_codigo", FALSE);
        $pro_codigo = $this->_request->getPost("pro_codigo", FALSE);
        $pros_codigo = $this->_request->getPost("pros_codigo", FALSE);
        $gru_codigo = $this->_request->getPost("gru_codigo", FALSE);
        $tipo_relatorio = $this->_request->getPost("tipo_relatorio", FALSE);
        if (!$set_codigo) {
            $tbPros = new Application_Model_ProdutoSubgrupo();
            $this->view->subgrupos = $tbPros->getSubGrupos();

            $tbProdGrupo = new Application_Model_ProdutoGrupo();
            $this->view->grupos = $tbProdGrupo->getGrupos();

            $this->view->action = array("action" => "estoque-minimo");
            return $this->render("setor-flag-obrigatorio", NULL, TRUE); // mostra action para pedir os dados
        }

        $where = $this->tbPro->relMedicamentosPorEstoqueMinimo($this->view, $set_codigo, $pro_codigo, $pros_codigo, $gru_codigo, $tipo_relatorio);
        $this->relatorio($where);
    }

    public function entradaPsicotropicosAction()
    {
        $this->view->title .= " - Entrada Psicotrópicos";

        $set_codigo = $this->_request->getPost("set_codigo", FALSE);
        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);
        //die($set_codigo."-".$data_inicial."-".$data_final);
        if (!$set_codigo) {
            $this->view->action = array("action" => "entrada-psicotropicos");
            return $this->render("setor-data", NULL, TRUE); // mostra action para pedir os dados
        }

        $where = $this->tbPro->relEntradaPsicotropicos($this->view, $set_codigo, $data_inicial, $data_final);
        $this->relatorio($where);
    }

    public function formBalancoProdutoSetorAction()
    {
        $this->view->title .= " - Balanço Psicotrópicos";
        $this->view->portarias = $this->portariaPsicotropicos();

    }

    public function formSaidasTransferenciasMateriaisAction()
    {
        $tbProdGrupo = new Application_Model_ProdutoGrupo();
        $this->view->grupos = $tbProdGrupo->getGrupos();
        $this->view->title .= " - Saídas e Transferência de Materiais";

    }

    public function formEntradaMateriaisAction()
    {
        $this->view->title .= " - Entrada de Materiais por Fornecedores";

    }

    public function formAnvisaAction()
    {
        $this->view->title = "Relatório Anvisa";
        $this->view->portarias = $this->portariaPsicotropicos();


    }

    public function relAnvisaAction()
    {
        if ($this->_request->getPost("tp_rel") == 0) {
            $this->relAnvisaSinteticoAction();
        } else {
            $this->relAnvisaAnaliticoAction();
        }
    }

    public function relAnvisaSinteticoAction()
    {
        $this->view->title = "Relatório Anvisa Sintético";

        $set_codigo = $this->_request->getPost("set_codigo", FALSE);
        $portarias = $this->_request->getPost("psico_codigo", FALSE);
        $portaria = "";
        foreach ($portarias as $p) {
            $portaria .= $p . ",";
        }
        $portaria = substr($portaria, 0, -1);
        $pro_codigo = $this->_request->getPost("pro_codigo", FALSE);
        $filtro = $this->_request->getPost("filtro", FALSE);

        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);

        if (!$filtro) {
            $this->view->action = array("action" => "anvisa");
            return $this->render("setor-data-produto", NULL, TRUE); // mostra action para pedir os dados
        }
        //echo "<pre>".print_r($_POST,1);exit;
        $where = $this->tbPro->relAnvisa($this->view, $set_codigo, $data_inicial, $data_final, $pro_codigo, $portaria);
        //die($where);
        $this->relatorio($where, 2);
    }

    public function relAnvisaAnaliticoAction()
    {
        $tbSec = new Application_Model_Secretaria();
        $tbConf = new Application_Model_Configuracao();
        $this->view->secretaria = $tbSec->getDadosSec();
        $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
        Zend_Layout::getMvcInstance()->setLayout("relatorio");
        $this->view->title = "Medicamentos Controlados - Livro de Psicotrópicos";
        $set_codigo = $this->_request->getPost("set_codigo", FALSE);
        $set_nome = $this->_request->getPost("set_nome", FALSE);
        $portarias = $this->_request->getPost("psico_codigo", FALSE);
        $portaria = "";
        foreach ($portarias as $p) {
            $portaria .= $p . ",";
        }
        $portaria = substr($portaria, 0, -1);
        $pro_codigo = $this->_request->getPost("pro_codigo", FALSE);
        $tp_rel = $this->_request->getPost("tp_rel", FALSE);
        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);
        $tbProd = new Application_Model_Produto();
        $dadosProd = $tbProd->dadosProdRelAnalitico($set_codigo, $data_inicial, $data_final, $pro_codigo, $portaria)->toArray();
// Lendo os produtos que contem dispensacao para incluir os pacientes que receber?o
        $i = 0;
        foreach ($dadosProd as $prod) {
            $dadosProd[$i]["dispensacoes"] = $tbProd->dadosPacienteRelAnalitico($prod["pro_codigo"], $data_inicial, $data_final, $set_codigo)->toArray();
            $y = 0;
            foreach ($dadosProd[$i]["dispensacoes"] as $item) {
                // Validando o tipo se ? entrada ou saida, validação realizada por causa da transfer?ncia
                if ($item["set_entrada"] == $set_codigo)
                    $dadosProd[$i]["dispensacoes"][$y]["mov_tipo"] = "E";
                if ($item["set_saida"] == $set_codigo)
                    $dadosProd[$i]["dispensacoes"][$y]["mov_tipo"] = "S";
                $y++;
            }
            //$dadosProd[$i]["entrada"] = $tbProd->entradas;
            $i++;
        }
        //echo "<pre>".print_r($dadosProd,1); die();
        // Dados cabe?alho relatório
        $tbUsr = new Application_Model_Usuarios();
        $this->view->usr = $tbUsr->getUsrAtual();
        $array = array('uni_desc' => $tbUsr->getUsrAtual()->uni_desc,
            'set_nome' => $set_nome);
        if ($data_inicial)
            $array["data_inicial"] = $data_inicial;
        if ($data_final)
            $array["data_final"] = $data_final;

        $this->view->params = serialize($array);
//            echo "<pre>".print_r($dadosProd,1)."</pre>";die();
        $this->view->dados = $dadosProd;
        $this->render("rel-anvisa-analitico");
    }

    public function balancoAction()
    {
        $this->view->title .= " - Balanço Psicotrópicos";

        $set_codigo = $this->_request->getPost("set_codigo", FALSE);
        $psi = $this->_request->getPost("psi", FALSE);

        $portarias = $this->_request->getPost("psico_codigo", FALSE);
        $portaria = "";
        foreach ($portarias as $p) {
            $portaria .= $p . ",";
        }
        $portaria = substr($portaria, 0, -1);

        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);

        if (!$set_codigo) {
            $this->view->action = array("action" => "balanco");
            return $this->render("setor-data-psicotropicos", NULL, TRUE); // mostra action para pedir os dados
        }

        $where = $this->tbPro->relBalanco($this->view, $set_codigo, $data_inicial, $data_final, $psi, $portaria);
        $this->relatorio($where);
    }

    public function transferenciasPorSetorAction()
    {
        $this->view->title .= " - Transferências por setor";

        $set_codigo = $this->_request->getPost("set_codigo", FALSE);

        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);

        if (!$set_codigo) {
            $this->view->action = array("action" => "transferencias-por-setor");
            return $this->render("setor-data", NULL, TRUE); // mostra action para pedir os dados
        }

        $where = $this->tbPro->relTransferencias($this->view, $set_codigo, $data_inicial, $data_final, $psi);
        $this->relatorio($where, 2);


    }

    public function anvisaAction()
    {
        $this->view->title = "Relatório Anvisa";

        $set_codigo = $this->_request->getPost("set_codigo", FALSE);

        $pro_codigo = $this->_request->getPost("pro_codigo", FALSE);
        $filtro = $this->_request->getPost("filtro", FALSE);

        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);

        if (!$filtro) {
            $this->view->action = array("action" => "anvisa");
            return $this->render("setor-data-produto", NULL, TRUE); // mostra action para pedir os dados
        }
        //echo "<pre>".print_r($_POST,1);exit;
        $where = $this->tbPro->relAnvisa($this->view, $set_codigo, $data_inicial, $data_final, $pro_codigo);
        //die($where);
        $this->relatorio($where, 2);


    }

    public function formRankingDeConsumoAction()
    {
        $this->view->title = "Ranking de consumo de Materiais";
        $tbPros = new Application_Model_ProdutoSubgrupo();
        $this->view->subgrupos = $tbPros->getSubGrupos();
    }

    public function relRankingConsumoAction()
    {
        $this->_helper->layout->setLayout("retrato-print");
        $tbSec = new Application_Model_Secretaria();
        $tbConf = new Application_Model_Configuracao();
        $tbPro = new Application_Model_Produto();
        $tbUsr = new Application_Model_Usuarios();
        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);
        $set_codigo = $this->_request->getPost("set_codigo", FALSE);
        $pros_codigo = $this->_request->getPost("pros_codigo", FALSE);
        $quantidade = $this->_request->getPost("quantidade", FALSE);
        $this->view->usr = $tbUsr->getUsrAtual();
        $this->view->produtos = $tbPro->getRankingProdutos($set_codigo, $quantidade, $data_inicial, $data_final, $pros_codigo);
        $this->view->secretaria = $tbSec->getDadosSec();
        $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
        $this->view->tipo_impressao = "RANKING DE CONSUMO";
    }

    public function portariaPsicotropicos()
    {
        $tbPort = new Application_Model_PortariaPsicotropico();
        return $tbPort->getPortaria();
    }

    public function relCurvaAbcIndexAction()
    {
        $this->view->title = "Curva ABC de Consumo";
    }

    public function relCurvaAbcAction()
    {
        $tbSec = new Application_Model_Secretaria();
        $tbConf = new Application_Model_Configuracao();
        $tbPro = new Application_Model_Produto();
        $tbUsr = new Application_Model_Usuarios();
        $this->view->usr = $tbUsr->getUsrAtual();
        $this->view->secretaria = $tbSec->getDadosSec();
        $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
        $this->view->tipo_impressao = "CURVA ABC DE CONSUMO";
        $this->_helper->layout->setLayout("retrato-print");
        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);
        $set_codigo = $this->_request->getPost("set_codigo", FALSE);
        $tbItensMov = new Application_Model_ItensMovimento();
        $this->view->produtos = $tbItensMov->getItensCurvaAbc($data_inicial, $data_final, $set_codigo);
        $this->view->total_lista = $this->calculaTotalCurvaAbcAction($this->view->produtos->toArray());
    }

    public function calculaTotalCurvaAbcAction($produtos = FALSE)
    {
        foreach ($produtos as $produto) {
            $vlr_total_lista += $produto[vlr_total_item];
            $qtd_total_lista += $produto[total_qtde];
        }
        $total_lista = array("qtde_total" => $qtd_total_lista,
            "vlr_total" => $vlr_total_lista);
        return $total_lista;
    }

    public function formMovimentoEntradaAction()
    {
        $this->view->title .= " - Movimentação de Entrada";
        $tbPros = new Application_Model_ProdutoSubgrupo();
        $this->view->subgrupos = $tbPros->getSubGrupos();
    }

    public function movimentoEntradaAction()
    {
        Zend_Layout::getMvcInstance()->setLayout("retrato-print");
        $tbSec = new Application_Model_Secretaria();
        $tbConf = new Application_Model_Configuracao();
        $tbUsr = new Application_Model_Usuarios();
        $this->view->usr = $tbUsr->getUsrAtual();
        $this->view->secretaria = $tbSec->getDadosSec();
        $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
        $this->view->tipo_impressao = "Movimentos de Entrada";
        $set_codigo = $this->_request->getPost("set_codigo", FALSE);
        $pro_codigo = $this->_request->getPost("pro_codigo", FALSE);
        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);
        $pros_codigo = $this->_request->getPost("pros_codigo", FALSE);
        $tbMov = new Application_Model_Movimento();
        $tbIte = new Application_Model_ItensMovimento();
        $mov = $tbMov->getMovimentosEntrada($set_codigo, $data_inicial, $data_final, $pro_codigo, null, $pros_codigo)->toArray();
        $i = 0;
        foreach ($mov as $movimento) {
            $mov[$i][$movimento['mov_codigo']] = $tbIte->getProdutosPorMovimento($movimento['mov_codigo'], $pro_codigo)->toArray();
            $i++;
        }
//        print_r($mov);
//        die();
        $this->view->relatorio = $mov;

    }

	public function formMovimentoSaidaAction()
	{
		$this->view->title .= " - Movimentação de Saída";
	}

	public function gerarRelatorioMovimentoSaidaAction(){
		$setor = $this->_getParam("setor", NULL);
		$produto = $this->_getParam("produto", NULL);
		$data_inicial = $this->_getParam("data_inicial", NULL);
		$data_final = $this->_getParam("data_final", NULL);
		$tp_saida = $this->_getParam("tp_saida", NULL);

		$gerador = new GeradorRelatorio();
		$this->view->dados = $gerador->gerar("SAUDE", "movimentoSaida", [
			"setor" => $setor,
			"produto" => $produto,
			"dtInicial" => $data_inicial,
			"dtFinal" => $data_final,
			"tpSaida" => $tp_saida,
		]);
		$this->render("dados", NULL, TRUE);
	}

    public function formRelMovimentacaoMateriaisAction()
    {
        $this->view->title .= " - Movimentação de Materiais";

        $tbPros = new Application_Model_ProdutoSubgrupo();
        $this->view->subgrupos = $tbPros->getSubGrupos();

        $tbProdGrupo = new Application_Model_ProdutoGrupo();
        $this->view->grupos = $tbProdGrupo->getGrupos();

    }

    public function relMovimentacaoMateriaisAction()
    {
        $this->view->title .= " - Movimentação de Materiais";

        Zend_Layout::getMvcInstance()->setLayout("relatorio");
        $set_codigo = $this->_request->getPost("set_codigo", FALSE); //Setor
        $gru_codigo = $this->_request->getPost("gru_codigo", FALSE); //Grupoo
        $pros_codigo = $this->_request->getPost("pros_codigo", FALSE); //Subgrupo
        $pro_codigo = $this->_request->getPost("pro_codigo", FALSE); //Produto
        $data_inicial = $this->_request->getPost("data_inicial", FALSE); //Data Inicial
        $data_final = $this->_request->getPost("data_final", FALSE); //Data Final

        // Lista dados relatório
        $tbMov = new Application_Model_Movimento();
        $this->view->dados = $tbMov->relMovimentacaoMateriais($set_codigo, $gru_codigo, $pros_codigo, $pro_codigo, $data_inicial, $data_final)->toArray();

        if ($data_inicial) {
            $array["data_inicial"] = $data_inicial;
        }
        if ($data_final) {
            $array["data_final"] = $data_final;
        }
        $array["set_nome"] = $this->_request->getPost("set_nome", FALSE);
        $this->view->params = serialize($array);
    }

    public function formRelMovimentacaoMateriaisAnaliticoAction()
    {
        $this->view->title .= " - Movimentação de Materiais (Analítico)";

        $tbPros = new Application_Model_ProdutoSubgrupo();
        $this->view->subgrupos = $tbPros->getSubGrupos();

        $tbProdGrupo = new Application_Model_ProdutoGrupo();
        $this->view->grupos = $tbProdGrupo->getGrupos();

    }

    public function relMovimentacaoMateriaisAnaliticoAction()
    {
        $this->view->title .= " - Movimentação de Materiais (Analítico)";

        Zend_Layout::getMvcInstance()->setLayout("relatorio");
        $set_codigo = $this->_request->getPost("set_codigo", FALSE); //Setor
        $set_nome = $this->_request->getPost("set_nome", FALSE);
        //$gru_codigo = $this->_request->getPost("gru_codigo", FALSE); //Grupo
        //$pros_codigo = $this->_request->getPost("pros_codigo", FALSE); //Subgrupo
        $pro_codigo = $this->_request->getPost("pro_codigo", FALSE); //Produto
        $data_inicial = $this->_request->getPost("data_inicial", FALSE); //Data Inicial
        $data_final = $this->_request->getPost("data_final", FALSE); //Data Final

        // Lista dados relatório
        $tbMov = new Application_Model_Movimento();
        $this->view->dados = $tbMov->relMovimentacaoMateriaisAnalitico($set_codigo, $gru_codigo, $pros_codigo, $pro_codigo, $data_inicial, $data_final)->toArray();
        $this->view->set_codigo = $set_codigo;

        $tbUsr = new Application_Model_Usuarios();
        $this->view->usr = $tbUsr->getUsrAtual();

        if ($data_inicial) {
            $array["data_inicial"] = $data_inicial;
        }
        if ($data_final) {
            $array["data_final"] = $data_final;
        }
        if ($set_nome) {
            $array["set_nome"] = $set_nome;
        }

        $array["uni_desc"] = $tbUsr->getUsrAtual()->uni_desc;

        $this->view->params = serialize($array);

    }


    public function gerarRelatorioSaidaTransferenciaAction(){
        $setor_origem = $this->_getParam("setorOrigem", NULL);
        $setor_destino = $this->_getParam("setorDestino", NULL);
        $data_inicial = $this->_getParam("dataInicial", NULL);
        $data_final = $this->_getParam("dataFinal", NULL);
        $saida = $this->_getParam("saida", NULL);
        $perda = $this->_getParam("perda", NULL);
        $transferencia = $this->_getParam("transferencia", NULL);
        $grupo = $this->_getParam("grupo", NULL);
        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "saidaTransferenciaMateriais", [
            "setorOrigem" => $setor_origem,
            "setorDestino" => $setor_destino,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "saida" => $saida,
            "perda" => $perda,
            "transferencia" => $transferencia,
            "grupo" => $grupo
        ]);
        $this->render("dados", NULL, TRUE);
    }

}

