<?php

require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";
class Relatorio_PacienteController extends Elotech_Controller_Action_Relatorio {
    public function init() {

    }

    public function indexAction(){
        Zend_Layout::getMvcInstance()->setLayout("retrato-print");
        $this->view->title = "Relatório total de pacientes ativos";
        $tbUsr = new Application_Model_Usuarios();
        $tbSec = new Application_Model_Secretaria();
        $tbUsu = new Application_Model_Usuario();
        $this->view->usr = $tbUsr->getUsrAtual();
        $this->view->secretaria  = $tbSec->getDadosSec();
        $this->view->tipo_impressao = "PACIENTES";
        $this->view->title = "Imprimir Encaminhamento Médico";
        $this->view->dados = $tbUsu->getQtdUsuariosAtivo();
    }

    private function getFiltros($sexo){
        $delimitador = "@#$";
        $sexo_nome = ($sexo == 'F') ? "Feminino" : "Masculino";
        $sexo_filtro = ($sexo == "*") ? "" : "usu_sexo ='{$sexo}' AND ";
        $idade = "EXTRACT(YEAR FROM age(usu_datanasc))";
        $counter = $this->_request->getPost("counter", FALSE);

        $filtros = array();
        for($i=0; $i <= $counter; $i++){
            $filtro = $this->_request->getPost("filtro_tipo_" . $i, FALSE);
            if($filtro == '><') {
                $inicio = $this->_request->getPost("filtro_".$i."_inicio");
                $fim = $this->_request->getPost("filtro_".$i."_fim");

                $chave = $sexo_nome.' - '.sprintf('%02d', $inicio).' a '.sprintf('%02d', $fim).' ano(s)';
                $filtros[$chave] = "{$sexo_filtro}{$idade} BETWEEN {$inicio} AND {$fim}";
            } else if($filtro) {
                $valor= $this->_request->getPost("filtro_".$i);

                if($filtro == '<') {
                    $chave = $sexo_nome.' - Menos de '.sprintf('%02d', $valor).' ano(s)';
                } else if($filtro == '=') {
                    $chave = $sexo_nome.' - '.sprintf('%02d', $valor).' ano(s)';
                } else {
                    $chave = $sexo_nome.' - Mais de '.sprintf('%02d', $valor).' ano(s)';
                }
                $filtros[$chave] = "{$sexo_filtro}{$idade} {$filtro} {$valor}";
            }
        }
        if (empty($filtros)) {
            $filtros = $this->getFiltrosPadrao($sexo_nome, $sexo_filtro, $idade);
        }
        $filtros = array_map(
            function ($str) { return "COUNT(CASE WHEN (".$str.") THEN 1 END)"; }, $filtros);
        return $filtros;
    }

    private function getFiltrosPadrao($sexo_nome, $sexo_filtro, $idade) {
        $filtros = Array();
        $filtros[$sexo_nome.' - Menos de 01 ano(s)']  = "{$sexo_filtro}{$idade} < 1";
        $filtros[$sexo_nome.' - 01 ano(s)']           = "{$sexo_filtro}{$idade} = 1";
        $filtros[$sexo_nome.' - 02 ano(s)']           = "{$sexo_filtro}{$idade} = 2";
        $filtros[$sexo_nome.' - 03 ano(s)']           = "{$sexo_filtro}{$idade} = 3";
        $filtros[$sexo_nome.' - 04 ano(s)']           = "{$sexo_filtro}{$idade} = 4";
        $filtros[$sexo_nome.' - 05 a 09 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 5 AND 9";
        $filtros[$sexo_nome.' - 10 a 14 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 10 AND 14";
        $filtros[$sexo_nome.' - 15 a 19 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 15 AND 19";
        $filtros[$sexo_nome.' - 20 a 24 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 20 AND 24";
        $filtros[$sexo_nome.' - 25 a 29 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 25 AND 29";
        $filtros[$sexo_nome.' - 30 a 34 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 30 AND 34";
        $filtros[$sexo_nome.' - 35 a 39 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 35 AND 39";
        $filtros[$sexo_nome.' - 40 a 44 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 40 AND 44";
        $filtros[$sexo_nome.' - 45 a 49 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 45 AND 49";
        $filtros[$sexo_nome.' - 50 a 54 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 50 AND 54";
        $filtros[$sexo_nome.' - 55 a 59 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 55 AND 59";
        $filtros[$sexo_nome.' - 60 a 64 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 60 AND 64";
        $filtros[$sexo_nome.' - 65 a 69 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 65 AND 69";
        $filtros[$sexo_nome.' - 70 a 74 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 70 AND 74";
        $filtros[$sexo_nome.' - 75 a 79 ano(s)']      = "{$sexo_filtro}{$idade} BETWEEN 75 AND 79";
        $filtros[$sexo_nome.' - Mais de 80 ano(s)']   = "{$sexo_filtro}{$idade} > 80";

        return $filtros;
    }

    public function relatorioPacienteFiltroAction(){
        $tbSec = new Application_Model_Secretaria();
        $tbConf = new Application_Model_Configuracao();
        $tbEsp = new Application_Model_Especialidade();
        $this->view->secretaria = $tbSec->getDadosSec();
        $this->view->nome_cidade = $tbConf->getConfig("NOME_CIDADE");
        Zend_Layout::getMvcInstance()->setLayout("retrato-print");
        $this->view->title = "Relatório Total de Pacientes por Faixa Etária e Sexo";

        $uni_codigo = $this->_request->getPost("uni_codigo", FALSE);
        $ine_codigo = $this->_request->getPost("ine_codigo", FALSE);
        $usr_codigo = $this->_request->getPost("usr_codigo", FALSE);
        $this->view->prof_nome = $this->_request->getPost("prof_nome", FALSE);

        $this->view->sexo = $this->_request->getPost("sexo", "*");
        $tbUsr = new Application_Model_Usuarios();
        $filtros = null;

        if($this->view->sexo == '*') {
            $f = $this->getFiltros('F');
            $m = $this->getFiltros('M');
            $filtros = array_merge($m, $f);
        } else {
            $filtros = $this->getFiltros($this->view->sexo);
        }

        $params = $_POST;
        if($usr_codigo) {
            $especialidade = $tbEsp->getEspecialidadePorProfissional($usr_codigo)->toArray();
            $params["esp_nome"] = strtoupper($especialidade[0]["esp_nome"]);
        }

        $this->view->dados = $tbUsr->getPacientesPorSexoFaixaEtaria($filtros, $uni_codigo, $ine_codigo, $usr_codigo);
        $this->_helper->layout->setLayout("relatorio");
        $this->view->params = serialize($params);
    }

    public function formRelatorioPacienteFiltroAction() {
        $this->view->title = "Relatório total de pacientes por faixa etária e sexo";
    }

    public function gerarRelatorioPacientesPorFaixaEtariaSexoAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $equipe = $this->_getParam("equipe", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $faixa_etaria = $this->_getParam("faixa_etaria",NULL);
        $sexo = $this->_getParam("sexo", NULL);
        $tp_rel = $this->_getParam("tp_rel", NULL);
        $agr_usr = $this->_getParam("agr_usr", NULL);

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "pacientesFaixaSexo", [
            "unidade" => $unidade,
            "profissional" => $profissional,
            "equipe" => $equipe,
            "faixaEtaria" => $faixa_etaria,
            "sexo" => $sexo,
            "tpRel" => $tp_rel,
            "agrUsr" => $agr_usr
        ]);
        $this->render("dados", NULL, TRUE);
    }

}

