<?php
require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";
class Relatorio_TransporteController extends Elotech_Controller_Action_Relatorio {

	public function formVeiculoAction() {
		/* Considerações
		 * A paginá HTML que está localizada na pasta relatórios/script/view/transporte/
		 * tem que possuir o mesmo nome da chamada do form por ex: form-veiculo
		 * incluindo sempre o action na frente
		 */
		// Chamando o model de veículos
		$tbVei = new Application_Model_Veiculo();
		// Encaminha um array com todos os veículos cadastrados
		$this->view->veiculo = $tbVei->getVeiculos();
		// Título da view
		$this->view->title = "Viagem por veículo";
		// Chamando a view de form-veiculo
		$this->render("form-veiculo");
	}

	public function veiculoAction() {
		// Chamando o model de viagem
		$tbVia = new Application_Model_Viagem();
		// Chamando o Layout padrão de relatórios, que está na pasta layout/default/scripts  
		Zend_Layout::getMvcInstance()->setLayout("relatorio");
		// Recebendo os dados do formulário 
		$data_inicial	= $this->_request->getPost("data_inicial", FALSE);
		$data_final		= $this->_request->getPost("data_final", FALSE);
		$vei_codigo		= $this->_request->getPost("vei_codigo", FALSE);
		// Chamando o métod o de viagem por veículo
		$this->view->dados = $tbVia->getViagemPorVeiculo($vei_codigo, $data_inicial, $data_final);
		// Não sei o que faz
		$this->view->uni_cnes = $uni_cnes;
		$this->view->data_inicial	= $data_inicial;
		$this->view->data_final		= $data_final;
		$array	= array('data_inicial' => $data_inicial, 'data_final' => $data_final);
		// Não sei o que faz
		$this->view->params			= serialize($array);
		// Seta o título da página
		$this->view->title			= "Relatório de Viagem por Veículo";
	}
	
	public function formMotoristaAction() {
		$tbVia = new Application_Model_Viagem();
		$this->view->motorista = $tbVia->getViagemPorMotorista();

		$this->view->title = "Viagem por Motorista";
		$this->render("form-motorista");
	}

	public function motoristaAction() {
		$tbVia = new Application_Model_Viagem();
		//echo "<pre>".print_r($_POST,1);die();
		Zend_Layout::getMvcInstance()->setLayout("relatorio");

		$data_inicial = $this->_request->getPost("data_inicial", FALSE);
		$data_final = $this->_request->getPost("data_final", FALSE);
		$usr_codigo = $this->_request->getPost("usr_codigo", FALSE);

		//echo "<pre>".print_r($tipo_consulta,1);die();

		$this->view->dados = $tbVia->getViagemPorMotorista($usr_codigo, $data_inicial, $data_final);



		$this->view->data_inicial = $data_inicial;
		$this->view->data_final = $data_final;
		$array = array('data_inicial' => $data_inicial,
			'data_final' => $data_final);
		$this->view->params = serialize($array);
		$this->view->title = "Relatório de Viagem por Motorista";
	}

	public function formEncaminhamentosAction() {
		// Chamando o model de veículos
		$tbVei = new Application_Model_Veiculo();
		// Chamando o métod o que retorna todos os veículos cadastrados
		$this->view->veiculo = $tbVei->getVeiculos();
		// Setando o título da página
		$this->view->title = "Relatório de Viagens";
		// Chama a página e faz o redirecionamento
		$this->render("form-encaminhamentos");
	}

	public function gerarRelatorioViagemAction(){
        $veiculo = $this->_getParam("veiculo", NULL);
        $paciente = $this->_getParam("paciente", NULL);
        $municipio = $this->_getParam("municipio", NULL);
        $data_inicial = $this->_getParam("dataInicial", NULL);
        $data_final = $this->_getParam("dataFinal", NULL);
        $agrupamento = $this->_getParam("agrupamento", FALSE);
        $tp_rel = $this->_getParam("tpRel", NULL);

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "viagens", [
            "veiculo" => $veiculo,
            "paciente" => $paciente,
            "municipio" => $municipio,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "agrupamento" => $agrupamento,
            "tpRel" => $tp_rel
        ]);
        $this->render("dados", NULL, TRUE);
    }

}

