<?php

require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";

class Relatorio_UsuarioController extends Elotech_Controller_Action_Relatorio
{

    private $tbUsu;

    public function init()
    {
        $this->view->title = "Pacientes";
        $this->tbUsu = new Application_Model_Usuario();
    }

    public function indexAction()
    {

    }

    public function prontuarioAction()
    {
        $this->view->title .= " - Prontuário";

        $usu_codigo_relatorio = $this->_request->getPost("usu_codigo", FALSE);
        $usu_codigo_atendimento = $this->_getParam("usu_codigo", FALSE);
        $agendamento = $this->_getParam("age_codigo", FALSE);


        $usu_codigo = ($usu_codigo_relatorio ? $usu_codigo_relatorio : $usu_codigo_atendimento);

        if (!$usu_codigo) {
            $this->view->action = array("action" => "prontuario");
            return $this->render("prontuario", NULL, TRUE); // mostra action para pedir os dados
        }

        Zend_Layout::getMvcInstance()->setLayout("simples");

        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);

        $options = $this->_request->getPost("op", FALSE);

        $this->view->dados = $this->tbUsu->relProntuario($usu_codigo, $data_inicial, $data_final, $options);

        $this->view->data_inicial = $data_inicial;
        $this->view->data_final = $data_final;
        $tbUsr = new Application_Model_Usuarios();
        $this->view->usr_nome = $tbUsr->getUsrAtual()->usr_nome;

        $tbDom = new Application_Model_Domicilio();

        $this->view->dom = $tbDom->getEnderecoPorUsuario($usu_codigo)->estrat_risco_familiar;

        if (!$this->view->dados->usu) {
            // Paciente não localizado, redirecionar
        }

        if ($agendamento) {
            $this->render('prontuario-timeline');
        }
    }

    public function guiaDiagnosticoAction()
    {
        $this->view->headLink()->appendStylesheet($this->view->baseUrl() . '/public/css/relatorio/usuario/prontuario.css', 'all');
        $this->view->title .= " - Guia de Diagnostico";
        $this->view->age_codigo = $this->_getParam("age_codigo", FALSE);
        $tbUsr = new Application_Model_Usuarios();
        $this->view->med_nome = $tbUsr->getInfoUsr($this->_getParam("med_codigo", FALSE))->usr_nome;

        $usu_codigo = $this->_request->getPost("usu_codigo", FALSE);
        if (!$usu_codigo)
            $usu_codigo = $this->_getParam("usu_codigo", FALSE);

        if (!$usu_codigo) {
            $this->view->action = array("action" => "prontuario");
            return $this->render("prontuario", NULL, TRUE); // mostra action para pedir os dados
        }

        Zend_Layout::getMvcInstance()->setLayout("simples");

        $data_inicial = $this->_request->getPost("data_inicial", FALSE);
        $data_final = $this->_request->getPost("data_final", FALSE);

        //$options = $this->_request->getPost("op", FALSE);
        $options = array(0 => "atendimentos", 1 => "pre-consulta", 2 => "medicamentos"); //caso quiser colocar mais historicos add no array e descomente o codigo da view

        $tbConf = new Application_Model_Configuracao();
        if ($tbConf->getConfig("LIMIT_GUIA_DIAGNOSTICO") != NULL) {
            $limit = $tbConf->getConfig("LIMIT_GUIA_DIAGNOSTICO");
        } else {
            $limit = null;
        }

        $this->view->dados = $this->tbUsu->relProntuario($usu_codigo, $data_inicial, $data_final, $options, $limit);
        //die($data_inicial);
        $this->view->data_inicial = $data_inicial;
        $this->view->data_final = $data_final;
        $tbUsr = new Application_Model_Usuarios();
        $this->view->usr_nome = $tbUsr->getUsrAtual()->usr_nome;

        if (!$this->view->dados->usu) {
            // Paciente não localizado, redirecionar
        }


    }

    public function buscaDomicilioPacienteAction()
    {
        $tbDom = new Application_Model_Domicilio();

        $paciente = $this->_request->getPost("usu_codigo");
        $this->view->dados = $tbDom->getEnderecoPorUsuario($paciente)->toArray();

        return $this->render("dados", NULL, TRUE);
    }

    public function relatorioDuplicadosAction()
    {
        Zend_Layout::getMvcInstance()->setLayout("modelo-print");
        $tbUsuario = new Application_Model_Usuario();
        $this->view->duplicados = $tbUsuario->getDuplicados();
    }

    public function estratificacaoHdiAction()
    {
        $this->view->title = "Relatório Estratificação de Risco: Hipertensos, Diabéticos e Idosos";
    }


    public function gerarRelatorioEstratificacaoHdiAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $equipe = $this->_getParam("equipe", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $risco = $this->_getParam("risco", NULL);
        $tp_rel = $this->_getParam("tpRel", "S");
        $tp_rel = ($tp_rel == "S" ? "SINTETICO" : "ANALITICO");
        $hipertenso = $this->_getParam("hipertenso", NULL);
        $diabetico = $this->_getParam("diabetico", NULL);
        $idoso = $this->_getParam("idoso", NULL);

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "estratificacaoHdi", [
            "unidade" => $unidade,
            "equipe" => $equipe,
            "profissional" => $profissional,
            "risco" => $risco,
            "tpRel" => $tp_rel,
            "hipertenso" => $hipertenso,
            "diabetico" => $diabetico,
            "idoso" => $idoso
        ]);

        $this->render("dados", NULL, TRUE);

    }

    public function estratificacaoRiscoGestantesPuerperasAction()
    {
        $this->view->title = "Relatório Estratificação de Risco: Gestantes e Puérperas";
    }

    public function gerarRelatorioEstratificacaoGestantesPuerperasAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $equipe = $this->_getParam("equipe", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $risco = $this->_getParam("risco", NULL);
        $tpDados = $this->_getParam("tpDados", NULL);
        $tpRel = $this->_getParam("tpRel", "SINTETICO");

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "estratificacaoGestantesPuerperas", [
            "unidade" => $unidade,
            "equipe" => $equipe,
            "profissional" => $profissional,
            "risco" => $risco,
            "tpDados" => $tpDados,
            "tpRel" => $tpRel
        ]);
        $this->render("dados", NULL, TRUE);

    }

    public function estratificacaoRiscoSaudeBucalAction()
    {
        $this->view->title = "Relatório Estratificação de Risco: Saúde Bucal";
    }

    public function gerarRelatorioEstratificacaoSaudeBucalAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $equipe = $this->_getParam("equipe", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $risco = $this->_getParam("risco", NULL);

        $tpRel = $this->_getParam("tpRel", "SINTETICO");

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "estratificacaoSaudeBucal", [
            "unidade" => $unidade,
            "equipe" => $equipe,
            "profissional" => $profissional,
            "risco" => $risco,
            "tpRel" => $tpRel
        ]);
        $this->render("dados", NULL, TRUE);

    }

    public function estratificacaoRiscoSaudeMentalAction()
    {
        $this->view->title = "Relatório Estratificação de Risco: Saúde Mental";
    }

    public function gerarRelatorioEstratificacaoSaudeMentalAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $equipe = $this->_getParam("equipe", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $risco = $this->_getParam("risco", NULL);

        $tpRel = $this->_getParam("tpRel", "SINTETICO");

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "estratificacaoSaudeMental", [
            "unidade" => $unidade,
            "equipe" => $equipe,
            "profissional" => $profissional,
            "risco" => $risco,
            "tpRel" => $tpRel
        ]);
//
        $this->render("dados", NULL, TRUE);

    }

    public function estratificacaoRiscoFamiliarAction()
    {
        $this->view->title = "Relatório Estratificação de Risco: Familiar";
    }

    public function gerarRelatorioEstratificacaoRiscoFamiliarAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $equipe = $this->_getParam("equipe", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $risco = $this->_getParam("risco", NULL);
        $tpRel = $this->_getParam("tpRel", "SINTETICO");

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "estratificacaoFamiliar", [
            "unidade" => $unidade,
            "equipe" => $equipe,
            "profissional" => $profissional,
            "risco" => $risco,
            "tpRel" => $tpRel
        ]);
        $this->render("dados", NULL, TRUE);

    }

    public function estratificacaoRiscoCriancaAction()
    {
        $this->view->title = "Relatório Estratificação de Risco: Crianças";
    }

    public function gerarRelatorioEstratificacaoRiscoCriancaAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $equipe = $this->_getParam("equipe", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $faixa_etaria = $this->_getParam("faixa_etaria");
        $risco = $this->_getParam("risco", NULL);
        $tpRel = $this->_getParam("tpRel", "SINTETICO");

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "estratificacaoCrianca", [
            "unidade" => $unidade,
            "equipe" => $equipe,
            "profissional" => $profissional,
            "risco" => $risco,
            "tpRel" => $tpRel,
            "faixaEtaria" => $faixa_etaria
        ]);
        $this->render("dados", NULL, TRUE);

    }

	public function estatisticasAreaMicroareaAction()
	{
		$this->view->title = "Estatísticas de Área e Micro-Área";
	}

	public function gerarRelatorioEstatisticasAreaMicroareaAction()
	{
		$unidade = $this->_getParam("unidade", NULL);
		$equipe = $this->_getParam("equipe", NULL);
		$microarea = $this->_getParam("microarea", NULL);
		$tpRel = $this->_getParam("tpRel", "SINTETICO");

		$gerador = new GeradorRelatorio();
		$this->view->dados = $gerador->gerar("SAUDE", "estatisticasAreaMicroarea", [
			"unidade" => $unidade,
			"equipe" => $equipe,
			"microarea" => $microarea,
			"tpRel" => $tpRel
		]);
		$this->render("dados", NULL, TRUE);

	}
}

