<?php

require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";

class Relatorio_VacinaController extends Elotech_Controller_Action_Relatorio
{

    public function init()
    {

    }

    public function formVacinadosPorVacinaAction()
    {
        $this->view->title .= "Controle de Vacinados por Vacina";
    }

    public function gerarRelatorioControleVacinadosPorVacinaAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $vacina = $this->_getParam("vacina", NULL);
        $dtInicial = $this->_getParam("dtInicial", NULL);
        $dtFinal = $this->_getParam("dtFinal", NULL);
        $tpRel = $this->_getParam("tpRel", "SINTETICO");

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "controleVacinadosPorVacina", [
            "unidade" => $unidade,
            "profissional" => $profissional,
            "vacina" => $vacina,
            "dtInicial" => $dtInicial,
            "dtFinal" => $dtFinal,
            "tpRel" => $tpRel
        ]);
        $this->render("dados", NULL, TRUE);

    }

    public function buscarVacinaAction()
    {
        $term = $this->_getParam("term", FALSE);
        if (!$term)
            return false;

        $tbPro = new Application_Model_Produto();
        $this->view->dados = $tbPro->buscarVacina($term);

        return $this->render("dados", NULL, TRUE);

    }


}