<?php
require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";
class Relatorio_VisitaDomiciliarController extends Elotech_Controller_Action_Relatorio
{

    public function init()
    {
        $this->view->title = "Relatório de Visita Domiciliar";
    }

    public function indexAction()
    {
        //Pega a lista de Unidades para a view
        $tbUni = new Application_Model_Unidade();
        $tbUsr = new Application_Model_Usuarios();
        if($tbUsr->getUsrAtual()->usr_acesso_unidades == "S") {
            $this->view->unidade = $tbUni->getUnidades();
        }else{
            $this->view->unidade = $tbUni->getUnidadePorUsuario($tbUsr->getUsrAtual()->usr_codigo);
        }
        $tbDesf = new Application_Model_TbCdsVisitaDomDesfecho();
        $this->view->desfechos = $tbDesf->getDesfecho();
    }

    public function relatorioVisitaDomiciliarAction()
    {
        /*
         * Este metodo busca as atividades de acordo com os filtros selecionados
         * e os coloca em uma unica variavel.
        */
        Zend_Layout::getMvcInstance()->setLayout("simples");
        $this->view->title = "Relatorio Visita Domiciliar";
        //Pegando os paramentros dos filtros informados
        //PS: validação dos filtros esta na querry
        $dadosParaConsulta = array(
            "unidade" => $this->_request->getPost("uni_codigo"),
            "paciente" => $this->_request->getPost("usu_codigo"),
            "profissional" => $this->_request->getPost("usr_codigo"),
            "dataInicial" => $this->formatarDataBD($this->_request->getPost("dataInicial")),
            "dataFinal" => $this->formatarDataBD($this->_request->getPost("dataFinal"))
        );

        if ($this->_request->getPost("pac_part_nome") == "") {
            $dadosParaConsulta['paciente'] = null;
        }
        if ($this->_request->getPost("profs_part_nome") == "") {
            $dadosParaConsulta['profissional'] = null;
        }

        //Função que ira buscar as Atividades
        $tbVisita = new Application_Model_EsusVisitaDomiciliar();
        $this->view->dados = $tbVisita->getDadosRelatorio($dadosParaConsulta);
    }

    public function formDomicilioVinculadoPorUsuarioAction()
    {
        $this->view->title = "Domicilios com Usuários Vinculados";
    }

    public function preencheEquipesAction()
    {
        $tbEquipes = new Application_Model_EquipeIne();

        $unidade = $this->_request->getPost("uni_codigo");
        $this->view->dados = $tbEquipes->getEquipesPorUnidade($unidade)->toArray();

        return $this->render("dados", NULL, TRUE);
    }

	public function preencheMicroareaAction()
	{
		$tbMic = new Application_Model_MicroArea();

		$nu_ine = $this->_getParam("nu_ine");
		$this->view->dados = $tbMic->getMicroAreasAtivasPorNuIne($nu_ine)->toArray();
		return $this->render("dados", NULL, TRUE);
	}

    public function gerarRelatorioDomicilioVinculadoPorUsuarioAction()
    {
        $unidade = $this->_getParam("unidade", NULL);
        $paciente = $this->_getParam("paciente", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $data_inicial = $this->_getParam("dataInicial", NULL);
        $data_final = $this->_getParam("dataFinal", NULL);
        $tp_rel = $this->_getParam("tpRel", NULL);
        $complemento_relatorio = $this->_getParam("complemento", FALSE);

        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "domicilioVinculado", [
            "unidade" => $unidade,
            "paciente" => $paciente,
            "profissional" => $profissional,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "integrantes" => $complemento_relatorio,
            "tpRel" => $tp_rel
        ]);
        $this->render("dados", NULL, TRUE);

    }

    private function formatarDataBD($dt)
    {
        if (!empty($dt)) {
            $data = explode("/", $dt);
            return $data[2] . "-" . $data[1] . "-" . $data[0];
        }
    }

    public function gerarRelatorioVisitaDomiciliarAction(){
        $unidade = $this->_getParam("unidade", NULL);
        $paciente = $this->_getParam("paciente", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $data_inicial = $this->_getParam("dataInicial", NULL);
        $data_final = $this->_getParam("dataFinal", NULL);
        $desfecho = $this->_getParam("desfecho", NULL);
        $tp_rel = $this->_getParam("tpRel", NULL);
        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "visitaDomiciliar", [
            "unidade" => $unidade,
            "paciente" => $paciente,
            "profissional" => $profissional,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "desfecho" => $desfecho,
            "tpRel" => $tp_rel,
        ]);
        $this->render("dados", NULL, TRUE);
    }


    public function formRelatorioBuscaAtivaAction()
    {
        //Pega a lista de Unidades para a view
	    $this->view->title = "Buscas Ativas";
        $tbUni = new Application_Model_Unidade();
        $this->view->unidade = $tbUni->getUnidades();

    }

    public function gerarRelatorioBuscaAtivaAction(){
        $unidade = $this->_getParam("unidade", NULL);
        $profissional = $this->_getParam("profissional", NULL);
        $equipe = $this->_getParam("equipe", NULL);
        $data_inicial = $this->_getParam("dataInicial", NULL);
        $data_final = $this->_getParam("dataFinal", NULL);
        $tp_rel = $this->_getParam("tpRel", NULL);
        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "buscaAtiva", [
            "unidade" => $unidade,
            "profissional" => $profissional,
            "equipe" => $equipe,
            "dtInicial" => $data_inicial,
            "dtFinal" => $data_final,
            "tpRel" => $tp_rel,
        ]);
        $this->render("dados", NULL, TRUE);
    }
}