<?php
class Transporte_LocaisController extends Zend_Controller_Action {

    public function init(){
       $this->view->title = "Cadastro de Locais";
    }

    public function indexAction(){
        $this->view->title = "Cadastro de Locais";
        $this->view->itens = (new Application_Model_TransporteLocais())->getLocais();
    }

    public function novoAction() {

         $this->render("form");

    }

    public function salvarAction(){
      $data = array(
          "loc_descricao" => $this->_request->getPost("loc_descricao"),
          "loc_logradouro" => $this->_request->getPost("loc_logradouro"),
          "loc_bairro" => $this->_request->getPost("loc_bairro",NULL),
          "cid_codigo" => $this->_request->getPost("cid_codigo",NULL),
      );
      if($this->_request->getPost("loc_codigo")){
          $data['loc_codigo'] = $this->_request->getPost("loc_codigo");
      }

      $tbLoc = new Application_Model_TransporteLocais();

      try{
          $tbLoc->salvar($data);
          $this->view->dados = array("success"=>true);
      } catch (Exception $e){
          $this->view->dados = array("success"=>false,"mensagem"=>$e->getMessage());
      }

      return $this->render("dados",NULL,TRUE);

    }

    public function editarAction() {
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/transporte/locais/novo.js');
        $loc_codigo = $this->_getParam("id",FALSE);
        $this->view->dados = (new Application_Model_TransporteLocais())->getLocal($loc_codigo);
        return $this->render("form");
      }

    public function excluirAction(){
        $id = $this->_getParam("id",false);
        $tbLoc = new Application_Model_TransporteLocais();

        try{
            $tbLoc->excluir($id);
            $this->view->dados = array("success"=>true);
        } catch (Exception $e){
            $this->view->dados = array("success"=>false,"mensagem"=>$e->getMessage());
        }

        return $this->render("dados",NULL,TRUE);


    }

    public function pesquisaAction() {
        $term = $this->_request->getPost("busca", FALSE);
        if($term){
            $this->view->itens = (new Application_Model_TransporteLocais())->pesquisar($term);
            $this->render("index");
        }
    }

}
