<?php
class Transporte_ViagemController extends Zend_Controller_Action {

  public function init() {
    $this->view->title = "Viagem";
  }

  public function indexAction() {
    $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/transporte/viagem/novo.js');
    $tbVia = new Application_Model_Viagem();
    $this->view->itens = $tbVia->getViagens(15);
    $this->view->edicao = 0;
  }

  public function novoAction() {
    $tbVei = new Application_Model_Veiculo();
    $this->view->locais = (new Application_Model_TransporteLocais())->getLocais();
    $this->view->veiculo = $tbVei->getVeiculos();
    $this->view->edicao = 0;

    $this->render("form");
  }

  public function salvarAction() {
    $tbVia = new Application_Model_Viagem();
    $tbLoc = new Application_Model_TransporteViagemLocais();
    $this->_helper->layout->disableLayout();

    $dados = array(
                  "via_codigo"=>$this->_request->getPost("via_codigo",FALSE),
                  "via_data"=>$this->_request->getPost("via_data",FALSE),
                  "vei_codigo"=>$this->_request->getPost("vei_codigo",FALSE),
                  "usr_codigo"=>$this->_request->getPost("usr_codigo",FALSE),
                  "cid_codigo_origem"=>$this->_request->getPost("cid_codigo_origem",FALSE),
                  "cid_codigo_destino"=>$this->_request->getPost("cid_codigo_destino",FALSE),
                  "via_motivo"=>$this->_request->getPost("via_motivo",FALSE),
                  "usr_codigo_cadastro"=>$this->_request->getPost("usr_codigo_cadastro",FALSE),
                  "via_km"=>$this->_request->getPost("via_km",FALSE),
                  );

    $this->view->edicao = 1;
    $via_codigo = $tbVia->salvar($dados);

      $embarques = $this->_request->getPost("emb", FALSE);
//      print_r($embarques);die();

      foreach ($embarques as $emb){
          $dados = array(
              'via_codigo' => $via_codigo,
              'loc_codigo' => $emb['loc_codigo'],
              'tvl_hora' => $emb['tvl_hora'],
              'tvl_tipo' => "E",
          );
          if($emb['tvl_codigo']){
              $dados['tvl_codigo'] = $emb['tvl_codigo'];
          }
          $tbLoc->salvar($dados);
      }

      $desembarques = $this->_request->getPost("desemb", FALSE);

      foreach ($desembarques as $desemb){
          $dados = array(
              'via_codigo' => $via_codigo,
              'loc_codigo' => $desemb['loc_codigo'],
              'tvl_hora' => $desemb['tvl_hora'],
              'tvl_tipo' => "D",
          );
          if($desemb['tvl_codigo']){
              $dados['tvl_codigo'] = $desemb['tvl_codigo'];
          }
          $tbLoc->salvar($dados);
      }

    $this->_redirect("transporte/viagem/");
  }

  public function getViagemUsuarioAction() {
    $this->_helper->layout->disableLayout();

    $tbViaU = new Application_Model_ViagemUsuario();
    $id = $this->_getParam("id",false);

    $this->view->dados = $tbViaU->getViagemPorUsuarioJson($id)->count();
    $this->view->edicao = 1;
    $this->render("dados");

  }
  public function editarAction() {
    $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/transporte/viagem/novo.js');
    $this->view->locais = (new Application_Model_TransporteLocais())->getLocais();
    $this->view->edicao = 1;
    $via_codigo = $this->_getParam("id",FALSE);

    if (!$via_codigo)
      return $this->_redirect("/transporte/viagem");

    $tbVei = new Application_Model_Veiculo();
    $tbVia = new Application_Model_Viagem();
    $tbLoc = new Application_Model_TransporteViagemLocais();

    $this->view->veiculo = $tbVei->getVeiculos();
    $this->view->dados =  $tbVia->getViagem($via_codigo);
    $this->view->embarques = $tbLoc->getLocaisEmbarque($via_codigo);
    $this->view->desembarques = $tbLoc->getLocaisDesembarque($via_codigo);
    return $this->render("form");
  }

  public function excluirAction() {
    $id = $this->_getParam("id",false);
    $tbVia = new Application_Model_Viagem();
    $tbVia->excluir($id);

    $this->_redirect("transporte/viagem/");
  }

  public function pesquisaAction() {
    if ($this->_request->isPost()) {
      $tbVia = new Application_Model_Viagem();
      $this->view->busca = $this->_request->getPost("busca");
      $this->view->itens = $tbVia->pesquisar($this->view->busca);
      $this->render("index");
    } else {
      $this->_redirect("/transporte/veiculo/index");
    }
  }

  public function excluirLocalAction(){
    $tvl_codigo = $this->_request->getParam('id');
   if($tvl_codigo){
       try{
           (new Application_Model_TransporteViagemLocais())->excluir($tvl_codigo);
           $this->view->dados = array("success"=>true);
       } catch (Exception $e){
           $this->view->dados = array("success"=>false, "mensagem"=>$e->getMessage());
       }
       return $this->render("dados",NULL,TRUE);
   }
  }
}
?>
