<?php
require_once COMUM_PATH . "/reportApi/GeradorRelatorio.php";
class Transporte_ViagemUsuarioController extends Zend_Controller_Action
{

    public function init()
    {
        $this->view->title = "Agendamento de Paciente";
    }

    public function indexAction()
    {
        $via_data = $this->_getParam("via_data", FALSE);
        $cid_codigo_origem = $this->_getParam("cid_codigo", FALSE);
        $cid_codigo_destino = $this->_getParam("cid_codigo2", FALSE);
        $vei_codigo = $this->_getParam("vei_codigo", FALSE);

        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/transporte/viagem-usuario/novo.js');
        $tbVia = new Application_Model_ViagemUsuario();
        $this->view->itens = $tbVia->pesquisar($via_data, $cid_codigo_origem, $cid_codigo_destino, $vei_codigo, 15);

        $tbVei = new Application_Model_Veiculo();
        $this->view->veiculo = $tbVei->getVeiculos();
    }

    public function novoAction()
    {
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/maps.google.js');
        $via_codigo = $this->_getParam("cod", FALSE);
        $this->view->disponivel = $this->_getParam("disponivel", FALSE);

        $tbVia = new Application_Model_Viagem();
        $this->view->dados = $tbVia->getViagem($via_codigo);

        $tbVu = new Application_Model_ViagemUsuario();
        $this->view->itens = $tbVu->getViagemUsuario($via_codigo);

        $tbLoc = new Application_Model_TransporteViagemLocais();
        $this->view->locais_embarque = $tbLoc->getLocaisEmbarque($via_codigo);
        $this->view->locais_desembarque = $tbLoc->getLocaisDesembarque($via_codigo);
        $this->view->locais = (new Application_Model_TransporteLocais())->getLocais();
        $this->render("form");
    }

    public function editarAction()
    {
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/transporte/viagem-usuario/novo.js');
        $viausu_codigo = $this->_getParam("id", FALSE);

        if (!$viausu_codigo)
            return $this->_redirect("/transporte/viagem-usuario");

        $tbViaUsu = new Application_Model_ViagemUsuario();

        $this->view->dadosViagem = $tbViaUsu->getViagemPorUsuario($viausu_codigo);
        $tbVia = new Application_Model_Viagem();
        $via_codigo = $this->view->dadosViagem->via_codigo;
        $this->view->dados = $tbVia->getViagem($via_codigo);
        $cota = (new Application_Model_Veiculo())->verificaCota($via_codigo);
        $this->view->disponivel = $cota->vei_capacidade - $cota->pacientes - $cota->acompanhantes;

        $this->view->acompanhantes = $tbViaUsu->getDadosAcompanhantesDaViagem($viausu_codigo);

        $tbLoc = new Application_Model_TransporteViagemLocais();
        $this->view->locais_embarque = $tbLoc->getLocaisEmbarque($via_codigo);
        $this->view->locais_desembarque = $tbLoc->getLocaisDesembarque($via_codigo);
        $this->view->locais = (new Application_Model_TransporteLocais())->getLocais();

        return $this->render("form");
    }

    public function salvarAction()
    {
        $tbViaU = new Application_Model_ViagemUsuario();
        $this->_helper->layout->disableLayout();

        //dados para salvar o paciente da viagem
        $dados = array("viausu_codigo" => $this->_getParam("viausu_codigo", FALSE),
            "via_codigo" => $this->_getParam("via_codigo", FALSE),
            "usu_codigo" => $this->_getParam("usu_codigo", FALSE),
            "viausu_alimentacao" => $this->_getParam("viausu_alimentacao", FALSE),
            "viausu_pernoite" => $this->_getParam("viausu_pernoite", FALSE),
            "viausu_despesas" => $this->_getParam("viausu_despesas", FALSE),
            "cid_codigo_origem" => $this->_getParam("cid_codigo", FALSE),
            "cid_codigo_destino" => $this->_getParam("cid_codigo_2", FALSE),
            "viausu_km" => $this->_getParam("viausu_km", FALSE),
            "usr_codigo_cadastro" => $this->_getParam("usr_codigo_cadastro", FALSE),
            "viausu_observacao" => $this->_getParam("viausu_observacao", FALSE),
            "loc_codigo_embarque" => $this->_getParam("loc_codigo_emb", FALSE),
            "loc_codigo_desembarque" => $this->_getParam("loc_codigo_desemb", FALSE),
            "loc_codigo_atendimento" => $this->_getParam("loc_codigo_atend", FALSE),
            "hora_atendimento" => $this->_getParam("hora_atendimento", FALSE),

        );

        $viausu_codigo = $tbViaU->salvar($dados);

        $tbProc = new Application_Model_ViagemProcedimentoUsuario();
        //dados dos procedimentos do paciente da viagem
        $dadosProc = array("via_codigo" => $this->_getParam("via_codigo", FALSE),
            "viausu_alimentacao" => $this->_getParam("viausu_alimentacao", FALSE),
            "viausu_pernoite" => $this->_getParam("viausu_pernoite", FALSE),
            "viausu_km" => $this->_getParam("viausu_km", FALSE),
            "viausu_codigo" => $viausu_codigo);
        //verifica qual procedimento de pernoite e alimentacao vai gerar para o paciente
        if ($dadosProc["viausu_alimentacao"] == 'TRUE') {
            $dadosProcResul = $tbProc->VerificaPerNoiteAlimentacao($dadosProc);
            $tbProc->salvar($dadosProcResul);
        }
        $tbVia = new Application_Model_Viagem();

        $tipo = $tbVia->getViagem($this->_getParam("via_codigo", FALSE))->vei_tipo_veiculo;

        $distancia = $tbProc->converteEmKm($this->_getParam("viausu_km", FALSE), $tipo);

        $procDistancia = array("tipo" => $tipo, "viausu_codigo" => $viausu_codigo);
        //verifica qual procedimento irá gerar
        $dadosDistanciaResul = $tbProc->VerificaQuaisProcedimentosIraGerarDeDistancia($procDistancia);
        $quantidadeDeInsert = $tbProc->divideProcedimentosPorDistancia($distancia, $tipo);
        for ($index = 0; $index < $quantidadeDeInsert; $index++) {
            $tbProc->salvar($dadosDistanciaResul);
        }

        //ACOMPANHANTE
        $tbAcom = new Application_Model_UsuarioAcompanhante();
        //dados de quais acompanhantes tem o paciente
        $dadosAcom = $this->_request->getPost("acomp", FALSE);

        foreach ($dadosAcom as $item) {

            $insertDados = array("usu_codigo" => $item['usu_codigo'], "viausu_codigo" => $viausu_codigo);
            if ($item['acom_codigo']) {
                $insertDados['acom_codigo'] = $item['acom_codigo'];
            }
            $tbAcom->salvar($insertDados);

            if ($dadosProc["viausu_alimentacao"] == 'TRUE') {
                //verifica qual procedimento vai gerar para o acompanhante do paciente
                $dadosProcResulAcom = $tbProc->VerificaPerNoiteAlimentacao($dadosProc, "s");
                $tbProc->salvar($dadosProcResulAcom);
            }
            $dadosDistanciaResul = $tbProc->VerificaQuaisProcedimentosIraGerarDeDistancia($procDistancia, "S");
            for ($i = 0; $i < $quantidadeDeInsert; $i++) {
                $tbProc->salvar($dadosDistanciaResul);
            }
        }

    }

    public function excluirAction()
    {
        $id = $this->_getParam("id", false);
        $via_codigo = $this->_getParam("via_codigo", false);

        $tbAcom = new Application_Model_UsuarioAcompanhante();
        $tbAcom->excluirByViausuCodigo($id);

        $tbProcU = new Application_Model_ViagemProcedimentoUsuario();
        $tbProcU->excluir($id);

        $tbViaU = new Application_Model_ViagemUsuario();
        $tbViaU->excluir($id);

        $this->_redirect("transporte/viagem-usuario/novo/cod/$via_codigo");
    }

    public function relViagemAction()
    {
        Zend_Layout::getMvcInstance()->setLayout("relatorio");
        $this->view->headLink()->appendStylesheet($this->view->baseUrl() . '/public/css/relatorio.css', 'all');

        $id = $this->_getParam("cod", false);

        $this->view->title = "Relatorio De Viagem";

        $tbVia = new Application_Model_Viagem();
        $this->view->dados = $tbVia->getViagem($id);

        $tbViaU = new Application_Model_ViagemUsuario();
        $this->view->dadosP = $tbViaU->getBalancoViagem($id)->toArray();
    }

    public function listaAction()
    {
        Zend_Layout::getMvcInstance()->setLayout("relatorio");
        $this->view->headLink()->appendStylesheet($this->view->baseUrl() . '/public/css/relatorio.css', 'all');
        $id = $this->_getParam("cod", false);
        $this->view->title = "Lista De Viagem";

        $tbVia = new Application_Model_Viagem();
        $this->view->dados = $tbVia->getViagem($id);
        $this->view->params = serialize(array("dados" => $this->view->dados->usr_nome . "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>Hora:</strong>" . $this->view->dados->via_hora));

        $tbViaU = new Application_Model_ViagemUsuario();
        $dadosP = $tbViaU->getDadosFullDaViagem($id)->toArray();
        $i = 0;
        foreach ($dadosP as $item) {
            $dadosP[$i]["usu_acomp"] = $tbViaU->getDadosAcompanhantesDaViagem($dadosP[$i]["viausu_codigo"])->toArray();
            $i++;
        }
        $this->view->dadosP = $dadosP;
    }

    public function pesquisaAction()
    {
        if ($this->_request->isPost()) {
            $this->view->busca = $this->_request->getPost("busca");
            $this->view->itens = $this->tbvei->pesquisar($this->view->busca);
            $this->render("index");
        } else {
            $this->_redirect("/transporte/veiculo/index");
        }
    }

    public function getCodigoProcedimentoTfdAction()
    {
        $this->_helper->layout->disableLayout();

        $tbProc = new Application_Model_Procedimento();
        $proc_codigo_sus = $this->_getParam("proc_codigo_sus");

        $this->view->dados = $tbProc->getProcedimentoPeloCodigoSus($proc_codigo_sus)->toArray();

        $this->render("dados");
    }

    public function excluirAcompanhanteAction()
    {
        $acom_codigo = $this->_request->getParam('cod');
        if ($acom_codigo) {
            try {
                (new Application_Model_UsuarioAcompanhante())->excluir($acom_codigo);
                $this->view->dados = array("success" => true);
            } catch (Exception $e) {
                $this->view->dados = array("success" => false, "mensagem" => $e->getMessage());
            }
            return $this->render("dados", NULL, TRUE);
        }
    }

    public function gerarListaViagemAction(){
        $via_codigo = $this->_getParam("via_codigo", NULL);
        $gerador = new GeradorRelatorio();
        $this->view->dados = $gerador->gerar("SAUDE", "listaViagem", [
            "viaCodigo" => $via_codigo
        ]);
        $this->render("dados", NULL, TRUE);
    }
}

?>
