<?php

require_once __DIR__ . '/../../Util.php';

class Usuarios_UsuariosController extends Zend_Controller_Action {

  public function init() {
    $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/usuarios/form.js');
    $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/jquery.pstrength-min.1.2.js');
    $this->view->headLink()->appendStylesheet($this->view->baseUrl() . '/public/css/usuarios/form.css', 'all');
    parent::init();
    $tbCon = new Application_Model_Conselho();
    $this->view->conselho = $tbCon->fetchAll();
    $tbEst = new Application_Model_Estado();
    $this->view->uf = $tbEst->getEstados();
    $tbUsr = new Application_Model_Usuarios();

    $isMestre = $tbUsr->checaUsuarioMestre($tbUsr->getUsrAtual()->usr_codigo);

    $this->view->isMestre = $isMestre[0][usr_mestre];
  }

  public function indexAction() {
    $tbUsr = new Application_Model_Usuarios();

    $tbConf = new Application_Model_Configuracao();
    $this->view->itens = $tbUsr->getUsuariosBuscaForm();

    $this->view->id_login = $tbUsr->getUsrAtual()->usr_codigo;
    $this->view->conf_valor = $tbConf->getDadosConfigPelaChave("MODULO_USUARIOS")->conf_valor_bool;
    $this->view->title = "Módulo Usuários";
  }

  public function novoAction() {

    $this->_helper->layout->setLayout("simples");
    $this->render("form");
  }

  public function formAction() {

  }

  public function salvarAction() {
    $tbUsr = new Application_Model_Usuarios();
    $tbUnu = new Application_Model_UnidadeUsuarios();
    $tbEst = new Application_Model_Estado();
    $this->_helper->layout->disableLayout();

    $dados_usr = array("usr_nome" => mb_strtoupper($this->_getParam("usr_nome", FALSE), "UTF-8"),
      "usr_tipo_medico" => $this->_getParam("usr_tipo_medico", FALSE),
      "con_codigo" => ($this->_getParam("con_codigo", FALSE) ? $this->_getParam("con_codigo", FALSE) : NULL),
      "usr_num_conselho" => $this->_getParam("usr_num_conselho", FALSE),
      "cnes_sigla_est" => ($this->_getParam("con_codigo", FALSE) ? $tbEst->getSiglaPorCodigo($this->_getParam("cnes_sigla_uf", FALSE))->uf_sigla : NULL),
      "usr_login" => $this->_getParam("usr_login", FALSE),
      "usr_email" => $this->_getParam("usr_email", FALSE),
      "usr_modulos" => $this->_getParam("usr_modulos", FALSE),
      "usr_ativo" => $this->_getParam("usr_ativo", FALSE),
      "usr_troca_senha" => $this->_getParam("usr_troca_senha", FALSE),
      "cnes_cod_cns" => $this->_getParam("cnes_cod_cns", FALSE),
      "usr_cpf" => preg_replace('#[^0-9]#', '', $this->_getParam("usr_cpf", FALSE)),
      "usr_restringe_atendimento_simplificado" => $this->_getParam("usr_restringe_atendimento_simplificado", FALSE),
      "usr_digitador" => $this->_getParam("usr_digitador", FALSE),
      "usr_acesso_unidades" => $this->_getParam("usr_acesso_unidades", FALSE),
    );

    if ($this->_request->getPost("usr_codigo", NULL)) {
      $dados_usr[usr_codigo] = $this->_request->getPost("usr_codigo", NULL);
    }

    if ($this->_request->getPost("usr_senha") != NULL) {
      $dados_usr[usr_senha] = md5($this->_getParam("usr_senha", FALSE));
    }
    if (!$dados_usr[usr_codigo] && !$dados_usr[usr_senha]) {
      $dados_usr[usr_senha] = md5(123);
    }
    try {
      $usr_codigo = $tbUsr->salvar($dados_usr);
    } catch (Exception $e) {
      echo $e->getMessage();
    }

    if ((new Application_Model_Configuracao())->getConfig('ENVIO_MENSAGENS_AUTOMATICAS')) {
      $dados_usr_agentic = $tbUsr->getDadosMedicoPorId($usr_codigo);

      $dados_usr_agentic["access_token"] = $_SESSION['access_token'];
      $dados_usr["usr_codigo_agentic"] = Util::sendRequestAgentic($dados_usr_agentic, 'medico', '/medicos/cadastrar');
      $usr_codigo = $tbUsr->salvar($dados_usr);
    }


    $array_codigo = array();
    if ($this->_getParam("todas_unidades", FALSE) == "T") {
      $tbUni = new Application_Model_Unidade();
      $array_codigo = $tbUni->getCodUnidade()->toArray();

      $this->removeUnidadesDoUsuario($usr_codigo, $array_unidades);
    } else {
      $array_codigo = $this->_getParam("uni_codigo", FALSE);
    }
    if ($usr_codigo) {
      if (!empty($array_codigo)) {
        if (count($array_codigo) > 1) {
          foreach ($array_codigo as $uni_codigo) {
            $tbUnu->salvar(array("usr_codigo" => $usr_codigo,
              "uni_codigo" => ($uni_codigo[uni_codigo] ? $uni_codigo[uni_codigo] : $uni_codigo)));
          }
        } else {
          $tbUnu->salvar(array("usr_codigo" => $usr_codigo,
            "uni_codigo" => ($array_codigo[0] ? $array_codigo[0] : "NULL")));
        }
      }

      $esp_codigo = $this->_request->getPost("esp_codigo_u", NULL);
      if (!empty($esp_codigo)) {
        $tbMesp = new Application_Model_MedicoEspecialidade();
        foreach ($esp_codigo as $esp_codigo) {
          $tbMesp->salvar(array("esp_codigo" => $esp_codigo,
            "med_codigo" => $usr_codigo,
            "mes_ativo" => "A",
            "mes_data" => date('d-m-Y'),
            "uni_codigo" => $this->_request->getPost("uni_codigo_$esp_codigo", NULL)));
        }
      }
      $set_codigo = $this->_request->getPost("set_codigo", NULL);
      if (!empty($set_codigo)) {
        $tbUset = new Application_Model_UsuariosSetores();
        foreach ($set_codigo as $set_codigo) {
          $tbUset->salvar(array("set_codigo" => $set_codigo,
            "usr_codigo" => $usr_codigo));
        }
      }
    }
    $this->_redirect("usuarios/usuarios/");
  }

  public function removeUnidadesDoUsuario($usr_codigo = FALSE) {
    $tbUnu = new Application_Model_UnidadeUsuarios();
    $tbUnu->excluirTodos($usr_codigo);
    return true;
  }

  public function pesquisaAction() {
    $this->view->title = "Módulo Usuários";
    if ($this->_request->isPost()) {
      $tbUsr = new Application_Model_Usuarios();
      $tbConf = new Application_Model_Configuracao();
      $this->view->busca = $this->_request->getPost("busca");
      $this->view->itens = $tbUsr->getUsuariosBuscaForm($this->view->busca);
      $this->view->conf_valor = $tbConf->getDadosConfigPelaChave("MODULO_USUARIOS")->conf_valor_bool;
      $this->render("index");
    } else {
      $this->_redirect("/usuarios/usuarios/index");
    }
  }

  public function editarAction() {
    $this->_helper->layout->setLayout("simples");
    $usr_codigo = $this->_getParam("id");
    $tbUsr = new Application_Model_Usuarios();
    $tbUnu = new Application_Model_UnidadeUsuarios();
    $tbMes = new Application_Model_MedicoEspecialidade();
    $tbUset = new Application_Model_UsuariosSetores();
    $this->view->dados = $tbUsr->getInfoUsr($usr_codigo);
    //echo"<pre>".  print_r($this->view->dados,1);
    $this->view->unidades = $tbUnu->getUnidadeUsuarios($this->view->dados->usr_codigo, 1);
    $this->view->especialidades = $tbMes->getEspecialidadePorMedico($this->view->dados->usr_codigo);
    $this->view->setores = $tbUset->getSetoresPorUsuarios($this->view->dados->usr_codigo);
    return $this->render("form");
  }

  public function inativarAction() {
    $id = (int)$this->_getParam("id", 0);
    $tbUsr = new Application_Model_Usuarios();
    $dados = array("usr_codigo" => $id, "usr_ativo" => "N");
    $tbUsr->salvar($dados);
    return $this->_redirect("/usuarios/usuarios");
  }

  public function excluirUnidadeAction() {
    $this->_helper->layout->disableLayout();
    $id = $this->_getParam("id", false);
    $tbUnu = new Application_Model_UnidadeUsuarios();
    $tbUnu->excluir($id);
    $this->render("dados");
  }

  public function excluirEspecialidadeAction() {
    $this->_helper->layout->disableLayout();
    $id = $this->_getParam("id", false);
    $tbMes = new Application_Model_MedicoEspecialidade();
    $tbMes->excluir($id);
    $this->render("dados");
  }

  public function excluirSetoresAction() {
    $this->_helper->layout->disableLayout();
    $id = $this->_getParam("id", false);
    $tbUset = new Application_Model_UsuariosSetores();
    $tbUset->excluir($id);
    $this->render("dados");
  }

  public function jqgridAction() {

    $page = $this->_getParam("page", 1);
    $limit = $this->_getParam("rows");
    $sidx = $this->_getParam("sidx", "id");
    $sord = $this->_getParam("sord", "ASC");

    $tbUsr = new Application_Model_Usuarios();
    $tbUsr->setFields(array("usr_codigo", "usr_nome"));
    $this->view->dados = $tbUsr->getGridResource($page, $limit, $sidx, $sord);
    //echo "<pre>".print_r( $this->view->dados,1);die();

    return $this->render("dados", NULL, TRUE);
  }

  public function verificaLoginAction() {
    $usr_login = $this->_getParam("login", false);
    $usr_senha = $this->_getParam("senha", false);

    $usr_senha = md5($usr_senha);

//        print_r($usr_senha);die();

    $tbUsr = new Application_Model_Usuarios();

    $sucesso = $tbUsr->verificaLogin($usr_login, $usr_senha);

    if ($sucesso) {
      $this->view->dados = array("success" => true);
    } else {
      $this->view->dados = array("success" => false);
    }
    return $this->render("dados", NULL, TRUE);

  }
}

?>
