<?php

class Elotech_View_Helper_Idade extends Zend_View_Helper_Abstract {

	/**
	 * Converte uma data (aaaa-mm-dd) em um valor relativo a idade
	 * @example idade('1989-06-04'); // 22 anos
	 * @example idade('2012-01-01'); // 1 mês e 10 dias
	 * @param string $dataNasc Data de nascimento no formato Y-m-d
	 * @return string 
	 */
//    function idade($dataNasc=FALSE,$especificacao=FALSE) {
//		if(!$dataNasc)
//			return "";
//		
//		list($a,$m,$d) = explode("-",$dataNasc);
//		$mk = mktime(0, 0, 0, $m, $d, $a); // segundos	
//		if($mk > time()){
//			//trigger_error("A data de nascimento informada é maior que a data atual", E_USER_NOTICE);
//			return "";
//		}
//		
//		$anos = floor((time() - $mk)  / 31536000 );
//		$meses = floor((time() - $mk)  / 2592000 );
//		$meses = $meses%12;
//		$dias = floor((time() - $mk)  / 86400 );
//		$dias = $dias%30;
//                
//		
//                if($especificacao == FALSE){
//                    $out = array();
//                    if($anos)
//                            $out []= "$anos ano".($anos>1?"s":"");
//
//                    if($meses && $anos < 3)
//                            $out []= "$meses ".($meses>1?"meses":"mês");
//
//                    if(!$anos && $meses < 3)
//                            $out []= "$dias dia".($dias>1?"s":"");
//
//                    return implode(" e ",$out);
//                }else{
//                    return $anos;
//                }
//    }
    function idade($dob=FALSE,$especificacao=FALSE, $datacontrole = FALSE) {
    
        $data = explode('-', $dob);
        if($datacontrole){
            $current_time = time($datacontrole);
        } else{
            $current_time = time();
        }


        $age_years = date('Y',$current_time) - $data[0];
        $age_months = date('m',$current_time) - $data[1];
        $age_days = date('d',$current_time) - $data[2];

        if ($age_days<0) {
            $days_in_month = date('t',$current_time);
            $age_months--;
            $age_days= $days_in_month+$age_days;
        }

        if ($age_months<0) {
            $age_years--;
            $age_months = 12+$age_months;
        }

        if($especificacao == FALSE){
            if($age_years >= 5){
                return $age_years.' anos';
            }
            if(($age_years >= 1 && $age_years < 5)|| $datacontrole != false){
                return $age_years.' anos '.$age_months.' meses ';
            }
            if($age_years < 1){
                return $age_months.' meses '.$age_days.' dias';
            }
        }else{
            return $age_years;
        }
    }
}