/* -----------------------------------------------------------------
 * MÉTODOS CONVÊNIOS ITENS AGENDAMENTO ESTABELECIMENTOS DE SAUDE
 * ----------------------------------------------------------------- */

// Função responsável por abrir e fechar a Inclusão de Horários
function abreFechaInclusaoDeHorarios() {
    $("#inclusao-horarios-det").toggle("slow");
}

function selecionaTodosOptions() {
    $.map($('#orientacoes-selecionadas option'), function (option) {
        $(option).attr('selected', 'selected');
    });
}

function populaComboDiasDaSemana(id, nomeDia) {
    $("#inclusao-horarios").show();
    $("#inclusao-horarios-det").show();
    if ($("#" + id + "").is(":checked") == true) {
        $("#dia" + id + "").val("" + id + "");
        $("#combo-dias").append("<option value='" + id + "'>" + nomeDia + "</option>");
        $("#dias").append("<a type='button' class='btn-dias' id='btn_" + id + "'>" + nomeDia + "</a>");
    } else {
        limparAdicionarTurno();
        $("#dia" + id + "").val("");
        $("#combo-dias option[value='" + id + "']").remove();
        $("#btn_" + id).remove();
        validaComboDiasDaSemana();
    }
}

function validaComboDiasDaSemana() {
    if ($("#combo-dias option").length == 0) {
        $("#inclusao-horarios").hide();
        $("#inclusao-horarios-det").hide();
    }
}

function validaCampos(id) {
    var retorno = false;
    var cb_dias = $("#combo-dias option").length;
    if (cb_dias > 0 &&
        $("#hr_inicio_" + id).val() != "" && $("#hr_fim_" + id).val() != "" &&
        $("#coni_cota_dia_" + id).val() != "" && $("#coni_intervalo_" + id).val() != "") {
        retorno = true;
    }
    return retorno;
}

function removeHorario(id) {
    confirme("Confirme:", "Deseja remover o horário preenchido?", 300, 150, function () {
        $("#tb_hor_" + id).remove();
        $("#" + id + "").attr("disabled", false);
        $("#" + id + "").attr("checked", false);
    });
}

function limpaHorarios() {
    confirme("Confirme:", "Deseja remover todos os horários desse profissional?", 300, 150, function () {
        limparInclusao();
        $("#form-agendamento-profissionais input").each(function () {
            var id = $(this).val();
            $("#" + id + "").attr("checked", false);
            $("#" + id + "").attr("disabled", false);
        });
        $("#visualizacao").empty();
    });
}

function limparAdicionarTurno() {
    $("#cad-turnos").html(
        "<section id='cad-turnos_1' style='border: 1px solid #70a8d2; padding: 5px; width: 50%; margin: 5px 150px'>"
        + "	<header style='display: flex; width: 100%'>"
        + "     <input id='turno' value='1' hidden/>"
        + "		<strong style='color: #70a8d2'>Turno</strong>"
        + "     <img src='" + baseUrl + "/public/images/icons/excluir3.png' style='cursor:pointer;' onclick='removeTurno(1)' >"
        + "	</header>"
        + " <hr style='background-color: #70a8d2; color: #70a8d2'>"
        + "	<div>"
        + "		<label for=''>Hora Inicial: </label>"
        + "		<input type='text'"
        + "		id='hr_inicio_1'"
        + "		style='width:58px;' class='ini qtd-hor ui-state-default focus' maxlength='5' rel='99:99'/>"
        + "		<label for=''>Hora Final: </label>"
        + "		<input type='text'"
        + "		id='hr_fim_1'"
        + "		style='width:58px;' class='fim ui-state-default focus' rel='99:99' />"
        + "	</div>"
        + "	<div>"
        + "		<label for=''>Qtde. Vagas: </label>"
        + "		<input type='hidden'/>"
        + "		<input type='text'"
        + "		    id='coni_cota_dia_1'"
        + "		    style='width:58px;' onchange='chamaCalculo(1)' class='ui-state-default'/>"
        + "		<label style='width:150px; margin-right: 10px;'>Tem encaixe?</label>"
        + "		<input type='checkbox' value='S'"
        + "		id='encaixe_1'"
        + "		onchange='mostraEncaixe(1)'><br/>"
        + "		<div id='checkbox_div_1' style='display:none;'>"
        + "			<label>Qtde. Encaixes:</label>"
        + "			<input type='text' class='ui-state-default valid'"
        + "			id='coni_encaixe_1'"
        + "			style='width:50px;' value='0' onChange='calculaComEncaixe(1)'/>"
        + "		</div>"
        + "		<label>Tempo de Atend. <small>(min)</small></label>"
        + "		<input type='text' id='coni_intervalo_1' style='width:25px;' class='ui-state-default'/>"
        + "	</div>"
        + "</section>"
    );
    $(".ini").mask('99:99');
    $(".fim").mask('99:99');
    $('#dias').empty();
    $('#combo-dias').empty();
    abreFechaInclusaoDeHorarios();
}

function limparInclusao() {
    confirme("Confirme:", "Deseja limpar as informações do(s) dia(s) informado(s)?", 300, 150, function () {
        $("#cad-turnos input").each(function (index, element) {
            $(this).val("");
            $(this).attr("checked", false);
        });
        $("#combo-dias option").each(function () {
            var id = $(this).val();
            $("#" + id + "").attr("checked", false);
        });
        $('#dias').empty();
        $('#combo-dias').empty();
        abreFechaInclusaoDeHorarios();
    });
}

function adicionaHorariosDiaDaSemana() {
    var turnos = $('#cad-turnos section');
    var dt_inicio = $('#data_inicio').val();
    var dt_final = $('#data_termino').val();
    var arrErr = [];
    for (var i = 1; i <= turnos.length; i++) {
        if (!validaCampos(i)) {
            arrErr.push(i);
        }
    }
    if (arrErr.length > 0) {
        mensagem("Erro",
            "Campos obrigatórios " + (arrErr.length > 1 ? "nos turnos " : "no turno ") + arrErr.toString() + " não preenchidos");
    } else {
        $('#combo-dias option').each(function (index, element) {
            var id_dia = $(this).val();
            $("#tb_hor_" + id_dia).remove();
            var template = "<table id='tb_hor_" + id_dia + "' name='tb_encaixe' style='width: 100%'>"
                + "    <thead>"
                + "        <tr>"
                + "            <th colspan='5' style='font-size: 13px;' class='ui-state-default'><b>" + element.text + "</b></th>"
                + "            <th hidden><input type='text' name='coni_data_inicio' value='" + dt_inicio + "'></th>"
                + "            <th hidden><input type='text' name='coni_data_termino' value='" + dt_final + "'></th>"
                + "            <th hidden><input type='text' name='dias-semana[" + element.value + "]'></th>"
                + "            <th style='font-size: 13px;' class='ui-state-default'>"
                + "                  <img src='" + baseUrl + "/public/images/icons/excluir3.png' style='cursor:pointer;' onclick='removeHorario(" + id_dia + ")' >"
                + "            </th>"
                + "        </tr>"
                + "        <tr class='ui-widget-header'>"
                + "            <th >Hora Inicial</th>"
                + "            <th >Hora Final</th>"
                + "            <th >Qtde. Vagas</th>"
                + "            <th >Encaixe?</th>"
                + "            <th >Qtde. Encaixe</th>"
                + "            <th >Tempo Atend. Aprox.</th>"
                + "        </tr>"
                + "    </thead>"
                + "    <tbody>";
            turnos.each(function (index, item) {
                var id = item.id.charAt(item.id.length - 1);
                var hr_i = $('#hr_inicio_' + id).val();
                var hr_f = $('#hr_fim_' + id).val();
                var qtd_v = $('#coni_cota_dia_' + id).val();
                var encx = $('#encaixe_' + id).is(':checked') ? 'Sim' : 'Não';
                var val_encx = $('#encaixe_' + id).is(':checked') ? 1 : 0;
                var qtd_e = $('#coni_encaixe_' + id).val();
                var temp_at = $('#coni_intervalo_' + id).val();
                temp_at = (temp_at != "" ? parseFloat(temp_at).toFixed(2) : "");

                template += "<tr class='ui-widget-content'>"
                    + "     <td class='ui-state-default' align='center' width='10%'>"
                    + "           <input type='hidden' name='dias-semana[" + element.value + "][hora_inicial][]' value='" + hr_i + "'>" + hr_i
                    + "     </td>"
                    + "     <td class='ui-state-default' align='center' width='10%' >"
                    + "           <input type='hidden' name='dias-semana[" + element.value + "][hora_final][]' value='" + hr_f + "'>" + hr_f
                    + "     </td>"
                    + "     <td class='ui-state-default' align='center' width='10%' >"
                    + "           <input type='hidden' name='dias-semana[" + element.value + "][conh_cota_dia][]' value='" + qtd_v + "'>" + qtd_v
                    + "     </td>"
                    + "     <td hidden><input type='hidden' name='dias-semana[" + element.value + "][encaixe][]' value='" + val_encx + "'>" + val_encx + "</td>"
                    + "     <td class='ui-state-default' align='center' width='10%'>" + encx + "</td>"
                    + "     <td class='ui-state-default' align='center' width='10%'>"
                    + "           <input type='hidden' name='dias-semana[" + element.value + "][conh_encaixe][]' value='" + qtd_e + "'>" + qtd_e
                    + "     </td>"
                    + "     <td hidden><input type='hidden' name='dias-semana[" + element.value + "][conh_intervalo][]' value='" + temp_at + "'>" + temp_at + "</td>"
                    + "     <td class='ui-state-default' align='center' width='10%'>" + temp_at + " min</td>"
                    + "</tr>";
            });
            var semana = 7;
            var inseriu = false;
            template += "</tbody></table>";
            for(var i = id_dia;i <= semana; i++){
                var diaAnt = i - 1;
                var diaPos = parseInt(i) + 1;
                if($("#tb_hor_" + diaAnt + "").length){
            $("#tb_hor_" + diaAnt + "").after(template);
                    i=8;
                    inseriu =true;
                } else if ($("#tb_hor_" + diaPos + "").length) {
                    $("#tb_hor_" + diaPos + "").before(template);
                    i=8;
                    inseriu = true;
                }
            }
            if(!inseriu){
                $('#visualizacao').append(template);
            }
        });
        limparAdicionarTurno();
    }
}

var id_turno = 1;

function adicionaNovoTurno() {
    id_turno += 1;
    var tpl = "<section id='cad-turnos_" + id_turno + "' style='border: 1px solid #70a8d2; padding: 5px; width: 50%; margin: 5px 150px'>"
        + "	<header style='display: flex; width: 100%'>"
        + "     <input id='turno' value='" + id_turno + "' hidden/>"
        + "		<strong style='color: #70a8d2'>Turno</strong>"
        + "     <img src='" + baseUrl + "/public/images/icons/excluir3.png' style='cursor:pointer;' onclick='removeTurno(" + id_turno + ")' >"
        + "	</header>"
        + " <hr style='background-color: #70a8d2; color: #70a8d2'>"
        + "	<div>"
        + "		<label for=''>Hora Inicial: </label>"
        + "		<input type='text'"
        + "		id='hr_inicio_" + id_turno + "'"
        + "		style='width:58px;' class='ini qtd-hor ui-state-default focus' maxlength='5' rel='99:99'/>"
        + "		<label for=''>Hora Final: </label>"
        + "		<input type='text'"
        + "		id='hr_fim_" + id_turno + "'"
        + "		style='width:58px;' class='fim ui-state-default focus' rel='99:99' />"
        + "	</div>"
        + "	<div>"
        + "		<label for=''>Qtde. Vagas: </label>"
        + "		<input type='hidden'/>"
        + "		<input type='text'"
        + "		    id='coni_cota_dia_" + id_turno + "'"
        + "		    style='width:58px;' onchange='chamaCalculo(" + id_turno + ")' class='ui-state-default'/>"
        + "		<label style='width:150px; margin-right: 10px;'>Tem encaixe?</label>"
        + "		<input type='checkbox' value='S'"
        + "		id='encaixe_" + id_turno + "'"
        + "		onchange='mostraEncaixe(" + id_turno + ")'><br/>"
        + "		<div id='checkbox_div_" + id_turno + "' style='display:none;'>"
        + "			<label>Qtde. Encaixes:</label>"
        + "			<input type='text' class='ui-state-default valid'"
        + "			id='coni_encaixe_" + id_turno + "'"
        + "			style='width:50px;' value='0' onChange='calculaComEncaixe(" + id_turno + ")'/>"
        + "		</div>"
        + "		<label>Tempo de Atend. <small>(min)</small></label>"
        + "		<input type='text' id='coni_intervalo_" + id_turno + "' style='width:25px;' class='ui-state-default'/>"
        + "	</div>"
        + "</section>";
    $('#cad-turnos').append(tpl);
    $(".ini").mask('99:99');
    $(".fim").mask('99:99');
}

function removeTurno(id) {
    confirme("Confirme:", "Deseja remover esse turno ?", 300, 150, function () {
        $('#cad-turnos_' + id).remove();
    });
}

function retornaDiaSemana(id) {
    switch (id) {
        case(1):
            return "Segunda-Feira";
        case(2):
            return "Terça-Feira";
        case(3):
            return "Quarta-Feira";
        case(4):
            return "Quinta-Feira";
        case(5):
            return "Sexta-Feira";
        case(6):
            return "Sábado";
        case(7):
            return "Domingo";
    }
    ;
}

function configuraEdicaoDiasDaSemana() {
    if ($("#coni_codigo").val() != "") {
        for (var i = 1; i <= 7; i++) {
            if ($("#" + i + "").is(":checked") == true) {
                $("#" + i + "-dia-semana").show();
                $("#" + i + "").attr("disabled", "disabled");
                $("#dia" + i + "").val("" + i + "");
            }
        }
    }
}

function carregaHorarios(coni_codigo) {
    var array_dias = [];
    if (coni_codigo) {
        $.ajax({
            url: baseUrl + '/agenda/convenio-itens/carrega-convenio-horarios',
            type: "POST",
            data: {
                coni_codigo: coni_codigo
            },
            success: function (json) {
                var template = "";
                // console.log(JSON.stringify(json));
                if (json.length > 0) {
                    var array_dias = [];
                    var controle_dia = 0;
                    $.each(json, function (key, value) {
                        var dt_inicio = $('#data_inicio').val();
                        var dt_final = $('#data_termino').val();
                        var id_dia = value.condi_age_dia;
                        var hr_i = value.hora_inicial;
                        var hr_inicial = hr_i.substring(0, 5);
                        var hr_f = value.hora_final;
                        var hr_final = hr_f.substring(0, 5);
                        var qtd_v = value.conh_cota_dia;
                        var encx = value.conh_encaixe != 0 ? 'Sim' : 'Não';
                        var val_encx = value.conh_encaixe != 0 ? 1 : 0;
                        var qtd_e = value.conh_encaixe;
                        var temp_at = value.conh_intervalo;
                        if (id_dia !== controle_dia) {
                            if (controle_dia !== id_dia && controle_dia !== 0) {
                                template += "</tbody></table>";
                            }
                            template += "<table id='tb_hor_" + id_dia + "' name='tb_encaixe' style='width: 100%'>"
                                + "    <thead>"
                                + "        <tr>"
                                + "            <th colspan='5' style='font-size: 13px;' class='ui-state-default'><b>" + retornaDiaSemana(id_dia) + "</b></th>"
                                + "            <th hidden><input type='text' name='coni_data_inicio' value='" + dt_inicio + "'></th>"
                                + "            <th hidden><input type='text' name='coni_data_termino' value='" + dt_final + "'></th>"
                                + "            <th hidden><input type='text' name='dias-semana[" + id_dia + "]'></th>"
                                + "            <th style='font-size: 13px;' class='ui-state-default'>"
                                + "                  <img src='" + baseUrl + "/public/images/icons/excluir3.png' style='cursor:pointer;' onclick='removeHorario(" + id_dia + ")' >"
                                + "            </th>"
                                + "        </tr>"
                                + "        <tr class='ui-widget-header'>"
                                + "            <th >Hora Inicial</th>"
                                + "            <th >Hora Final</th>"
                                + "            <th >Qtde. Vagas</th>"
                                + "            <th >Encaixe?</th>"
                                + "            <th >Qtde. Encaixe</th>"
                                + "            <th >Tempo Atend.</th>"
                                + "        </tr>"
                                + "    </thead>"
                                + "    <tbody>";
                        }
                        template += "<tr class='ui-widget-content'>"
                            + "     <td class='ui-state-default focus' align='center' width='10%'>"
                            + "           <input type='hidden' name='dias-semana[" + id_dia + "][hora_inicial][]' value='" + hr_inicial + "'>" + hr_inicial
                            + "     </td>"
                            + "     <td class='ui-state-default focus' align='center' width='10%' >"
                            + "           <input type='hidden' name='dias-semana[" + id_dia + "][hora_final][]' value='" + hr_final + "'>" + hr_final
                            + "     </td>"
                            + "     <td class='ui-state-default' align='center' width='10%' >"
                            + "           <input type='hidden' name='dias-semana[" + id_dia + "][conh_cota_dia][]' value='" + qtd_v + "'>" + qtd_v
                            + "     </td>"
                            + "     <td hidden><input type='hidden' name='dias-semana[" + id_dia + "][encaixe][]' value='" + val_encx + "'>" + val_encx + "</td>"
                            + "     <td class='ui-state-default' align='center' width='10%'>" + encx + "</td>"
                            + "     <td class='ui-state-default' align='center' width='10%'>"
                            + "           <input type='hidden' name='dias-semana[" + id_dia + "][conh_encaixe][]' value='" + qtd_e + "'>" + qtd_e
                            + "     </td>"
                            + "     <td hidden><input type='hidden' name='dias-semana[" + id_dia + "][conh_intervalo][]' value='" + temp_at + "'>" + temp_at + "</td>"
                            + "     <td class='ui-state-default' align='center' width='10%'>" + temp_at + " min</td>"
                            + "</tr>";

                        array_dias[id_dia] = id_dia;
                        controle_dia = id_dia;
                    });
                    template += "</tbody></table>";
                    $("#visualizacao").append(template);
                    // console.log(array_dias);
                }
            }
        });
    }
}

/* -----------------------------------------------------------------
* MÉTODOS GERAIS UTIL PARA CONVÊNIO DE LABORATORIO OU AGENDAMENTO
* ----------------------------------------------------------------*/
function carregaEspecialidade(usr_codigo, conv_codigo) {
    var metodo = (conv_codigo ? "carrega-especialidade-por-convenio" : "carrega-especialidade?uni_codigo=" + $('#uni_codigo').val());
    $.ajax({
        url: baseUrl + '/agenda/convenio-itens/' + metodo,
        type: "POST",
        data: {
            usr_codigo: usr_codigo,
            conv_codigo: conv_codigo
        },
        success: function (json) {
            $("#esp").children().remove();
            $("#med_esp").show('slow');
            $.each(json, function (key, value) {
                if ($("#esp_codigo_hidden").val() != "") {
                    if (value['esp_codigo'] == $("#esp_codigo_hidden").val()) {
                        $("#esp").append("<option title=\"" + value['esp_nome'] + "\"  value=\"" + value['esp_codigo'] + "\">" + value['esp_nome'] + "</option>");
                        $("#med_esp").show('slow');
                    }
                } else {
                    $("#esp").append("<option title=\"" + value['esp_nome'] + "\"  value=\"" + value['esp_codigo'] + "\" " + (value['esp_codigo'] == $("#esp_codigo_hidden").val() ? "selected=selected" : "") + " >" + value['esp_nome'] + "</option>");
                    $("#med_esp").show('slow');
                }
            })
        }
    });
    return true;
}

function chamaCalculo(id) {
    var cota = $("#coni_cota_dia_" + id).val();
    var encaixe = $("#coni_encaixe_" + id).val();
    encaixe = (encaixe != "" ? encaixe : 0);
    var minutos = horaEmMinutos(id);
    if (!minutos) {
        return false;
    }
    ;
    if (cota != "") {
        var soma = (parseInt(cota) + parseInt(encaixe));
        var intervalo = minutos / soma;
        if (intervalo < 0) {
            intervalo = intervalo * -1;
        }
        ;
        $("#coni_intervalo_" + id).val(intervalo);
    } else {
        $("#coni_intervalo_" + id).empty();
    }
    ;
}

function calculaComEncaixe(id) {
    chamaCalculo(id);
}

function mostraEncaixe(id) {
    if ($('#encaixe_' + id).is(':checked')) {
        $("#checkbox_div_" + id).show();
    } else {
        $("#checkbox_div_" + id).hide();
        $("#coni_encaixe_" + id).val(0);
        chamaCalculo(id);
    }
}

function horaEmMinutos(id) {
    var minutos = 0;
    if ($("#hr_inicio_" + id).val() == "" || $("#hr_inicio_" + id).val() == null) {
        return false;
    } else {
        var hr_inicio = $("#hr_inicio_" + id).val().split(':');
    }
    if ($("#hr_fim_" + id).val() == "__:__" || $("#hr_fim_" + id).val() == null) {
        return false;
    } else {
        var hr_fim = $("#hr_fim_" + id).val().split(':');
    }
    var minutos_ini = (hr_inicio[0] * 60 + parseInt(hr_inicio[1]));
    var minutos_fim = (hr_fim[0] * 60 + parseInt(hr_fim[1]));
    minutos += minutos_fim - minutos_ini;
    return minutos;
}

function mask() {
    for (var i = 1; i <= $(".ini").size(); i++) {
        if ($("#hr_inicio_" + i).val().length == 2) {
            $("#hr_inicio_" + i).val($("#hr_inicio" + i).val() + ':');
        }
    }
}

/* -----------------------------------------------------------------
* OUTROS MÉTODOS DE CONVÊNIO QUE NÃO SEI SE ESTÁ SENDO USADO
* ----------------------------------------------------------------*/

var pad = function (val, len, str) {
    val = String(val);
    len = len || 2;
    str = str || "0";
    while (val.length < len)
        val = str + val;
    return val;
};

function verificaCampos() {
    var salvar = true;
    var horarios = false;
    salvar = comparaDatas($("#data_inicio").val(), $("#data_termino").val());
    $("#visualizacao input").each(function (index, element) {
        if ($(this).val() != null) {
            horarios = true;
        }
    });
    if (!horarios) {
        salvar = false;
        mensagem("Atenção", "Informe pelo menos um horário para esse profissional!");
    }
    if (salvar) {
        $('#form-agendamento-profissionais').submit();
    }
}

function comparaDatas(data_inicial, data_final) {
    //Verifica se a data inicial  maior que a data final
    str_data_inicial = data_inicial;
    str_data_final = data_final;
    dia_inicial = data_inicial.substr(0, 2);
    dia_final = data_final.substr(0, 2);
    mes_inicial = data_inicial.substr(3, 2);
    mes_final = data_final.substr(3, 2);
    ano_inicial = data_inicial.substr(6, 4);
    ano_final = data_final.substr(6, 4);
    if (ano_inicial > ano_final) {
        mensagem("Atenção", "A data de início deve ser menor que a data de término.");
        return false
    } else {
        if (ano_inicial == ano_final) {
            if (mes_inicial > mes_final) {
                mensagem("Atenção", "A data de início deve ser menor que a data de término.");
                return false
            } else {
                if (mes_inicial == mes_final) {
                    if (dia_inicial > dia_final) {
                        mensagem("Atenção", "A data de início deve ser menor que a data de término.");
                        return false
                    }
                }
            }
        }
    }
    return true;
}

$(function () {

    configuraEdicaoDiasDaSemana();

    carregaHorarios($("#coni_codigo").val());

    $("#usr_nome").buscar({
        url: baseUrl + '/default/usuarios/buscar-usuarios-saude-por-unidade',
        parametros: "&uni_codigo=" + $("#uni_codigo").val(),
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function () {
            var usr_codigo = $("#usr_codigo").val();
            carregaEspecialidade(usr_codigo);
        }
    });

    if ($("#usr_codigo").val()) {
        carregaEspecialidade($("#usr_codigo").val(), $("#conv_codigo").val());
    }

    $("#form-agendamento-profissionais").validate({
        rules: {
            usr_codigo: {required: true}
        },
        messages: {
            usr_codigo: {required: "Selecione um profissional"}
        }
    });

    $("#proc_nome").buscar({
        url: baseUrl + '/procedimento/buscar',
        template: function (ul, item) {
            return $("<li/>").data("item.autocomplete", item).append(
                "<a>" + item.label + "</a>").appendTo(ul);
        },
        callback: function (ul, item) {
            return true;
        }
    });

    $("#orientacoes")
      .bind('dblclick', selecionarOrientacao)
      .bind('keydown', selecionarOrientacao);

    $("#orientacoes-selecionadas")
      .bind('dblclick', deselecionarOrientacao)
      .bind('keydown', deselecionarOrientacao);

    function selecionarOrientacao(e) {
      // só pode ser a tecla 39 (seta para direita)
      if (e.keyCode && e.keyCode != 39 || e.charCode) {
        return;
      }

      var itemSelecionado = $("#orientacoes option:selected").val();
      var podeSelecionar = true;
      $.map($('#orientacoes-selecionadas option'), function (option) {
        if (parseInt(itemSelecionado) === parseInt($(option).val())) {
          podeSelecionar = false;
          return;
        }
      });

      if (!$("#orientacoes option:selected").size()) {
        return;
      }

      // add
      if (podeSelecionar) {
        $("#orientacoes-selecionadas").append(
          $("#orientacoes option:selected")
        );
      } else {
        mensagem("Atenção", "Orientação já selecionada para este item de convênio!");
      }

      // se não houver mais opções, add "Nenhum"
      if ($("#orientacoes option").size() == 0) {
        $("#orientacoes")
          .empty()
          .append('<option value="0" disabled="disabled">Selecione a orientação</option>');
      }

      $("#orientacoes").focus();
    }

    function deselecionarOrientacao(e) {
      // só pode ser a tecla 39 (seta para esquerda)
      if (e.keyCode && e.keyCode != 37 || e.charCode) {
        return;
      }

      var itemSelecionado = $("#orientacoes-selecionadas option:selected").val();
      var podeSelecionar = true;
      $.map($('#orientacoes option'), function (option) {
        if (parseInt(itemSelecionado) === parseInt($(option).val())) {
          podeSelecionar = false;
          return;
        }
      });

      // remover
      if (podeSelecionar) {
        $("#orientacoes-selecionadas option:selected").appendTo("#orientacoes");
      }

      // se não houver mais opções, add "Nenhum"
      if ($("#orientacoes-selecionadas option").size() == 0) {
        $("#orientacoes-selecionadas")
          .empty()
          .append('<option value="0" disabled="disabled">Nenhuma orientação selecionada</option>');
      }

      $("#orientacoes-selecionadas").focus();
    }
});
